/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.model_elements.input_output;

import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import org.colos.ejs.library.Model;
import org.colos.ejs.library.utils.ModelElementsUtilities;
import org.opensourcephysics.display.OSPRuntime;

public class FileChooser {
    static boolean sCanAccessDisk = true;
    private Model model;
    private String description;
    private String extensions;
    private JFileChooser fileChooser;
    private ExtensionFileFilter fileFilter;
    private String initialPath;

    static {
        try {
            System.getProperty("user.home");
        }
        catch (Exception exception) {
            sCanAccessDisk = false;
        }
    }

    public FileChooser(Model model, String string, String string2) {
        this.model = model;
        if (sCanAccessDisk) {
            this.fileChooser = new JFileChooser();
            this.description = string;
            this.extensions = string2;
            this.fileFilter = new ExtensionFileFilter();
            this.fileChooser.setFileFilter(this.fileFilter);
            File file = new File(".");
            this.initialPath = file.getAbsolutePath();
            this.fileChooser.setCurrentDirectory(file);
        } else {
            this.fileChooser = null;
        }
    }

    public String chooseFilename(Component component, boolean bl) {
        String string;
        if (this.fileChooser == null) {
            JOptionPane.showMessageDialog(null, "This simulation does NOT have disk access!", "Disk Access Error", 0);
            return null;
        }
        if (this.description != null) {
            this.fileFilter.setDescription(ModelElementsUtilities.getValue(this.model, this.description));
        }
        if (this.extensions != null) {
            this.fileFilter.setExtensions(ModelElementsUtilities.getValue(this.model, this.extensions));
        }
        if ((string = OSPRuntime.chooseFilename(this.fileChooser, component, bl)) == null) {
            return null;
        }
        if (string.startsWith(this.initialPath)) {
            string = "." + string.substring(this.initialPath.length());
        }
        return string;
    }

    public String getDescription() {
        return ModelElementsUtilities.getValue(this.model, this.description);
    }

    public String getExtensions() {
        return ModelElementsUtilities.getValue(this.model, this.extensions);
    }

    private static class ExtensionFileFilter
    extends FileFilter {
        private String description = "";
        private ArrayList<String> extensions = new ArrayList();

        private ExtensionFileFilter() {
        }

        public void setExtensions(String string) {
            this.extensions.clear();
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",; ");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken().trim();
                if (!string2.startsWith(".")) {
                    string2 = "." + string2;
                }
                this.extensions.add(string2.toLowerCase());
            }
        }

        public String toString() {
            return this.description;
        }

        public void setDescription(String string) {
            this.description = string;
        }

        public String getDescription() {
            return this.description;
        }

        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String string = file.getName().toLowerCase();
            int n = 0;
            while (n < this.extensions.size()) {
                if (string.endsWith(this.extensions.get(n))) {
                    return true;
                }
                ++n;
            }
            return false;
        }
    }
}

