/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.swing;

import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JSplitPane;
import org.colos.ejs.library.control.ControlElement;
import org.colos.ejs.library.control.swing.ControlContainer;
import org.colos.ejs.library.control.swing.ControlSwingElement;
import org.colos.ejs.library.control.swing.RadioButtonInterface;
import org.colos.ejs.library.control.value.IntegerValue;
import org.colos.ejs.library.control.value.Value;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControlSplitPanel
extends ControlContainer {
    protected JSplitPane splitpanel;
    private boolean hasOne = false;
    private static List<String> infoList = null;

    @Override
    protected Component createVisual() {
        this.splitpanel = new JSplitPane();
        this.splitpanel.setOneTouchExpandable(true);
        this.splitpanel.setDividerLocation(-1);
        return this.splitpanel;
    }

    @Override
    public void reset() {
        this.splitpanel.setDividerLocation(-1);
    }

    @Override
    public void add(ControlElement controlElement) {
        if (this.hasOne) {
            this.splitpanel.setBottomComponent(controlElement.getComponent());
            this.splitpanel.setDividerLocation(-1);
        } else {
            this.splitpanel.setTopComponent(controlElement.getComponent());
            this.splitpanel.setDividerLocation(-1);
            this.hasOne = true;
        }
        if (controlElement instanceof RadioButtonInterface) {
            this.radioButtons.add((ControlSwingElement)controlElement);
            ((RadioButtonInterface)((Object)controlElement)).setControlParent(this);
        }
    }

    @Override
    public List<String> getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList<String>();
            infoList.add("orientation");
            infoList.add("expandable");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    @Override
    public String getPropertyInfo(String string) {
        if (string.equals("orientation")) {
            return "Orientation|int";
        }
        if (string.equals("expandable")) {
            return "boolean";
        }
        return super.getPropertyInfo(string);
    }

    @Override
    public Value parseConstant(String string, String string2) {
        if (string2 == null) {
            return null;
        }
        if (string.indexOf("Orientation") >= 0) {
            if ((string2 = string2.trim().toLowerCase()).equals("vertical")) {
                return new IntegerValue(0);
            }
            if (string2.equals("horizontal")) {
                return new IntegerValue(1);
            }
        }
        return super.parseConstant(string, string2);
    }

    @Override
    public void setValue(int n, Value value) {
        switch (n) {
            case 0: {
                if (this.splitpanel.getOrientation() == value.getInteger()) break;
                this.splitpanel.setOrientation(value.getInteger());
                break;
            }
            case 1: {
                this.splitpanel.setOneTouchExpandable(value.getBoolean());
                break;
            }
            default: {
                super.setValue(n - 2, value);
            }
        }
    }

    @Override
    public void setDefaultValue(int n) {
        switch (n) {
            case 0: {
                this.splitpanel.setOrientation(1);
                break;
            }
            case 1: {
                this.splitpanel.setOneTouchExpandable(true);
                break;
            }
            default: {
                super.setDefaultValue(n - 2);
            }
        }
    }

    @Override
    public String getDefaultValueString(int n) {
        switch (n) {
            case 0: {
                return "HORIZONTAL";
            }
            case 1: {
                return "true";
            }
        }
        return super.getDefaultValueString(n - 2);
    }

    @Override
    public Value getValue(int n) {
        switch (n) {
            case 0: 
            case 1: {
                return null;
            }
        }
        return super.getValue(n - 2);
    }
}

