/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.swing;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.ToolTipManager;
import org.colos.ejs.library.control.swing.ControlSwingElement;
import org.colos.ejs.library.control.value.Value;
import org.opensourcephysics.display.TeXParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControlMenuItem
extends ControlSwingElement {
    protected static final int MENUITEM_ADDED = 6;
    protected JMenuItem menuItem;
    private String imageFile = null;
    private String menuAcc = null;
    private String labelString = "";
    private static List<String> infoList = null;

    public ControlMenuItem() {
        JPopupMenu.setDefaultLightWeightPopupEnabled(false);
        ToolTipManager.sharedInstance().setLightWeightPopupEnabled(false);
    }

    @Override
    protected Component createVisual() {
        this.menuItem = new JMenuItem();
        this.menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ControlMenuItem.this.invokeActions();
            }
        });
        return this.menuItem;
    }

    @Override
    public List<String> getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList<String>();
            infoList.add("text");
            infoList.add("image");
            infoList.add("alignment");
            infoList.add("action");
            infoList.add("accelerator");
            infoList.add("mnemonic");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    @Override
    public String getPropertyInfo(String string) {
        if (string.equals("text")) {
            return "String NotTrimmed TRANSLATABLE";
        }
        if (string.equals("image")) {
            return "File|String TRANSLATABLE";
        }
        if (string.equals("alignment")) {
            return "Alignment|int";
        }
        if (string.equals("action")) {
            return "Action CONSTANT";
        }
        if (string.equals("accelerator")) {
            return "String TRANSLATABLE";
        }
        if (string.equals("mnemonic")) {
            return "String TRANSLATABLE";
        }
        return super.getPropertyInfo(string);
    }

    @Override
    public void setValue(int n, Value value) {
        switch (n) {
            case 0: {
                if (this.labelString.equals(value.getString())) break;
                this.labelString = value.getString();
                if (this.labelString == null) {
                    this.labelString = "";
                }
                this.menuItem.setText(TeXParser.parseTeX(value.getString()));
                break;
            }
            case 1: {
                if (value.getString().equals(this.imageFile)) {
                    return;
                }
                this.imageFile = value.getString();
                this.menuItem.setIcon(this.getIcon(this.imageFile));
                break;
            }
            case 2: {
                this.menuItem.setHorizontalAlignment(value.getInteger());
                break;
            }
            case 3: {
                this.removeAction(0, this.getProperty("action"));
                this.addAction(0, value.getString());
                break;
            }
            case 4: {
                if (value.getString().equals(this.menuAcc)) break;
                this.menuAcc = value.getString();
                this.menuItem.setAccelerator(KeyStroke.getKeyStroke(this.menuAcc));
                break;
            }
            case 5: {
                this.menuItem.setMnemonic(value.getString().charAt(0));
                break;
            }
            default: {
                super.setValue(n - 6, value);
            }
        }
    }

    @Override
    public void setDefaultValue(int n) {
        switch (n) {
            case 0: {
                this.labelString = "";
                this.menuItem.setText("");
                break;
            }
            case 1: {
                this.imageFile = null;
                this.menuItem.setIcon(null);
                break;
            }
            case 2: {
                this.menuItem.setHorizontalAlignment(0);
                break;
            }
            case 3: {
                this.removeAction(0, this.getProperty("action"));
                break;
            }
            case 4: {
                this.menuAcc = null;
                this.menuItem.setAccelerator(null);
                break;
            }
            case 5: {
                this.menuItem.setMnemonic(-1);
                break;
            }
            default: {
                super.setDefaultValue(n - 6);
            }
        }
    }

    @Override
    public String getDefaultValueString(int n) {
        switch (n) {
            case 0: {
                return "<none>";
            }
            case 1: {
                return "<none>";
            }
            case 2: {
                return "CENTER";
            }
            case 3: {
                return "<no_action>";
            }
            case 4: 
            case 5: {
                return "<none>";
            }
        }
        return super.getDefaultValueString(n - 6);
    }

    @Override
    public Value getValue(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return null;
            }
        }
        return super.getValue(n - 6);
    }
}

