/*
 * Decompiled with CFR 0.152.
 */
package EJSToTwinCAT;

import EJSToTwinCAT.datoBeckhoff;
import java.util.ArrayList;
import java.util.List;

public class StructTwinCAT {
    private List<Integer> ordenTipos;
    private List<String> Tipos;
    private List<datoBeckhoff> datos = new ArrayList<datoBeckhoff>();
    private String strLectura;
    private String nomStruct;

    public StructTwinCAT(String nom) {
        this.ordenTipos = new ArrayList<Integer>();
        this.Tipos = new ArrayList<String>();
        this.strLectura = nom;
        this.nomStruct = nom;
    }

    public String read() {
        return this.strLectura;
    }

    public String write() {
        String cad = null;
        cad = this.nomStruct;
        int l = this.datos.size();
        int i = 0;
        int tipo = 0;
        String strTipo = null;
        Object strVal = null;
        boolean parar = false;
        datoBeckhoff di = null;
        while (i < l & !parar) {
            di = this.datos.get(i);
            tipo = this.ordenTipos.get(i);
            int tam = di.total;
            switch (tipo) {
                case 1: {
                    strTipo = "I:";
                    break;
                }
                case 2: {
                    strTipo = "F:";
                    break;
                }
                case 3: {
                    strTipo = "B:";
                    break;
                }
                case 4: {
                    strTipo = "S:";
                    break;
                }
                case 5: {
                    strTipo = "D:";
                }
            }
            cad = cad + ";" + strTipo + tam + ":";
            for (int j = 0; j < di.fila; ++j) {
                for (int k = 0; k < di.col; ++k) {
                    cad = di.dato[j * di.col + k] == null ? cad + "0" + ":" : cad + di.dato[j * di.col + k] + ":";
                }
            }
            cad = cad.substring(0, cad.length() - 1);
            ++i;
        }
        return cad;
    }

    private int tipoNum(String tipo) {
        if (tipo.equalsIgnoreCase("int")) {
            return 1;
        }
        if (tipo.equalsIgnoreCase("float")) {
            return 2;
        }
        if (tipo.equalsIgnoreCase("byte")) {
            return 3;
        }
        if (tipo.equalsIgnoreCase("short")) {
            return 4;
        }
        if (tipo.equalsIgnoreCase("double")) {
            return 5;
        }
        return 0;
    }

    public int add(String tipo, String nom, int tamFil, int tamCol) {
        int val = this.tipoNum(tipo);
        if (val > 0) {
            this.ordenTipos.add(val);
            this.Tipos.add(tipo);
            datoBeckhoff d = null;
            switch (val) {
                case 1: {
                    d = new datoBeckhoff(nom, tamFil, tamCol);
                    this.strLectura = this.strLectura.concat(";I:" + Integer.toString(tamFil * tamCol));
                    break;
                }
                case 2: {
                    d = new datoBeckhoff(nom, tamFil, tamCol);
                    this.strLectura = this.strLectura.concat(";F:" + Integer.toString(tamFil * tamCol));
                    break;
                }
                case 3: {
                    d = new datoBeckhoff(nom, tamFil, tamCol);
                    this.strLectura = this.strLectura.concat(";B:" + Integer.toString(tamFil * tamCol));
                    break;
                }
                case 4: {
                    d = new datoBeckhoff(nom, tamFil, tamCol);
                    this.strLectura = this.strLectura.concat(";S:" + Integer.toString(tamFil * tamCol));
                    break;
                }
                case 5: {
                    d = new datoBeckhoff(nom, tamFil, tamCol);
                    this.strLectura = this.strLectura.concat(";D:" + Integer.toString(tamFil * tamCol));
                }
            }
            this.datos.add(d);
        }
        return val;
    }

    public int add(String tipo, String nom, int tam) {
        int val = this.add(tipo, nom, tam, 1);
        return val;
    }

    public int add(String tipo, String nom) {
        int val = this.add(tipo, nom, 1, 1);
        return val;
    }

    public void setVal(String nom, Number val, int posFil, int posCol) {
        int l = this.datos.size();
        int i = 0;
        boolean parar = false;
        while (i < l & !parar) {
            datoBeckhoff d = this.datos.get(i);
            if (d.getNombre().equals(nom)) {
                int ind = posFil * d.col + posCol;
                d.setVal(ind, val);
                this.datos.set(i, d);
                parar = true;
            }
            ++i;
        }
    }

    public void setVal(String nom, Number val, int posFil) {
        this.setVal(nom, val, posFil, 0);
    }

    public void setVal(String nom, Number val) {
        this.setVal(nom, val, 0, 0);
    }

    public void setStrMat(String nom, String cad) {
        int i = 0;
        int pos = 0;
        boolean parar = false;
        datoBeckhoff d = null;
        int l = this.datos.size();
        int tipo = 0;
        while (i < l & !parar) {
            d = this.datos.get(i);
            tipo = this.ordenTipos.get(i);
            if (d.getNombre().equals(nom)) {
                pos = i;
                parar = true;
            }
            ++i;
        }
        if (parar) {
            if (d.total > 1) {
                cad = cad.substring(1, cad.length() - 1);
            }
            String[] filas = cad.split(";");
            for (int fi = 0; fi < filas.length; ++fi) {
                String[] columnas = filas[fi].split(",");
                for (int k = 0; k < columnas.length; ++k) {
                    int ind = fi * d.col + k;
                    switch (tipo) {
                        case 1: {
                            d.setVal(ind, Integer.parseInt(columnas[k]));
                            break;
                        }
                        case 2: {
                            d.setVal(ind, Float.valueOf(Float.parseFloat(columnas[k])));
                            break;
                        }
                        case 3: {
                            d.setVal(ind, Byte.parseByte(columnas[k]));
                            break;
                        }
                        case 4: {
                            d.setVal(ind, Short.parseShort(columnas[k]));
                            break;
                        }
                        case 5: {
                            d.setVal(ind, Double.parseDouble(columnas[k]));
                        }
                    }
                    this.datos.set(pos, d);
                }
            }
        }
    }

    public void setStrMsg(String answer) {
        String[] cad = answer.split(":");
        datoBeckhoff d = null;
        int l = this.datos.size();
        int la = cad.length;
        int tipo = 0;
        int j = 1;
        for (int i = 0; i < l; ++i) {
            d = this.datos.get(i);
            tipo = this.ordenTipos.get(i);
            for (int k = 0; k < d.total; ++k) {
                switch (tipo) {
                    case 1: {
                        d.setVal(k, Integer.parseInt(cad[j]));
                        break;
                    }
                    case 2: {
                        d.setVal(k, Float.valueOf(Float.parseFloat(cad[j])));
                        break;
                    }
                    case 3: {
                        d.setVal(k, Byte.parseByte(cad[j]));
                        break;
                    }
                    case 4: {
                        d.setVal(k, Short.parseShort(cad[j]));
                        break;
                    }
                    case 5: {
                        d.setVal(k, Double.parseDouble(cad[j]));
                    }
                }
                this.datos.set(i, d);
                if (++j <= la) continue;
                return;
            }
        }
    }

    public Number getVal(String nom, int posFil, int posCol) {
        int l = this.datos.size();
        int i = 0;
        boolean parar = false;
        while (i < l & !parar) {
            datoBeckhoff d = this.datos.get(i);
            if (d.getNombre().equals(nom)) {
                int ind = posFil * d.col + posCol;
                if (d.dato[ind] == null) {
                    return 0;
                }
                Number a = (Number)d.dato[ind];
                return a;
            }
            ++i;
        }
        return 0;
    }

    public Number getVal(String nom, int posFil) {
        return this.getVal(nom, posFil, 0);
    }

    public Number getVal(String nom) {
        return this.getVal(nom, 0, 0);
    }

    public String getStrMat(String nom) {
        String cad = "";
        int l = this.datos.size();
        int i = 0;
        boolean parar = false;
        datoBeckhoff di = null;
        while (i < l & !parar) {
            di = this.datos.get(i);
            if (di.getNombre().equals(nom)) {
                parar = true;
            }
            ++i;
        }
        if (parar) {
            if (di.total > 1) {
                cad = "[";
            }
            for (int j = 0; j < di.fila; ++j) {
                for (int k = 0; k < di.col - 1; ++k) {
                    cad = di.dato[j * di.col + k] == null ? cad + "0" + "," : cad + di.dato[j * di.col + k] + ",";
                }
                cad = di.dato[j * di.col + di.col - 1] == null ? cad + "0" + ";" : cad + di.dato[j * di.col + di.col - 1] + ";";
            }
            di.strMat = cad = cad.substring(0, cad.length() - 1);
            if (di.total > 1) {
                cad = cad + "]";
            }
        }
        return cad;
    }

    public boolean Equal(StructTwinCAT cp) {
        if (!this.nomStruct.equals(cp.nomStruct)) {
            return false;
        }
        if (!this.strLectura.equals(cp.strLectura)) {
            return false;
        }
        int n = this.datos.size();
        for (int i = 0; i < n; ++i) {
            datoBeckhoff d1 = this.datos.get(i);
            datoBeckhoff d2 = cp.datos.get(i);
            if (d1.col != d2.col || d1.fila != d2.fila) {
                return false;
            }
            for (int k = 0; k < d1.total; ++k) {
                if (d1.dato[k] == d2.dato[k]) continue;
                return false;
            }
        }
        return true;
    }

    public StructTwinCAT(StructTwinCAT or) {
        this.ordenTipos = new ArrayList<Integer>();
        this.Tipos = new ArrayList<String>();
        this.strLectura = new String(or.nomStruct);
        this.nomStruct = new String(or.nomStruct);
        int n = or.datos.size();
        for (int i = 0; i < n; ++i) {
            datoBeckhoff d2 = or.datos.get(i);
            this.add(or.Tipos.get(i), d2.Nombre, d2.fila, d2.col);
            datoBeckhoff d1 = this.datos.get(i);
            for (int j = 0; j < d1.total; ++j) {
                d1.setVal(j, d2.getVal(j));
            }
        }
    }
}

