/*
 * Decompiled with CFR 0.152.
 */
package EJSToTwinCAT;

import EJSToTwinCAT.StructTwinCAT;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CommIndirect {
    long port = 0L;
    private String CameraIP;
    private Socket cliente;
    private String servidorChat;
    private ObjectOutputStream salida;
    private ObjectInputStream entrada;
    private String errorMsg;
    private String readInstruction;
    private StructTwinCAT st;
    private StructTwinCAT[] ast;

    public CommIndirect(String host) {
        this.servidorChat = host;
        this.CameraIP = null;
        this.errorMsg = "";
    }

    public String getCameraIP() {
        return this.CameraIP;
    }

    public boolean isOK() {
        return this.port > 0L;
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public long openPort(int Prt, String Practica) {
        if (this.port == 0L) {
            this.readInstruction = "";
            this.st = null;
            this.ast = null;
            this.port = Prt;
            try {
                this.cliente = new Socket(InetAddress.getByName(this.servidorChat), Prt);
                this.obtainStreams();
                if (Practica == null) {
                    String resp = this.readMsg();
                    if (resp == null) {
                        this.errorMsg = "SERVER NO ANSWERING";
                        return 0L;
                    }
                    if (!resp.contentEquals("SERVER>>> READY")) {
                        return 0L;
                    }
                } else {
                    String resp = this.readWriteMsg(Practica);
                    if (resp == null) {
                        this.errorMsg = "SERVER NO ANSWERING";
                        this.port = 0L;
                        return 0L;
                    }
                    String[] partes = resp.split("#");
                    if (!partes[0].contentEquals("SERVER>>> READY")) {
                        this.errorMsg = partes[1];
                        this.port = 0L;
                        return 0L;
                    }
                    this.CameraIP = new String(partes[1]);
                }
                return this.port;
            }
            catch (Exception ex) {
                this.errorMsg = "OP_PORT EXCEPTION";
                this.port = 0L;
                return 0L;
            }
        }
        return this.port;
    }

    public long closePort() {
        if (this.port != 0L) {
            this.closeConnexion();
            this.port = 0L;
            return 1L;
        }
        return this.port;
    }

    public String read(String sIn) {
        String sOut = this.readWriteMsg("READ#" + sIn);
        return sOut;
    }

    public void request(String sIn) {
        this.readInstruction = sIn;
        String sout = this.readWriteMsg("REQUEST#" + sIn);
    }

    public String read() {
        try {
            String sOut = this.readMsg();
            return sOut;
        }
        catch (IOException ex) {
            Logger.getLogger(CommIndirect.class.getName()).log(Level.SEVERE, null, ex);
            return "";
        }
    }

    public void write(String sIn) {
        String sOut = this.readWriteMsg("WRITE#" + sIn);
    }

    public void readVariable(StructTwinCAT stin) {
        this.st = stin;
        String answer = this.readWriteMsg("READ#" + stin.read());
        stin.setStrMsg(answer);
    }

    public void requestVariable(StructTwinCAT stin) {
        this.st = stin;
        String answer = this.readWriteMsg("REQUEST#" + stin.read());
    }

    public void readVariable() {
        try {
            String answer = this.readMsg();
            this.st.setStrMsg(answer);
        }
        catch (IOException ex) {
            Logger.getLogger(CommIndirect.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void writeVariable(StructTwinCAT st) {
        String answer = this.readWriteMsg("WRITE#" + st.write());
    }

    public void readVariables(StructTwinCAT[] sts) {
        this.ast = sts;
        int n = sts.length;
        StructTwinCAT st = null;
        String order = "READ";
        for (int i = 0; i < n; ++i) {
            order = order + "#" + sts[i].read();
        }
        String answer = this.readWriteMsg(order);
        String[] cad = answer.split("#");
        for (int i = 0; i < n; ++i) {
            st = sts[i];
            st.setStrMsg(cad[i + 1]);
        }
    }

    public void requestVariables(StructTwinCAT[] sts) {
        this.ast = sts;
        int n = sts.length;
        Object st = null;
        String order = "REQUEST";
        for (int i = 0; i < n; ++i) {
            order = order + "#" + sts[i].read();
        }
        String answer = this.readWriteMsg(order);
    }

    public void readVariables() {
        StructTwinCAT st = null;
        int n = this.ast.length;
        try {
            String answer = this.readMsg();
            if (answer.contains("TIMEOUT")) {
                this.errorMsg = "TIMEOUT";
                this.port = 0L;
                return;
            }
            String[] cad = answer.split("#");
            if (cad.length == n + 1) {
                for (int i = 0; i < n; ++i) {
                    st = this.ast[i];
                    st.setStrMsg(cad[i + 1]);
                }
            }
        }
        catch (IOException ex) {
            Logger.getLogger(CommIndirect.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void writeVariables(StructTwinCAT[] sts) {
        int n = sts.length;
        String order = "WRITE";
        for (int i = 0; i < n; ++i) {
            order = order + "#" + sts[i].write();
        }
        String answer = this.readWriteMsg(order);
    }

    public void plcRun() {
        this.readWriteMsg("RUN");
    }

    public void plcRun(long time) {
        String msg = "RUN#" + time;
        this.readWriteMsg(msg);
    }

    public void plcStart() {
        this.readWriteMsg("START");
    }

    public void plcStop() {
        this.readWriteMsg("NOREAD");
        this.readWriteMsg("STOP");
    }

    public void plcReset() {
        this.readWriteMsg("RESET");
    }

    private void writeMsg(String message) {
        if (this.port != 0L) {
            try {
                this.salida.writeObject(message);
                this.salida.flush();
            }
            catch (IOException excepcionES) {
                System.out.println("\nError al escribir el objeto");
            }
        }
    }

    private String readMsg() throws IOException {
        String mensaje = "";
        if (this.port != 0L) {
            try {
                mensaje = (String)this.entrada.readObject();
                if (mensaje.equals("SERVIDOR>>> TIMEOUT")) {
                    this.port = 0L;
                }
            }
            catch (ClassNotFoundException excepcionClaseNoEncontrada) {
                System.out.println("Se recibi\u00f3 un objeto de tipo desconocido");
            }
        }
        return mensaje;
    }

    private String readWriteMsg(String message) {
        String OK = "";
        this.writeMsg(message);
        try {
            OK = this.readMsg();
            if (OK.isEmpty()) {
                OK = "";
            }
        }
        catch (IOException ex) {
            Logger.getLogger(CommIndirect.class.getName()).log(Level.SEVERE, null, ex);
            OK = "";
        }
        return OK;
    }

    private void closeConnexion() {
        try {
            this.salida.close();
            this.entrada.close();
            this.cliente.close();
        }
        catch (IOException excepcionES) {
            excepcionES.printStackTrace();
        }
    }

    private void obtainStreams() throws IOException {
        this.salida = new ObjectOutputStream(this.cliente.getOutputStream());
        this.salida.flush();
        InputStream jj = this.cliente.getInputStream();
        this.entrada = new ObjectInputStream(jj);
    }
}

