var _isEPub = false;
var _isApp = false;

var __base64Images = [];
__base64Images["./MassAndSpring/MassAndSpring.png"]="data:image/png;base64,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";
__base64Images["./MassAndSpring/PacoEsquembre2011.png"]="data:image/png;base64,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";
__base64Images["./MassAndSpring/WC_logo.png"]="data:image/png;base64,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";
__base64Images["./MassAndSpring/MassAndSpringComplete.png"]="data:image/png;base64,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";
__base64Images["./MassAndSpring/MassAndSpring.gif"]="data:image/gif;base64,R0lGODlhbwBHAIcAAAAAAP8A/+/v/wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAMAAAIALAAAAABvAEcAAAj/AAUIHEiwoMGDCBMqXMiwocOHECNKnEixosWLGDNq3Mixo0MAIEOKHEkSgMeTHEuqLImyJcaVMEO6nEkxZkyaOCHahJmzJ8OdK30KRQhU5dCjBIuyRIpUKUmmTZ2KhHpU6lSqQq3KxOpTK0iuXb2C7enV5FicZc+iFat2Ztq2Lt/CRSl3rse6dlOyzUv06se9fAeGDECY8NeGePkCKMy4sNmFie0ubkz5cMLIcCdTrgwZMNGDjwWDNhha9OXNqAOULog5KenVsGG/Pp0a9WrBnmWz1p2UN27atTn31dqbtYDSlgWaRI78+G7gwRnfVg44uXPmxrG71k46uu3hVn+H4l6efXt50dxZe988vezV8c5Nw4cfX3n9670Hr2/c3vN98vKZFyB6Av63H3/gSUWaafWZ9diDAzYYIHIHSpegU6NJaN+GEG4YX4cNwlahapf592GE+KEIIIc/jTjdcSbC+NyMv9FI3UcHvggjcYEdt56OO4bXI0jRWfcajz36mBqQ1CGZpH6OMdmkkEnmZ6RCrVUZUZZaPsRll4jFCKaXYo4ZppNmbllmmliuyeaFSr0p0Zdy7oZmnZ3diWeJeu4Jmpt+BqlgoHlSSSicRR3aZp+KCopho38yqiidkFZq6aVsBgQAOw==";
