var _isEPub = false;
var _isApp = false;

var __base64Images = [];
__base64Images["./MagneticBarField/barMagnet.png"]="data:image/png;base64,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";
__base64Images["./Bar_magnet_and_compass_2/2016-05-31_1605s.png"]="data:image/png;base64,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";
__base64Images["./Bar_magnet_and_compass_2/lookangphoto.png"]="data:image/png;base64,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";
__base64Images["./Bar_magnet_and_compass_2/Magnet_and_compass.png"]="data:image/png;base64,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";
__base64Images["./MagneticBarField/circle.gif"]="data:image/gif;base64,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";
