/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics.rk;

import org.opensourcephysics.numerics.ODE;
import org.opensourcephysics.numerics.ODESolverInterpolator;
import org.opensourcephysics.numerics.dde_solvers.interpolation.StateMemory;

public abstract class AbstractExplicitRKSolverInterpolator
implements ODESolverInterpolator {
    protected double stepSize = 0.1;
    protected double maximumStepSize = Double.POSITIVE_INFINITY;
    protected int dimension;
    protected int timeIndex;
    protected int error_code = 0;
    protected double initialTime = 0.0;
    protected double finalTime = 0.0;
    protected double deltaTime = 0.0;
    protected double[] initialState;
    protected double[] initialRate;
    protected double[] finalState;
    protected double[] finalRate;
    protected ODE ode;
    protected long counter = 0L;
    protected long evals = 0L;
    private boolean bootStrap1Ready = false;
    private boolean bootStrap2Ready = false;
    private static final double ALPHA = 0.25;
    private static final double bt1_den = 0.1875;
    private static final double bt1_cf1 = 0.3125;
    private static final double bt1_cf0 = -0.1875;
    private static final double bt1_cys = -1.125;
    private static final double BETA1 = 0.7;
    private static final double BETA2 = 0.85;
    private static final double bt2_den = 0.009639000000000005;
    private static final double bt2_cf11 = -0.06999999999999974;
    private static final double bt2_cf01 = 0.33000000000000007;
    private static final double bt2_cys1 = -1.26;
    private static final double bt2_cf12 = -0.46749999999999986;
    private static final double bt2_cf02 = 0.23250000000000015;
    private static final double bt2_cys2 = -0.765;
    private static final double bt2_m44 = -0.16799999999999982;
    private static final double bt2_m54 = -0.17849999999999996;
    private static final double bt2_m45 = -0.4095;
    private static final double bt2_m55 = -0.4924687499999998;
    private double[] state_bt1 = null;
    private double[] rate_bt1;
    private double[] bt1_c2;
    private double[] bt1_c3;
    private double[] bt1_c4;
    private double[] state_bt2 = null;
    private double[] rate_bt21;
    private double[] rate_bt22;
    private double[] bt2_c2;
    private double[] bt2_c3;
    private double[] bt2_c4;
    private double[] bt2_c5;

    protected abstract int getNumberOfEvaluations();

    protected abstract void allocateOtherArrays();

    protected abstract double[] computeIntermediateStep(double var1, double[] var3);

    protected void computeOneStep() {
        this.computeIntermediateStep(this.stepSize, this.finalState);
        this.ode.getRate(this.finalState, this.finalRate);
        this.finalTime = this.initialTime + this.stepSize;
        this.counter += this.evals;
    }

    @Override
    public final ODE getODE() {
        return this.ode;
    }

    @Override
    public final void initialize(double _stepSize) {
        this.stepSize = _stepSize;
        double[] ode_state = this.ode.getState();
        if (this.initialState == null || this.initialState.length != ode_state.length) {
            this.dimension = ode_state.length;
            this.timeIndex = this.dimension - 1;
            this.initialState = new double[this.dimension];
            this.initialRate = new double[this.dimension];
            this.finalState = new double[this.dimension];
            this.finalRate = new double[this.dimension];
            this.allocateOtherArrays();
        }
        this.counter = 0L;
        this.evals = this.getNumberOfEvaluations();
        this.reinitialize(ode_state);
    }

    @Override
    public void reinitialize(double[] _state) {
        this.initialTime = _state[this.timeIndex];
        System.arraycopy(_state, 0, this.initialState, 0, this.dimension);
        this.ode.getRate(this.initialState, this.initialRate);
        this.finalTime = Double.NaN;
        this.error_code = 0;
        this.bootStrap2Ready = false;
        this.bootStrap1Ready = false;
    }

    @Override
    public double[] getCurrentRate() {
        return this.initialRate;
    }

    @Override
    public void setEstimateFirstStep(boolean _estimate) {
    }

    @Override
    public final void setStepSize(double stepSize) {
        this.stepSize = stepSize;
    }

    @Override
    public void setMaximumStepSize(double _stepSize) {
        this.maximumStepSize = Math.abs(_stepSize);
    }

    @Override
    public final double getStepSize() {
        return this.stepSize;
    }

    @Override
    public void setTolerances(double absTol, double relTol) {
    }

    @Override
    public final double getMaximumTime() {
        if (this.error_code != 0) {
            return Double.NaN;
        }
        if (Double.isNaN(this.finalTime)) {
            this.computeOneStep();
            this.deltaTime = this.finalTime - this.initialTime;
            this.bootStrap2Ready = false;
            this.bootStrap1Ready = false;
        }
        return this.finalTime;
    }

    @Override
    public final long getCounter() {
        return this.counter;
    }

    @Override
    public final double internalStep() {
        this.initialTime = this.finalTime;
        System.arraycopy(this.finalState, 0, this.initialState, 0, this.dimension);
        System.arraycopy(this.finalRate, 0, this.initialRate, 0, this.dimension);
        this.error_code = 0;
        this.computeOneStep();
        this.bootStrap2Ready = false;
        this.bootStrap1Ready = false;
        this.deltaTime = this.finalTime - this.initialTime;
        return this.finalTime;
    }

    @Override
    public final double getInternalStepSize() {
        return this.deltaTime;
    }

    protected double[] interpolateHermite(double _time, double[] _state) {
        this.hermite((_time - this.initialTime) / this.deltaTime, _state);
        _state[this.timeIndex] = _time;
        return _state;
    }

    private double[] hermite(double _theta, double[] _state) {
        double minus1 = _theta - 1.0;
        double prod1 = _theta * minus1;
        double prod2 = prod1 * (1.0 - 2.0 * _theta);
        double coefX0 = -minus1 - prod2;
        double coefX1 = _theta + prod2;
        double coefF0 = prod1 * minus1 * this.deltaTime;
        double coefF1 = prod1 * _theta * this.deltaTime;
        int i = 0;
        while (i < this.timeIndex) {
            _state[i] = coefX0 * this.initialState[i] + coefX1 * this.finalState[i] + coefF0 * this.initialRate[i] + coefF1 * this.finalRate[i];
            ++i;
        }
        return _state;
    }

    private void prepareFirstBootstrap() {
        if (this.state_bt1 == null) {
            this.state_bt1 = new double[this.dimension];
            this.rate_bt1 = new double[this.dimension];
            this.bt1_c2 = new double[this.dimension];
            this.bt1_c3 = new double[this.dimension];
            this.bt1_c4 = new double[this.dimension];
        }
        this.hermite(0.25, this.state_bt1);
        this.state_bt1[this.timeIndex] = this.initialTime + 0.25 * this.deltaTime;
        this.ode.getRate(this.state_bt1, this.rate_bt1);
        int i = 0;
        while (i < this.timeIndex) {
            double dif = this.finalState[i] - this.initialState[i];
            double f0 = this.deltaTime * this.initialRate[i];
            double f1 = this.deltaTime * this.finalRate[i];
            double c4 = (this.deltaTime * this.rate_bt1[i] + 0.3125 * f1 + -0.1875 * f0 + -1.125 * dif) / 0.1875;
            double c3 = f1 + f0 - 2.0 * dif - 2.0 * c4;
            this.bt1_c4[i] = c4;
            this.bt1_c3[i] = c3;
            this.bt1_c2[i] = dif - f0 - c3 - c4;
            ++i;
        }
        this.bootStrap1Ready = true;
    }

    protected double[] interpolateBootstrap1(double _time, double[] _state) {
        this.bootstrap1((_time - this.initialTime) / this.deltaTime, _state);
        _state[this.timeIndex] = _time;
        return _state;
    }

    private double[] bootstrap1(double _step, double[] _state) {
        if (!this.bootStrap1Ready) {
            this.prepareFirstBootstrap();
        }
        int i = 0;
        while (i < this.timeIndex) {
            _state[i] = this.initialState[i] + _step * (this.deltaTime * this.initialRate[i] + _step * (this.bt1_c2[i] + _step * (this.bt1_c3[i] + _step * this.bt1_c4[i])));
            ++i;
        }
        return _state;
    }

    private void prepareSecondBootstrap() {
        if (this.state_bt2 == null) {
            this.state_bt2 = new double[this.dimension];
            this.rate_bt21 = new double[this.dimension];
            this.rate_bt22 = new double[this.dimension];
            this.bt2_c2 = new double[this.dimension];
            this.bt2_c3 = new double[this.dimension];
            this.bt2_c4 = new double[this.dimension];
            this.bt2_c5 = new double[this.dimension];
        }
        this.bootstrap1(0.7, this.state_bt2);
        this.state_bt2[this.timeIndex] = this.initialTime + 0.7 * this.deltaTime;
        this.ode.getRate(this.state_bt2, this.rate_bt21);
        this.bootstrap1(0.85, this.state_bt2);
        this.state_bt2[this.timeIndex] = this.initialTime + 0.85 * this.deltaTime;
        this.ode.getRate(this.state_bt2, this.rate_bt22);
        int i = 0;
        while (i < this.timeIndex) {
            double dif = this.finalState[i] - this.initialState[i];
            double f0 = this.deltaTime * this.initialRate[i];
            double f1 = this.deltaTime * this.finalRate[i];
            double e1 = this.deltaTime * this.rate_bt21[i] + -0.06999999999999974 * f1 + 0.33000000000000007 * f0 + -1.26 * dif;
            double e2 = this.deltaTime * this.rate_bt22[i] + -0.46749999999999986 * f1 + 0.23250000000000015 * f0 + -0.765 * dif;
            double c4 = (-0.4924687499999998 * e1 - -0.4095 * e2) / 0.009639000000000005;
            double c5 = (-0.16799999999999982 * e2 - -0.17849999999999996 * e1) / 0.009639000000000005;
            double c3 = f1 + f0 - 2.0 * dif - 2.0 * c4 - 3.0 * c5;
            this.bt2_c5[i] = c5;
            this.bt2_c4[i] = c4;
            this.bt2_c3[i] = c3;
            this.bt2_c2[i] = dif - f0 - c3 - c4 - c5;
            ++i;
        }
        this.bootStrap2Ready = true;
    }

    protected double[] interpolateBootstrap2(double _time, double[] _state) {
        this.bootstrap2((_time - this.initialTime) / this.deltaTime, _state);
        _state[this.timeIndex] = _time;
        return _state;
    }

    private double[] bootstrap2(double _step, double[] _state) {
        if (!this.bootStrap2Ready) {
            this.prepareSecondBootstrap();
        }
        int i = 0;
        while (i < this.timeIndex) {
            _state[i] = this.initialState[i] + _step * (this.deltaTime * this.initialRate[i] + _step * (this.bt2_c2[i] + _step * (this.bt2_c3[i] + _step * (this.bt2_c4[i] + _step * this.bt2_c5[i]))));
            ++i;
        }
        return _state;
    }

    @Override
    public void setMemoryLength(double length) {
    }

    @Override
    public StateMemory getStateMemory() {
        return null;
    }

    @Override
    public abstract double[] interpolate(double var1, boolean var3, double[] var4);

    public double[] interpolate(double _time, boolean _useLeftApproximation, double[] _state, int _beginIndex, int _length) {
        double[] fullState = this.interpolate(_time, _useLeftApproximation, new double[this.dimension]);
        System.arraycopy(fullState, _beginIndex, _state, 0, _length);
        return _state;
    }

    public double interpolate(double _time, boolean _useLeftApproximation, int _index) {
        return this.interpolate(_time, _useLeftApproximation, new double[this.dimension])[_index];
    }

    @Override
    public double[] bestInterpolate(double _time, double[] _state) {
        if (Double.isNaN(this.finalTime)) {
            return null;
        }
        if (_time == this.finalTime) {
            System.arraycopy(this.finalState, 0, _state, 0, this.dimension);
            return _state;
        }
        if (_time == this.initialTime) {
            System.arraycopy(this.initialState, 0, _state, 0, this.dimension);
            return _state;
        }
        return this.computeIntermediateStep(_time - this.initialTime, _state);
    }
}

