/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.drawing3d.utils;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import org.opensourcephysics.drawing3d.DrawingPanel3D;
import org.opensourcephysics.drawing3d.interaction.InteractionEvent;
import org.opensourcephysics.drawing3d.interaction.InteractionListener;
import org.opensourcephysics.drawing3d.utils.Camera;
import org.opensourcephysics.drawing3d.utils.CameraInspectorFrame;
import org.opensourcephysics.tools.ToolsRes;

public class CameraInspector
extends JPanel
implements InteractionListener {
    private DrawingPanel3D panel = null;
    private Camera camera = null;
    private NumberFormat format = new DecimalFormat("0.000");
    private JTextField xField;
    private JTextField yField;
    private JTextField zField;
    private JTextField focusxField;
    private JTextField focusyField;
    private JTextField focuszField;
    private JTextField azimuthField;
    private JTextField altitudeField;
    private JTextField rotationField;
    private JTextField distanceField;
    private JRadioButton perspectiveRB;
    private JRadioButton noperspectiveRB;
    private JRadioButton planarxyRB;
    private JRadioButton planarxzRB;
    private JRadioButton planaryzRB;
    private AbstractList<ActionListener> listeners = new ArrayList<ActionListener>();

    public static JFrame createFrame(DrawingPanel3D panel) {
        return new CameraInspectorFrame(ToolsRes.getString("CameraInspector.FrameTitle"), new CameraInspector(panel));
    }

    public static JFrame createFrame(CameraInspector inspector) {
        return new CameraInspectorFrame(ToolsRes.getString("CameraInspector.FrameTitle"), inspector);
    }

    public CameraInspector(DrawingPanel3D _panel3D) {
        this.panel = _panel3D;
        this.camera = _panel3D.getCamera();
        _panel3D.addInteractionListener(this);
        ActionListener fieldListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                String cmd = evt.getActionCommand();
                JTextField field = (JTextField)evt.getSource();
                double value = 0.0;
                try {
                    value = CameraInspector.this.format.parse(field.getText()).doubleValue();
                }
                catch (ParseException exc) {
                    value = 0.0;
                }
                if (cmd.equals("x")) {
                    CameraInspector.this.camera.setXYZ(value, CameraInspector.this.camera.getY(), CameraInspector.this.camera.getZ());
                } else if (cmd.equals("y")) {
                    CameraInspector.this.camera.setXYZ(CameraInspector.this.camera.getX(), value, CameraInspector.this.camera.getZ());
                } else if (cmd.equals("z")) {
                    CameraInspector.this.camera.setXYZ(CameraInspector.this.camera.getX(), CameraInspector.this.camera.getY(), value);
                } else if (cmd.equals("focusx")) {
                    CameraInspector.this.camera.setFocusXYZ(value, CameraInspector.this.camera.getFocusY(), CameraInspector.this.camera.getFocusZ());
                } else if (cmd.equals("focusy")) {
                    CameraInspector.this.camera.setFocusXYZ(CameraInspector.this.camera.getFocusX(), value, CameraInspector.this.camera.getFocusZ());
                } else if (cmd.equals("focusz")) {
                    CameraInspector.this.camera.setFocusXYZ(CameraInspector.this.camera.getFocusX(), CameraInspector.this.camera.getFocusY(), value);
                } else if (cmd.equals("azimuth")) {
                    CameraInspector.this.camera.setAzimuth(value);
                } else if (cmd.equals("altitude")) {
                    CameraInspector.this.camera.setAltitude(value);
                } else if (cmd.equals("rotation")) {
                    CameraInspector.this.camera.setRotation(value);
                } else if (cmd.equals("screen")) {
                    CameraInspector.this.camera.setDistanceToScreen(value);
                }
                CameraInspector.this.panel.getImplementingPanel().forceRefresh();
                CameraInspector.this.updateFields();
                ActionEvent event = new ActionEvent(CameraInspector.this, 1001, "FieldChange");
                Iterator it = CameraInspector.this.listeners.iterator();
                while (it.hasNext()) {
                    ((ActionListener)it.next()).actionPerformed(event);
                }
            }
        };
        ActionListener buttonListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                String cmd = evt.getActionCommand();
                if (cmd.equals("reset")) {
                    CameraInspector.this.camera.reset();
                    CameraInspector.this.panel.getImplementingPanel().forceRefresh();
                    CameraInspector.this.updateFields();
                } else if (cmd.equals("perspective")) {
                    CameraInspector.this.camera.setProjectionMode(11);
                } else if (cmd.equals("perspective_on")) {
                    CameraInspector.this.camera.setProjectionMode(4);
                } else if (cmd.equals("no_perspective")) {
                    CameraInspector.this.camera.setProjectionMode(10);
                } else if (cmd.equals("perspective_off")) {
                    CameraInspector.this.camera.setProjectionMode(3);
                } else if (cmd.equals("planarXY")) {
                    CameraInspector.this.camera.setProjectionMode(0);
                } else if (cmd.equals("planarXZ")) {
                    CameraInspector.this.camera.setProjectionMode(1);
                } else if (cmd.equals("planarYZ")) {
                    CameraInspector.this.camera.setProjectionMode(2);
                }
                if (CameraInspector.this.panel.getResetCameraOnChanges()) {
                    CameraInspector.this.camera.reset();
                }
                ActionEvent event = new ActionEvent(CameraInspector.this, 1001, "ButtonChange");
                Iterator it = CameraInspector.this.listeners.iterator();
                while (it.hasNext()) {
                    ((ActionListener)it.next()).actionPerformed(event);
                }
            }
        };
        this.setLayout(new BorderLayout());
        JPanel projectionPanel = new JPanel(new GridLayout(2, 3));
        projectionPanel.setBorder(new TitledBorder(ToolsRes.getString("CameraInspector.ProjectionMode")));
        ButtonGroup group = new ButtonGroup();
        this.perspectiveRB = new JRadioButton(ToolsRes.getString("CameraInspector.Perspective"));
        this.perspectiveRB.setActionCommand("perspective");
        this.perspectiveRB.addActionListener(buttonListener);
        projectionPanel.add(this.perspectiveRB);
        group.add(this.perspectiveRB);
        this.planarxyRB = new JRadioButton(ToolsRes.getString("CameraInspector.PlanarXY"));
        this.planarxyRB.setActionCommand("planarXY");
        this.planarxyRB.addActionListener(buttonListener);
        projectionPanel.add(this.planarxyRB);
        group.add(this.planarxyRB);
        this.planaryzRB = new JRadioButton(ToolsRes.getString("CameraInspector.PlanarYZ"));
        this.planaryzRB.setActionCommand("planarYZ");
        this.planaryzRB.addActionListener(buttonListener);
        projectionPanel.add(this.planaryzRB);
        group.add(this.planaryzRB);
        this.noperspectiveRB = new JRadioButton(ToolsRes.getString("CameraInspector.NoPerspective"));
        this.noperspectiveRB.setActionCommand("no_perspective");
        this.noperspectiveRB.addActionListener(buttonListener);
        projectionPanel.add(this.noperspectiveRB);
        group.add(this.noperspectiveRB);
        this.planarxzRB = new JRadioButton(ToolsRes.getString("CameraInspector.PlanarXZ"));
        this.planarxzRB.setActionCommand("planarXZ");
        this.planarxzRB.addActionListener(buttonListener);
        projectionPanel.add(this.planarxzRB);
        group.add(this.planarxzRB);
        JPanel topPanel = new JPanel(new BorderLayout());
        topPanel.add((Component)projectionPanel, "Center");
        this.add((Component)projectionPanel, "North");
        JPanel labelPanel = new JPanel(new GridLayout(0, 1));
        JPanel fieldPanel = new JPanel(new GridLayout(0, 1));
        JPanel label2Panel = new JPanel(new GridLayout(0, 1));
        JPanel field2Panel = new JPanel(new GridLayout(0, 1));
        this.xField = CameraInspector.createRow(labelPanel, fieldPanel, "X", fieldListener);
        this.yField = CameraInspector.createRow(labelPanel, fieldPanel, "Y", fieldListener);
        this.zField = CameraInspector.createRow(labelPanel, fieldPanel, "Z", fieldListener);
        this.focusxField = CameraInspector.createRow(label2Panel, field2Panel, "FocusX", fieldListener);
        this.focusyField = CameraInspector.createRow(label2Panel, field2Panel, "FocusY", fieldListener);
        this.focuszField = CameraInspector.createRow(label2Panel, field2Panel, "FocusZ", fieldListener);
        this.azimuthField = CameraInspector.createRow(labelPanel, fieldPanel, "Azimuth", fieldListener);
        this.altitudeField = CameraInspector.createRow(labelPanel, fieldPanel, "Altitude", fieldListener);
        this.rotationField = CameraInspector.createRow(label2Panel, field2Panel, "Rotation", fieldListener);
        this.distanceField = CameraInspector.createRow(label2Panel, field2Panel, "Screen", fieldListener);
        JPanel leftPanel = new JPanel(new BorderLayout());
        leftPanel.add((Component)labelPanel, "West");
        leftPanel.add((Component)fieldPanel, "Center");
        JPanel rightPanel = new JPanel(new BorderLayout());
        rightPanel.add((Component)label2Panel, "West");
        rightPanel.add((Component)field2Panel, "Center");
        JPanel centerPanel = new JPanel(new GridLayout(1, 0));
        centerPanel.setBorder(new TitledBorder(ToolsRes.getString("CameraInspector.CameraParameters")));
        centerPanel.add(leftPanel);
        centerPanel.add(rightPanel);
        this.add((Component)centerPanel, "Center");
        JButton resetButton = new JButton(ToolsRes.getString("CameraInspector.ResetCamera"));
        resetButton.setActionCommand("reset");
        resetButton.addActionListener(buttonListener);
        this.add((Component)resetButton, "South");
        this.updateFields();
    }

    public void setFormat(NumberFormat format) {
        this.format = format;
    }

    public void addActionListener(ActionListener listener) {
        this.listeners.add(listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void interactionPerformed(InteractionEvent _event) {
        if (_event.getSource() != this.panel) {
            return;
        }
        if (_event.getInfo() != null) {
            return;
        }
        this.updateFields();
    }

    public void updateFields() {
        switch (this.camera.getProjectionMode()) {
            default: {
                this.perspectiveRB.setSelected(true);
                break;
            }
            case 3: 
            case 10: {
                this.noperspectiveRB.setSelected(true);
                break;
            }
            case 0: {
                this.planarxyRB.setSelected(true);
                break;
            }
            case 1: {
                this.planarxzRB.setSelected(true);
                break;
            }
            case 2: {
                this.planaryzRB.setSelected(true);
            }
        }
        this.xField.setText(this.format.format(this.camera.getX()));
        this.yField.setText(this.format.format(this.camera.getY()));
        this.zField.setText(this.format.format(this.camera.getZ()));
        this.focusxField.setText(this.format.format(this.camera.getFocusX()));
        this.focusyField.setText(this.format.format(this.camera.getFocusY()));
        this.focuszField.setText(this.format.format(this.camera.getFocusZ()));
        this.azimuthField.setText(this.format.format(this.camera.getAzimuth()));
        this.altitudeField.setText(this.format.format(this.camera.getAltitude()));
        this.rotationField.setText(this.format.format(this.camera.getRotation()));
        this.distanceField.setText(this.format.format(this.camera.getDistanceToScreen()));
    }

    private static JTextField createRow(JPanel labelParent, JPanel fieldParent, String labelText, ActionListener listener) {
        if (labelText == null) {
            labelParent.add(new JLabel());
            fieldParent.add(new JLabel());
            return null;
        }
        JLabel label = new JLabel(ToolsRes.getString("CameraInspector." + labelText));
        label.setHorizontalAlignment(0);
        label.setBorder(new EmptyBorder(0, 3, 0, 3));
        JTextField field = new JTextField(4);
        field.setActionCommand(labelText.toLowerCase());
        field.addActionListener(listener);
        labelParent.add(label);
        fieldParent.add(field);
        return field;
    }
}

