/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.drawing3d.simple3d;

import org.opensourcephysics.drawing3d.ElementEllipsoid;
import org.opensourcephysics.drawing3d.simple3d.SimpleAbstractTile;
import org.opensourcephysics.drawing3d.utils.Resolution;

public class SimpleElementEllipsoid
extends SimpleAbstractTile {
    public SimpleElementEllipsoid(ElementEllipsoid _element) {
        super(_element);
    }

    @Override
    protected double[][][] computeTile() {
        Resolution res;
        ElementEllipsoid ellipsoid = (ElementEllipsoid)this.element;
        int nr = 1;
        int nu = 1;
        int nv = 1;
        double angleu1 = ellipsoid.getMinimumAngleU();
        double angleu2 = ellipsoid.getMaximumAngleU();
        if (Math.abs(angleu2 - angleu1) > 360.0) {
            angleu2 = angleu1 + 360.0;
        }
        double anglev1 = ellipsoid.getMinimumAngleV();
        double anglev2 = ellipsoid.getMaximumAngleV();
        if (Math.abs(anglev2 - anglev1) > 180.0) {
            anglev2 = anglev1 + 180.0;
        }
        if ((res = this.style.getResolution()) != null) {
            switch (res.getType()) {
                case 0: {
                    nr = Math.max(res.getN1(), 1);
                    nu = Math.max(res.getN2(), 1);
                    nv = Math.max(res.getN3(), 1);
                    break;
                }
                case 1: {
                    double maxRadius = Math.max(Math.max(Math.abs(this.element.getSizeX()), Math.abs(this.element.getSizeY())), Math.abs(this.element.getSizeZ())) / 2.0;
                    nr = Math.max((int)Math.round(0.49 + maxRadius / res.getMaxLength()), 1);
                    nu = Math.max((int)Math.round(0.49 + Math.abs(angleu2 - angleu1) * (Math.PI / 180) * maxRadius / res.getMaxLength()), 1);
                    nv = Math.max((int)Math.round(0.49 + Math.abs(anglev2 - anglev1) * (Math.PI / 180) * maxRadius / res.getMaxLength()), 1);
                }
            }
        }
        return ElementEllipsoid.createStandardEllipsoid(nr, nu, nv, angleu1, angleu2, anglev1, anglev2, ellipsoid.isClosedTop(), ellipsoid.isClosedBottom(), ellipsoid.isClosedLeft(), ellipsoid.isClosedRight());
    }
}

