/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.drawing3d.java3d;

import com.sun.j3d.utils.geometry.Sphere;
import com.sun.j3d.utils.image.TextureLoader;
import com.sun.j3d.utils.universe.SimpleUniverse;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsConfigTemplate;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.media.j3d.AmbientLight;
import javax.media.j3d.Appearance;
import javax.media.j3d.Background;
import javax.media.j3d.BadTransformException;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.DirectionalLight;
import javax.media.j3d.Geometry;
import javax.media.j3d.GraphicsConfigTemplate3D;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.J3DGraphics2D;
import javax.media.j3d.Light;
import javax.media.j3d.Node;
import javax.media.j3d.QuadArray;
import javax.media.j3d.RenderingAttributes;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.swing.JOptionPane;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.TexCoord2f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import org.opensourcephysics.display.TextPanel;
import org.opensourcephysics.display3d.simple3d.utils.EllipsoidUtils;
import org.opensourcephysics.drawing3d.DrawingPanel3D;
import org.opensourcephysics.drawing3d.Element;
import org.opensourcephysics.drawing3d.ElementText;
import org.opensourcephysics.drawing3d.java3d.Java3dElementText;
import org.opensourcephysics.drawing3d.utils.Camera;
import org.opensourcephysics.drawing3d.utils.ImplementingPanel;
import org.opensourcephysics.tools.ResourceLoader;

public class Java3dDrawingPanel3D
implements ImplementingPanel {
    public RenderCanvas canvas;
    protected boolean updateModel = false;
    private DrawingPanel3D panel3D;
    private static double RBACK = 5.0;
    private static final int BACKGROUND = 3;
    private SimpleUniverse universe;
    private TransformGroup rootTG;
    private TransformGroup scaleTG;
    private TransformGroup backTG;
    private BranchGroup branchGroup;
    private Appearance appBack;
    private BoundingSphere bounds;
    protected Java3DTextPanel trMessageBox = new Java3DTextPanel(2);
    protected Java3DTextPanel tlMessageBox = new Java3DTextPanel(3);
    protected Java3DTextPanel brMessageBox = new Java3DTextPanel(1);
    protected Java3DTextPanel blMessageBox = new Java3DTextPanel(0);
    private static RenderingHints optionsImage = new RenderingHints(null);

    static {
        optionsImage.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        optionsImage.put(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        optionsImage.put(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_DISABLE);
        optionsImage.put(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        optionsImage.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        optionsImage.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        optionsImage.put(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        optionsImage.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
    }

    public Java3dDrawingPanel3D(DrawingPanel3D _panel) {
        this.panel3D = _panel;
        GraphicsConfiguration config = Java3dDrawingPanel3D.getPreferredConfiguration();
        this.canvas = new RenderCanvas(config);
        this.canvas.setSize(new Dimension(300, 300));
        this.canvas.setDoubleBufferEnable(true);
        this.canvas.setBackground(this.panel3D.getVisualizationHints().getBackgroundColor());
        this.branchGroup = new BranchGroup();
        this.branchGroup.setCapability(14);
        this.branchGroup.setCapability(12);
        this.branchGroup.setCapability(13);
        this.bounds = new BoundingSphere();
        this.bounds.setRadius(Double.MAX_VALUE);
        AmbientLight lightA = new AmbientLight();
        lightA.setCapability(14);
        lightA.setCapability(15);
        lightA.setCapability(12);
        lightA.setCapability(13);
        lightA.setInfluencingBounds((Bounds)this.bounds);
        lightA.setColor(new Color3f(Color.white));
        this.branchGroup.addChild((Node)lightA);
        DirectionalLight lightD = new DirectionalLight();
        lightD.setCapability(14);
        lightD.setCapability(15);
        lightD.setCapability(18);
        lightD.setCapability(19);
        lightD.setCapability(12);
        lightD.setCapability(13);
        lightD.setInfluencingBounds((Bounds)this.bounds);
        lightD.setColor(new Color3f(Color.white));
        lightD.setDirection(new Vector3f(0.0f, 0.0f, -1.0f));
        this.branchGroup.addChild((Node)lightD);
        this.rootTG = new TransformGroup();
        this.rootTG.setCapability(12);
        this.rootTG.setCapability(13);
        this.rootTG.setCapability(14);
        this.rootTG.setCapability(18);
        this.rootTG.setCapability(17);
        this.rootTG.setCapability(17);
        this.rootTG.setBounds((Bounds)this.bounds);
        this.branchGroup.addChild((Node)this.rootTG);
        Color3f bkgdColor = new Color3f(this.panel3D.getVisualizationHints().getBackgroundColor());
        Background backGround = new Background(bkgdColor);
        backGround.setCapability(17);
        backGround.setCapability(15);
        backGround.setCapability(21);
        backGround.setApplicationBounds((Bounds)new BoundingSphere());
        BranchGroup bg = new BranchGroup();
        bg.setCapability(17);
        bg.setCapability(12);
        bg.setCapability(13);
        bg.addChild((Node)backGround);
        this.branchGroup.addChild((Node)bg);
        this.backTG = new TransformGroup();
        this.backTG.setCapability(12);
        this.backTG.setCapability(13);
        this.backTG.setCapability(17);
        this.backTG.setCapability(18);
        this.backTG.setCapability(14);
        Transform3D scaleBack = new Transform3D();
        scaleBack.setScale(RBACK * this.panel3D.getMaximum3DSize());
        this.backTG.setTransform(scaleBack);
        this.rootTG.addChild((Node)this.backTG);
        this.scaleTG = new TransformGroup();
        this.scaleTG.setCapability(14);
        this.scaleTG.setCapability(18);
        this.scaleTG.setCapability(17);
        this.scaleTG.setBounds((Bounds)this.bounds);
        this.rootTG.addChild((Node)this.scaleTG);
        this.universe = new SimpleUniverse(this.canvas);
        this.universe.getViewer().getView().setLocalEyeLightingEnable(true);
        this.universe.getViewer().getView().setCompatibilityModeEnable(false);
        this.universe.getViewer().getView().setBackClipDistance(200.0);
        this.universe.addBranchGraph(this.branchGroup);
    }

    protected TransformGroup getTransformGroup() {
        return this.rootTG;
    }

    private static final GraphicsConfiguration getPreferredConfiguration() {
        GraphicsConfigTemplate3D template = new GraphicsConfigTemplate3D();
        String stereo = (String)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return System.getProperty("j3d.stereo");
            }
        });
        if (stereo != null) {
            if (stereo.equals("REQUIRED")) {
                template.setStereo(1);
            } else if (stereo.equals("PREFERRED")) {
                template.setStereo(2);
            }
        }
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getBestConfiguration((GraphicsConfigTemplate)template);
    }

    public double getScreenRatio() {
        return this.panel3D.isSquareAspect() ? (float)this.canvas.getWidth() / (float)this.canvas.getHeight() : 1.0f;
    }

    @Override
    public Component getComponent() {
        return this.canvas;
    }

    @Override
    public void forceRefresh() {
        this.update();
    }

    @Override
    public synchronized void update() {
        for (Element el : this.panel3D.getElements()) {
            el.processChanges(0);
        }
        for (Element el : this.panel3D.getDecoration().getElementList()) {
            el.processChanges(0);
        }
        this.cameraChanged(0);
        this.updateModel = true;
    }

    @Override
    public void setFastRedraw(boolean fast) {
    }

    @Override
    public void cameraChanged(int change) {
        Camera camera = this.panel3D.getCamera();
        block1 : switch (change) {
            case 5: {
                double factor = 1.0;
                double dif = 0.0;
                int diferencia = 0;
                if (this.getComponent().getWidth() >= this.getComponent().getHeight()) {
                    dif = this.getComponent().getWidth() - this.getComponent().getHeight();
                    diferencia = (int)(dif / 10.0);
                    factor = diferencia < 10 ? 0.8 + 0.05 * (double)diferencia : (-6.0E-5 * Math.pow(diferencia, 3.0) + 0.0083 * Math.pow(diferencia, 2.0) - 0.4011 * (double)diferencia + 8.59) * dif / (double)this.getComponent().getWidth();
                }
                if (this.getComponent().getWidth() < this.getComponent().getHeight()) {
                    dif = this.getComponent().getHeight() - this.getComponent().getWidth();
                    diferencia = (int)(dif / 10.0);
                    if (diferencia < 10) {
                        factor = 0.65 + 0.045 * (double)diferencia;
                    }
                    factor = 3.0E-8 * Math.pow(dif, 3.0) - 2.0E-5 * Math.pow(dif, 2.0) + 0.0078 * dif + 0.686;
                }
                double scale = 1.37 * ((double)this.getComponent().getWidth() * factor / (double)this.getComponent().getHeight());
                double fov = 2.0 * Math.atan(scale * this.panel3D.getDiagonal() / (2.0 * camera.getDistanceToScreen()));
                this.universe.getViewer().getView().setFieldOfView(fov);
                break;
            }
            case 7: {
                this.panel3D.getDecoration().reset();
                for (Element el : this.panel3D.getElements()) {
                    el.getImplementingObject().processChanges(279, 279);
                }
                break;
            }
            case 0: {
                double factor = 1.0;
                double dif = 0.0;
                int diferencia = 0;
                if (this.getComponent().getWidth() >= this.getComponent().getHeight()) {
                    dif = this.getComponent().getWidth() - this.getComponent().getHeight();
                    diferencia = (int)(dif / 10.0);
                    factor = diferencia < 10 ? 0.8 + 0.05 * (double)diferencia : (-6.0E-5 * Math.pow(diferencia, 3.0) + 0.0083 * Math.pow(diferencia, 2.0) - 0.4011 * (double)diferencia + 8.59) * dif / (double)this.getComponent().getWidth();
                }
                if (this.getComponent().getWidth() < this.getComponent().getHeight()) {
                    dif = this.getComponent().getHeight() - this.getComponent().getWidth();
                    diferencia = (int)(dif / 10.0);
                    if (diferencia < 10) {
                        factor = 0.65 + 0.045 * (double)diferencia;
                    }
                    factor = 3.0E-8 * Math.pow(dif, 3.0) - 2.0E-5 * Math.pow(dif, 2.0) + 0.0078 * dif + 0.686;
                }
                double scale = 1.37 * ((double)this.getComponent().getWidth() * factor / (double)this.getComponent().getHeight());
                double fov = 2.0 * Math.atan(scale * this.panel3D.getDiagonal() / (2.0 * camera.getDistanceToScreen()));
                this.universe.getViewer().getView().setFieldOfView(fov);
            }
            case 1: {
                switch (this.panel3D.getCamera().getProjectionMode()) {
                    case 0: {
                        this.universe.getViewer().getView().setProjectionPolicy(0);
                        break block1;
                    }
                    case 1: {
                        this.universe.getViewer().getView().setProjectionPolicy(0);
                        break block1;
                    }
                    case 2: {
                        this.universe.getViewer().getView().setProjectionPolicy(0);
                        break block1;
                    }
                    case 4: 
                    case 11: {
                        this.universe.getViewer().getView().setProjectionPolicy(1);
                        break block1;
                    }
                }
            }
        }
        for (ElementText text : this.panel3D.getTextElements()) {
            ((Java3dElementText)text.getImplementingObject()).updateText(camera.getDistanceToScreen());
        }
        Transform3D currXform = new Transform3D();
        Vector3d position = this.getPerspectivePosition(camera);
        try {
            if (camera.getProjectionMode() == 0) {
                currXform.lookAt(new Point3d(position.x, position.y, position.z), new Point3d(camera.getFocusX(), camera.getFocusY(), camera.getFocusZ()), new Vector3d(0.0, 1.0, 0.0));
            } else {
                currXform.lookAt(new Point3d(position.x, position.y, position.z), new Point3d(camera.getFocusX(), camera.getFocusY(), camera.getFocusZ()), new Vector3d(0.0, 0.0, 1.0));
            }
            this.rootTG.setTransform(currXform);
        }
        catch (BadTransformException badTransformException) {
            // empty catch block
        }
    }

    private Vector3d getPerspectivePosition(Camera camera) {
        if (camera.is3dMode()) {
            return new Vector3d(camera.getX(), camera.getY(), camera.getZ());
        }
        Vector3d position = new Vector3d(camera.map(this.panel3D.getCenter()));
        switch (camera.getProjectionMode()) {
            case 0: {
                position.z += camera.getDistanceToFocus();
                break;
            }
            case 1: {
                position.y -= camera.getDistanceToFocus();
                break;
            }
            case 2: {
                position.x += camera.getDistanceToFocus();
            }
        }
        return position;
    }

    @Override
    public void setMessage(String msg) {
        this.brMessageBox.setText(msg);
    }

    @Override
    public void setMessage(String msg, int location) {
        switch (location) {
            case 0: {
                this.blMessageBox.setText(msg);
                break;
            }
            default: {
                this.brMessageBox.setText(msg);
                break;
            }
            case 2: {
                this.trMessageBox.setText(msg);
                break;
            }
            case 3: {
                this.tlMessageBox.setText(msg);
            }
        }
    }

    @Override
    public BufferedImage render() {
        this.update();
        return null;
    }

    @Override
    public BufferedImage render(BufferedImage image) {
        this.update();
        return null;
    }

    public void hintChanged(int hintThatChanged) {
    }

    public void mouseDragged(MouseEvent evt) {
    }

    @Override
    public void visualizationChanged(int _change) {
        switch (_change) {
            case 7: {
                if (this.panel3D.getVisualizationHints().getBackgroundImage() != null) {
                    this.setImage(this.panel3D.getVisualizationHints().getBackgroundImage(), this.panel3D.getVisualizationHints().getBackgroundTile(), null);
                    break;
                }
                this.setImage(this.panel3D.getVisualizationHints().getBackgroundImageFilename(), this.panel3D.getVisualizationHints().getBackgroundTile());
                break;
            }
            case 8: {
                this.setBackgroundMoveable(this.panel3D.getVisualizationHints().getBackgroundMoveable());
                break;
            }
            case 10: {
                if (this.panel3D.getVisualizationHints().getBackgroundImage() != null) {
                    this.setImage(this.panel3D.getVisualizationHints().getBackgroundImage(), this.panel3D.getVisualizationHints().getBackgroundTile(), null);
                    break;
                }
                this.setImage(this.panel3D.getVisualizationHints().getBackgroundImageFilename(), this.panel3D.getVisualizationHints().getBackgroundTile());
                break;
            }
            case 12: {
                this.setLightEnabled(this.panel3D.getVisualizationHints().getDefaultIllumination());
                break;
            }
            case 9: {
                this.setScaleBackground(this.panel3D.getVisualizationHints().getScaleBackground());
            }
        }
    }

    private void setImage(String _name, Dimension _tile) {
        if (_name == null) {
            this.setImage(null, _tile, null);
        } else {
            this.setImage(ResourceLoader.getBufferedImage(_name), _tile, ResourceLoader.getResource(_name).getURL());
        }
    }

    private void setImage(Image _image, Dimension _tile, URL _url) {
        if (_image == null) {
            this.branchGroup.removeChild(3);
            if (this.backTG.numChildren() > 0) {
                this.backTG.removeChild(0);
            }
            this.setBackgroundMoveable(false);
            Color3f bkgdColor = new Color3f(this.panel3D.getVisualizationHints().getBackgroundColor());
            Background backGround = new Background(bkgdColor);
            backGround.setCapability(17);
            backGround.setCapability(15);
            backGround.setCapability(21);
            backGround.setApplicationBounds((Bounds)new BoundingSphere());
            BranchGroup bg = new BranchGroup();
            bg.setCapability(17);
            bg.setCapability(12);
            bg.addChild((Node)backGround);
            this.branchGroup.addChild((Node)bg);
            this.canvas.setBackground(this.panel3D.getVisualizationHints().getBackgroundColor());
            return;
        }
        if (!(_image instanceof BufferedImage)) {
            JOptionPane.showMessageDialog(this.getComponent(), "Image for background must be a BufferedImaged", "DrawingPanel3D error", 0);
            return;
        }
        int width = 0;
        int height = 0;
        BufferedImage bufImg = (BufferedImage)_image;
        width = _tile == null ? this.canvas.getWidth() : _tile.width;
        height = _tile == null ? this.canvas.getHeight() : _tile.height;
        AffineTransformOp op = new AffineTransformOp(AffineTransform.getScaleInstance((double)width / (double)bufImg.getWidth(), (double)height / (double)bufImg.getHeight()), optionsImage);
        ImageComponent2D image2D = new ImageComponent2D(2, op.filter(bufImg, null));
        BranchGroup bg = (BranchGroup)this.branchGroup.getChild(3);
        Background bgImage = (Background)bg.getChild(0);
        if (_tile != null) {
            bgImage.setImageScaleMode(4);
            if (this.backTG.numChildren() > 0) {
                this.backTG.removeChild(0);
            }
            if (this.backTG.numChildren() <= 0) {
                this.backTG.addChild((Node)this.getShapeBackground(_tile));
            }
        } else {
            bgImage.setImageScaleMode(3);
            if (this.backTG.numChildren() > 0) {
                this.backTG.removeChild(0);
            }
            if (this.backTG.numChildren() <= 0) {
                this.backTG.addChild((Node)this.getShapeBackground(null));
            }
        }
        if (_url != null) {
            TextureLoader tex = new TextureLoader(_url, new String("RGBA"), 6, null);
            this.appBack.setTexture(tex.getTexture());
        }
        bgImage.setImage(image2D);
        this.setBackgroundMoveable(this.panel3D.getVisualizationHints().getBackgroundMoveable());
    }

    private void setBackgroundMoveable(boolean _state) {
        if (this.appBack != null) {
            this.appBack.getRenderingAttributes().setVisible(_state);
        }
    }

    private void setScaleBackground(double _factor) {
        Transform3D scaleBack = new Transform3D();
        scaleBack.setScale(RBACK * _factor);
        this.backTG.setTransform(scaleBack);
    }

    private BranchGroup getShapeBackground(Dimension _tile) {
        Shape3D shape = null;
        Sphere s = null;
        float radius = 0.5f;
        BranchGroup bg = new BranchGroup();
        bg.setCapability(17);
        bg.setCapability(14);
        TransformGroup tg = new TransformGroup();
        tg.setCapability(12);
        tg.setCapability(14);
        tg.setCapability(17);
        Transform3D t = new Transform3D();
        this.appBack = new Appearance();
        this.appBack.setCapability(3);
        this.appBack.setCapability(12);
        RenderingAttributes ra = new RenderingAttributes();
        ra.setCapability(6);
        this.appBack.setRenderingAttributes(ra);
        this.appBack.getRenderingAttributes().setVisible(this.panel3D.getVisualizationHints().getBackgroundMoveable());
        if (_tile != null) {
            shape = this.createTileBackground(_tile.width, _tile.height);
            shape.setAppearance(this.appBack);
            t.setScale(new Vector3d(1.0, 1.0, 1.0));
            tg.setTransform(t);
            tg.addChild((Node)shape);
            bg.addChild((Node)tg);
        } else {
            s = new Sphere(radius, 102, 45);
            t.rotX(-1.5707963267948966);
            s.setAppearance(this.appBack);
            tg.setTransform(t);
            tg.addChild((Node)s);
            bg.addChild((Node)tg);
        }
        return bg;
    }

    private Shape3D createTileBackground(int w, int h) {
        double[][][] tileSphere = null;
        int res = 0;
        if (w >= 100 || h >= 100) {
            res = 10;
        } else {
            float temp = -0.18f * (float)(w + h) / 2.0f + 30.0f;
            res = (int)temp;
        }
        tileSphere = EllipsoidUtils.createStandardEllipsoid(res, res, res, 0.0, 360.0, -90.0, 90.0, true, true, true, true);
        int totalN = tileSphere.length;
        int tileSize = tileSphere[0].length;
        Point3d[] coords = new Point3d[totalN * tileSize];
        TexCoord2f[] texCoords = new TexCoord2f[totalN * tileSize];
        TexCoord2f[] texCoordTile = new TexCoord2f[]{new TexCoord2f(0.0f, 0.0f), new TexCoord2f(1.0f, 0.0f), new TexCoord2f(1.0f, 1.0f), new TexCoord2f(0.0f, 1.0f)};
        QuadArray quad = new QuadArray(totalN * tileSize, 33);
        int n = 0;
        while (n < totalN) {
            int j = 0;
            while (j < tileSize) {
                texCoords[n * tileSize + j] = new TexCoord2f(texCoordTile[j]);
                if (j == 0) {
                    coords[n * tileSize + j + 3] = new Point3d(tileSphere[n][j][0], tileSphere[n][j][1], tileSphere[n][j][2]);
                } else if (j == 1) {
                    coords[n * tileSize + j + 1] = new Point3d(tileSphere[n][j][0], tileSphere[n][j][1], tileSphere[n][j][2]);
                } else if (j == 2) {
                    coords[n * tileSize + j - 1] = new Point3d(tileSphere[n][j][0], tileSphere[n][j][1], tileSphere[n][j][2]);
                } else {
                    coords[n * tileSize + j - 3] = new Point3d(tileSphere[n][j][0], tileSphere[n][j][1], tileSphere[n][j][2]);
                }
                ++j;
            }
            ++n;
        }
        quad.setCoordinates(0, coords);
        quad.setTextureCoordinates(0, 0, texCoords);
        Shape3D shape = new Shape3D((Geometry)quad, this.appBack);
        return shape;
    }

    public void setLightEnabled(boolean _state) {
        int i = 0;
        while (i < 2) {
            Light light = (Light)this.branchGroup.getChild(i);
            light.setEnable(_state);
            ++i;
        }
    }

    public void SetUpdateModel(boolean _state) {
        this.updateModel = _state;
    }

    public boolean GetUpdateModel() {
        return this.updateModel;
    }

    private class Java3DTextPanel
    extends TextPanel {
        private BufferedImage image;
        private int location;

        public Java3DTextPanel(int _location) {
            this.location = _location;
            int width = 200;
            int height = 50;
            this.image = new BufferedImage(width, height, 2);
        }

        public void render(J3DGraphics2D g2d) {
            switch (this.location) {
                case 3: {
                    g2d.drawAndFlushImage(this.image, 0, 0, null);
                    break;
                }
                case 2: {
                    g2d.drawAndFlushImage(this.image, Java3dDrawingPanel3D.this.canvas.getWidth() - this.getWidth(), 0, null);
                    break;
                }
                case 1: {
                    g2d.drawAndFlushImage(this.image, Java3dDrawingPanel3D.this.canvas.getWidth() - this.getWidth(), Java3dDrawingPanel3D.this.canvas.getHeight() - this.getHeight(), null);
                    break;
                }
                default: {
                    g2d.drawAndFlushImage(this.image, 0, Java3dDrawingPanel3D.this.canvas.getHeight() - this.getHeight(), null);
                }
            }
        }

        @Override
        public void setText(String _text) {
            super.setText(_text);
            int width = this.getWidth();
            int height = this.getHeight();
            if (width == 0 || height == 0) {
                return;
            }
            if (this.image.getWidth() != width || this.image.getHeight() != height) {
                this.image = new BufferedImage(this.getWidth(), this.getHeight(), 2);
            }
            this.paint(this.image.getGraphics());
        }
    }

    private class RenderCanvas
    extends Canvas3D {
        RenderCanvas(GraphicsConfiguration config) {
            super(config);
        }

        public void postRender() {
            J3DGraphics2D g2d = Java3dDrawingPanel3D.this.canvas.getGraphics2D();
            Java3dDrawingPanel3D.this.tlMessageBox.render(g2d);
            Java3dDrawingPanel3D.this.trMessageBox.render(g2d);
            Java3dDrawingPanel3D.this.brMessageBox.render(g2d);
            Java3dDrawingPanel3D.this.blMessageBox.render(g2d);
        }

        public void preRender() {
            try {
                Thread.sleep(75L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

