/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.drawing3d;

import org.opensourcephysics.drawing3d.Element;
import org.opensourcephysics.drawing3d.java3d.Java3dElementEllipsoid;
import org.opensourcephysics.drawing3d.simple3d.SimpleElementEllipsoid;
import org.opensourcephysics.drawing3d.utils.ImplementingObject;
import org.opensourcephysics.drawing3d.utils.Resolution;

public class ElementEllipsoid
extends Element {
    private boolean closedBottom = true;
    private boolean closedTop = true;
    private boolean closedLeft = true;
    private boolean closedRight = true;
    private int minAngleU = 0;
    private int maxAngleU = 360;
    private int minAngleV = -90;
    private int maxAngleV = 90;

    public ElementEllipsoid() {
        this.getStyle().setResolution(new Resolution(3, 12, 12));
    }

    @Override
    protected ImplementingObject createImplementingObject(int _implementation) {
        switch (_implementation) {
            default: {
                return new SimpleElementEllipsoid(this);
            }
            case 1: 
        }
        return new Java3dElementEllipsoid(this);
    }

    public void setClosedBottom(boolean close) {
        if (this.closedBottom == close) {
            return;
        }
        this.closedBottom = close;
        this.addChange(8);
    }

    public boolean isClosedBottom() {
        return this.closedBottom;
    }

    public void setClosedTop(boolean close) {
        if (this.closedTop == close) {
            return;
        }
        this.closedTop = close;
        this.addChange(8);
    }

    public boolean isClosedTop() {
        return this.closedTop;
    }

    public void setClosedLeft(boolean close) {
        if (this.closedLeft == close) {
            return;
        }
        this.closedLeft = close;
        this.addChange(8);
    }

    public boolean isClosedLeft() {
        return this.closedLeft;
    }

    public void setClosedRight(boolean close) {
        if (this.closedRight == close) {
            return;
        }
        this.closedRight = close;
        this.addChange(8);
    }

    public boolean isClosedRight() {
        return this.closedRight;
    }

    public void setMinimumAngleU(int angle) {
        if (this.minAngleU == angle) {
            return;
        }
        this.minAngleU = Math.max(0, Math.min(360, angle));
        this.addChange(8);
    }

    public int getMinimumAngleU() {
        return this.minAngleU;
    }

    public void setMaximumAngleU(int angle) {
        if (this.maxAngleU == angle) {
            return;
        }
        this.maxAngleU = Math.max(0, Math.min(360, angle));
        this.addChange(8);
    }

    public int getMaximumAngleU() {
        return this.maxAngleU;
    }

    public void setMinimumAngleV(int angle) {
        if (this.minAngleV == angle) {
            return;
        }
        this.minAngleV = Math.max(-90, Math.min(90, angle));
        this.addChange(8);
    }

    public int getMinimumAngleV() {
        return this.minAngleV;
    }

    public void setMaximumAngleV(int angle) {
        if (this.maxAngleV == angle) {
            return;
        }
        this.maxAngleV = Math.max(-90, Math.min(90, angle));
        this.addChange(8);
    }

    public int getMaximumAngleV() {
        return this.maxAngleV;
    }

    public boolean checkStandarEllipsoid() {
        return this.minAngleU == 0 && this.maxAngleU == 360 && this.minAngleV == -90 && this.maxAngleV == 90;
    }

    public static double[][][] createStandardEllipsoid(int nr, int nu, int nv, double angleu1, double angleu2, double anglev1, double anglev2, boolean top, boolean bottom, boolean left, boolean right) {
        int k;
        int u;
        double angle;
        int totalN = nu * nv;
        if (Math.abs(anglev2 - anglev1) < 180.0) {
            if (bottom) {
                totalN += nr * nu;
            }
            if (top) {
                totalN += nr * nu;
            }
        }
        if (Math.abs(angleu2 - angleu1) < 360.0) {
            if (left) {
                totalN += nr * nv;
            }
            if (right) {
                totalN += nr * nv;
            }
        }
        double[][][] data = new double[totalN][4][3];
        double[] cosu = new double[nu + 1];
        double[] sinu = new double[nu + 1];
        double[] cosv = new double[nv + 1];
        double[] sinv = new double[nv + 1];
        int u2 = 0;
        while (u2 <= nu) {
            angle = ((double)(nu - u2) * angleu1 + (double)u2 * angleu2) * (Math.PI / 180) / (double)nu;
            cosu[u2] = Math.cos(angle);
            sinu[u2] = Math.sin(angle);
            ++u2;
        }
        int v = 0;
        while (v <= nv) {
            angle = ((double)(nv - v) * anglev1 + (double)v * anglev2) * (Math.PI / 180) / (double)nv;
            cosv[v] = Math.cos(angle) / 2.0;
            sinv[v] = Math.sin(angle) / 2.0;
            ++v;
        }
        int tile = 0;
        double[] vectorx = Element.X_UNIT_VECTOR;
        double[] vectory = Element.Y_UNIT_VECTOR;
        double[] vectorz = Element.Z_UNIT_VECTOR;
        double[] center = new double[]{0.0, 0.0, 0.0};
        int v2 = 0;
        while (v2 < nv) {
            u = 0;
            while (u < nu) {
                k = 0;
                while (k < 3) {
                    data[tile][0][k] = (cosu[u] * vectorx[k] + sinu[u] * vectory[k]) * cosv[v2] + sinv[v2] * vectorz[k];
                    data[tile][1][k] = (cosu[u + 1] * vectorx[k] + sinu[u + 1] * vectory[k]) * cosv[v2] + sinv[v2] * vectorz[k];
                    data[tile][2][k] = (cosu[u + 1] * vectorx[k] + sinu[u + 1] * vectory[k]) * cosv[v2 + 1] + sinv[v2 + 1] * vectorz[k];
                    data[tile][3][k] = (cosu[u] * vectorx[k] + sinu[u] * vectory[k]) * cosv[v2 + 1] + sinv[v2 + 1] * vectorz[k];
                    ++k;
                }
                ++u;
                ++tile;
            }
            ++v2;
        }
        if (Math.abs(anglev2 - anglev1) < 180.0) {
            if (bottom) {
                center[2] = sinv[0];
                int u3 = 0;
                while (u3 < nu) {
                    int i = 0;
                    while (i < nr) {
                        k = 0;
                        while (k < 3) {
                            data[tile][0][k] = ((double)(nr - i) * center[k] + (double)i * data[u3][0][k]) / (double)nr;
                            data[tile][1][k] = ((double)(nr - i - 1) * center[k] + (double)(i + 1) * data[u3][0][k]) / (double)nr;
                            data[tile][2][k] = ((double)(nr - i - 1) * center[k] + (double)(i + 1) * data[u3][1][k]) / (double)nr;
                            data[tile][3][k] = ((double)(nr - i) * center[k] + (double)i * data[u3][1][k]) / (double)nr;
                            ++k;
                        }
                        ++i;
                        ++tile;
                    }
                    ++u3;
                }
            }
            if (top) {
                center[2] = sinv[nv];
                int ref = nu * (nv - 1);
                u = 0;
                while (u < nu) {
                    int i = 0;
                    while (i < nr) {
                        int k2 = 0;
                        while (k2 < 3) {
                            data[tile][0][k2] = ((double)(nr - i) * center[k2] + (double)i * data[ref + u][3][k2]) / (double)nr;
                            data[tile][1][k2] = ((double)(nr - i - 1) * center[k2] + (double)(i + 1) * data[ref + u][3][k2]) / (double)nr;
                            data[tile][2][k2] = ((double)(nr - i - 1) * center[k2] + (double)(i + 1) * data[ref + u][2][k2]) / (double)nr;
                            data[tile][3][k2] = ((double)(nr - i) * center[k2] + (double)i * data[ref + u][2][k2]) / (double)nr;
                            ++k2;
                        }
                        ++i;
                        ++tile;
                    }
                    ++u;
                }
            }
        }
        if (Math.abs(angleu2 - angleu1) < 360.0) {
            int k3;
            int i;
            int j;
            int ref;
            double[] nextCenter = new double[]{0.0, 0.0, 0.0};
            if (right) {
                ref = 0;
                j = 0;
                while (j < nv) {
                    center[2] = sinv[j];
                    nextCenter[2] = sinv[j + 1];
                    i = 0;
                    while (i < nr) {
                        k3 = 0;
                        while (k3 < 3) {
                            data[tile][0][k3] = ((double)(nr - i) * center[k3] + (double)i * data[ref][0][k3]) / (double)nr;
                            data[tile][1][k3] = ((double)(nr - i - 1) * center[k3] + (double)(i + 1) * data[ref][0][k3]) / (double)nr;
                            data[tile][2][k3] = ((double)(nr - i - 1) * nextCenter[k3] + (double)(i + 1) * data[ref][3][k3]) / (double)nr;
                            data[tile][3][k3] = ((double)(nr - i) * nextCenter[k3] + (double)i * data[ref][3][k3]) / (double)nr;
                            ++k3;
                        }
                        ++i;
                        ++tile;
                    }
                    ++j;
                    ref += nu;
                }
            }
            if (left) {
                ref = nu - 1;
                j = 0;
                while (j < nv) {
                    center[2] = sinv[j];
                    nextCenter[2] = sinv[j + 1];
                    i = 0;
                    while (i < nr) {
                        k3 = 0;
                        while (k3 < 3) {
                            data[tile][0][k3] = ((double)(nr - i) * center[k3] + (double)i * data[ref][1][k3]) / (double)nr;
                            data[tile][1][k3] = ((double)(nr - i - 1) * center[k3] + (double)(i + 1) * data[ref][1][k3]) / (double)nr;
                            data[tile][2][k3] = ((double)(nr - i - 1) * nextCenter[k3] + (double)(i + 1) * data[ref][2][k3]) / (double)nr;
                            data[tile][3][k3] = ((double)(nr - i) * nextCenter[k3] + (double)i * data[ref][2][k3]) / (double)nr;
                            ++k3;
                        }
                        ++i;
                        ++tile;
                    }
                    ++j;
                    ref += nu;
                }
            }
        }
        return data;
    }
}

