/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.swing;

import java.text.DecimalFormat;
import javax.swing.JProgressBar;
import org.colos.ejs.library.control.ConstantParser;

public class JProgressBarDouble
extends JProgressBar {
    public static final int RESOLUTION = 100000;
    private double scale;
    private double minimum;
    private double maximum = Double.NaN;
    private double doubleValue;
    private DecimalFormat format = null;

    public JProgressBarDouble(int _orientation) {
        super(_orientation);
        this.setBorderPainted(true);
        this.setStringPainted(false);
        this.setMinimum(0);
        this.setMaximum(100000);
        this.setValue(0);
        this.minimum = 0.0;
        this.doubleValue = 0.0;
        this.setDoubleMaximum(1.0);
    }

    public void setDoubleValue(double value) {
        if (value == this.doubleValue) {
            return;
        }
        this.doubleValue = value;
        if (this.doubleValue < this.minimum) {
            this.setValue(0);
        } else if (this.doubleValue > this.maximum) {
            this.setValue(100000);
        } else {
            int intValue = (int)((this.doubleValue - this.minimum) * this.scale);
            this.setValue(intValue);
        }
        if (this.format != null) {
            this.setString(this.format.format(this.doubleValue));
        }
    }

    public double getDoubleValue() {
        return this.doubleValue;
    }

    public double getDoubleMinimum() {
        return this.minimum;
    }

    public void setDoubleMinimum(double val) {
        if (val == this.minimum) {
            return;
        }
        this.minimum = val;
        this.scale = 100000.0 / (this.maximum - this.minimum);
        this.setDoubleValue(this.doubleValue);
    }

    public double getDoubleMaximum() {
        return this.maximum;
    }

    public void setDoubleMaximum(double val) {
        if (val == this.maximum) {
            return;
        }
        this.maximum = val;
        this.scale = 100000.0 / (this.maximum - this.minimum);
        this.setDoubleValue(this.doubleValue);
    }

    public void setFormat(DecimalFormat _format) {
        if (_format == null) {
            this.format = null;
            this.setStringPainted(false);
            return;
        }
        if (_format.equals(this.format)) {
            return;
        }
        this.format = _format;
        this.setString(this.format.format(this.doubleValue));
        this.setStringPainted(true);
        this.repaint();
    }

    public void setFormat(String _formatStr) {
        this.setFormat((DecimalFormat)ConstantParser.formatConstant(_formatStr).getObject());
    }
}

