/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.colos.ejs.library.control.ConstantParser;
import org.colos.ejs.library.control.swing.ControlSwingElement;
import org.colos.ejs.library.control.value.DoubleValue;
import org.colos.ejs.library.control.value.Value;
import org.opensourcephysics.display.TeXParser;

public class ControlNumberField
extends ControlSwingElement {
    private static final int NUMBER_FIELD_ADDED = 6;
    protected static final int VARIABLE = 0;
    protected static final int VALUE = 1;
    private static final int FIELD_BACKGROUND = 13;
    private static final int FIELD_FOREGROUND = 12;
    protected static final DecimalFormat defaultFormat = new DecimalFormat("0.000;0.000");
    protected JTextField textfield;
    protected DoubleValue internalValue;
    protected double defaultValue;
    protected boolean defaultValueSet;
    protected int defaultColumns;
    protected DecimalFormat format;
    protected String formatStr = null;
    protected boolean foregroundSet;
    protected Color defaultColor;
    protected Color editingColor;
    protected Color errorColor;
    private static List<String> infoList = null;

    protected void fixTheFormat(DecimalFormat _format) {
    }

    @Override
    protected Component createVisual() {
        this.textfield = new JTextField();
        this.fixTheFormat(defaultFormat);
        this.format = defaultFormat;
        this.defaultValue = 0.0;
        this.defaultValueSet = false;
        this.defaultColumns = this.textfield.getColumns();
        this.internalValue = new DoubleValue(this.defaultValue);
        this.textfield.setText(this.format.format(this.internalValue.value));
        this.textfield.addActionListener(new MyActionListener());
        this.textfield.addKeyListener(new MyKeyListener());
        this.textfield.setBackground(Color.WHITE);
        this.textfield.setForeground(Color.BLACK);
        this.foregroundSet = false;
        this.decideColors(this.textfield.getBackground());
        return this.textfield;
    }

    @Override
    public void reset() {
        if (this.defaultValueSet) {
            this.setTheValue(this.defaultValue);
            this.setInternalValue(this.defaultValue);
        }
    }

    private void setTheValue(double _value) {
        if (_value != this.internalValue.value) {
            this.internalValue.value = _value;
            if (SwingUtilities.isEventDispatchThread()) {
                this.textfield.setText(this.format.format(_value));
                this.getVisual().setBackground(this.defaultColor);
            } else {
                final String str = this.format.format(_value);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public synchronized void run() {
                        ControlNumberField.this.textfield.setText(str);
                        ControlNumberField.this.getVisual().setBackground(ControlNumberField.this.defaultColor);
                    }
                });
            }
        }
    }

    protected void setInternalValue(double _value) {
        this.internalValue.value = _value;
        this.variableChanged(0, this.internalValue);
    }

    @Override
    public List<String> getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList<String>();
            infoList.add("variable");
            infoList.add("value");
            infoList.add("editable");
            infoList.add("format");
            infoList.add("action");
            infoList.add("columns");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    @Override
    public String getPropertyInfo(String _property) {
        if (_property.equals("variable")) {
            return "int|double";
        }
        if (_property.equals("value")) {
            return "int|double CONSTANT";
        }
        if (_property.equals("editable")) {
            return "boolean";
        }
        if (_property.equals("format")) {
            return "Format|Object|String TRANSLATABLE";
        }
        if (_property.equals("action")) {
            return "Action CONSTANT";
        }
        if (_property.equals("columns")) {
            return "int";
        }
        return super.getPropertyInfo(_property);
    }

    @Override
    public void setValue(int _index, Value _value) {
        switch (_index) {
            case 0: {
                this.setTheValue(_value.getDouble());
                break;
            }
            case 1: {
                this.defaultValueSet = true;
                this.defaultValue = _value.getDouble();
                this.setActive(false);
                this.reset();
                this.setActive(true);
                break;
            }
            case 2: {
                if (_value.getBoolean()) {
                    this.textfield.setEditable(true);
                    if (this.foregroundSet) break;
                    this.textfield.setForeground(Color.BLACK);
                    break;
                }
                this.textfield.setEditable(false);
                if (this.foregroundSet) break;
                this.textfield.setForeground(Color.GRAY);
                break;
            }
            case 3: {
                DecimalFormat newFormat = null;
                if (_value.getObject() instanceof DecimalFormat) {
                    newFormat = (DecimalFormat)_value.getObject();
                    this.fixTheFormat(newFormat);
                    this.formatStr = null;
                } else {
                    String newFormatStr = TeXParser.parseTeX(_value.getString());
                    if (newFormatStr.equals(this.formatStr)) {
                        return;
                    }
                    this.formatStr = newFormatStr;
                    newFormat = (DecimalFormat)ConstantParser.formatConstant(this.formatStr).getObject();
                    this.fixTheFormat(newFormat);
                }
                if (newFormat.equals(this.format)) {
                    return;
                }
                this.format = newFormat;
                if (SwingUtilities.isEventDispatchThread()) {
                    this.textfield.setText(this.format.format(this.internalValue.value));
                    break;
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public synchronized void run() {
                        ControlNumberField.this.textfield.setText(ControlNumberField.this.format.format(ControlNumberField.this.internalValue.value));
                    }
                });
                break;
            }
            case 4: {
                this.removeAction(1, this.getProperty("action"));
                this.addAction(1, _value.getString());
                break;
            }
            case 5: {
                if (_value.getInteger() == this.textfield.getColumns()) break;
                this.textfield.setColumns(_value.getInteger());
                if (this.textfield.getParent() == null) break;
                this.textfield.getParent().validate();
                break;
            }
            case 13: {
                super.setValue(7, _value);
                this.decideColors(this.getVisual().getBackground());
                this.setColor(this.defaultColor);
                break;
            }
            case 12: {
                super.setValue(6, _value);
                this.foregroundSet = true;
                break;
            }
            default: {
                super.setValue(_index - 6, _value);
            }
        }
    }

    @Override
    public String getDefaultValueString(int _index) {
        switch (_index) {
            case 0: 
            case 1: {
                return "<none>";
            }
            case 2: {
                return "true";
            }
            case 3: {
                return "0.000;0.000";
            }
            case 4: {
                return "<no_action>";
            }
            case 5: {
                return Integer.toString(this.defaultColumns);
            }
            default: {
                return super.getDefaultValueString(_index - 6);
            }
            case 13: {
                return "WHITE";
            }
            case 12: 
        }
        return "BLACK/GRAY";
    }

    @Override
    public void setDefaultValue(int _index) {
        switch (_index) {
            case 0: {
                break;
            }
            case 1: {
                this.defaultValueSet = false;
                break;
            }
            case 2: {
                this.textfield.setEditable(true);
                if (this.foregroundSet) break;
                this.textfield.setForeground(Color.BLACK);
                break;
            }
            case 3: {
                this.format = defaultFormat;
                this.formatStr = null;
                Runnable refreshScreen = new Runnable(){

                    @Override
                    public synchronized void run() {
                        ControlNumberField.this.textfield.setText(ControlNumberField.this.format.format(ControlNumberField.this.internalValue.value));
                    }
                };
                if (SwingUtilities.isEventDispatchThread()) {
                    refreshScreen.run();
                    break;
                }
                SwingUtilities.invokeLater(refreshScreen);
                break;
            }
            case 4: {
                this.removeAction(1, this.getProperty("action"));
                break;
            }
            case 5: {
                this.textfield.setColumns(this.defaultColumns);
                if (this.textfield.getParent() == null) break;
                this.textfield.getParent().validate();
                break;
            }
            case 13: {
                super.setDefaultValue(7);
                this.decideColors(this.getVisual().getBackground());
                this.setColor(this.defaultColor);
                break;
            }
            case 12: {
                super.setDefaultValue(6);
                this.foregroundSet = false;
                break;
            }
            default: {
                super.setDefaultValue(_index - 6);
            }
        }
    }

    @Override
    public Value getValue(int _index) {
        switch (_index) {
            case 0: {
                return this.internalValue;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return null;
            }
        }
        return super.getValue(_index - 6);
    }

    protected void setColor(Color aColor) {
        this.textfield.setBackground(aColor);
    }

    protected void decideColors(Color aColor) {
        if (aColor == null) {
            return;
        }
        this.defaultColor = aColor;
        this.editingColor = this.defaultColor.equals(Color.yellow) ? Color.orange : Color.yellow;
        this.errorColor = this.defaultColor.equals(Color.red) ? Color.magenta : Color.red;
    }

    protected void acceptValue() {
        this.setColor(this.defaultColor);
        try {
            this.setInternalValue(this.format.parse(this.textfield.getText()).doubleValue());
            if (this.isUnderEjs) {
                this.setFieldListValueWithAlternative(0, 1, this.internalValue);
            }
        }
        catch (Exception exc) {
            this.setColor(this.errorColor);
        }
    }

    protected class MyActionListener
    implements ActionListener {
        protected MyActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent _e) {
            if (ControlNumberField.this.textfield.isEditable()) {
                ControlNumberField.this.acceptValue();
            }
        }
    }

    protected class MyKeyListener
    implements KeyListener {
        protected MyKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent _e) {
            this.processKeyEvent(_e, 0);
        }

        @Override
        public void keyReleased(KeyEvent _e) {
            this.processKeyEvent(_e, 1);
        }

        @Override
        public void keyTyped(KeyEvent _e) {
            this.processKeyEvent(_e, 2);
        }

        private void processKeyEvent(KeyEvent _e, int _n) {
            if (!ControlNumberField.this.textfield.isEditable()) {
                return;
            }
            if (_e.getKeyChar() != '\n') {
                ControlNumberField.this.setColor(ControlNumberField.this.editingColor);
            }
            if (_e.getKeyCode() == 27) {
                ControlNumberField.this.setValue(0, ControlNumberField.this.internalValue);
            }
        }
    }
}

