/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.drawing3d;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.SwingUtilities;
import org.colos.ejs.library.Simulation;
import org.colos.ejs.library.control.ControlElement;
import org.colos.ejs.library.control.HasEditor;
import org.colos.ejs.library.control.NeedsFinalUpdate;
import org.colos.ejs.library.control.NeedsUpdate;
import org.colos.ejs.library.control.SpecialRender;
import org.colos.ejs.library.control.drawing3d.ControlParentOfElement3D;
import org.colos.ejs.library.control.drawing3d.utils.Control3DChild;
import org.colos.ejs.library.control.swing.ControlSwingElement;
import org.colos.ejs.library.control.swing.NeedsPreUpdate;
import org.colos.ejs.library.control.value.BooleanValue;
import org.colos.ejs.library.control.value.DoubleValue;
import org.colos.ejs.library.control.value.IntegerValue;
import org.colos.ejs.library.control.value.StringValue;
import org.colos.ejs.library.control.value.Value;
import org.opensourcephysics.display.DisplayColors;
import org.opensourcephysics.drawing3d.DrawingPanel3D;
import org.opensourcephysics.drawing3d.Element;
import org.opensourcephysics.drawing3d.interaction.InteractionEvent;
import org.opensourcephysics.drawing3d.interaction.InteractionListener;
import org.opensourcephysics.drawing3d.utils.Camera;
import org.opensourcephysics.drawing3d.utils.CameraInspector;
import org.opensourcephysics.drawing3d.utils.ImplementationChangeListener;
import org.opensourcephysics.drawing3d.utils.VisualizationHints;

public class ControlDrawingPanel3D
extends ControlSwingElement
implements NeedsUpdate,
NeedsFinalUpdate,
ControlParentOfElement3D,
InteractionListener,
SpecialRender,
HasEditor,
ImplementationChangeListener {
    private static final int DP3D_ADDED = 49;
    private static final int PANEL_ENABLED = 52;
    private static final int PANEL_BACKGROUND = 56;
    private static final int PANEL_FOREGROUND = 55;
    private static final int PANEL_FONT = 57;
    public static final double TO_RAD = Math.PI / 180;
    protected static final int PROJECTION = 7;
    protected static final int[] POSITION_INDEXES = new int[]{24, 25, 26};
    protected static final int[] CAMERA_INDEXES = new int[]{8, 9, 10, 11, 12, 13, 36, 37, 38, 39};
    protected static final int[] CAMERA_PARTIAL_INDEXES = new int[]{8, 9, 10, 11, 12, 13, 36, 37, 38, 39};
    private static final int KEY_INDEX = 35;
    DrawingPanel3D drawingPanel3D;
    private VisualizationHints visHints;
    private double minX;
    private double maxX;
    private double minY;
    private double maxY;
    private double minZ;
    private double maxZ;
    private double axisXSize;
    private double axisYSize;
    private double axisZSize;
    private Camera camera;
    private JFrame cameraInspectorFrame = null;
    private CameraInspector cameraInspector = null;
    private Color defBackground;
    private Color defForeground;
    private Font defFont;
    private boolean reportXYZMotion = false;
    private boolean reportCameraMotion = false;
    private boolean reportKey = false;
    private boolean cameraLocationSet = false;
    private IntegerValue keyPressedValue = new IntegerValue(-1);
    private DoubleValue[] posValues = new DoubleValue[]{new DoubleValue(0.0), new DoubleValue(0.0), new DoubleValue(0.0)};
    private DoubleValue[] cameraValues;
    private KeyListener keyListener;
    private MouseListener mouseListener;
    private Vector<NeedsPreUpdate> preupdateList = new Vector();
    private static List<String> infoList = null;
    private boolean settingExtrema = false;

    @Override
    public Object getObject() {
        return this.drawingPanel3D;
    }

    @Override
    public String getObjectClassname() {
        return "org.opensourcephysics.drawing3d.DrawingPanel3D";
    }

    @Override
    protected Component createVisual() {
        this.drawingPanel3D = new DrawingPanel3D();
        this.minX = this.drawingPanel3D.getPreferredMinX();
        this.maxX = this.drawingPanel3D.getPreferredMaxX();
        this.minY = this.drawingPanel3D.getPreferredMinY();
        this.maxY = this.drawingPanel3D.getPreferredMaxY();
        this.minZ = this.drawingPanel3D.getPreferredMinZ();
        this.maxZ = this.drawingPanel3D.getPreferredMaxZ();
        this.axisXSize = this.drawingPanel3D.getAxisXSize();
        this.axisYSize = this.drawingPanel3D.getAxisYSize();
        this.axisZSize = this.drawingPanel3D.getAxisZSize();
        this.visHints = this.drawingPanel3D.getVisualizationHints();
        this.defBackground = this.visHints.getBackgroundColor();
        this.defForeground = this.visHints.getForegroundColor();
        this.defFont = this.visHints.getFont();
        this.camera = this.drawingPanel3D.getCamera();
        this.cameraValues = new DoubleValue[]{new DoubleValue(this.camera.getFocusX()), new DoubleValue(this.camera.getFocusY()), new DoubleValue(this.camera.getFocusZ()), new DoubleValue(this.camera.getDistanceToScreen()), new DoubleValue(this.camera.getAzimuth()), new DoubleValue(this.camera.getAltitude()), new DoubleValue(this.camera.getX()), new DoubleValue(this.camera.getY()), new DoubleValue(this.camera.getZ()), new DoubleValue(this.camera.getRotation())};
        this.drawingPanel3D.addInteractionListener(this);
        this.drawingPanel3D.addImplementationChangeListener(this);
        this.drawingPanel3D.render();
        this.keyListener = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent _e) {
                if (_e.isControlDown() && ControlDrawingPanel3D.this.getSimulation() != null) {
                    if (_e.getKeyCode() == 77) {
                        ControlDrawingPanel3D.this.getPopupMenu(0, 0);
                    } else if (_e.getKeyCode() == 80) {
                        ControlDrawingPanel3D.this.printScreen();
                    }
                }
                ((ControlDrawingPanel3D)ControlDrawingPanel3D.this).keyPressedValue.value = _e.getKeyCode();
                if (ControlDrawingPanel3D.this.reportKey) {
                    ControlDrawingPanel3D.this.variableChanged(35, ControlDrawingPanel3D.this.keyPressedValue);
                    ControlDrawingPanel3D.this.invokeActions(30);
                }
            }

            @Override
            public void keyReleased(KeyEvent _e) {
                ((ControlDrawingPanel3D)ControlDrawingPanel3D.this).keyPressedValue.value = -1;
                if (ControlDrawingPanel3D.this.reportKey) {
                    ControlDrawingPanel3D.this.variableChanged(35, ControlDrawingPanel3D.this.keyPressedValue);
                }
            }
        };
        this.mouseListener = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent _e) {
                if ((_e.isPopupTrigger() || _e.getModifiers() == 4) && ControlDrawingPanel3D.this.getSimulation() != null) {
                    ControlDrawingPanel3D.this.getPopupMenu(_e.getX(), _e.getY());
                }
            }
        };
        this.setListeners();
        return this.drawingPanel3D.getComponent();
    }

    @Override
    public void implementationChanged(int toImplementation) {
        this.setListeners();
        super.changeVisual(this.drawingPanel3D.getComponent());
    }

    private void setListeners() {
        Component comp = this.drawingPanel3D.getComponent();
        comp.setFocusable(true);
        comp.removeKeyListener(this.keyListener);
        comp.addKeyListener(this.keyListener);
        comp.removeMouseListener(this.mouseListener);
        comp.addMouseListener(this.mouseListener);
    }

    @Override
    public void addMenuEntries() {
        JMenuItem cameraMenuItem = new JMenuItem("CameraInspector.Camera");
        cameraMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent _evt) {
                ControlDrawingPanel3D.this.showCameraInspector();
            }
        });
        cameraMenuItem.setActionCommand("CameraInspector.Camera");
        JRadioButtonMenuItem simple3DItem = new JRadioButtonMenuItem("Simple 3D", this.drawingPanel3D.getImplementation() == 0);
        simple3DItem.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                if (evt.getStateChange() == 1) {
                    ControlDrawingPanel3D.this.drawingPanel3D.setImplementation(0);
                }
            }
        });
        JRadioButtonMenuItem java3DItem = new JRadioButtonMenuItem("Java 3D", this.drawingPanel3D.getImplementation() == 1);
        java3DItem.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                if (evt.getStateChange() == 1) {
                    ControlDrawingPanel3D.this.drawingPanel3D.setImplementation(1);
                }
            }
        });
        ButtonGroup group = new ButtonGroup();
        group.add(simple3DItem);
        group.add(java3DItem);
        JMenu implementationMenu = new JMenu("Implementation");
        implementationMenu.setActionCommand("ejs_res:DrawingPanel3D.Implementation");
        implementationMenu.add(simple3DItem);
        implementationMenu.add(java3DItem);
        ArrayList<Object> menuEntries = new ArrayList<Object>();
        menuEntries.add(cameraMenuItem);
        menuEntries.add(implementationMenu);
        this.getSimulation().addElementMenuEntries(this.getMenuNameEntry(), menuEntries);
    }

    @Override
    public boolean acceptsChild(ControlElement _child) {
        return _child instanceof Control3DChild;
    }

    @Override
    public BufferedImage render(BufferedImage image) {
        return this.drawingPanel3D.render(image);
    }

    @Override
    public void showEditor(String editor) {
        if ("camera".equalsIgnoreCase(editor)) {
            this.showCameraInspector();
        }
    }

    public void showCameraInspector() {
        if (this.cameraInspectorFrame == null) {
            this.createCameraInspector();
        }
        this.cameraInspectorFrame.setVisible(true);
    }

    private void createCameraInspector() {
        this.cameraInspector = new CameraInspector(this.drawingPanel3D);
        this.cameraInspector.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent _evt) {
                if (ControlDrawingPanel3D.this.isUnderEjs) {
                    ControlDrawingPanel3D.this.updateCameraFields();
                }
            }
        });
        this.cameraInspectorFrame = CameraInspector.createFrame(this.cameraInspector);
        this.cameraInspectorFrame.setLocationRelativeTo(this.drawingPanel3D.getComponent());
    }

    @Override
    public void update() {
        Enumeration<NeedsPreUpdate> e = this.preupdateList.elements();
        while (e.hasMoreElements()) {
            e.nextElement().preupdate();
        }
    }

    @Override
    public void finalUpdate() {
        if (SwingUtilities.isEventDispatchThread() || Thread.currentThread().getName().equals("main")) {
            Simulation sim = this.getSimulation();
            if (sim == null || sim.isPaused()) {
                this.drawingPanel3D.update();
            }
        } else {
            this.drawingPanel3D.render();
        }
    }

    @Override
    public void addToPreupdateList(NeedsPreUpdate _child) {
        this.preupdateList.add(_child);
    }

    @Override
    public void removeFromPreupdateList(NeedsPreUpdate _child) {
        this.preupdateList.remove(_child);
    }

    @Override
    public void addElement(Element _element) {
        this.drawingPanel3D.addElement(_element);
    }

    @Override
    public void removeElement(Element _element) {
        this.drawingPanel3D.removeElement(_element);
    }

    @Override
    public DrawingPanel3D getDrawingPanel3D() {
        return this.drawingPanel3D;
    }

    @Override
    protected void getPopupMenu(int _x, int _y) {
        if (this.cameraInspectorFrame == null) {
            this.createCameraInspector();
        }
        super.getPopupMenu(_x, _y);
    }

    @Override
    public List<String> getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList<String>();
            infoList.add("minimumX");
            infoList.add("maximumX");
            infoList.add("minimumY");
            infoList.add("maximumY");
            infoList.add("minimumZ");
            infoList.add("maximumZ");
            infoList.add("squareAspect");
            infoList.add("projectionMode");
            infoList.add("cameraFocusX");
            infoList.add("cameraFocusY");
            infoList.add("cameraFocusZ");
            infoList.add("cameraDistanceToScreen");
            infoList.add("cameraAzimuth");
            infoList.add("cameraAltitude");
            infoList.add("implementation");
            infoList.add("decorationType");
            infoList.add("cursorType");
            infoList.add("removeHiddenLines");
            infoList.add("allowQuickRedraw");
            infoList.add("useColorDepth");
            infoList.add("showCoordinates");
            infoList.add("xFormat");
            infoList.add("yFormat");
            infoList.add("zFormat");
            infoList.add("x");
            infoList.add("y");
            infoList.add("z");
            infoList.add("movedAction");
            infoList.add("pressAction");
            infoList.add("releaseAction");
            infoList.add("dragAction");
            infoList.add("enteredAction");
            infoList.add("exitedAction");
            infoList.add("keyAction");
            infoList.add("keyPressed");
            infoList.add("axesLabels");
            infoList.add("cameraX");
            infoList.add("cameraY");
            infoList.add("cameraZ");
            infoList.add("cameraRotation");
            infoList.add("image");
            infoList.add("axesMapping");
            infoList.add("sizeX");
            infoList.add("sizeY");
            infoList.add("sizeZ");
            infoList.add("illumination");
            infoList.add("moveable");
            infoList.add("enabledPosition");
            infoList.add("autoAdjust");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    @Override
    public String getPropertyInfo(String _property) {
        if (_property.equals("minimumX")) {
            return "int|double";
        }
        if (_property.equals("maximumX")) {
            return "int|double";
        }
        if (_property.equals("minimumY")) {
            return "int|double";
        }
        if (_property.equals("maximumY")) {
            return "int|double";
        }
        if (_property.equals("minimumZ")) {
            return "int|double";
        }
        if (_property.equals("maximumZ")) {
            return "int|double";
        }
        if (_property.equals("squareAspect")) {
            return "boolean";
        }
        if (_property.equals("projectionMode")) {
            return "int|3DCameraMode";
        }
        if (_property.equals("cameraFocusX")) {
            return "int|double";
        }
        if (_property.equals("cameraFocusY")) {
            return "int|double";
        }
        if (_property.equals("cameraFocusZ")) {
            return "int|double";
        }
        if (_property.equals("cameraDistanceToScreen")) {
            return "int|double";
        }
        if (_property.equals("cameraAzimuth")) {
            return "int|double";
        }
        if (_property.equals("cameraAltitude")) {
            return "int|double";
        }
        if (_property.equals("implementation")) {
            return "int|3DImplementation";
        }
        if (_property.equals("decorationType")) {
            return "int|3DDecorationType";
        }
        if (_property.equals("cursorType")) {
            return "int|3DCursorType";
        }
        if (_property.equals("removeHiddenLines")) {
            return "boolean";
        }
        if (_property.equals("allowQuickRedraw")) {
            return "boolean";
        }
        if (_property.equals("useColorDepth")) {
            return "boolean";
        }
        if (_property.equals("showCoordinates")) {
            return "int|3DShowCoordinates";
        }
        if (_property.equals("xFormat")) {
            return "Object|String TRANSLATABLE";
        }
        if (_property.equals("yFormat")) {
            return "Object|String TRANSLATABLE";
        }
        if (_property.equals("zFormat")) {
            return "Object|String TRANSLATABLE";
        }
        if (_property.equals("x")) {
            return "int|double";
        }
        if (_property.equals("y")) {
            return "int|double";
        }
        if (_property.equals("z")) {
            return "int|double";
        }
        if (_property.equals("movedAction")) {
            return "Action CONSTANT";
        }
        if (_property.equals("releaseAction")) {
            return "Action CONSTANT";
        }
        if (_property.equals("pressAction")) {
            return "Action CONSTANT";
        }
        if (_property.equals("dragAction")) {
            return "Action CONSTANT";
        }
        if (_property.equals("enteredAction")) {
            return "Action CONSTANT";
        }
        if (_property.equals("exitedAction")) {
            return "Action CONSTANT";
        }
        if (_property.equals("keyAction")) {
            return "Action CONSTANT";
        }
        if (_property.equals("keyPressed")) {
            return "int";
        }
        if (_property.equals("axesLabels")) {
            return "String TRANSLATABLE";
        }
        if (_property.equals("cameraX")) {
            return "int|double";
        }
        if (_property.equals("cameraY")) {
            return "int|double";
        }
        if (_property.equals("cameraZ")) {
            return "int|double";
        }
        if (_property.equals("cameraRotation")) {
            return "int|double";
        }
        if (_property.equals("image")) {
            return "File|String TRANSLATABLE";
        }
        if (_property.equals("axesMapping")) {
            return "int|3DAxesMapping";
        }
        if (_property.equals("sizeX")) {
            return "int|double";
        }
        if (_property.equals("sizeY")) {
            return "int|double";
        }
        if (_property.equals("sizeZ")) {
            return "int|double";
        }
        if (_property.equals("illumination")) {
            return "boolean";
        }
        if (_property.equals("moveable")) {
            return "boolean";
        }
        if (_property.equals("enabledPosition")) {
            return "int|3DDraggable";
        }
        if (_property.equals("autoAdjust")) {
            return "boolean";
        }
        return super.getPropertyInfo(_property);
    }

    @Override
    public ControlElement setProperty(String _property, String _value) {
        if ((_property = _property.trim()).equals("x") || _property.equals("y") || _property.equals("z")) {
            if (_value != null) {
                Value constant = Value.parseConstant(_value, true);
                if (!this.reportXYZMotion) {
                    this.reportXYZMotion = constant == null;
                }
            }
        } else if (_property.startsWith("camera")) {
            if (_property.equals("cameraX") || _property.equals("cameraY") || _property.equals("cameraZ")) {
                this.cameraLocationSet = true;
            }
            if (_value != null) {
                Value constant = Value.parseConstant(_value, true);
                if (!this.reportCameraMotion) {
                    this.reportCameraMotion = constant == null;
                }
            }
        } else if ((_property.equals("keyAction") || _property.equals("keyPressed")) && _value != null) {
            Value constant = Value.parseConstant(_value, true);
            if (!this.reportKey) {
                this.reportKey = constant == null;
            }
        }
        return super.setProperty(_property, _value);
    }

    @Override
    public Value parseConstant(String _propertyType, String _value) {
        if (_value == null) {
            return null;
        }
        if (_propertyType.indexOf("3DCameraMode") >= 0) {
            if ((_value = _value.trim().toLowerCase()).equals("no_perspective")) {
                return new IntegerValue(10);
            }
            if (_value.equals("perspective_off")) {
                return new IntegerValue(3);
            }
            if (_value.equals("perspective_on")) {
                return new IntegerValue(4);
            }
            if (_value.equals("perspective")) {
                return new IntegerValue(11);
            }
            if (_value.equals("planar_xy")) {
                return new IntegerValue(0);
            }
            if (_value.equals("planar_xz")) {
                return new IntegerValue(1);
            }
            if (_value.equals("planar_yz")) {
                return new IntegerValue(2);
            }
        }
        if (_propertyType.indexOf("3DDecorationType") >= 0) {
            if ((_value = _value.trim().toLowerCase()).equals("none")) {
                return new IntegerValue(0);
            }
            if (_value.equals("axes")) {
                return new IntegerValue(1);
            }
            if (_value.equals("centered_axes")) {
                return new IntegerValue(3);
            }
            if (_value.equals("cube")) {
                return new IntegerValue(2);
            }
        }
        if (_propertyType.indexOf("3DCursorType") >= 0) {
            if ((_value = _value.trim().toLowerCase()).equals("none")) {
                return new IntegerValue(0);
            }
            if (_value.equals("cube")) {
                return new IntegerValue(2);
            }
            if (_value.equals("crosshair")) {
                return new IntegerValue(3);
            }
            if (_value.equals("xyz")) {
                return new IntegerValue(1);
            }
        }
        if (_propertyType.indexOf("3DShowCoordinates") >= 0) {
            if ((_value = _value.trim().toLowerCase()).equals("none")) {
                return new IntegerValue(-1);
            }
            if (_value.equals("bottom_left")) {
                return new IntegerValue(0);
            }
            if (_value.equals("bottom_right")) {
                return new IntegerValue(1);
            }
            if (_value.equals("top_left")) {
                return new IntegerValue(3);
            }
            if (_value.equals("top_right")) {
                return new IntegerValue(2);
            }
        }
        if (_propertyType.indexOf("3DImplementation") >= 0) {
            if ((_value = _value.trim().toLowerCase()).equals("simple3d")) {
                return new IntegerValue(0);
            }
            if (_value.equals("java3d")) {
                return new IntegerValue(1);
            }
        }
        if (_propertyType.indexOf("3DAxesMapping") >= 0) {
            if ((_value = _value.trim().toLowerCase()).equals("xyz")) {
                return new IntegerValue(0);
            }
            if (_value.equals("xzy")) {
                return new IntegerValue(1);
            }
            if (_value.equals("yxz")) {
                return new IntegerValue(2);
            }
            if (_value.equals("yzx")) {
                return new IntegerValue(3);
            }
            if (_value.equals("zxy")) {
                return new IntegerValue(4);
            }
            if (_value.equals("zyx")) {
                return new IntegerValue(5);
            }
        }
        if (_propertyType.indexOf("3DDraggable") >= 0) {
            if ((_value = _value.trim().toLowerCase()).equals("none")) {
                return new IntegerValue(0);
            }
            if (_value.equals("any")) {
                return new IntegerValue(1);
            }
            if (_value.equals("azimuth")) {
                return new IntegerValue(2);
            }
            if (_value.equals("altitude")) {
                return new IntegerValue(3);
            }
        }
        return super.parseConstant(_propertyType, _value);
    }

    private void setAxesLabels(String _labelsStr) {
        String[] labels = new String[]{"X", "Y", "Z"};
        if (_labelsStr != null) {
            StringTokenizer tkn = new StringTokenizer(_labelsStr, ",;");
            if (tkn.hasMoreTokens()) {
                labels[0] = tkn.nextToken();
            }
            if (tkn.hasMoreTokens()) {
                labels[1] = tkn.nextToken();
            }
            if (tkn.hasMoreTokens()) {
                labels[2] = tkn.nextToken();
            }
        }
        this.drawingPanel3D.getVisualizationHints().setAxesLabels(labels);
    }

    @Override
    public void setValue(int _index, Value _value) {
        switch (_index) {
            case 0: {
                if (_value.getDouble() == this.minX) break;
                this.minX = _value.getDouble();
                this.resetExtrema();
                break;
            }
            case 1: {
                if (_value.getDouble() == this.maxX) break;
                this.maxX = _value.getDouble();
                this.resetExtrema();
                break;
            }
            case 2: {
                if (_value.getDouble() == this.minY) break;
                this.minY = _value.getDouble();
                this.resetExtrema();
                break;
            }
            case 3: {
                if (_value.getDouble() == this.maxY) break;
                this.maxY = _value.getDouble();
                this.resetExtrema();
                break;
            }
            case 4: {
                if (_value.getDouble() == this.minZ) break;
                this.minZ = _value.getDouble();
                this.resetExtrema();
                break;
            }
            case 5: {
                if (_value.getDouble() == this.maxZ) break;
                this.maxZ = _value.getDouble();
                this.resetExtrema();
                break;
            }
            case 6: {
                if (_value.getBoolean() == this.drawingPanel3D.isSquareAspect()) break;
                this.drawingPanel3D.setSquareAspect(_value.getBoolean());
                break;
            }
            case 7: {
                if (_value.getInteger() == this.camera.getProjectionMode()) break;
                this.camera.setProjectionMode(_value.getInteger());
                break;
            }
            case 8: {
                if (_value.getDouble() == this.cameraValues[0].value) break;
                this.cameraValues[0].value = _value.getDouble();
                this.camera.setFocusXYZ(this.cameraValues[0].value, this.cameraValues[1].value, this.cameraValues[2].value);
                break;
            }
            case 9: {
                if (_value.getDouble() == this.cameraValues[1].value) break;
                this.cameraValues[1].value = _value.getDouble();
                this.camera.setFocusXYZ(this.cameraValues[0].value, this.cameraValues[1].value, this.cameraValues[2].value);
                break;
            }
            case 10: {
                if (_value.getDouble() == this.cameraValues[2].value) break;
                this.cameraValues[2].value = _value.getDouble();
                this.camera.setFocusXYZ(this.cameraValues[0].value, this.cameraValues[1].value, this.cameraValues[2].value);
                break;
            }
            case 11: {
                if (_value.getDouble() == this.cameraValues[3].value) break;
                this.cameraValues[3].value = _value.getDouble();
                this.camera.setDistanceToScreen(this.cameraValues[3].value);
                break;
            }
            case 12: {
                double angle = _value instanceof IntegerValue ? (double)_value.getInteger() * (Math.PI / 180) : _value.getDouble();
                if (angle == this.cameraValues[4].value) break;
                this.cameraValues[4].value = _value.getDouble();
                this.camera.setAzimuth(this.cameraValues[4].value);
                break;
            }
            case 13: {
                double angle = _value instanceof IntegerValue ? (double)_value.getInteger() * (Math.PI / 180) : _value.getDouble();
                if (angle == this.cameraValues[5].value) break;
                this.cameraValues[5].value = _value.getDouble();
                this.camera.setAltitude(this.cameraValues[5].value);
                break;
            }
            case 14: {
                if (_value.getInteger() == this.drawingPanel3D.getImplementation()) break;
                this.drawingPanel3D.setImplementation(_value.getInteger());
                break;
            }
            case 15: {
                if (_value.getInteger() == this.visHints.getDecorationType()) break;
                this.visHints.setDecorationType(_value.getInteger());
                break;
            }
            case 16: {
                if (_value.getInteger() == this.visHints.getCursorType()) break;
                this.visHints.setCursorType(_value.getInteger());
                break;
            }
            case 17: {
                if (_value.getBoolean() == this.visHints.isRemoveHiddenLines()) break;
                this.visHints.setRemoveHiddenLines(_value.getBoolean());
                break;
            }
            case 18: {
                if (_value.getBoolean() == this.visHints.isAllowQuickRedraw()) break;
                this.visHints.setAllowQuickRedraw(_value.getBoolean());
                break;
            }
            case 19: {
                if (_value.getBoolean() == this.visHints.isUseColorDepth()) break;
                this.visHints.setUseColorDepth(_value.getBoolean());
                break;
            }
            case 20: {
                if (_value.getInteger() == this.visHints.getShowCoordinates()) break;
                this.visHints.setShowCoordinates(_value.getInteger());
                break;
            }
            case 21: {
                String formatX = _value.getString();
                if (formatX == null) {
                    this.visHints.setXFormat(null);
                    break;
                }
                if (formatX.equals(this.visHints.getXFormat())) break;
                this.visHints.setXFormat(formatX);
                break;
            }
            case 22: {
                String formatY = _value.getString();
                if (formatY == null) {
                    this.visHints.setYFormat(null);
                    break;
                }
                if (formatY.equals(this.visHints.getYFormat())) break;
                this.visHints.setYFormat(formatY);
                break;
            }
            case 23: {
                String formatZ = _value.getString();
                if (formatZ == null) {
                    this.visHints.setZFormat(null);
                    break;
                }
                if (formatZ.equals(this.visHints.getZFormat())) break;
                this.visHints.setZFormat(formatZ);
                break;
            }
            case 24: {
                this.posValues[0].value = _value.getDouble();
                break;
            }
            case 25: {
                this.posValues[1].value = _value.getDouble();
                break;
            }
            case 26: {
                this.posValues[2].value = _value.getDouble();
                break;
            }
            case 27: {
                this.removeAction(33, this.getProperty("movedAction"));
                this.addAction(33, _value.getString());
                break;
            }
            case 28: {
                this.removeAction(10, this.getProperty("pressAction"));
                this.addAction(10, _value.getString());
                break;
            }
            case 29: {
                this.removeAction(0, this.getProperty("releaseAction"));
                this.addAction(0, _value.getString());
                break;
            }
            case 30: {
                this.removeAction(1, this.getProperty("dragAction"));
                this.addAction(1, _value.getString());
                break;
            }
            case 31: {
                this.removeAction(31, this.getProperty("enteredAction"));
                this.addAction(31, _value.getString());
                break;
            }
            case 32: {
                this.removeAction(32, this.getProperty("exitedAction"));
                this.addAction(32, _value.getString());
                break;
            }
            case 33: {
                this.removeAction(30, this.getProperty("keyAction"));
                this.addAction(30, _value.getString());
                break;
            }
            case 34: {
                this.keyPressedValue.value = _value.getInteger();
                break;
            }
            case 35: {
                this.setAxesLabels(_value.toString());
                break;
            }
            case 36: {
                if (_value.getDouble() == this.cameraValues[6].value) break;
                this.cameraValues[6].value = _value.getDouble();
                this.camera.setXYZ(this.cameraValues[6].value, this.cameraValues[7].value, this.cameraValues[8].value);
                break;
            }
            case 37: {
                if (_value.getDouble() == this.cameraValues[7].value) break;
                this.cameraValues[7].value = _value.getDouble();
                this.camera.setXYZ(this.cameraValues[6].value, this.cameraValues[7].value, this.cameraValues[8].value);
                break;
            }
            case 38: {
                if (_value.getDouble() == this.cameraValues[8].value) break;
                this.cameraValues[8].value = _value.getDouble();
                this.camera.setXYZ(this.cameraValues[6].value, this.cameraValues[7].value, this.cameraValues[8].value);
                break;
            }
            case 39: {
                double rotAngle = _value instanceof IntegerValue ? (double)_value.getInteger() * (Math.PI / 180) : _value.getDouble();
                if (rotAngle == this.cameraValues[9].value) break;
                this.cameraValues[9].value = rotAngle;
                this.camera.setRotation(this.cameraValues[9].value);
                break;
            }
            case 40: {
                this.visHints.setBackgroundImage(_value.getString());
                break;
            }
            case 41: {
                this.camera.setMapping(_value.getInteger());
                break;
            }
            case 42: {
                this.axisXSize = _value.getDouble();
                this.drawingPanel3D.setAxesSize(this.axisXSize, this.axisYSize, this.axisZSize);
                break;
            }
            case 43: {
                this.axisYSize = _value.getDouble();
                this.drawingPanel3D.setAxesSize(this.axisXSize, this.axisYSize, this.axisZSize);
                break;
            }
            case 44: {
                this.axisZSize = _value.getDouble();
                this.drawingPanel3D.setAxesSize(this.axisXSize, this.axisYSize, this.axisZSize);
                break;
            }
            case 45: {
                this.visHints.setDefaultIllumination(_value.getBoolean());
                break;
            }
            case 46: {
                this.visHints.setBackgroundMoveable(_value.getBoolean());
                break;
            }
            case 47: {
                if (_value instanceof BooleanValue) {
                    this.drawingPanel3D.setDraggable(_value.getBoolean());
                    break;
                }
                this.drawingPanel3D.setDraggable(_value.getInteger());
                break;
            }
            case 48: {
                this.drawingPanel3D.setResetCameraOnChanges(_value.getBoolean());
                break;
            }
            default: {
                super.setValue(_index - 49, _value);
                break;
            }
            case 52: {
                this.drawingPanel3D.getInteractionTarget(0).setEnabled(_value.getBoolean());
                break;
            }
            case 56: {
                if (_value.getObject() instanceof Color) {
                    this.visHints.setBackgroundColor((Color)_value.getObject());
                    break;
                }
                this.visHints.setBackgroundColor(DisplayColors.getLineColor(_value.getInteger()));
                break;
            }
            case 55: {
                if (_value.getObject() instanceof Color) {
                    this.visHints.setForegroundColor((Color)_value.getObject());
                    break;
                }
                this.visHints.setForegroundColor(DisplayColors.getLineColor(_value.getInteger()));
                break;
            }
            case 57: {
                if (!(_value.getObject() instanceof Font)) break;
                this.visHints.setFont((Font)_value.getObject());
            }
        }
        if (this.isUnderEjs) {
            if (this.cameraInspector != null) {
                if (_index == 7) {
                    this.cameraInspector.updateFields();
                } else {
                    int i = 0;
                    while (i < CAMERA_INDEXES.length) {
                        if (CAMERA_INDEXES[i] == _index) {
                            this.cameraInspector.updateFields();
                            break;
                        }
                        ++i;
                    }
                }
            }
            this.drawingPanel3D.getImplementingPanel().update();
        }
    }

    @Override
    public void setDefaultValue(int _index) {
        switch (_index) {
            case 0: {
                this.minX = -1.0;
                this.resetExtrema();
                break;
            }
            case 1: {
                this.maxX = 1.0;
                this.resetExtrema();
                break;
            }
            case 2: {
                this.minY = -1.0;
                this.resetExtrema();
                break;
            }
            case 3: {
                this.maxY = 1.0;
                this.resetExtrema();
                break;
            }
            case 4: {
                this.minZ = -1.0;
                this.resetExtrema();
                break;
            }
            case 5: {
                this.maxZ = 1.0;
                this.resetExtrema();
                break;
            }
            case 6: {
                this.drawingPanel3D.setSquareAspect(true);
                break;
            }
            case 7: {
                this.camera.setProjectionMode(4);
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 39: {
                break;
            }
            case 36: 
            case 37: 
            case 38: {
                break;
            }
            case 14: {
                this.drawingPanel3D.setImplementation(0);
                this.setListeners();
                super.changeVisual(this.drawingPanel3D.getComponent());
                break;
            }
            case 15: {
                this.visHints.setDecorationType(2);
                break;
            }
            case 16: {
                this.visHints.setCursorType(1);
                break;
            }
            case 17: {
                this.visHints.setRemoveHiddenLines(true);
                break;
            }
            case 18: {
                this.visHints.setAllowQuickRedraw(true);
                break;
            }
            case 19: {
                this.visHints.setUseColorDepth(true);
                break;
            }
            case 20: {
                this.visHints.setShowCoordinates(0);
                break;
            }
            case 21: {
                this.visHints.setXFormat("x = 0.00;x = -0.00");
                break;
            }
            case 22: {
                this.visHints.setYFormat("y = 0.00;y = -0.00");
                break;
            }
            case 23: {
                this.visHints.setZFormat("z = 0.00;z = -0.00");
                break;
            }
            case 24: {
                this.posValues[0].value = (this.minX + this.maxX) / 2.0;
                break;
            }
            case 25: {
                this.posValues[1].value = (this.minY + this.maxY) / 2.0;
                break;
            }
            case 26: {
                this.posValues[2].value = (this.minZ + this.maxZ) / 2.0;
                break;
            }
            case 27: {
                this.removeAction(33, this.getProperty("movedAction"));
                break;
            }
            case 28: {
                this.removeAction(10, this.getProperty("pressAction"));
                break;
            }
            case 29: {
                this.removeAction(0, this.getProperty("releaseAction"));
                break;
            }
            case 30: {
                this.removeAction(1, this.getProperty("dragAction"));
                break;
            }
            case 31: {
                this.removeAction(31, this.getProperty("enteredAction"));
                break;
            }
            case 32: {
                this.removeAction(32, this.getProperty("exitedAction"));
                break;
            }
            case 33: {
                this.removeAction(30, this.getProperty("keyAction"));
                break;
            }
            case 34: {
                this.keyPressedValue.value = -1;
                break;
            }
            case 35: {
                this.setAxesLabels(null);
                break;
            }
            case 40: {
                this.visHints.setBackgroundImage((String)null);
                break;
            }
            case 41: {
                this.camera.setMapping(0);
                break;
            }
            case 42: {
                this.drawingPanel3D.setAxesSize(Double.NaN, this.axisYSize, this.axisZSize);
                break;
            }
            case 43: {
                this.drawingPanel3D.setAxesSize(this.axisXSize, Double.NaN, this.axisZSize);
                break;
            }
            case 44: {
                this.drawingPanel3D.setAxesSize(this.axisXSize, this.axisYSize, Double.NaN);
                break;
            }
            case 45: {
                this.visHints.setDefaultIllumination(true);
                break;
            }
            case 46: {
                this.visHints.setBackgroundMoveable(true);
                break;
            }
            case 47: {
                this.drawingPanel3D.setDraggable(1);
                break;
            }
            case 48: {
                this.drawingPanel3D.setResetCameraOnChanges(true);
                break;
            }
            default: {
                super.setDefaultValue(_index - 49);
                break;
            }
            case 52: {
                this.drawingPanel3D.getInteractionTarget(0).setEnabled(false);
                break;
            }
            case 56: {
                this.visHints.setBackgroundColor(this.defBackground);
                break;
            }
            case 55: {
                this.visHints.setForegroundColor(this.defForeground);
                break;
            }
            case 57: {
                this.visHints.setFont(this.defFont);
            }
        }
    }

    @Override
    public String getDefaultValueString(int _index) {
        switch (_index) {
            case 0: {
                return "-1.0";
            }
            case 1: {
                return "1.0";
            }
            case 2: {
                return "-1.0";
            }
            case 3: {
                return "1.0";
            }
            case 4: {
                return "-1.0";
            }
            case 5: {
                return "1.0";
            }
            case 6: {
                return "true";
            }
            case 7: {
                return "PERSPECTIVE_ON";
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                return "<none>";
            }
            case 14: {
                return "SIMPLE3D";
            }
            case 15: {
                return "CUBE";
            }
            case 16: {
                return "XYZ";
            }
            case 17: 
            case 18: 
            case 19: {
                return "true";
            }
            case 20: {
                return "BOTTOM_LEFT";
            }
            case 21: {
                return "x = 0.00;x = -0.00";
            }
            case 22: {
                return "y = 0.00;y = -0.00";
            }
            case 23: {
                return "z = 0.00;z = -0.00";
            }
            case 24: 
            case 25: 
            case 26: {
                return "<none>";
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                return "<no_action>";
            }
            case 34: {
                return "-1";
            }
            case 35: {
                return "<none>";
            }
            case 40: {
                return "<none>";
            }
            case 41: {
                return "xyz";
            }
            case 42: 
            case 43: 
            case 44: {
                return "<none>";
            }
            case 45: {
                return "true";
            }
            case 46: {
                return "true";
            }
            case 47: {
                return "ANY";
            }
            case 48: {
                return "true";
            }
            default: {
                return super.getDefaultValueString(_index - 49);
            }
            case 52: {
                return "false";
            }
            case 56: {
                return this.defBackground.toString();
            }
            case 55: {
                return this.defForeground.toString();
            }
            case 57: 
        }
        return this.defFont.toString();
    }

    @Override
    public Value getValue(int _index) {
        switch (_index) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return null;
            }
            case 8: {
                return this.cameraValues[0];
            }
            case 9: {
                return this.cameraValues[1];
            }
            case 10: {
                return this.cameraValues[2];
            }
            case 11: {
                return this.cameraValues[3];
            }
            case 12: {
                return this.cameraValues[4];
            }
            case 13: {
                return this.cameraValues[5];
            }
            case 36: {
                return this.cameraValues[6];
            }
            case 37: {
                return this.cameraValues[7];
            }
            case 38: {
                return this.cameraValues[8];
            }
            case 39: {
                return this.cameraValues[9];
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                return null;
            }
            case 24: {
                return this.posValues[0];
            }
            case 25: {
                return this.posValues[1];
            }
            case 26: {
                return this.posValues[2];
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                return null;
            }
            case 34: {
                return this.keyPressedValue;
            }
            case 35: {
                return null;
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: {
                return null;
            }
            default: {
                return super.getValue(_index - 49);
            }
            case 52: 
        }
        return null;
    }

    private void resetExtrema() {
        this.settingExtrema = true;
        this.drawingPanel3D.setPreferredMinMax(this.minX, this.maxX, this.minY, this.maxY, this.minZ, this.maxZ);
        this.reportCameraMotion();
    }

    private void reportCameraMotion() {
        if (this.settingExtrema) {
            this.camera.setDistanceToScreen(this.cameraValues[3].value);
            if (this.cameraLocationSet) {
                this.camera.setXYZ(this.cameraValues[6].value, this.cameraValues[7].value, this.cameraValues[8].value);
            } else {
                this.camera.setAzimuthAndAltitude(this.cameraValues[4].value, this.cameraValues[5].value);
            }
            this.camera.setRotation(this.cameraValues[9].value);
            this.camera.setFocusXYZ(this.cameraValues[0].value, this.cameraValues[1].value, this.cameraValues[2].value);
        } else {
            this.cameraValues[0].value = this.camera.getFocusX();
            this.cameraValues[1].value = this.camera.getFocusY();
            this.cameraValues[2].value = this.camera.getFocusZ();
            this.cameraValues[3].value = this.camera.getDistanceToScreen();
            this.cameraValues[4].value = this.camera.getAzimuth();
            this.cameraValues[5].value = this.camera.getAltitude();
            this.cameraValues[6].value = this.camera.getX();
            this.cameraValues[7].value = this.camera.getY();
            this.cameraValues[8].value = this.camera.getZ();
            this.cameraValues[9].value = this.camera.getRotation();
        }
        if (this.reportCameraMotion) {
            this.variablesChanged(CAMERA_INDEXES, this.cameraValues);
        }
        if (this.isUnderEjs) {
            if (!this.editorIsReading()) {
                if (this.cameraLocationSet) {
                    ControlDrawingPanel3D.CAMERA_PARTIAL_INDEXES[4] = -1;
                    ControlDrawingPanel3D.CAMERA_PARTIAL_INDEXES[5] = -1;
                    ControlDrawingPanel3D.CAMERA_PARTIAL_INDEXES[6] = 36;
                    ControlDrawingPanel3D.CAMERA_PARTIAL_INDEXES[7] = 37;
                    ControlDrawingPanel3D.CAMERA_PARTIAL_INDEXES[8] = 38;
                } else {
                    ControlDrawingPanel3D.CAMERA_PARTIAL_INDEXES[4] = 12;
                    ControlDrawingPanel3D.CAMERA_PARTIAL_INDEXES[5] = 13;
                    ControlDrawingPanel3D.CAMERA_PARTIAL_INDEXES[6] = -1;
                    ControlDrawingPanel3D.CAMERA_PARTIAL_INDEXES[7] = -1;
                    ControlDrawingPanel3D.CAMERA_PARTIAL_INDEXES[8] = -1;
                }
                this.setFieldListValues(CAMERA_PARTIAL_INDEXES, this.cameraValues);
            }
            this.drawingPanel3D.render();
        }
        this.settingExtrema = false;
    }

    private void updateCameraFields() {
        this.reportCameraMotion();
        switch (this.camera.getProjectionMode()) {
            case 0: {
                this.setFieldListValue(7, new StringValue("PLANAR_XY"));
                break;
            }
            case 1: {
                this.setFieldListValue(7, new StringValue("PLANAR_XZ"));
                break;
            }
            case 2: {
                this.setFieldListValue(7, new StringValue("PLANAR_YZ"));
                break;
            }
            case 3: 
            case 10: {
                this.setFieldListValue(7, new StringValue("PERSPECTIVE_OFF"));
                break;
            }
            default: {
                this.setFieldListValue(7, new StringValue("PERSPECTIVE_ON"));
            }
        }
    }

    private void reportMouseMotion(Object _info) {
        if (_info == null || !(_info instanceof double[])) {
            return;
        }
        double[] point = (double[])_info;
        this.posValues[0].value = point[0];
        this.posValues[1].value = point[1];
        this.posValues[2].value = point[2];
        if (this.reportXYZMotion) {
            this.variablesChanged(POSITION_INDEXES, this.posValues);
        }
        if (this.isUnderEjs) {
            this.setFieldListValues(POSITION_INDEXES, this.posValues);
        }
    }

    @Override
    public void interactionPerformed(InteractionEvent _event) {
        switch (_event.getID()) {
            case 2003: {
                this.invokeActions(31);
                break;
            }
            case 2004: {
                this.invokeActions(32);
                break;
            }
            case 2005: {
                this.reportMouseMotion(_event.getInfo());
                this.invokeActions(33);
                break;
            }
            case 2000: {
                this.drawingPanel3D.getComponent().requestFocus();
                this.reportMouseMotion(_event.getInfo());
                this.invokeActions(10);
                break;
            }
            case 2001: {
                if (_event.getInfo() == null) {
                    this.reportCameraMotion();
                    break;
                }
                this.reportMouseMotion(_event.getInfo());
                break;
            }
            case 2002: {
                this.invokeActions(0);
            }
        }
    }
}

