var _isEPub = false;
var _isApp = false;

var __base64Images = [];
__base64Images["./UnderstandingParallelCircuitsFrem/Understanding Parallel Circuits Thumbnail.PNG"]="data:image/png;base64,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";
