var _isEPub = false;
var _isApp = false;

var __base64Images = [];
__base64Images["./TypesOfCircuitsFrem/typesofcircuits.PNG"]="data:image/png;base64,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";
