var _isEPub = false;
var _isApp = false;

var __base64Images = [];
__base64Images["./PotentialDifferenceFrem/PotentialDiffference.PNG"]="data:image/png;base64,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";
