var _isEPub = false;
var _isApp = false;

var __base64Images = [];
__base64Images["./CircuitryAtHomeFrem/circuitryathome.PNG"]="data:image/png;base64,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";
