var _isEPub = false;
var _isApp = false;

var __base64Images = [];
__base64Images["./Blackbody Radiation/Blackbody Radiation.png"]="data:image/png;base64,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";
__base64Images["/org/opensourcephysics/resources/controls/images/pause.gif"]="data:image/gif;base64,R0lGODlhEAAQAKL/AP///5mZzGZmmTMzZgAAAMDAwAAAAAAAACH5BAEAAAUALAAAAAAQABAAQAMyWLrcPEEABaWrs+ArrO7ZMwzLSF5RtjXr6rxwjAZqQKOeW6YUz/q6Xs7XABgXxpDMkQAAIf5PQ29weXJpZ2h0IDIwMDAgYnkgU3VuIE1pY3Jvc3lzdGVtcywgSW5jLiBBbGwgUmlnaHRzIFJlc2VydmVkLg0KSkxGIEdSIFZlciAxLjANCgA7";
__base64Images["/org/opensourcephysics/resources/controls/images/stepforward.gif"]="data:image/gif;base64,R0lGODlhEAAQAKL/AP///5mZzGZmmTMzZgAAAMDAwAAAAAAAACH5BAEAAAUALAAAAAAQABAAQAM6WLrcO0GAAoUYYL444XDKYHUZSA0fZYYcFV1O1QWYtt54HASdsMoumE4StKQ2xEqtAUSVQBmNLWdKAAAh/k9Db3B5cmlnaHQgMjAwMCBieSBTdW4gTWljcm9zeXN0ZW1zLCBJbmMuIEFsbCBSaWdodHMgUmVzZXJ2ZWQuDQpKTEYgR1IgVmVyIDEuMA0KADs=";
__base64Images["./BlackbodyRadiationSpectrum/blackbodyradiation.gif"]="data:image/gif;base64,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";
__base64Images["/org/opensourcephysics/resources/controls/images/play.gif"]="data:image/gif;base64,R0lGODlhEAAQAKL/AP///5mZzGZmmTMzZgAAAMDAwAAAAAAAACH5BAEAAAUALAAAAAAQABAAQAMsWLrcPkHIAYBTUIzbBrXcMghhF01l9pUFyBbbiwUxm2n2iXL3ytMVW1BWSgAAIf5PQ29weXJpZ2h0IDIwMDAgYnkgU3VuIE1pY3Jvc3lzdGVtcywgSW5jLiBBbGwgUmlnaHRzIFJlc2VydmVkLg0KSkxGIEdSIFZlciAxLjANCgA7";
__base64Images["/org/opensourcephysics/resources/controls/images/reset1.gif"]="data:image/gif;base64,R0lGODlhEAAQAIMAAP///5mZzGZmmTMzZgAAAMDAwAAAAAAAAAi/Z9z8qBIvQNz/0AjBpwAAAAQS93Ft5CH5BAMAAAUAIf5QQ29weXJpZ2h0IDIwMDAgYnkgU3VuIE1pY3Jvc3lzdGVtcywgSW5jLiBBbGwgUmlnaHRzIFJlc2VydmVkLg0KSkxGIEdSIFZlciAxLjANCgAALAAAAAAQABAAAAQ3sMhJq71YDrv5ANTwVUMwaiY4lSnausLIxupM22cxCLzM06FeTUgCaoyhnE65UjUxzkk0Q6VGAAA7";
__base64Images["./Blackbody Radiation/lookangphoto.png"]="data:image/png;base64,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";
__base64Images["/org/opensourcephysics/resources/controls/images/reset.gif"]="data:image/gif;base64,R0lGODlhEAAQAIcAAAAAAAAAMwAAZgAAmQAAzAAA/wAzAAAzMwAzZgAzmQAzzAAz/wBmAABmMwBmZgBmmQBmzABm/wCZAACZMwCZZgCZmQCZzACZ/wDMAADMMwDMZgDMmQDMzADM/wD/AAD/MwD/ZgD/mQD/zAD//zMAADMAMzMAZjMAmTMAzDMA/zMzADMzMzMzZjMzmTMzzDMz/zNmADNmMzNmZjNmmTNmzDNm/zOZADOZMzOZZjOZmTOZzDOZ/zPMADPMMzPMZjPMmTPMzDPM/zP/ADP/MzP/ZjP/mTP/zDP//2YAAGYAM2YAZmYAmWYAzGYA/2YzAGYzM2YzZmYzmWYzzGYz/2ZmAGZmM2ZmZmZmmWZmzGZm/2aZAGaZM2aZZmaZmWaZzGaZ/2bMAGbMM2bMZmbMmWbMzGbM/2b/AGb/M2b/Zmb/mWb/zGb//5kAAJkAM5kAZpkAmZkAzJkA/5kzAJkzM5kzZpkzmZkzzJkz/5lmAJlmM5lmZplmmZlmzJlm/5mZAJmZM5mZZpmZmZmZzJmZ/5nMAJnMM5nMZpnMmZnMzJnM/5n/AJn/M5n/Zpn/mZn/zJn//8wAAMwAM8wAZswAmcwAzMwA/8wzAMwzM8wzZswzmcwzzMwz/8xmAMxmM8xmZsxmmcxmzMxm/8yZAMyZM8yZZsyZmcyZzMyZ/8zMAMzMM8zMZszMmczMzMzM/8z/AMz/M8z/Zsz/mcz/zMz///8AAP8AM/8AZv8Amf8AzP8A//8zAP8zM/8zZv8zmf8zzP8z//9mAP9mM/9mZv9mmf9mzP9m//+ZAP+ZM/+ZZv+Zmf+ZzP+Z///MAP/MM//MZv/Mmf/MzP/M////AP//M///Zv//mf//zP///87OzgAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAMAANgALAAAAAAQABAAAAheALEJHMhioMGDAq8URIiQhaCFDAleeRhR4kQWGDMeZHGl48OOICEK5HgxI0aFGy9eW7nSoUhsLq8ZjLmRhUyCD2/O1AkzJ0OeNE0KPWlzJMijIXUOFcoTG8unLA0GBAA7";
