/*
 * Decompiled with CFR 0.152.
 */
package users.sgeducation.lookang.capacitor_pkg;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JFrame;
import org.colos.ejs.library.LauncherApplet;
import org.colos.ejs.library.Model;
import org.colos.ejs.library.Simulation;
import org.colos.ejs.library.View;
import org.colos.ejs.library.control.EjsControl;
import org.colos.ejs.library.external.ExternalApp;
import org.colos.ejs.library.external.ExternalAppsHandler;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.tools.ResourceLoader;
import users.sgeducation.lookang.capacitor_pkg.capacitorSimulation;
import users.sgeducation.lookang.capacitor_pkg.capacitorView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class capacitor
extends Model {
    public capacitorSimulation _simulation = null;
    public capacitorView _view = null;
    public capacitor _model = this;
    private ExternalAppsHandler _external = new ExternalAppsHandler(this);
    public double Q = 1.0;
    public double V = 1.0;
    public double C = 1.0;
    public double E = 1.0;
    public double U = 1.0;
    public double K = 1.0;
    public double d = 0.3;
    public boolean batteryflag = true;
    public boolean switchopenflag = true;
    public String helpLabel = "Show Help";
    public boolean helpFlag = false;
    public int redness = 100;
    public int greenness = 100;
    public int blueness = 100;
    public Object dielectricColor = null;
    public double colorValue = 0.0;
    public double switchlengthx = 0.0;
    public double switchlengthy = 0.2;
    public double switchlengthx2 = 0.0;
    public double switchlengthy2 = 0.2;
    public double switchlengthx3 = -0.14;
    public double switchlengthy3 = 0.14;
    public int number;
    public int i = this.number = 16;
    public boolean[] fieldflag;
    public double[] fieldy;
    public double[] field2y;
    public double ymaximum = 0.0;
    public double yspacing = 0.0;
    private boolean _isEnabled_initialization1 = true;
    private boolean _isEnabled_constraints1 = true;

    public static String _getEjsModel() {
        return "/users/sgeducation/lookang/capacitor.xml";
    }

    public static String _getModelDirectory() {
        return "users/sgeducation/lookang/";
    }

    public static Dimension _getEjsAppletDimension() {
        return new Dimension(700, 570);
    }

    public static Set<String> _getEjsResources() {
        HashSet<String> hashSet = new HashSet<String>();
        return hashSet;
    }

    public static boolean _common_initialization(String[] stringArray) {
        int n;
        String string = null;
        boolean bl = true;
        if (stringArray != null) {
            for (n = 0; n < stringArray.length; ++n) {
                if (stringArray[n].equals("-_lookAndFeel")) {
                    string = stringArray[++n];
                    continue;
                }
                if (stringArray[n].equals("-_decorateWindows")) {
                    bl = true;
                    continue;
                }
                if (!stringArray[n].equals("-_doNotDecorateWindows")) continue;
                bl = false;
            }
        }
        if (string != null) {
            OSPRuntime.setLookAndFeel(bl, string);
        }
        ResourceLoader.addSearchPath("users/sgeducation/lookang/");
        n = 0;
        boolean bl2 = false;
        try {
            if (System.getProperty("osp_ejs") != null) {
                bl2 = true;
                Simulation.setPathToLibrary("C:/LooKang/EJS_4.2.7_100314/EJS_4.2.7/bin/config/");
                n = 1;
            }
        }
        catch (Exception exception) {
            n = 0;
        }
        try {
            EjsControl.setDefaultScreen(Integer.parseInt(System.getProperty("screen")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (n == 0) {
            Simulation.setPathToLibrary("C:/LooKang/EJS_4.2.7_100314/EJS_4.2.7/bin/config/");
        }
        if (!bl2) {
            // empty if block
        }
        return true;
    }

    public static void main(String[] stringArray) {
        if (!capacitor._common_initialization(stringArray)) {
            if (OSPRuntime.isLauncherMode()) {
                return;
            }
            System.exit(-1);
        }
        capacitor capacitor2 = new capacitor(stringArray);
    }

    public static JComponent getModelPane(String[] stringArray, JFrame jFrame) {
        if (!capacitor._common_initialization(stringArray)) {
            return null;
        }
        capacitor capacitor2 = new capacitor("MainWindow", jFrame, null, null, stringArray, true);
        return (JComponent)capacitor2._getView().getComponent("MainWindow");
    }

    public capacitor() {
        this(null, null, null, null, null, false);
    }

    public capacitor(String[] stringArray) {
        this(null, null, null, null, stringArray, true);
    }

    public capacitor(String string, Frame frame, URL uRL, LauncherApplet launcherApplet, String[] stringArray, boolean bl) {
        this.__theArguments = stringArray;
        this.__theApplet = launcherApplet;
        NumberFormat numberFormat = NumberFormat.getInstance();
        if (numberFormat instanceof DecimalFormat) {
            ((DecimalFormat)numberFormat).getDecimalFormatSymbols().setDecimalSeparator('.');
        }
        this._simulation = new capacitorSimulation(this, string, frame, uRL, bl);
        this._view = (capacitorView)this._simulation.getView();
        this._simulation.processArguments(stringArray);
    }

    @Override
    public View _getView() {
        return this._view;
    }

    @Override
    public Simulation _getSimulation() {
        return this._simulation;
    }

    @Override
    public int _getPreferredStepsPerDisplay() {
        return 1;
    }

    @Override
    public void _resetModel() {
        int n;
        this._isEnabled_initialization1 = true;
        this._isEnabled_constraints1 = true;
        this.Q = 1.0;
        this.V = 1.0;
        this.C = 1.0;
        this.E = 1.0;
        this.U = 1.0;
        this.K = 1.0;
        this.d = 0.3;
        this.batteryflag = true;
        this.switchopenflag = true;
        this.helpLabel = "Show Help";
        this.helpFlag = false;
        this.redness = 100;
        this.greenness = 100;
        this.blueness = 100;
        this.colorValue = 0.0;
        this.switchlengthx = 0.0;
        this.switchlengthy = 0.2;
        this.switchlengthx2 = 0.0;
        this.switchlengthy2 = 0.2;
        this.switchlengthx3 = -0.14;
        this.switchlengthy3 = 0.14;
        this.i = this.number = 16;
        this.fieldflag = new boolean[this.number];
        for (n = 0; n < this.number; ++n) {
            this.fieldflag[n] = true;
        }
        this.fieldy = new double[this.number];
        for (n = 0; n < this.number; ++n) {
            this.fieldy[n] = 0.0;
        }
        this.field2y = new double[this.number];
        for (n = 0; n < this.number; ++n) {
            this.field2y[n] = 0.0;
        }
        this.ymaximum = 0.0;
        this.yspacing = 0.0;
    }

    public void _initializeSolvers() {
    }

    @Override
    public void _initializeModel() {
        if (this._isEnabled_initialization1) {
            this._initialization1();
        }
        this._initializeSolvers();
    }

    @Override
    public void _resetSolvers() {
        this._external.resetIC();
    }

    @Override
    public void _stepModel() {
    }

    @Override
    public void _updateModel() {
        if (this._isEnabled_constraints1) {
            this._constraints1();
        }
    }

    @Override
    public void _freeMemory() {
        this.fieldflag = null;
        this.fieldy = null;
        this.field2y = null;
        System.gc();
    }

    @Override
    public String _externalInitCommand(String string) {
        return null;
    }

    @Override
    public void _externalSetValues(boolean bl, ExternalApp externalApp) {
    }

    @Override
    public void _externalGetValues(boolean bl, ExternalApp externalApp) {
    }

    public void _setPageEnabled(String string, boolean bl) {
        boolean bl2 = false;
        if ("Init Page".equals(string)) {
            bl2 = true;
            this._isEnabled_initialization1 = bl;
        }
        if ("Cons Page".equals(string)) {
            bl2 = true;
            this._isEnabled_constraints1 = bl;
        }
        if (!bl2) {
            System.out.println("_setPageEnabled() warning. Page not found: " + string);
        }
    }

    public void _initialization1() {
        this.dielectricColor = new Color(this.redness, this.greenness, this.blueness);
    }

    public void _constraints1() {
        this.C = this.K * 0.3 / this.d;
        if (this.batteryflag) {
            this.V = 1.0;
            this.Q = this.C * this.V;
        } else {
            this.V = this.Q / this.C;
        }
        this.E = 0.3 * this.V / this.d;
        this.U = this.Q * this.V;
        this.ymaximum = 7.5 / this.E;
        this.yspacing = this.ymaximum / (double)this.number;
        this.i = 0;
        while (this.i < this.number) {
            this.fieldy[this.i] = 0.5 * this.yspacing + (double)this.i * this.yspacing;
            this.field2y[this.i] = -1.0 * this.fieldy[this.i];
            this.fieldflag[this.i] = true;
            if (this.fieldy[this.i] > 0.5) {
                this.fieldflag[this.i] = false;
            }
            ++this.i;
        }
    }

    public void _method_for_close_actionon() {
        this.switchlengthx = this.switchlengthx2;
        this.switchlengthy = this.switchlengthy2;
    }

    public void _method_for_close_actionoff() {
        this.switchopenflag = true;
        this.switchlengthx = this.switchlengthx3;
        this.switchlengthy = this.switchlengthy3;
    }

    public void _method_for_open_actionon() {
        this.batteryflag = false;
        this.switchlengthx = this.switchlengthx3;
        this.switchlengthy = this.switchlengthy3;
    }

    public void _method_for_open_actionoff() {
        this.batteryflag = true;
        this.switchlengthx = this.switchlengthx2;
        this.switchlengthy = this.switchlengthy2;
    }

    public void _method_for_dielectric_dragaction() {
        this.greenness = (int)(100.0 + 36.0 * (this.K - 1.0));
        this.dielectricColor = new Color(this.redness, this.greenness, this.blueness);
    }

    public void _method_for_dielectric_action() {
        this.greenness = (int)(100.0 + 36.0 * (this.K - 1.0));
        this.dielectricColor = new Color(this.redness, this.greenness, this.blueness);
    }

    public void _method_for_reset_action() {
        this._reset();
    }

    public void _method_for_instructions_action() {
        if (this.helpFlag) {
            this.helpFlag = false;
            this.helpLabel = "Show Help";
        } else {
            this.helpFlag = true;
            this.helpLabel = "Hide Help";
        }
    }

    public double _method_for_rightplate_x() {
        return this.d / 2.0;
    }

    public double _method_for_leftplate_x() {
        return -this.d / 2.0;
    }

    public double _method_for_switch3_x() {
        return -0.34 + this.switchlengthx3;
    }

    public double _method_for_switch3_y() {
        return 0.3 + this.switchlengthy3;
    }

    public double _method_for_plusvectors_x() {
        return -this.d / 2.0;
    }

    public double _method_for_minusvectors_x() {
        return -this.d / 2.0;
    }

    public void _method_for_helpBox_onClosing() {
        this.helpFlag = false;
        this.helpLabel = "Show Help";
    }
}

