/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.Writer;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.rmi.RemoteException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.controls.XMLProperty;
import org.opensourcephysics.controls.XMLTree;
import org.opensourcephysics.controls.XMLTreeChooser;
import org.opensourcephysics.display.Data;
import org.opensourcephysics.display.DataFunction;
import org.opensourcephysics.display.DataTable;
import org.opensourcephysics.display.Dataset;
import org.opensourcephysics.display.DatasetManager;
import org.opensourcephysics.display.OSPFrame;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.display.TeXParser;
import org.opensourcephysics.display.TextFrame;
import org.opensourcephysics.tools.DataFunctionPanel;
import org.opensourcephysics.tools.DataToolTab;
import org.opensourcephysics.tools.DataToolTable;
import org.opensourcephysics.tools.FontSizer;
import org.opensourcephysics.tools.FunctionPanel;
import org.opensourcephysics.tools.FunctionTool;
import org.opensourcephysics.tools.Job;
import org.opensourcephysics.tools.JobManager;
import org.opensourcephysics.tools.Resource;
import org.opensourcephysics.tools.ResourceLoader;
import org.opensourcephysics.tools.SnapshotTool;
import org.opensourcephysics.tools.Tool;
import org.opensourcephysics.tools.Toolbox;
import org.opensourcephysics.tools.ToolsRes;

public class DataTool
extends OSPFrame
implements Tool,
PropertyChangeListener {
    public static boolean loadClass = false;
    protected static JFileChooser chooser;
    protected static Dimension dim;
    protected static final int defaultButtonHeight = 28;
    protected static int buttonHeight;
    protected static String[] delimiters;
    protected JTabbedPane tabbedPane;
    protected boolean useChooser = true;
    protected JPanel contentPane = new JPanel(new BorderLayout());
    protected PropertyChangeSupport support;
    protected XMLControl control = new XMLControlElement();
    protected JobManager jobManager = new JobManager(this);
    protected DatasetManager addableData = null;
    protected JMenuBar emptyMenubar;
    protected JMenu emptyFileMenu;
    protected JMenuItem emptyNewTabItem;
    protected JMenuItem emptyOpenItem;
    protected JMenuItem emptyExitItem;
    protected JMenu emptyEditMenu;
    protected JMenuItem emptyPasteItem;
    protected JMenuBar menubar;
    protected JMenu fileMenu;
    protected JMenuItem newTabItem;
    protected JMenuItem openItem;
    protected JMenuItem exportItem;
    protected JMenuItem saveItem;
    protected JMenuItem saveAsItem;
    protected JMenuItem closeItem;
    protected JMenuItem closeAllItem;
    protected JMenuItem printItem;
    protected JMenuItem exitItem;
    protected JMenu editMenu;
    protected JMenuItem undoItem;
    protected JMenuItem redoItem;
    protected JMenu copyMenu;
    protected JMenuItem copyImageItem;
    protected JMenuItem copyTabItem;
    protected JMenuItem copyDataItem;
    protected JMenu pasteMenu;
    protected JMenuItem pasteNewTabItem;
    protected JMenuItem pasteColumnsItem;
    protected JMenu displayMenu;
    protected JMenu languageMenu;
    protected JMenuItem[] languageItems;
    protected JMenu fontSizeMenu;
    protected JMenuItem defaultFontSizeItem;
    protected JMenu helpMenu;
    protected JMenuItem helpItem;
    protected JMenuItem logItem;
    protected JMenuItem aboutItem;
    protected FunctionTool dataFunctionTool;
    protected JLabel helpLabel;
    protected TextFrame helpFrame;
    protected String helpPath = "data_tool_help.html";
    protected String helpBase = "http://www.opensourcephysics.org/online_help/tools/";
    protected int fontLevel = FontSizer.getLevel();
    protected boolean exitOnClose = false;
    protected boolean userEditable = false;
    protected boolean saveChangesOnClose = false;
    static final DataTool DATATOOL;

    static {
        dim = new Dimension(720, 500);
        buttonHeight = 28;
        delimiters = new String[]{" ", "\t", ",", ";"};
        DATATOOL = new DataTool();
    }

    public static DataTool getTool() {
        return DATATOOL;
    }

    public static void main(String[] stringArray) {
        DataTool.DATATOOL.userEditable = true;
        DataTool.DATATOOL.exitOnClose = true;
        DataTool.DATATOOL.saveChangesOnClose = true;
        if (stringArray != null && stringArray.length > 0 && stringArray[0] != null) {
            DATATOOL.open(stringArray[0]);
        } else {
            DATATOOL.addTab((Data)null);
        }
        DATATOOL.setVisible(true);
    }

    public DataTool() {
        this(ToolsRes.getString("DataTool.Frame.Title"), "DataTool");
    }

    public DataTool(String string) {
        this();
        this.open(string);
    }

    public DataTool(XMLControl xMLControl) {
        this();
        this.addTab(xMLControl);
    }

    public DataTool(Data data) {
        this();
        this.addTab(data);
    }

    public DataTool(Data data, String string) {
        this();
        this.addTab(data, string);
    }

    public void setUserEditable(boolean bl) {
        this.userEditable = bl;
        int n = this.tabbedPane.getTabCount();
        int n2 = 0;
        while (n2 < n) {
            DataToolTab dataToolTab = (DataToolTab)this.tabbedPane.getComponentAt(n2);
            dataToolTab.userEditable = bl;
            dataToolTab.refreshGUI();
            ++n2;
        }
    }

    public void setSaveChangesOnClose(boolean bl) {
        this.saveChangesOnClose = bl && !OSPRuntime.appletMode;
    }

    public DataToolTab addTab(XMLControl xMLControl) {
        if (DataToolTab.class.isAssignableFrom(xMLControl.getObjectClass())) {
            DataToolTab dataToolTab = (DataToolTab)xMLControl.loadObject(null);
            dataToolTab.dataTool = this;
            this.addTab(dataToolTab);
            dataToolTab.userEditable = true;
            dataToolTab.refreshGUI();
            return dataToolTab;
        }
        return this.loadData(null, xMLControl, this.useChooser);
    }

    public DataToolTab addTab(Data data) {
        String string = "";
        try {
            Method method = data.getClass().getMethod("getName", new Class[0]);
            string = (String)method.invoke((Object)data, new Object[0]);
        }
        catch (Exception exception) {}
        return this.addTab(data, string);
    }

    public DataToolTab addTab(Data data, String string) {
        DataToolTab dataToolTab = new DataToolTab(data, this);
        dataToolTab.setName(string);
        this.addTab(dataToolTab);
        return dataToolTab;
    }

    public boolean removeTab(int n) {
        if (n >= 0 && n < this.tabbedPane.getTabCount()) {
            if (!this.saveChangesAt(n)) {
                return false;
            }
            String string = this.tabbedPane.getTitleAt(n);
            OSPLog.finer("removing tab " + string);
            this.tabbedPane.removeTabAt(n);
            this.refreshTabTitles();
            this.refreshMenubar();
            this.refreshFunctionTool();
            return true;
        }
        return false;
    }

    public void update(Data data) {
        DataToolTab dataToolTab = this.getTab(data);
        if (dataToolTab != null) {
            dataToolTab.reloadData(data);
        }
    }

    public DataToolTab getTab(Data data) {
        int n = this.getTabIndex(data);
        return n > -1 ? (DataToolTab)this.tabbedPane.getComponentAt(n) : null;
    }

    public DataToolTab getTab(int n) {
        return n > -1 && n < this.tabbedPane.getTabCount() ? (DataToolTab)this.tabbedPane.getComponentAt(n) : null;
    }

    public int getTabCount() {
        return this.tabbedPane.getTabCount();
    }

    public String open(String string) {
        OSPLog.fine("opening " + string);
        Resource resource = ResourceLoader.getResource(string);
        if (resource != null) {
            DataToolTab dataToolTab;
            DatasetManager datasetManager;
            BufferedReader bufferedReader = resource.openReader();
            String string2 = this.readFirstLine(bufferedReader);
            if (string2.startsWith("<?xml")) {
                XMLControlElement xMLControlElement = new XMLControlElement(string);
                DataToolTab dataToolTab2 = this.addTab(xMLControlElement);
                if (dataToolTab2 != null) {
                    this.refreshFunctionTool();
                    dataToolTab2.fileName = string;
                    dataToolTab2.tabChanged(false);
                    return string;
                }
            } else if (resource.getString() != null && (datasetManager = this.importCharDelimitedData(resource.getString(), string)) != null && (dataToolTab = this.addTab(datasetManager)) != null) {
                this.refreshFunctionTool();
                dataToolTab.fileName = string;
                dataToolTab.tabChanged(false);
                return string;
            }
        }
        OSPLog.finest("no data found");
        return null;
    }

    public void send(Job job, Tool tool) throws RemoteException {
        XMLControlElement xMLControlElement = new XMLControlElement(job.getXML());
        if (xMLControlElement.failedToRead() || xMLControlElement.getObjectClass() == Object.class) {
            return;
        }
        this.jobManager.log(job, tool);
        if (Data.class.isAssignableFrom(xMLControlElement.getObjectClass())) {
            Data data = (Data)xMLControlElement.loadObject(null, true, true);
            DataToolTab dataToolTab = this.getTab(data);
            dataToolTab = this.loadData(data, dataToolTab);
            this.refreshTabTitles();
            this.jobManager.associate(job, dataToolTab.dataManager);
            dataToolTab.refreshGUI();
        } else {
            this.addTab(xMLControlElement);
        }
    }

    public void setUseChooser(boolean bl) {
        this.useChooser = bl;
    }

    public boolean isUseChooser() {
        return this.useChooser;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        DataToolTab dataToolTab;
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("function") && (dataToolTab = this.getSelectedTab()) != null) {
            String string2;
            dataToolTab.tabChanged(true);
            dataToolTab.dataTable.refreshTable();
            dataToolTab.statsTable.refreshStatistics();
            if (propertyChangeEvent.getNewValue() instanceof DataFunction) {
                string2 = propertyChangeEvent.getNewValue().toString();
                dataToolTab.dataTable.getWorkingData(string2);
            }
            if (propertyChangeEvent.getOldValue() instanceof DataFunction) {
                string2 = propertyChangeEvent.getOldValue().toString();
                dataToolTab.dataTable.removeWorkingData(string2);
            }
            if (propertyChangeEvent.getNewValue() instanceof String) {
                string2 = propertyChangeEvent.getNewValue().toString();
                if (propertyChangeEvent.getOldValue() instanceof String) {
                    String string3 = propertyChangeEvent.getOldValue().toString();
                    dataToolTab.columnNameChanged(string3, string2);
                } else {
                    dataToolTab.dataTable.getWorkingData(string2);
                }
            }
            dataToolTab.refreshPlot();
        }
    }

    public static boolean containsDuplicateValues(double[] dArray) {
        int n = 0;
        while (n < dArray.length) {
            int n2 = DataTool.getIndex(dArray[n], dArray, n);
            if (n2 > -1) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static int getIndex(double d, double[] dArray, int n) {
        int n2 = 0;
        while (n2 < dArray.length) {
            if (n2 != n && dArray[n2] == d) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public static double[] getRowArray(int n) {
        double[] dArray = new double[n];
        int n2 = 0;
        while (n2 < n) {
            dArray[n2] = n2;
            ++n2;
        }
        return dArray;
    }

    public static String[] parseStrings(String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string != null) {
            String string3 = string;
            int n = string.indexOf(string2);
            if (n == -1) {
                arrayList.add(DataTool.stripQuotes(string3));
                string = null;
            } else {
                string3 = string.substring(0, n);
                string = string.substring(n + 1);
            }
            while (string != null) {
                arrayList.add(DataTool.stripQuotes(string3));
                n = string.indexOf(string2);
                if (n == -1) {
                    string3 = string;
                    arrayList.add(DataTool.stripQuotes(string3));
                    string = null;
                    continue;
                }
                string3 = string.substring(0, n).trim();
                string = string.substring(n + 1);
            }
        }
        return arrayList.toArray(new String[0]);
    }

    public static String stripQuotes(String string) {
        String string2;
        int n;
        if (string.startsWith("\"") && (n = (string2 = string.substring(1)).indexOf("\"")) == string2.length() - 1) {
            return string2.substring(0, n);
        }
        return string;
    }

    public static double[] parseDoubles(String string, String string2) {
        String[] stringArray = DataTool.parseStrings(string, string2);
        return DataTool.parseDoubles(stringArray);
    }

    public static double[] parseDoubles(String[] stringArray) {
        double[] dArray = new double[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].indexOf("\t") > -1) {
                dArray[n] = Double.NaN;
            } else {
                try {
                    dArray[n] = Double.parseDouble(stringArray[n]);
                }
                catch (NumberFormatException numberFormatException) {
                    dArray[n] = Double.NaN;
                }
            }
            ++n;
        }
        return dArray;
    }

    public static String[][] parseStrings(String string, String string2, String string3) {
        String[] stringArray = DataTool.parseStrings(string, string2);
        String[][] stringArray2 = new String[stringArray.length][0];
        int n = 0;
        while (n < stringArray.length) {
            stringArray2[n] = DataTool.parseStrings(stringArray[n], string3);
            ++n;
        }
        return stringArray2;
    }

    public static double[][] parseDoubles(String string, String string2, String string3) {
        String[][] stringArray = DataTool.parseStrings(string, string2, string3);
        double[][] dArray = new double[stringArray.length][0];
        int n = 0;
        while (n < stringArray.length) {
            double[] dArray2 = new double[stringArray[n].length];
            int n2 = 0;
            while (n2 < dArray2.length) {
                try {
                    dArray2[n2] = Double.parseDouble(stringArray[n][n2]);
                }
                catch (NumberFormatException numberFormatException) {
                    dArray2[n2] = Double.NaN;
                }
                ++n2;
            }
            dArray[n] = dArray2;
            ++n;
        }
        return dArray;
    }

    protected String readFirstLine(Reader reader) {
        String string;
        BufferedReader bufferedReader = null;
        bufferedReader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
        try {
            string = bufferedReader.readLine();
            while (string == null || string.equals("")) {
                string = bufferedReader.readLine();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
        try {
            bufferedReader.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return string;
    }

    protected DatasetManager importCharDelimitedData(String string, String string2) {
        BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
        String string3 = "#";
        try {
            String string4 = bufferedReader.readLine();
            int n = 0;
            while (n < delimiters.length) {
                int n2;
                ArrayList<double[]> arrayList = new ArrayList<double[]>();
                int n3 = Integer.MAX_VALUE;
                String[] stringArray = null;
                String string5 = null;
                int n4 = 0;
                while (string4 != null) {
                    if (string4.startsWith(string3)) {
                        int n5 = string4.indexOf("name:");
                        if (n5 > -1) {
                            string5 = string4.substring(n5 + 5).trim();
                        }
                        if ((n5 = string4.indexOf("columnNames:")) > -1) {
                            string4 = string4.substring(n5 + 12).trim();
                        } else {
                            string4 = bufferedReader.readLine();
                            continue;
                        }
                    }
                    String[] stringArray2 = DataTool.parseStrings(string4, delimiters[n]);
                    double[] dArray = DataTool.parseDoubles(stringArray2);
                    if (arrayList.isEmpty() && stringArray2.length > 0 && string5 == null) {
                        String string6 = "";
                        n2 = 0;
                        while (n2 < stringArray2.length) {
                            if (Double.isNaN(dArray[n2]) && !stringArray2[n2].equals("")) {
                                if (string6.equals("")) {
                                    string6 = stringArray2[n2];
                                } else {
                                    string6 = "";
                                    break;
                                }
                            }
                            ++n2;
                        }
                        if (!string6.equals("")) {
                            string5 = string6;
                            string4 = bufferedReader.readLine();
                            continue;
                        }
                    }
                    if (arrayList.isEmpty() && stringArray2.length > 0 && stringArray == null) {
                        boolean bl = true;
                        n2 = 0;
                        while (n2 < stringArray2.length) {
                            if (!Double.isNaN(dArray[n2]) || stringArray2[n2].equals("")) {
                                bl = false;
                                break;
                            }
                            ++n2;
                        }
                        if (bl) {
                            stringArray = stringArray2;
                            string4 = bufferedReader.readLine();
                            continue;
                        }
                    }
                    if (stringArray2.length > 0) {
                        ++n4;
                        boolean bl = true;
                        n2 = 1;
                        int n6 = 0;
                        while (n6 < stringArray2.length) {
                            if (Double.isNaN(dArray[n6]) && !stringArray2[n6].equals("")) {
                                bl = false;
                            }
                            if (!stringArray2[n6].equals("")) {
                                n2 = 0;
                            }
                            ++n6;
                        }
                        if (arrayList.isEmpty() && n2 != 0) {
                            bl = false;
                        }
                        if (bl) {
                            arrayList.add(dArray);
                            n3 = Math.min(dArray.length, n3);
                        }
                    }
                    if (arrayList.isEmpty() && n4 > 10) break;
                    string4 = bufferedReader.readLine();
                }
                if (!arrayList.isEmpty() && n3 > 0) {
                    double[][] dArray = new double[n3][arrayList.size()];
                    int n7 = 0;
                    while (n7 < arrayList.size()) {
                        double[] dArray2 = (double[])arrayList.get(n7);
                        n2 = 0;
                        while (n2 < n3) {
                            dArray[n2][n7] = dArray2[n2];
                            ++n2;
                        }
                        ++n7;
                    }
                    DatasetManager datasetManager = new DatasetManager();
                    datasetManager.setName(string5 == null ? XML.getName(string2) : string5);
                    double[] dArray3 = DataTool.getRowArray(arrayList.size());
                    n2 = 0;
                    while (n2 < n3) {
                        Dataset dataset = datasetManager.getDataset(n2);
                        String string7 = stringArray != null && stringArray.length >= n2 ? stringArray[n2] : (n2 == 0 && string5 != null ? string5 : "?");
                        dataset.setXYColumnNames(DataTable.rowName, string7);
                        dataset.append(dArray3, dArray[n2]);
                        ++n2;
                    }
                    OSPLog.finest("imported data found using delimiter \"" + delimiters[n] + "\"");
                    return datasetManager;
                }
                bufferedReader.close();
                bufferedReader = new BufferedReader(new StringReader(string));
                string4 = bufferedReader.readLine();
                ++n;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        try {
            bufferedReader.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return null;
    }

    protected String getUniqueName(String string) {
        Object object;
        if (string == null || string.equals("")) {
            string = ToolsRes.getString("DataToolTab.DefaultName");
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        while (n < this.getTabCount()) {
            object = this.getTab(n);
            arrayList.add(((Component)object).getName());
            ++n;
        }
        if (!arrayList.contains(string)) {
            return string;
        }
        n = string.lastIndexOf("_");
        if (n > -1) {
            object = string.substring(n + 1);
            try {
                Integer.parseInt((String)object);
                string = string.substring(0, n);
            }
            catch (Exception exception) {}
        }
        string = String.valueOf(string) + "_";
        int n2 = 1;
        String string2 = String.valueOf(string) + n2;
        while (arrayList.contains(string2)) {
            string2 = String.valueOf(string) + ++n2;
        }
        return string2;
    }

    protected DataToolTab loadData(DataToolTab dataToolTab, XMLControl xMLControl, boolean bl) {
        List<XMLProperty> list;
        Iterator<XMLProperty> iterator;
        if (bl) {
            iterator = new XMLTreeChooser(ToolsRes.getString("Chooser.Title"), ToolsRes.getString("Chooser.Label"), this);
            list = ((XMLTreeChooser)((Object)iterator)).choose(xMLControl, Data.class);
        } else {
            iterator = new XMLTree(xMLControl);
            ((XMLTree)((Object)iterator)).setHighlightedClass(Data.class);
            ((XMLTree)((Object)iterator)).selectHighlightedProperties();
            list = ((XMLTree)((Object)iterator)).getSelectedProperties();
            if (list.isEmpty()) {
                JOptionPane.showMessageDialog(null, ToolsRes.getString("Dialog.NoDatasets.Message"));
            }
        }
        if (!list.isEmpty()) {
            for (XMLControl xMLControl2 : list) {
                Data data = null;
                if (xMLControl2 instanceof XMLControlElement) {
                    XMLControlElement xMLControlElement = (XMLControlElement)xMLControl2;
                    data = (Data)xMLControlElement.loadObject(null, true, true);
                } else {
                    data = (Data)xMLControl2.loadObject(null);
                }
                if (data == null) continue;
                dataToolTab = this.loadData(data, dataToolTab);
            }
        }
        return dataToolTab;
    }

    protected DataToolTab loadData(Data data, DataToolTab dataToolTab) {
        String string = "";
        try {
            Method method = data.getClass().getMethod("getName", new Class[0]);
            string = (String)method.invoke((Object)data, new Object[0]);
        }
        catch (Exception exception) {}
        if (dataToolTab == null) {
            dataToolTab = this.addTab(data, string);
        } else {
            dataToolTab.reloadData(data);
        }
        return dataToolTab;
    }

    protected void addTab(final DataToolTab dataToolTab) {
        if (this.getTabCount() == 1) {
            DataToolTab dataToolTab2 = this.getTab(0);
            if (dataToolTab2.owner == null) {
                dataToolTab2.tabChanged(false);
                this.removeTab(0);
            }
        }
        dataToolTab.setName(this.getUniqueName(dataToolTab.getName()));
        dataToolTab.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                if (dataToolTab.bottomPaneCheckbox != null && !dataToolTab.bottomPaneCheckbox.isSelected()) {
                    dataToolTab.splitPanes[1].setDividerLocation(1.0);
                }
            }
        });
        OSPLog.finer("adding tab " + dataToolTab.getName());
        this.tabbedPane.addTab("", dataToolTab);
        this.tabbedPane.setSelectedComponent(dataToolTab);
        this.validate();
        dataToolTab.init();
        dataToolTab.refreshPlot();
        dataToolTab.userEditable = this.userEditable;
        dataToolTab.refreshGUI();
        this.refreshTabTitles();
        this.refreshMenubar();
        this.setFontLevel(this.fontLevel);
    }

    protected boolean saveChangesAt(int n) {
        if (OSPRuntime.appletMode) {
            return true;
        }
        DataToolTab dataToolTab = this.getTab(n);
        if (!dataToolTab.tabChanged) {
            return true;
        }
        String string = dataToolTab.getName();
        if (ToolsRes.getString("DataToolTab.DefaultName").equals(string) && dataToolTab.owner == null) {
            return true;
        }
        int n2 = JOptionPane.showConfirmDialog(this, String.valueOf(ToolsRes.getString("DataTool.Dialog.SaveChanges.Message1")) + " \"" + string + "\" " + ToolsRes.getString("DataTool.Dialog.SaveChanges.Message2"), ToolsRes.getString("DataTool.Dialog.SaveChanges.Title"), 1);
        if (n2 == 2) {
            return false;
        }
        return n2 != 0 || this.save(dataToolTab, dataToolTab.fileName) != null;
    }

    protected DataToolTab getSelectedTab() {
        return (DataToolTab)this.tabbedPane.getSelectedComponent();
    }

    protected void setSelectedTab(DataToolTab dataToolTab) {
        this.tabbedPane.setSelectedComponent(dataToolTab);
    }

    public void setFontLevel(int n) {
        this.fontLevel = Math.max(n, 0);
        super.setFontLevel(this.fontLevel);
        double d = FontSizer.getFactor(this.fontLevel);
        buttonHeight = (int)(d * 28.0);
        if (this.tabbedPane != null) {
            int n2 = 0;
            while (n2 < this.getTabCount()) {
                this.getTab(n2).setFontLevel(this.fontLevel);
                ++n2;
            }
        }
        if (this.dataFunctionTool != null) {
            this.dataFunctionTool.setFontLevel(this.fontLevel);
        }
    }

    public String write(String string) {
        String string2 = this.getSelectedTab().getName();
        OSPRuntime.getChooser().setSelectedFile(new File(String.valueOf(string2) + ".txt"));
        int n = OSPRuntime.getChooser().showSaveDialog(this);
        if (n == 0) {
            OSPRuntime.chooserDir = OSPRuntime.getChooser().getCurrentDirectory().toString();
            String string3 = OSPRuntime.getChooser().getSelectedFile().getAbsolutePath();
            string3 = XML.getRelativePath(string3);
            return this.write(string, string3);
        }
        return null;
    }

    public String write(String string, String string2) {
        Object object;
        block7: {
            block8: {
                File file;
                int n = string2.lastIndexOf("/");
                if (n < 0) {
                    n = string2.lastIndexOf("\\");
                }
                if (n > 0 && !(file = new File((String)(object = string2.substring(0, n + 1)))).exists() && !file.mkdir()) {
                    return null;
                }
                object = new File(string2);
                if (!((File)object).exists()) break block7;
                if (((File)object).canWrite()) break block8;
                JOptionPane.showMessageDialog(null, "File is read-only.");
                return null;
            }
            int n = JOptionPane.showConfirmDialog(null, String.valueOf(ToolsRes.getString("Tool.Dialog.ReplaceFile.Message")) + " " + ((File)object).getName() + "?", ToolsRes.getString("Tool.Dialog.ReplaceFile.Title"), 1);
            if (n == 0) break block7;
            return null;
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream((File)object);
            Charset charset = Charset.forName("UTF-8");
            this.write(string, new OutputStreamWriter((OutputStream)fileOutputStream, charset));
            if (((File)object).exists()) {
                return ((File)object).getAbsolutePath();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return null;
    }

    public void write(String string, Writer writer) {
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(writer);
            bufferedWriter.write(string);
            ((Writer)bufferedWriter).flush();
            ((Writer)bufferedWriter).close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    protected String open() {
        int n = OSPRuntime.getChooser().showOpenDialog(null);
        if (n == 0) {
            OSPRuntime.chooserDir = OSPRuntime.getChooser().getCurrentDirectory().toString();
            String string = OSPRuntime.getChooser().getSelectedFile().getAbsolutePath();
            string = XML.getRelativePath(string);
            return this.open(string);
        }
        return null;
    }

    protected String save(String string) {
        return this.save(this.getSelectedTab(), string);
    }

    protected String save(DataToolTab dataToolTab, String string) {
        if (string == null || string.equals("")) {
            return this.saveAs();
        }
        XMLControlElement xMLControlElement = new XMLControlElement(dataToolTab);
        if (xMLControlElement.write(string) == null) {
            return null;
        }
        dataToolTab.fileName = string;
        dataToolTab.tabChanged(false);
        return string;
    }

    protected String saveAs() {
        int n = OSPRuntime.getChooser().showSaveDialog(this);
        if (n == 0) {
            int n2;
            OSPRuntime.chooserDir = OSPRuntime.getChooser().getCurrentDirectory().toString();
            File file = OSPRuntime.getChooser().getSelectedFile();
            if (file.exists() && (n2 = JOptionPane.showConfirmDialog(null, String.valueOf(ToolsRes.getString("Tool.Dialog.ReplaceFile.Message")) + " " + file.getName() + "?", ToolsRes.getString("Tool.Dialog.ReplaceFile.Title"), 1)) != 0) {
                return null;
            }
            String string = file.getAbsolutePath();
            if (string == null || string.trim().equals("")) {
                return null;
            }
            if (XML.getExtension(string) == null) {
                string = String.valueOf(string) + ".xml";
            }
            return this.save(XML.getRelativePath(string));
        }
        return null;
    }

    protected int getTabIndex(Data data) {
        int n = 0;
        while (n < this.tabbedPane.getTabCount()) {
            DataToolTab dataToolTab = (DataToolTab)this.tabbedPane.getComponentAt(n);
            if (dataToolTab.isOwnedBy(data)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    protected DataTool(String string, String string2) {
        super(string);
        this.setName(string2);
        this.createGUI();
        Toolbox.addTool(string2, this);
        ToolsRes.addPropertyChangeListener("locale", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                DataTool.this.refreshGUI();
            }
        });
    }

    protected boolean removeAllButTab(int n) {
        int n2 = this.tabbedPane.getTabCount() - 1;
        while (n2 >= 0) {
            if (n2 != n) {
                if (!this.saveChangesAt(n2)) {
                    return false;
                }
                String string = this.tabbedPane.getTitleAt(n2);
                OSPLog.finer("removing tab " + string);
                this.tabbedPane.removeTabAt(n2);
            }
            --n2;
        }
        this.refreshTabTitles();
        this.refreshFunctionTool();
        return true;
    }

    protected boolean removeAllTabs() {
        int n = this.tabbedPane.getTabCount() - 1;
        while (n >= 0) {
            if (!this.saveChangesAt(n)) {
                return false;
            }
            String string = this.tabbedPane.getTitleAt(n);
            OSPLog.finer("removing tab " + string);
            this.tabbedPane.removeTabAt(n);
            --n;
        }
        this.refreshMenubar();
        this.refreshFunctionTool();
        return true;
    }

    protected void refreshTabTitles() {
        String[] stringArray = new String[this.tabbedPane.getTabCount()];
        int n = 0;
        while (n < stringArray.length) {
            DataToolTab dataToolTab = (DataToolTab)this.tabbedPane.getComponentAt(n);
            String string = dataToolTab.getName();
            DataToolTable.WorkingDataset workingDataset = dataToolTab.getWorkingData();
            if (workingDataset != null) {
                String string2 = TeXParser.removeSubscripting(workingDataset.getColumnName(0));
                String string3 = TeXParser.removeSubscripting(workingDataset.getColumnName(1));
                String string4 = " (" + string2 + ", " + string3 + ")";
                stringArray[n] = String.valueOf(string) + string4;
            } else {
                stringArray[n] = string;
            }
            ++n;
        }
        n = 0;
        while (n < stringArray.length) {
            this.tabbedPane.setTitleAt(n, stringArray[n]);
            ++n;
        }
    }

    protected void refreshMenubar() {
        if (this.getTabCount() == 0) {
            this.emptyMenubar.add(this.displayMenu);
            this.emptyMenubar.add(this.helpMenu);
            this.setJMenuBar(this.emptyMenubar);
            this.helpLabel.setText(null);
        } else {
            this.menubar.add(this.displayMenu);
            this.menubar.add(this.helpMenu);
            this.setJMenuBar(this.menubar);
        }
    }

    protected FunctionTool getDataFunctionTool() {
        if (this.dataFunctionTool == null) {
            this.dataFunctionTool = new FunctionTool((Component)this);
            this.dataFunctionTool.setFontLevel(this.fontLevel);
            this.dataFunctionTool.setHelpPath("data_builder_help.html");
            this.dataFunctionTool.addPropertyChangeListener("function", this);
            this.dataFunctionTool.setTitle(ToolsRes.getString("DataTool.DataBuilder.Title"));
        }
        this.refreshFunctionTool();
        return this.dataFunctionTool;
    }

    protected void refreshFunctionTool() {
        Object object;
        Iterator iterator;
        if (this.dataFunctionTool == null) {
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        while (n < this.tabbedPane.getTabCount()) {
            iterator = this.getTab(n);
            arrayList.add(((Component)((Object)iterator)).getName());
            if (this.dataFunctionTool.getPanel(((Component)((Object)iterator)).getName()) == null) {
                object = new DataFunctionPanel(((DataToolTab)((Object)iterator)).dataManager);
                this.dataFunctionTool.addPanel(((Component)((Object)iterator)).getName(), (FunctionPanel)object);
            }
            ++n;
        }
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        iterator = this.dataFunctionTool.panels.keySet().iterator();
        while (iterator.hasNext()) {
            object = ((String)iterator.next()).toString();
            if (arrayList.contains(object)) continue;
            arrayList2.add(object);
        }
        iterator = arrayList2.iterator();
        while (iterator.hasNext()) {
            object = ((String)iterator.next()).toString();
            this.dataFunctionTool.removePanel((String)object);
        }
    }

    protected StringBuffer getSelectedTableData(String string, DataTable dataTable) {
        int n;
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        if (string != null) {
            stringBuffer.append(String.valueOf(string) + "\n");
        }
        if (dataTable.getColumnCount() == 1 || dataTable.getRowCount() == 0) {
            return stringBuffer;
        }
        int[] nArray = dataTable.getSelectedRows();
        if (nArray.length == 0) {
            dataTable.selectAll();
            nArray = dataTable.getSelectedRows();
        }
        int[] nArray2 = dataTable.getSelectedColumns();
        int n3 = 0;
        while (n3 < nArray2.length) {
            n2 = nArray2[n3];
            n = dataTable.convertColumnIndexToModel(n2);
            if (!dataTable.isRowNumberVisible() || n != 0) {
                stringBuffer.append(dataTable.getColumnName(n2));
                stringBuffer.append("\t");
            }
            ++n3;
        }
        stringBuffer.setLength(stringBuffer.length() - 1);
        stringBuffer.append("\n");
        DateFormat dateFormat = DateFormat.getInstance();
        n2 = 0;
        while (n2 < nArray.length) {
            n = 0;
            while (n < nArray2.length) {
                int n4 = nArray2[n];
                int n5 = dataTable.convertColumnIndexToModel(n4);
                if (!dataTable.isRowNumberVisible() || n5 != 0) {
                    Object object = dataTable.getValueAt(nArray[n2], n4);
                    if (object != null) {
                        if (object instanceof Date) {
                            object = dateFormat.format(object);
                        }
                        stringBuffer.append(object);
                    }
                    stringBuffer.append("\t");
                }
                ++n;
            }
            stringBuffer.setLength(stringBuffer.length() - 1);
            stringBuffer.append("\n");
            ++n2;
        }
        return stringBuffer;
    }

    protected void copy(String string) {
        StringSelection stringSelection = new StringSelection(string);
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(stringSelection, stringSelection);
    }

    protected String paste() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable transferable = clipboard.getContents(null);
        if (transferable != null && transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            try {
                String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                return string;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return null;
    }

    public void setDefaultCloseOperation(int n) {
        if (n == 3) {
            this.exitOnClose = true;
            n = 0;
        }
        if (n != 0) {
            this.saveChangesOnClose = false;
        }
        super.setDefaultCloseOperation(n);
    }

    protected void createGUI() {
        this.contentPane.setPreferredSize(dim);
        this.setContentPane(this.contentPane);
        JPanel jPanel = new JPanel(new BorderLayout());
        this.contentPane.add((Component)jPanel, "Center");
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                DataTool.this.exitItem.doClick();
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                DataToolTab dataToolTab = DataTool.this.getSelectedTab();
                if (dataToolTab == null) {
                    return;
                }
                if (!dataToolTab.propsCheckbox.isSelected() && !dataToolTab.statsCheckbox.isSelected()) {
                    dataToolTab.splitPanes[2].setDividerLocation(0);
                }
            }
        });
        this.tabbedPane = new JTabbedPane(1);
        jPanel.add((Component)this.tabbedPane, "Center");
        this.tabbedPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                DataToolTab dataToolTab = DataTool.this.getSelectedTab();
                int n = 0;
                while (n < DataTool.this.getTabCount()) {
                    DataToolTab dataToolTab2 = DataTool.this.getTab(n);
                    if (dataToolTab2 != dataToolTab) {
                        FunctionTool functionTool;
                        FunctionTool functionTool2 = functionTool = dataToolTab2.curveFitter == null ? null : dataToolTab2.curveFitter.fitBuilder;
                        if (functionTool != null && functionTool.isVisible()) {
                            functionTool.wasVisible = true;
                            functionTool.setVisible(false);
                        }
                    }
                    ++n;
                }
                if (dataToolTab != null) {
                    FunctionTool functionTool;
                    FunctionTool functionTool3 = functionTool = dataToolTab.curveFitter == null ? null : dataToolTab.curveFitter.fitBuilder;
                    if (functionTool != null && functionTool.wasVisible) {
                        functionTool.setVisible(true);
                    }
                    dataToolTab.dataTable.refreshTable();
                    dataToolTab.statsTable.refreshStatistics();
                    dataToolTab.propsTable.refreshTable();
                    dataToolTab.refreshPlot();
                    DataTool.this.refreshGUI();
                    dataToolTab.dataTable.requestFocusInWindow();
                }
            }
        });
        this.tabbedPane.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                if (OSPRuntime.isPopupTrigger(mouseEvent)) {
                    final int n = DataTool.this.tabbedPane.getSelectedIndex();
                    JPopupMenu jPopupMenu = new JPopupMenu();
                    JMenuItem jMenuItem = new JMenuItem(ToolsRes.getString("DataTool.MenuItem.Name"));
                    jPopupMenu.add(jMenuItem);
                    jMenuItem.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            DataToolTab dataToolTab = DataTool.this.getTab(n);
                            String string = dataToolTab.getName();
                            Object object = JOptionPane.showInputDialog(DataTool.this, ToolsRes.getString("DataTool.Dialog.Name.Message"), ToolsRes.getString("DataTool.Dialog.Name.Title"), 3, null, null, string);
                            if (object == null) {
                                return;
                            }
                            dataToolTab.setName("");
                            dataToolTab.setName(DataTool.this.getUniqueName(object.toString()));
                            dataToolTab.tabChanged(true);
                            DataTool.this.refreshTabTitles();
                            DataTool.this.refreshFunctionTool();
                        }
                    });
                    jPopupMenu.addSeparator();
                    jMenuItem = new JMenuItem(ToolsRes.getString("MenuItem.Close"));
                    jPopupMenu.add(jMenuItem);
                    jMenuItem.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            DataTool.this.removeTab(n);
                        }
                    });
                    jMenuItem = new JMenuItem(ToolsRes.getString("MenuItem.CloseOthers"));
                    jPopupMenu.add(jMenuItem);
                    jMenuItem.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            DataTool.this.removeAllButTab(n);
                        }
                    });
                    jMenuItem = new JMenuItem(ToolsRes.getString("MenuItem.CloseAll"));
                    jPopupMenu.add(jMenuItem);
                    jMenuItem.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            DataTool.this.removeAllTabs();
                        }
                    });
                    FontSizer.setFonts(jPopupMenu, DataTool.this.fontLevel);
                    jPopupMenu.show(DataTool.this.tabbedPane, mouseEvent.getX(), mouseEvent.getY() + 8);
                }
            }
        });
        int n = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        this.menubar = new JMenuBar();
        this.fileMenu = new JMenu();
        this.menubar.add(this.fileMenu);
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mouseEntered(MouseEvent mouseEvent) {
                this.mousePressed(mouseEvent);
            }

            public void mousePressed(MouseEvent mouseEvent) {
                boolean bl = DataTool.this.getSelectedTab().owner == null;
                DataTool.this.exportItem.setEnabled(!bl);
                DataTool.this.saveItem.setEnabled(!bl);
                DataTool.this.saveAsItem.setEnabled(!bl);
                int[] nArray = DataTool.this.getSelectedTab().dataTable.getSelectedRows();
                int n = DataTool.this.getSelectedTab().dataTable.getRowCount() - 1;
                if (nArray.length == 0 || nArray.length == 1 && nArray[0] == n && DataTool.this.getSelectedTab().dataTable.isEmptyRow(n)) {
                    DataTool.this.exportItem.setText(ToolsRes.getString("DataTool.MenuItem.Export"));
                } else {
                    DataTool.this.exportItem.setText(ToolsRes.getString("DataTool.MenuItem.ExportSelection"));
                }
            }
        };
        this.fileMenu.addMouseListener(mouseAdapter);
        this.newTabItem = new JMenuItem();
        this.newTabItem.setAccelerator(KeyStroke.getKeyStroke(78, n));
        this.newTabItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DataToolTab dataToolTab = DataTool.this.addTab((Data)null);
                dataToolTab.userEditable = true;
                dataToolTab.refreshGUI();
            }
        });
        this.fileMenu.add(this.newTabItem);
        if (!OSPRuntime.appletMode) {
            this.openItem = new JMenuItem();
            this.openItem.setAccelerator(KeyStroke.getKeyStroke(79, n));
            this.openItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    DataTool.this.open();
                }
            });
            this.fileMenu.add(this.openItem);
        }
        this.fileMenu.addSeparator();
        this.closeItem = new JMenuItem();
        this.closeItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = DataTool.this.tabbedPane.getSelectedIndex();
                DataTool.this.removeTab(n);
            }
        });
        this.fileMenu.add(this.closeItem);
        this.closeAllItem = new JMenuItem();
        this.closeAllItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DataTool.this.removeAllTabs();
            }
        });
        this.fileMenu.add(this.closeAllItem);
        this.fileMenu.addSeparator();
        if (!OSPRuntime.appletMode) {
            this.exportItem = new JMenuItem();
            this.exportItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    int[] nArray = DataTool.this.getSelectedTab().dataTable.getSelectedRows();
                    int n = DataTool.this.getSelectedTab().dataTable.getRowCount() - 1;
                    if (nArray.length == 1 && nArray[0] == n && DataTool.this.getSelectedTab().dataTable.isEmptyRow(n)) {
                        DataTool.this.getSelectedTab().dataTable.clearSelection();
                    }
                    String string = DataTool.this.getSelectedTab().getName();
                    String string2 = DataTool.this.getSelectedTableData(string, DataTool.this.getSelectedTab().dataTable).toString();
                    DataTool.this.write(string2);
                }
            });
            this.fileMenu.add(this.exportItem);
            this.fileMenu.addSeparator();
            this.saveItem = new JMenuItem();
            this.saveItem.setAccelerator(KeyStroke.getKeyStroke(83, n));
            this.saveItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    DataToolTab dataToolTab = DataTool.this.getSelectedTab();
                    DataTool.this.save(dataToolTab.fileName);
                }
            });
            this.fileMenu.add(this.saveItem);
            this.saveAsItem = new JMenuItem();
            this.saveAsItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    DataTool.this.saveAs();
                }
            });
            this.fileMenu.add(this.saveAsItem);
            this.fileMenu.addSeparator();
        }
        this.printItem = new JMenuItem();
        this.printItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SnapshotTool.getTool().printImage(DataTool.this);
            }
        });
        this.printItem.setAccelerator(KeyStroke.getKeyStroke(80, n));
        this.fileMenu.add(this.printItem);
        this.fileMenu.addSeparator();
        this.exitItem = new JMenuItem();
        this.exitItem.setAccelerator(KeyStroke.getKeyStroke(81, n));
        this.exitItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!DataTool.this.saveChangesOnClose || DataTool.this.removeAllTabs()) {
                    if (DataTool.this.exitOnClose) {
                        System.exit(0);
                    } else {
                        DataTool.this.setVisible(false);
                    }
                }
            }
        });
        this.fileMenu.add(this.exitItem);
        this.editMenu = new JMenu();
        MouseAdapter mouseAdapter2 = new MouseAdapter(){

            public void mouseEntered(MouseEvent mouseEvent) {
                this.mousePressed(mouseEvent);
            }

            public void mousePressed(MouseEvent mouseEvent) {
                Serializable serializable;
                String string;
                boolean bl;
                if (!DataTool.this.editMenu.isPopupMenuVisible() && !DataTool.this.emptyEditMenu.isPopupMenuVisible()) {
                    return;
                }
                DataToolTab dataToolTab = DataTool.this.getSelectedTab();
                if (dataToolTab != null) {
                    DataTool.this.undoItem.setEnabled(dataToolTab.undoManager.canUndo());
                    DataTool.this.redoItem.setEnabled(dataToolTab.undoManager.canRedo());
                }
                boolean bl2 = bl = (string = DataTool.this.paste()) != null;
                if (bl) {
                    if (!string.startsWith("<?xml")) {
                        DataTool.this.addableData = DataTool.this.importCharDelimitedData(string, null);
                        bl = DataTool.this.addableData != null;
                    } else {
                        DataTool.this.control = new XMLControlElement();
                        DataTool.this.control.readXML(string);
                        serializable = DataTool.this.control.getObjectClass();
                        if (Data.class.isAssignableFrom((Class<?>)serializable)) {
                            DataTool.this.addableData = (DatasetManager)DataTool.this.control.loadObject(null);
                        }
                        bl = Data.class.isAssignableFrom((Class<?>)serializable) || DataToolTab.class.isAssignableFrom((Class<?>)serializable) || DataTool.this.control.getBoolean("data_tool_transfer");
                    }
                }
                DataTool.this.emptyPasteItem.setEnabled(bl);
                DataTool.this.pasteMenu.setEnabled(bl);
                DataTool.this.copyMenu.removeAll();
                if (dataToolTab != null) {
                    serializable = dataToolTab.dataManager.getDatasets();
                    DataTool.this.copyDataItem.setEnabled(!((ArrayList)serializable).isEmpty());
                    if (!((ArrayList)serializable).isEmpty()) {
                        boolean bl3;
                        DataTool.this.copyTabItem.setText(ToolsRes.getString("DataTool.MenuItem.CopyTab"));
                        DataTool.this.copyMenu.add(DataTool.this.copyTabItem);
                        DataTool.this.copyMenu.addSeparator();
                        String string2 = ToolsRes.getString("DataTool.MenuItem.CopyData");
                        int[] nArray = DataTool.this.getSelectedTab().dataTable.getSelectedRows();
                        int n = DataTool.this.getSelectedTab().dataTable.getRowCount() - 1;
                        boolean bl4 = bl3 = nArray.length == 1 && nArray[0] == n && DataTool.this.getSelectedTab().dataTable.isEmptyRow(n);
                        if (nArray.length > 0 && !bl3) {
                            string2 = ToolsRes.getString("DataTool.MenuItem.CopySelectedData");
                        }
                        DataTool.this.copyDataItem.setText(string2);
                        DataTool.this.copyMenu.add(DataTool.this.copyDataItem);
                        DataTool.this.copyMenu.addSeparator();
                    }
                }
                DataTool.this.copyMenu.add(DataTool.this.copyImageItem);
                FontSizer.setFonts(DataTool.this.copyMenu, DataTool.this.fontLevel);
            }
        };
        this.editMenu.addMouseListener(mouseAdapter2);
        this.menubar.add(this.editMenu);
        this.undoItem = new JMenuItem();
        this.undoItem.setEnabled(false);
        this.undoItem.setAccelerator(KeyStroke.getKeyStroke(90, n));
        this.undoItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DataTool.this.getSelectedTab().undoManager.undo();
            }
        });
        this.editMenu.add(this.undoItem);
        this.redoItem = new JMenuItem();
        this.redoItem.setEnabled(false);
        this.redoItem.setAccelerator(KeyStroke.getKeyStroke(89, n));
        this.redoItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DataTool.this.getSelectedTab().undoManager.redo();
            }
        });
        this.editMenu.add(this.redoItem);
        this.editMenu.addSeparator();
        this.copyMenu = new JMenu();
        this.editMenu.add(this.copyMenu);
        this.copyTabItem = new JMenuItem();
        this.copyTabItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = DataTool.this.tabbedPane.getSelectedIndex();
                String string = DataTool.this.tabbedPane.getTitleAt(n);
                OSPLog.finest("copying tab " + string);
                XMLControlElement xMLControlElement = new XMLControlElement(DataTool.this.getSelectedTab());
                DataTool.this.copy(xMLControlElement.toXML());
            }
        });
        this.copyDataItem = new JMenuItem();
        this.copyDataItem.setAccelerator(KeyStroke.getKeyStroke(67, n));
        this.copyDataItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int[] nArray = DataTool.this.getSelectedTab().dataTable.getSelectedRows();
                int n = DataTool.this.getSelectedTab().dataTable.getRowCount() - 1;
                if (nArray.length == 1 && nArray[0] == n && DataTool.this.getSelectedTab().dataTable.isEmptyRow(n)) {
                    DataTool.this.getSelectedTab().dataTable.clearSelection();
                }
                String string = DataTool.this.getSelectedTab().getName();
                OSPLog.finest("copying cells from " + string);
                String string2 = DataTool.this.getSelectedTableData(string, DataTool.this.getSelectedTab().dataTable).toString();
                DataTool.this.copy(string2);
            }
        });
        this.copyImageItem = new JMenuItem();
        this.copyImageItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = DataTool.this.getSelectedTab().getName();
                OSPLog.finest("copying image of " + string);
                SnapshotTool.getTool().copyImage(DataTool.this);
            }
        });
        MouseAdapter mouseAdapter3 = new MouseAdapter(){

            public void mouseEntered(MouseEvent mouseEvent) {
                if (!DataTool.this.pasteMenu.isEnabled() || DataTool.this.pasteMenu.isPopupMenuVisible()) {
                    return;
                }
                String string = "";
                DataToolTab dataToolTab = DataTool.this.getSelectedTab();
                boolean bl = false;
                if (DataTool.this.addableData != null) {
                    if (!DataTool.this.addableData.getName().equals(dataToolTab.getName())) {
                        bl = true;
                    } else if (DataTool.this.addableData.getDatasets().size() == 1) {
                        Dataset dataset = DataTool.this.addableData.getDataset(0);
                        int n = dataToolTab.dataManager.getDatasetIndex(dataset.getYColumnName());
                        boolean bl2 = bl = n == -1;
                    }
                }
                if (bl) {
                    for (Dataset dataset : DataTool.this.addableData.getDatasets()) {
                        if (!dataToolTab.isDuplicateColumn(dataset.getXColumnName(), dataset.getXPoints()) || dataToolTab.isDuplicateColumn(dataset.getYColumnName(), dataset.getYPoints())) continue;
                        if (!string.equals("")) {
                            string = String.valueOf(string) + ",";
                        }
                        string = String.valueOf(string) + " \"" + dataset.getYColumnName() + "\"";
                    }
                }
                if (string.equals("")) {
                    DataTool.this.addableData = null;
                    DataTool.this.pasteMenu.remove(DataTool.this.pasteColumnsItem);
                } else {
                    DataTool.this.pasteColumnsItem.setText(ToolsRes.getString("DataTool.MenuItem.PasteNewColumns"));
                    DataTool.this.pasteMenu.add(DataTool.this.pasteColumnsItem);
                }
                FontSizer.setFonts(DataTool.this.pasteMenu, DataTool.this.fontLevel);
            }
        };
        this.pasteMenu = new JMenu();
        this.pasteMenu.addMouseListener(mouseAdapter3);
        this.editMenu.add(this.pasteMenu);
        this.pasteNewTabItem = new JMenuItem();
        this.pasteNewTabItem.setAction(new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = false;
                String string = DataTool.this.paste();
                if (string != null) {
                    Serializable serializable;
                    if (!string.startsWith("<?xml")) {
                        DataToolTab dataToolTab;
                        serializable = DataTool.this.importCharDelimitedData(string, null);
                        OSPLog.finest("pasting clipboard data into new tab");
                        if (serializable != null && (dataToolTab = DataTool.this.addTab((Data)((Object)serializable))) != null) {
                            dataToolTab.userEditable = true;
                            dataToolTab.refreshGUI();
                            DataTool.this.refreshFunctionTool();
                            return;
                        }
                        bl = true;
                    }
                    if (!bl) {
                        DataTool.this.control = new XMLControlElement();
                        DataTool.this.control.readXML(string);
                        if (DataTool.this.control.failedToRead()) {
                            bl = true;
                        }
                    }
                    if (!bl) {
                        OSPLog.finest("pasting clipboard XML into new tab");
                        if (Dataset.class.isAssignableFrom(DataTool.this.control.getObjectClass()) || DataTool.this.control.getBoolean("data_tool_transfer")) {
                            serializable = DataTool.this.loadData(null, DataTool.this.control, false);
                            if (serializable != null) {
                                ((DataToolTab)serializable).userEditable = DataTool.this.control.getBoolean("data_tool_transfer");
                                ((DataToolTab)serializable).refreshGUI();
                                int n = DataTool.this.getTabCount() - 1;
                                DataTool.this.tabbedPane.setSelectedIndex(n);
                            } else {
                                bl = true;
                            }
                        } else if (DataTool.this.addTab(DataTool.this.control) == null) {
                            bl = true;
                            OSPLog.finest("no clipboard data found");
                        }
                    }
                    if (!bl) {
                        DataTool.this.refreshFunctionTool();
                    }
                }
                if (bl) {
                    JOptionPane.showMessageDialog(DataTool.this, ToolsRes.getString("Tool.Dialog.NoData.Message"), ToolsRes.getString("Tool.Dialog.NoData.Title"), 2);
                }
            }
        });
        this.pasteMenu.add(this.pasteNewTabItem);
        this.pasteColumnsItem = new JMenuItem();
        this.pasteColumnsItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (DataTool.this.addableData != null) {
                    DataToolTab dataToolTab = DataTool.this.getSelectedTab();
                    OSPLog.finest("pasting columns into " + dataToolTab.getName());
                    int n = dataToolTab.dataTable.convertColumnIndexToView(0);
                    int n2 = dataToolTab.dataTable.convertColumnIndexToModel(n == 0 ? 1 : 0);
                    Dataset serializable = null;
                    if (n2 > 0) {
                        Dataset dataset = dataToolTab.dataManager.getDataset(n2 - 1);
                        String object = dataset.getYColumnName();
                        for (Dataset dataset2 : DataTool.this.addableData.getDatasets()) {
                            int n3;
                            double[] dArray;
                            if (!dataset2.getYColumnName().equals(object)) continue;
                            double[] dArray2 = dataset2.getValidYPoints();
                            double[] dArray3 = dataset.getYPoints();
                            if (DataTool.containsDuplicateValues(dArray2) || DataTool.containsDuplicateValues(dArray3)) break;
                            boolean bl = true;
                            int n4 = 0;
                            while (n4 < dArray2.length) {
                                bl = bl && DataTool.getIndex(dArray2[n4], dArray3, -1) > -1;
                                ++n4;
                            }
                            if (bl) {
                                serializable = dataset2;
                                double[] dArray4 = dataset.getXPoints();
                                for (Dataset dataset3 : DataTool.this.addableData.getDatasets()) {
                                    if (dataset3 == serializable) continue;
                                    Object object2 = dataset3.getYPoints();
                                    dArray = new double[dArray4.length];
                                    int n5 = 0;
                                    while (n5 < dArray.length) {
                                        dArray[n5] = Double.NaN;
                                        ++n5;
                                    }
                                    n5 = 0;
                                    while (n5 < dArray2.length) {
                                        n3 = DataTool.getIndex(dArray2[n5], dArray3, -1);
                                        if (n3 > -1) {
                                            dArray[n3] = (double)object2[n5];
                                        }
                                        ++n5;
                                    }
                                    dataset3.clear();
                                    dataset3.append(dArray4, dArray);
                                }
                                continue;
                            }
                            bl = true;
                            n4 = 0;
                            while (n4 < dArray3.length) {
                                bl = bl && DataTool.getIndex(dArray3[n4], dArray2, -1) > -1;
                                ++n4;
                            }
                            if (!bl) continue;
                            serializable = dataset2;
                            double[] dArray5 = serializable.getXPoints();
                            Object object3 = serializable.getYPoints();
                            for (Object object2 : dataToolTab.dataManager.getDatasets()) {
                                dArray = ((Dataset)object2).getYPoints();
                                double[] dArray6 = new double[dArray5.length];
                                n3 = 0;
                                while (n3 < dArray6.length) {
                                    dArray6[n3] = object2 == dataset ? (double)object3[n3] : Double.NaN;
                                    ++n3;
                                }
                                n3 = 0;
                                while (n3 < dArray3.length) {
                                    int n6 = DataTool.getIndex(dArray3[n3], dArray2, -1);
                                    if (n6 > -1) {
                                        dArray6[n6] = dArray[n3];
                                    }
                                    ++n3;
                                }
                                ((Dataset)object2).clear();
                                ((Dataset)object2).append(dArray5, dArray6);
                            }
                        }
                    }
                    for (Dataset dataset : DataTool.this.addableData.getDatasets()) {
                        if (dataset == serializable || !dataToolTab.addData(dataset)) continue;
                        int n7 = dataToolTab.dataTable.getColumnCount() - 1;
                        DataToolTable dataToolTable = dataToolTab.dataTable;
                        dataToolTable.getClass();
                        DataToolTable.TableEdit tableEdit = new DataToolTable.TableEdit(dataToolTable, 1, dataset.getYColumnName(), new Integer(n7), dataset);
                        dataToolTab.undoSupport.postEdit(tableEdit);
                        dataToolTab.dataTable.refreshUndoItems();
                        DataTool.this.refreshFunctionTool();
                        OSPLog.finest("pasted column " + dataset.getYColumnName() + " into tab " + dataToolTab.getName());
                    }
                }
            }
        });
        this.pasteMenu.add(this.pasteColumnsItem);
        this.displayMenu = new JMenu();
        this.menubar.add(this.displayMenu);
        this.languageMenu = new JMenu();
        String string = "/org/opensourcephysics/resources/tools/html/";
        String string2 = XML.getResolvedPath(this.helpPath, string);
        ResourceLoader.getResource(string2);
        final Locale[] localeArray = OSPRuntime.getInstalledLocales();
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = actionEvent.getActionCommand();
                OSPLog.finest("setting language to " + string);
                int n = 0;
                while (n < localeArray.length) {
                    if (string.equals(localeArray[n].getDisplayName())) {
                        ToolsRes.setLocale(localeArray[n]);
                        return;
                    }
                    ++n;
                }
            }
        };
        ButtonGroup buttonGroup = new ButtonGroup();
        this.languageItems = new JMenuItem[localeArray.length];
        int n2 = 0;
        while (n2 < localeArray.length) {
            this.languageItems[n2] = new JRadioButtonMenuItem(localeArray[n2].getDisplayName(localeArray[n2]));
            this.languageItems[n2].setActionCommand(localeArray[n2].getDisplayName());
            this.languageItems[n2].addActionListener(abstractAction);
            this.languageMenu.add(this.languageItems[n2]);
            buttonGroup.add(this.languageItems[n2]);
            ++n2;
        }
        this.displayMenu.add(this.languageMenu);
        this.fontSizeMenu = new JMenu();
        this.displayMenu.add(this.fontSizeMenu);
        ButtonGroup buttonGroup2 = new ButtonGroup();
        AbstractAction abstractAction2 = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = Integer.parseInt(actionEvent.getActionCommand());
                DataTool.this.setFontLevel(n);
            }
        };
        int n3 = 0;
        while (n3 < 4) {
            JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem("+" + n3);
            if (n3 == 0) {
                this.defaultFontSizeItem = jRadioButtonMenuItem;
            }
            jRadioButtonMenuItem.addActionListener(abstractAction2);
            jRadioButtonMenuItem.setActionCommand("" + n3);
            this.fontSizeMenu.add(jRadioButtonMenuItem);
            buttonGroup2.add(jRadioButtonMenuItem);
            if (n3 == FontSizer.getLevel()) {
                jRadioButtonMenuItem.setSelected(true);
            }
            ++n3;
        }
        this.helpMenu = new JMenu();
        this.menubar.add(this.helpMenu);
        this.helpItem = new JMenuItem();
        this.helpItem.setAccelerator(KeyStroke.getKeyStroke(72, n));
        this.helpItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (DataTool.this.helpFrame == null) {
                    Object object;
                    String string = XML.getResolvedPath(DataTool.this.helpPath, DataTool.this.helpBase);
                    if (ResourceLoader.getResource(string) != null) {
                        DataTool.this.helpFrame = new TextFrame(string);
                    } else {
                        object = "/org/opensourcephysics/resources/tools/html/";
                        string = XML.getResolvedPath(DataTool.this.helpPath, (String)object);
                        DataTool.this.helpFrame = new TextFrame(string);
                    }
                    DataTool.this.helpFrame.setSize(760, 560);
                    object = Toolkit.getDefaultToolkit().getScreenSize();
                    int n = (((Dimension)object).width - DataTool.this.helpFrame.getBounds().width) / 2;
                    int n2 = (((Dimension)object).height - DataTool.this.helpFrame.getBounds().height) / 2;
                    DataTool.this.helpFrame.setLocation(n, n2);
                }
                DataTool.this.helpFrame.setVisible(true);
            }
        });
        this.helpMenu.add(this.helpItem);
        this.helpMenu.addSeparator();
        this.logItem = new JMenuItem();
        this.logItem.setAccelerator(KeyStroke.getKeyStroke(76, n));
        this.logItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OSPLog oSPLog = OSPLog.getOSPLog();
                if (oSPLog.getLocation().x == 0 && oSPLog.getLocation().y == 0) {
                    Point point = DataTool.this.getLocation();
                    oSPLog.setLocation(point.x + 28, point.y + 28);
                }
                ((Window)oSPLog).setVisible(true);
            }
        });
        this.helpMenu.add(this.logItem);
        this.helpMenu.addSeparator();
        this.aboutItem = new JMenuItem();
        this.aboutItem.setAccelerator(KeyStroke.getKeyStroke(65, n));
        this.aboutItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DataTool.this.showAboutDialog();
            }
        });
        this.helpMenu.add(this.aboutItem);
        this.setJMenuBar(this.menubar);
        this.emptyMenubar = new JMenuBar();
        this.emptyFileMenu = new JMenu();
        this.emptyMenubar.add(this.emptyFileMenu);
        this.emptyNewTabItem = new JMenuItem();
        this.emptyNewTabItem.setAccelerator(KeyStroke.getKeyStroke(78, n));
        this.emptyNewTabItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DataToolTab dataToolTab = DataTool.this.addTab((Data)null);
                dataToolTab.userEditable = true;
                dataToolTab.refreshGUI();
            }
        });
        this.emptyFileMenu.add(this.emptyNewTabItem);
        this.emptyOpenItem = new JMenuItem();
        this.emptyOpenItem.setAccelerator(KeyStroke.getKeyStroke(79, n));
        this.emptyOpenItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DataTool.this.open();
            }
        });
        this.emptyFileMenu.add(this.emptyOpenItem);
        this.emptyFileMenu.addSeparator();
        this.emptyExitItem = new JMenuItem();
        this.emptyExitItem.setAccelerator(KeyStroke.getKeyStroke(81, n));
        this.emptyExitItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                System.exit(0);
            }
        });
        this.emptyFileMenu.add(this.emptyExitItem);
        this.emptyEditMenu = new JMenu();
        this.emptyEditMenu.addMouseListener(mouseAdapter2);
        this.emptyMenubar.add(this.emptyEditMenu);
        this.emptyPasteItem = new JMenuItem();
        this.emptyPasteItem.addActionListener(this.pasteNewTabItem.getAction());
        this.emptyEditMenu.add(this.emptyPasteItem);
        this.helpLabel = new JLabel("", 10);
        this.helpLabel.setFont(new JTextField().getFont());
        this.helpLabel.setBorder(BorderFactory.createEmptyBorder(1, 2, 1, 2));
        jPanel.add((Component)this.helpLabel, "South");
        this.refreshGUI();
        this.refreshMenubar();
        this.pack();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n4 = (dimension.width - this.getBounds().width) / 2;
        int n5 = (dimension.height - this.getBounds().height) / 2;
        this.setLocation(n4, n5);
    }

    protected void refreshGUI() {
        this.setTitle(ToolsRes.getString("DataTool.Frame.Title"));
        this.emptyFileMenu.setText(ToolsRes.getString("Menu.File"));
        this.emptyNewTabItem.setText(ToolsRes.getString("DataTool.MenuItem.NewTab"));
        this.emptyOpenItem.setText(ToolsRes.getString("MenuItem.Open"));
        this.emptyExitItem.setText(ToolsRes.getString("MenuItem.Exit"));
        this.emptyEditMenu.setText(ToolsRes.getString("Menu.Edit"));
        this.emptyPasteItem.setText(ToolsRes.getString("MenuItem.Paste"));
        this.fileMenu.setText(ToolsRes.getString("Menu.File"));
        this.newTabItem.setText(ToolsRes.getString("DataTool.MenuItem.NewTab"));
        this.openItem.setText(ToolsRes.getString("MenuItem.Open"));
        this.closeItem.setText(ToolsRes.getString("MenuItem.Close"));
        this.closeAllItem.setText(ToolsRes.getString("MenuItem.CloseAll"));
        this.saveItem.setText(ToolsRes.getString("DataTool.MenuItem.Save"));
        this.saveAsItem.setText(ToolsRes.getString("DataTool.MenuItem.SaveAs"));
        this.printItem.setText(ToolsRes.getString("DataTool.MenuItem.Print"));
        this.exitItem.setText(ToolsRes.getString("MenuItem.Exit"));
        this.editMenu.setText(ToolsRes.getString("Menu.Edit"));
        this.undoItem.setText(ToolsRes.getString("DataTool.MenuItem.Undo"));
        this.redoItem.setText(ToolsRes.getString("DataTool.MenuItem.Redo"));
        this.copyMenu.setText(ToolsRes.getString("DataTool.Menu.Copy"));
        this.copyImageItem.setText(ToolsRes.getString("DataTool.MenuItem.CopyImage"));
        this.pasteMenu.setText(ToolsRes.getString("MenuItem.Paste"));
        this.pasteNewTabItem.setText(ToolsRes.getString("DataTool.MenuItem.PasteNewTab"));
        this.pasteColumnsItem.setText(ToolsRes.getString("DataTool.MenuItem.PasteNewColumns"));
        this.displayMenu.setText(ToolsRes.getString("Tool.Menu.Display"));
        this.languageMenu.setText(ToolsRes.getString("Tool.Menu.Language"));
        this.fontSizeMenu.setText(ToolsRes.getString("Tool.Menu.FontSize"));
        this.defaultFontSizeItem.setText(ToolsRes.getString("Tool.MenuItem.DefaultFontSize"));
        this.helpMenu.setText(ToolsRes.getString("Menu.Help"));
        this.helpItem.setText(ToolsRes.getString("DataTool.MenuItem.Help"));
        this.logItem.setText(ToolsRes.getString("MenuItem.Log"));
        this.aboutItem.setText(ToolsRes.getString("MenuItem.About"));
        Locale[] localeArray = OSPRuntime.getInstalledLocales();
        int n = 0;
        while (n < localeArray.length) {
            if (localeArray[n].getLanguage().equals(ToolsRes.resourceLocale.getLanguage())) {
                this.languageItems[n].setSelected(true);
            }
            ++n;
        }
    }

    protected void showAboutDialog() {
        String string = String.valueOf(this.getName()) + " 1.4  November 2008\n" + "Code Author: Douglas Brown\n" + "Open Source Physics Project\n" + "www.opensourcephysics.org";
        JOptionPane.showMessageDialog(this, string, String.valueOf(ToolsRes.getString("Dialog.About.Title")) + " " + this.getName(), 1);
    }

    protected static JButton createButton(String string) {
        JButton jButton = new JButton(string){

            public Dimension getMaximumSize() {
                Dimension dimension = super.getMaximumSize();
                dimension.height = buttonHeight;
                return dimension;
            }
        };
        return jButton;
    }
}

