/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.displayejs;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Stroke;
import java.util.ArrayList;
import org.colos.ejs.library.control.displayejs.ControlDrawable3D;
import org.colos.ejs.library.control.value.IntegerValue;
import org.colos.ejs.library.control.value.Value;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.displayejs.InteractiveArrow;
import org.opensourcephysics.displayejs.Style;
import org.opensourcephysics.displayejs.VectorField3D;

public class ControlVectorField3D
extends ControlDrawable3D {
    private static final int VFIELD_ADDED = 12;
    protected VectorField3D vectorfield3d;
    private boolean auto;
    private double minC;
    private double maxC;
    private double zoom;
    private double lineWidth = 1.0;
    private int levels;
    private Color mincolor;
    private Color maxcolor;
    private static ArrayList infoList = null;

    protected Drawable createDrawable() {
        this.vectorfield3d = new VectorField3D();
        this.minC = 0.0;
        this.maxC = 1.0;
        this.zoom = 1.0;
        this.levels = 0;
        this.auto = true;
        this.vectorfield3d.setAutoscaleMagnitude(true);
        this.vectorfield3d.setInvisibleLevel(-1);
        return this.vectorfield3d;
    }

    public ArrayList getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList();
            infoList.add("data");
            infoList.add("autoscale");
            infoList.add("minimum");
            infoList.add("maximum");
            infoList.add("levels");
            infoList.add("mincolor");
            infoList.add("maxcolor");
            infoList.add("zoom");
            infoList.add("visible");
            infoList.add("invisibleLevel");
            infoList.add("style");
            infoList.add("stroke");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    public String getPropertyInfo(String string) {
        if (string.equals("data")) {
            return "double[][][][]|double[][][]";
        }
        if (string.equals("autoscale")) {
            return "boolean";
        }
        if (string.equals("minimum")) {
            return "int|double";
        }
        if (string.equals("maximum")) {
            return "int|double";
        }
        if (string.equals("levels")) {
            return "int";
        }
        if (string.equals("mincolor")) {
            return "Color|Object";
        }
        if (string.equals("maxcolor")) {
            return "Color|Object";
        }
        if (string.equals("zoom")) {
            return "int|double";
        }
        if (string.equals("visible")) {
            return "boolean";
        }
        if (string.equals("invisibleLevel")) {
            return "int";
        }
        if (string.equals("style")) {
            return "ArrowStyle|int";
        }
        if (string.equals("stroke")) {
            return "int|double|Object";
        }
        return super.getPropertyInfo(string);
    }

    public Value parseConstant(String string, String string2) {
        if (string2 == null) {
            return null;
        }
        if (string.indexOf("ArrowStyle") >= 0) {
            if ((string2 = string2.trim().toLowerCase()).equals("arrow")) {
                return new IntegerValue(0);
            }
            if (string2.equals("segment")) {
                return new IntegerValue(1);
            }
            if (string2.equals("box")) {
                return new IntegerValue(2);
            }
        }
        return super.parseConstant(string, string2);
    }

    public void setValue(int n, Value value) {
        switch (n) {
            case 0: {
                if (value.getObject() instanceof double[][][][]) {
                    this.vectorfield3d.setDataArray((double[][][][])value.getObject());
                    break;
                }
                if (!(value.getObject() instanceof double[][][])) break;
                this.vectorfield3d.setDataArray((double[][][])value.getObject());
                break;
            }
            case 1: {
                if (this.auto == value.getBoolean()) break;
                this.auto = value.getBoolean();
                this.vectorfield3d.setAutoscaleMagnitude(this.auto);
                break;
            }
            case 2: {
                if (value.getDouble() == this.minC) break;
                this.minC = value.getDouble();
                this.vectorfield3d.setColorExtrema(this.minC, this.maxC);
                break;
            }
            case 3: {
                if (value.getDouble() == this.maxC) break;
                this.maxC = value.getDouble();
                this.vectorfield3d.setColorExtrema(this.minC, this.maxC);
                break;
            }
            case 4: {
                if (value.getInteger() == this.levels) break;
                this.levels = value.getInteger();
                this.vectorfield3d.setNumberOfLevels(this.levels);
                break;
            }
            case 5: {
                if (this.mincolor == (Color)value.getObject()) break;
                this.mincolor = (Color)value.getObject();
                this.vectorfield3d.setMinColor(this.mincolor);
                break;
            }
            case 6: {
                if (this.maxcolor == (Color)value.getObject()) break;
                this.maxcolor = (Color)value.getObject();
                this.vectorfield3d.setMaxColor(this.maxcolor);
                break;
            }
            case 7: {
                if (value.getDouble() == this.zoom) break;
                this.zoom = value.getDouble();
                this.vectorfield3d.setZoom(this.zoom);
                break;
            }
            case 8: {
                this.vectorfield3d.setVisible(value.getBoolean());
                break;
            }
            case 9: {
                this.vectorfield3d.setInvisibleLevel(value.getInteger());
                break;
            }
            case 10: {
                if (value.getObject() instanceof int[]) {
                    int[] nArray = (int[])value.getObject();
                    int n2 = 0;
                    int n3 = Math.min(this.vectorfield3d.getNumberOfElements(), nArray.length);
                    while (n2 < n3) {
                        ((InteractiveArrow)this.vectorfield3d.elementAt(n2)).setArrowType(nArray[n2]);
                        ++n2;
                    }
                } else {
                    int n4 = value.getInteger();
                    int n5 = 0;
                    int n6 = this.vectorfield3d.getNumberOfElements();
                    while (n5 < n6) {
                        ((InteractiveArrow)this.vectorfield3d.elementAt(n5)).setArrowType(n4);
                        ++n5;
                    }
                }
                break;
            }
            case 11: {
                if (value.getObject() instanceof Object[]) {
                    Object[] objectArray = (Object[])value.getObject();
                    int n7 = 0;
                    int n8 = Math.min(this.vectorfield3d.getNumberOfElements(), objectArray.length);
                    while (n7 < n8) {
                        this.vectorfield3d.elementAt(n7).getStyle().setEdgeStroke((Stroke)objectArray[n7]);
                        ++n7;
                    }
                } else if (value.getObject() instanceof Stroke) {
                    Stroke stroke = (Stroke)value.getObject();
                    int n9 = 0;
                    int n10 = this.vectorfield3d.getNumberOfElements();
                    while (n9 < n10) {
                        this.vectorfield3d.elementAt(n9).getStyle().setEdgeStroke(stroke);
                        ++n9;
                    }
                } else if (value.getObject() instanceof double[]) {
                    double[] dArray = (double[])value.getObject();
                    int n11 = 0;
                    int n12 = Math.min(this.vectorfield3d.getNumberOfElements(), dArray.length);
                    while (n11 < n12) {
                        BasicStroke basicStroke = dArray[n11] < 0.0 ? new BasicStroke((float)(-dArray[n11]), 0, 0, 10.0f, Style.DASHED_STROKE, 0.0f) : new BasicStroke((float)dArray[n11]);
                        this.vectorfield3d.elementAt(n11).getStyle().setEdgeStroke(basicStroke);
                        ++n11;
                    }
                } else {
                    if (this.lineWidth == value.getDouble()) break;
                    this.lineWidth = value.getDouble();
                    BasicStroke basicStroke = this.lineWidth < 0.0 ? new BasicStroke((float)(-this.lineWidth), 0, 0, 10.0f, Style.DASHED_STROKE, 0.0f) : new BasicStroke((float)this.lineWidth);
                    int n13 = 0;
                    int n14 = this.vectorfield3d.getNumberOfElements();
                    while (n13 < n14) {
                        this.vectorfield3d.elementAt(n13).getStyle().setEdgeStroke(basicStroke);
                        ++n13;
                    }
                }
                break;
            }
            default: {
                super.setValue(n - 12, value);
            }
        }
    }

    public void setDefaultValue(int n) {
        switch (n) {
            case 0: {
                this.vectorfield3d.setDataArray((double[][][])null);
                break;
            }
            case 1: {
                this.auto = true;
                this.vectorfield3d.setAutoscaleMagnitude(true);
                break;
            }
            case 2: {
                this.minC = 0.0;
                this.vectorfield3d.setColorExtrema(0.0, this.maxC);
                break;
            }
            case 3: {
                this.maxC = 1.0;
                this.vectorfield3d.setColorExtrema(this.minC, 1.0);
                break;
            }
            case 4: {
                this.levels = 16;
                this.vectorfield3d.setNumberOfLevels(16);
                break;
            }
            case 5: {
                this.mincolor = Color.blue;
                this.vectorfield3d.setMinColor(this.mincolor);
                break;
            }
            case 6: {
                this.maxcolor = Color.red;
                this.vectorfield3d.setMaxColor(this.maxcolor);
                break;
            }
            case 7: {
                this.zoom = 1.0;
                this.vectorfield3d.setZoom(1.0);
                break;
            }
            case 8: {
                this.vectorfield3d.setVisible(true);
                break;
            }
            case 9: {
                this.vectorfield3d.setInvisibleLevel(-1);
                break;
            }
            case 10: {
                int n2 = 0;
                int n3 = this.vectorfield3d.getNumberOfElements();
                while (n2 < n3) {
                    ((InteractiveArrow)this.vectorfield3d.elementAt(n2)).setArrowType(0);
                    ++n2;
                }
                break;
            }
            case 11: {
                this.lineWidth = 1.0;
                BasicStroke basicStroke = new BasicStroke((float)1.0);
                int n4 = 0;
                int n5 = this.vectorfield3d.getNumberOfElements();
                while (n4 < n5) {
                    this.vectorfield3d.elementAt(n4).getStyle().setEdgeStroke(basicStroke);
                    ++n4;
                }
                break;
            }
            default: {
                super.setDefaultValue(n - 12);
            }
        }
    }

    public Value getValue(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                return null;
            }
        }
        return super.getValue(n - 12);
    }
}

