var _isEPub = false;
var _isApp = false;

var __base64Images = [];
__base64Images["./Electric field lines/2015-11-06_1620s.png"]="data:image/png;base64,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";
__base64Images["./Electric field lines/Screen Shot 2017-05-11 at 3.52.34 PM.png"]="data:image/png;base64,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";
__base64Images["./Electric field lines/lookangphoto.png"]="data:image/png;base64,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";
__base64Images["./Electric field lines/lines.png"]="data:image/png;base64,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";
