var _isEPub = false;
var _isApp = false;

var __base64Images = [];
__base64Images["./eField/efields.png"]="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAUAAAAC0CAIAAABqhmJGAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAEYiSURBVHhe7Z0HfBTF28cnFVJoSSCht9ASWqRJk6qAiCggKIiFKkVAAQUEBAPCX3oRpElRDCAdpLfQS2gJKaSHmt57fX+5mZxbj1uSg4vvfj/hmGdm9rmZuXmm7O7MmBQUFBAVFZXSiSn7X0VFpRSiGrCKSimGN4SOj4+PiYmxs7PLz89nXiJMTU11hIoxqvgmJib41H/WoEi5ubl5dHR0w4YNExIS8vLymK8GfC9UpaWlVa9ePS4ujvkW6aepgtvCwiIzM5MGaYF/Tk6OjY0NPhFZkHgzM7P09PRKlSplZGQIgnAhNGdlZeFafDJfDlZWVikpKWXKlKGppYmhQbiwXLlyyA6uFeQFIKdly5ZFbcGnuHxwIZKEb7S0tOQqpA4HB4fQ0FDEgY+OH4KbGH146fj4ZXJzC5KTs+CgQTIg/fpWGw2K4iuIXFCQX7GitZOTPRV5hXjjxo2mTZuiTsiVLK0Q+Ml1FD0Xo4qPyLm5ufjlgJ7xFSUG9oBL6tev7+XlZW1tza33+EboQeiYMWM2bNgAY4OnVj8q+s2bN9u3b//w4UNcnp2dTa+iQO3cuXM9PDyCgoJgGILEI7Rt27aff/75hAkTqFoKlENP+fLl4UCDAjtE3lmYBnzpo0eP6tWrB224UJsYqhxqp02bdvr06fv373PVAlo97O3tv/rqq6VLlwpCcSEyiKDDhw/369dPm1NYC7C1te3du/fJkycTExNRRIIkaREk5oUUJ765uVVQ0N5atT4SNVM80P7op5uhKL6iyGZmJCysZ7Nmp5mMPGi5d+8ec8mDnDOXfhhVfNQY5tIPpYnp0qXLjBkzmCACpX3hwgUmaNDqP3PmTI0aNWClVBTw3XffNWvWbOvWrUzmA+Ns0KABE/hALXrLn376icl8Bg8ejCShE6YiN7NhYWFoUFq0aMFkPshF586d3d3dmcwnNjYWxnnp0iUmF0ELH60bbYN0Y9BqALjxw8NP4McpRX/BwR+ypBcU8IYNkJlLHn3icDGq+IisND5z6cewYcP27t3LBBGzZs1auXIlEzRo9aMz7NGjR7du3agooFGjRo6Ojl988YV4NJucnDx69Ojvv/+eyXwwG/rwww/79OnDZD5LliyBTlgaFbmZrVOnTuvWrd9//30m80E7hc8qVapQUQBKYPLkyYJxRGG5a/SjW16xYgX11AE3MfpQnPhmFiT6AVm/jYQ+ZD6BPiQ9kWRrCvuvNeTyzUJH8ANSkEbuBRe6KV7XCMkmi91JRgFJjyLRicz/1qnCzyf3EEgSNRMmr4vk198KHZSIW2TlRpKSzEQtebkkKZ659cwQbwiNHrhly5ZMkAFNF8YeTNADo4qPTgAjQIygmPwilCYGPHjwYPr06cePH2cyHxcXFz8/Pybw9WP8DPNev349FQV079793Llz+LHEiX/+/PmyZcswmmVyEVQ52oWzZ88yLz5Xrly5ffv2pEmTqCjIbLt27TClYgIf5M7b21uu1XBycoqMjGRCETTl27ZtwwQYIwLmK4/Ski9O/KeRJ7P9e59PIc1MiccV8l5n8uQZee5HnDuQjr3J4eXE+U3y8D6xcSIWiNOHeP9DokxJrWqFZrloMVkwnzi7kfwn5HEeqZBBUuoRy4uk7Uhyci+Z9z8ybyJp2p8MeptcPkhg++ViSIYD6ehIbGqRm7fImVOkWw9y7hzp3Ik8SSFursT7ImncnBw4Qzq1J+++Ryra0DTyCAn5sH79/dSt3oUuSVAtmjZtijqalJTEvPjA0tAPM4EPulnMOZkgokOHDhh8SjY9VatWDQgIYIIS0JQ0bNiQCSJ02MOaNWu+/vpr8XAA3L1797333mMCB5ryiRMn6mO9r5oCtOzEtQGGM8SmItJK7CsSF2eSlU8KcknrDsSxEsnII2XLkDLWxDKXhDwmlSoSu4qknDXJTCXDx5Ka9qRS+UJNVuWIqytxciABESQntdDHrjJxxEgli5RzIOnBxKIasbYkeZnkzDVSwYY0bkPqVSEFZUg9Z1KrFkl8TnILiDkhzZuRKuVJbFFvrAs0jVpQ+swlT2ZmJnPph1HF197I1ZOXS8zTp0/btGlDfcRUrlyZuUT6P/roo6ioKCbwQWc4Z84cJojAjJS5OFDl6LqpKGbq1KkhISFM4CcGYzEdk3mYPT4lCwcz5/T0dCbwWbhw4erVq5nwIiSV66A48cPCDmEYGvCwcNSankGyM0lObqE7N6fQnODAX0aGJjRT404nBbDtgsIxMA0tyNP4p5FcjQMasrIKjR9ujIpZnKK/NI2q5zGFn3kaPRkatdqgLM0lqVrlor+QkLdZ0jGuwT9myuoQWsRLJwbjz3379tWoUYP6c4FhYA5J56UC/bDS/fv3/+9//2MyHzqKZgKfrl27XrhwgQlFUOU6htCY4h4+fJgJ/MQsWLAAX4dun4pc7ty5s2PHDoz2JQvHzc0N3QAT+FhaWgomxjqQVK6D4sRPSIgNDrlSxrIMhhSoGhyDKOycC0zQJZvk5uaYm1sgML+AmJoyQ4KDPrqiFYpdW0BMTE3QVVhYWKCz4CqkblMTgovMTAqtV3OhSV5ejhkm4vgqfmQo14paTEzQA1m3atWVydSOKWoPLOClE4NeqG7dutQtBqNl6hDrd3Z2Zi4RsA3mEvFyPbDgKm5ievbsyVwiBg8eHB0dDYc48ZhOi28+U7755ps9e/YwQQ/EynVj6Ph5ecyhJ4riK1UeG5vAXIK70ColhZWVVZMmTa5evcpkPrVq1YqNjWUCn9q1a2OYwAQ+9erVQ7vABD7W1tbMVUIkJCQwl4jbt29jFsAEPh4eHp06dWICn82bN2OCwIRSSE6OxJswOlAUX6nyvLx/BzKqARsKDIa1T2gErFu37rPPPmMCn5kzZ/78889M4NO3b1+5m9uNGzd+9OgRE/RGbiqB3glNDBP4BAYGYrjOBD4bN25EN8sEPleuXPn777+ZoFKiqAZsKDDFknvQgnHyp59+ygQ+mLJu2bKFCXwwbT506BAT+MCAX+JGdNmyZZmLz9GjR3v37s0EPvPnz58+fToT+NSsWRPTeybw6dixY69eveRGFirFQTXg18PQoUOZS4Rcv+3k5JSaqnk0IaJBgwZ37txhAh/Bq45aQkJCMEtnAp/79++/++67TOCzcOFCTOCZwAfti467g5itMZdKiaIasNEhN3zNz8/HsJwJfNq2bTtw4EAm8JHr6qtUqfLtt98ygY+7u7vk/XNQp04d5lIxDlQDLjWgE4MNM4FPuXLl0Akzgc/48eOZiw8u0fEWh0ppgWfApqYvtmf9H6JSjCq+oROj6FEkMKrEq5nVgUHjF0c570UOT0/PqlWrYpgk+ZYchT6hZoIeGFV85AuNlP7lpUi5lZXV4MGDR40a1aVLl8IndJyCxTeam5uPGTNm06ZNubm52o6U6kdQeHj4uXPnxo4dK56ywk5OnDhRvXr1Fi1apKWlCRpZfOnmzZsxTsZXCPpnKC9fvvzKlSunTJkiORPGtUuWLJk+fToN5WYWSYK23377bfLkyeJrcaGXl1dQUNDHH3+cyV/AjGSULVt2xYoVbdq0ad++vfbNDZQGFCLo7t27SNKyZcvs7Oz+q9UMKIqvKDJKOCEhAXbKZFrVKPfv32cuebJe4TovfVAUnxoPE/RAaWJQ799//325dwlR2n369GGCBq1+eg9Z7u1Fuobp8ePHTObTrl27d999lwkcUC3wiQsDAwOpj4Bt27ZxK4Ags2jHO3XqxAQ+dMXV4sWLmcyHvuwteCkIxY7Ch2Pu3LncL5XDoNUAGFV8pcrpizQUXnMuaMIlwTXMpR9GFd/QiUHtvHnzJjooJvNp1qxZ3759maBBqz85ORk90pw5c6goICUlBZYfFRXFZD64Fp/iN0PQmmzcuNHNze3XX39lXnyuX7+OpCYmslVw3Myisejevfu/zTyfgQMHIi+VKlViMp9x48bZ29tXqFCByUVQ/bdu3ZK7xc3F0L+UUcUvjnL1JlZJglHu6tWrMYpmMp9169bNnz+fCXxgbMuXL8fAksl80MdiLNqqVSvJXxo6mzdv7uDgwOQi0OONGDECY2+59bcYeM+ePVvypauaNWui3x49ejST+fj5+aFzhmYm8+nRo8f+/fvLlSvH5CKQR8zRzMzM5NoplZcBdUKL+i60AKWJoTg6OsbExDCBj4eHB3dRkUB/jRo1mEvEggULzpw5wwQRHTp0YC4OVLmOd6Hd3d3v3LnDBFFiunbtylwievXqBbNnAh9vb+9+/foxQYSgvulAacmX6vhKlXOXrKk9cEmCyQw+w8LC6tevT30EfPzxx6tWrWKCCNhMUFAQE/igL926dSsTRKBbYy4leHl5yS0+O3jwoNyDZRAcHFyxYkWaWQH9+/fHtUzgM3jwYPWFyhJHNeCSBxNLDD7XrFnDZD7wR9fHBD5Lly6dOnUqE/hgOiq3TA9gZMFcSkBDLndD/o8//vj888+ZwGfHjh1yb4AEBAQ0adJE8mHk06dPb968OWjQICarlBSsJ9agDqEFFCcxOrZuq1ChAnWI9deqVYu5RPTu3RszYSbwGTZsWFpaGhOKoMpfbjkhJtXMJaJx48bUIU58w4YNxZ4UW1vbDM3Gt3oip0eOUh1fqXJ1CP0qwGywadOmTOCDnvaXX35hAp9JkybJbYsHK921axcT+LRt2/b69etM0Bu5Z49JSUlyL2mhBZRbS0hfrpZ8uwMjjokTJ8qtnVApFsyQNag9sIBiJmbs2LHMJcLa2hqfkg8AMQplLj7ofgWPkbVcuXJF/FSWJkauBw4MDPzuu++YoEGbeAzyDx8+TN0Cpk2bdvHiReoWZNbZ2VnuAfioUaPwSZ8D60kxS/6FGFV8pcrVHvgV8dtvnK1E+axfvz4iIkLy5hNGm/hFmcABHebjx4+ZwKdDhw5yO0jKce3atTZt2jCBz549e/r168cEPlu3bsXAmwl8Bg4cKPcAfNOmTbS2MVml5FAN+PXw2WefyW2+sWLFimfPnjGBj6urK0aqTOAjd4kcXl5eGHgzgU90dDRziZAb+QMMAZhL5RWiGrDR0bFjx3r16jGBz7Jly+TejqpYsSJz8ZHb4DYoKEhu3eKRI0eYS8SIESOYS8U4UA241JCXl1e9enW57a9OnDjBXHwwHmYuPnK78wC5lYkqRohqwKUJHct35JDrzFX+G/AMWF0PLEBpfEMvkVUan7n0Q2l8dT2wDl5ZZtX1wLpQpNxKc7xo69at9+7di2LkliH8y5Yti89FixbNmDFDu8KW6gcBAQGDBw/28vIyNzcXFD7Ubt682cfHZ9WqVZLrgSdOnDho0KCuXbsKFu5Cefny5Xv37o3RNX1QwQI04EsRoWfPnleuXBGvB4bao0ePbt++/e+//xaopXkZPXo06skPP/wgCMWFu3fvnjZt2qZNm9555x3t65b49nzN8aK9evU6derUs2fP7O3t/6vVDCiKrygyyl9dD6wvShPTvXt32BITRKC016xZwwQNWv10MeCsWbOoKMDDwwOhy5YtYzKfoUOHwqofPXrE5CJgHnQ9/enTp5kXnyZNmtjY2DCBn1lYdYUKFT799FMm89m4cSNseNu2bUzmQ18p4a5ZBSh2+hz4r7/+Qij11IFBqwEwqvhKlavrgfVFaXx0d+hC6fp7MTNnzhQcm6LVn5qa6ubmJlgtrCU5OblVq1bffvutZHpq1qw5ZMgQOzs7JhcBq0bX3a9fP7ltLseMGcOdIXOVd+jQAUMJWDiT+aD7dXV1les/kf33339f/MKWmZlZcHDw1KlT5c6O4WLoX8qo4hdLOQQt6ptYApQmJiwsDJ/W1tbcQ8O0IHTBggUrVqxgMkd/fHw8mtX69etTUQAG2GvXrt21axeT+cTExEiepUbb9bff/vcgLAEYP0dERDCBn9n09HSMdeX2ABkxYsStW7f8/PyYzAEDgTfeeEPQ/Wqh9e358+dU1IFBqwEwqvhKlXPfxFINWBdKE6N9W1DQMnIpU6YMc4n0owfmWpSAdu3aMZcIjNu1B+1rocp1LGYQHLbETczcuXN1LD92cHDAJ3pgKnJBxytXaJj0wuyZ8CKUlnypjq9UufoqpaHQvlnl5eUl99I/ZqT9+/dnAp8//vhDbhtngB6VuUQMGzZs586dTNAPzLpdXFyYIALaevTowQQ+mMbTw1/QGlIfLbt37x4wYIDk3enx48ePHDkSw3Imq5QUzJA1qD2wgOIk5vvvv8ckkwl8nJ2dIyMj4RDrp0fvSrJ9+/aNGzcyQcRbb73FXEVQ5XI98PLly0+ePMkEDdrEYAD8wQcfULcYdKTUIU68oDppOX/+PCbqTNAPsXLdlOr4SpWrQ2h9KWZi6tSp888//zCBQ2pqqpOTExzi24+enp4TJ05kgogWLVowl4hmzZoxVxE0MXIGLD6RVJv4yZMn3759m7oFXL169auvvqJuQWYxMd67dy8TONA9t+CQHHLLUcySfyFGFV+pcnUI/YoICwuTPM3IxsYG010MmC0tLZlXEehIdQyGdSypxXg4Pj6eCXpA97KU5MiRI2+88QYT+IwaNWr9+vVM4IAqhf5ccheeZ8+e+fr6wqHPMw4VpagGbFgGDx7MXHw2b9587do1JvCZM2cOQpnA57vvvpPbuXLo0KH0cbE+PH/+XG43rNDQ0Pbt2zOBD6bNclvJ7tmz58KFC0zgg5YFoK9gskrJQjtiijqEFvC6Ev/+++8zFwc6BNVx8L/2RAgKVS45hP7ll19OnTrFhCJo/I8++ujhw4fUR4C7u7u/vz8TFGYWxY7CZ4IelFRJymFU8ZUqV4fQxo7kOcD4tfCp4y2Ip0+fMhcHepWA7du3v/3220zgM2DAALn9dGbPnt24cWMmqBgHqgGXJtAJo4dkgggfHx/m4iD5vtTt27eZS8THH3/MXCqlAdWA/ztI3uLy9PRkLg5KFxKpGC2qAZck/68M4+V2k1cpWXgGrK4HFqA0vpeX17Fjx9LS0pjMJyIigrmK0OqXu4RCnw/BYCTTI7cbFo2sW3N4eDhzSWU2Wn5zLBATE8NcIhISEsSPqaj+w4cP37lzR3Jgz0Uypzoo1fGLo1xdD6wLRcrpeuB33nnn5MmTWVlZ3Mee8KfrgTt06HDu3LnCu4eaYqf6AWzb2dl5586dQ4cOFa+w3bZt2/jx4588eUI3o2UBGhC6aNGiWbNmubu7z549m3stlJcvXx4R4ClIDxJz9OjR4cOHN2rU6MaNG/QqbWZpanv06IFrEU2QHktLy7t373bs2HH+/Pnctc0UXEKPQb5y5cqbb76pff0TyUYCbG1tFy9ePHPmTFyFb+EmSYCikgelOr6iyCg3dT2wvihNzE8//WRjY4NKz2Q+qNBDhgxhggat/ijN0aGXLl2iooCDBw/iB4N5M5kPvSMlma8HDx4gaN26dUzmU65cOe4aY25mL1y4gLaGLmAU4+vrW6tWrT///JPJfPbv3y+oV4Amj+6w99lnn1FPHRi0GgCjiq9UuboeWF+Uxkel9/f3HzRo0B9//MG8OKB3zc7OpivaKVr9GBp88cUX58+fp6IA1PvmzZv37t2byXzq16+/atUq8XGeICwsDE2G+KheAG2rV692cnJiMj+zXbp0QScpt20lUosemO4WIABJRUbEJxKj30BikJL09HS5/ai5GPqXMqr4xVIOQYv6IocApYnRgpqKSswEPihzbYur1Q+TwKd2nYAAmMrDhw8/+eQTJkuxYsUKDLOZoIEq796zJxW5XL16VbCWEHAze+DAAbkD+IGLiwsSjFkukzlghpKamsoEDoGBgci4/uWptORLdXylytXFDPpSnMRg0Ltw4UImcHj69CmmgtQt0L9y5Uod641euKDH0dGRu7EObSbe7NiRilwEDTeFm5g33niDuUTExMTQlU9oVqiPlg8//FB7CAMXTM3wjbSR0pPilLw+GFV8pcpVA9aXYiYGg9sffviBCRwWLVpEjwsS67ezs2MuEfPnz5ebXVNgIRipMgEi5sAjR8JY/WrW5JpOu3btMFZnAgdtYlBKOjYPeOedd+hOHYLEnz17VtyrA7qhDxP0ppgl/0KMKr5S5aoB60vxE4NuU/LIr9q1a0uW9rhx4+RuZYFWrVoxlwybN2/W7kT3LCYmC5aj+Qv96y/qeeLECcEr01q0iUejI7cPHtC+jC3IrJyVYlxAHSh86tCH4pe8bowqvlLlqgHri0ETgxovHoWCOnXqMJcIyS5OAC6nv2PYrl3UevEXNnw4DdXRGWoTr2OsjvblwoUL1M3NLAYOAQEBTJACxa4asBxKlXMNWH0T67Vx7tw5TFmZwMHZ2Vnu3YwFCxbMmzePCTKEhIRgsF3o0pgrBUNrfP7yyy+XL1+mPnI8ePCgV69eTBDh4eGBDpwJHJCwRo0aMUHlVcIMWYPaAwswdOIlO6X4+PiWLVsygQO9CYSxNxVfCG8IvXs385WHJr5Pnz7cBp4LrJR7j0pRZtUeWAdKlas9sLEAm2QuDpUqVZo9ezYTOODXwme3bt30PEnU0cEhaNQoOB7Uq1dbZl8BLrSXjo2NrVKlCvUR4OrqOkqjUMV44L1Kee/ePbmNGrRkZWUpemXfqOLn5ubKvVEsiVElnt5k1ud9dQom2JaWlh26dLkqtSBJjEETj2qG9JubmzP5RRhVyQODxleqPDo6WtvIqj1waYLb2r4QGtlKtO2Wyn8J1YD/s6BRP3jwoIOd3a5du5iXyn8OngHrM7bUf/xJMbb4ilCqnA6E8vXeflGRfkSWi3/z5k3JXXiaNGmyZ88eyd0qMdddsWIFEzQoSgwQb6mpDxguMpdOlCamVMdXqpwLbw5848aNhg0bli9fXq4K4pvozErPsZxRxUdkzIH1X06oNDEWFhZDhw4NCAi4c+cOCpB7gwqqMPeeMmVKZGTk7t276QksWv1IUlRUVHBwcOfOnXNExx1A7f379/G7YAIJtYI5MEL/+eef9957b9OmTTVr1mzcuHHlypW5p/hXrFgxMTGRCRr7gejn54dv/Oqrr0aMGLF8+XJ8qTiz0Hzp0iW5JMXExPj7+7/11luCUAR9/fXXyPu0adPq1q2rPaoCapH4smXLoogiIiJOnToF93+ymgFF8ZUqRwVA4+vo6MhE+h8FuuhtBjjk0B0qxnjiK9UMFF2CyCEhId7e3uvWrUMpoyqzgCI9q1evRq3l6qRuREaNhzGg6nOvoiDOuHHjNmzYIA4CCG3ZsqWVlRVscs6cOc2bN7exsaFB48ePRyhdsn/gwAHqiQTUrl0bTcmJEydg6nQHWRqkdQB815MnT5AkricFQZs3b65Spcq9e/fEofDp2bPn+vXroZx5aUAFxVejRTh58uS1a9eQSPG1XHSHiinV8V9C+b/A7rXgJ2EuedCEM5d+GFV8dBdo9ZmgB0oTc/fu3Y0bN7777rsoWAxrmW8RCxYsGDhwIPdIBK1+9Ie4RPJQv4yMDNgn3R0Wdk49BRw/flzwDD8hIYG7BSz0wyCZUMR3333HXBoEmZ05c6atrS00M5lPtWrV/ip6PZML+nPY9vTp05lcREpKCgYI6Dc8PT3Xrl3LfOUxaDUARhVfqXLuc2CeAasvcghQmhgQFBSEz0ePHqHDwRgS5kf9ATpnfGJsiSpOfbT6MbRG1Zc8kQjjpVmzZnl4eCDlcgYsiaLIQJDZhw8fDhgwQHxuONi+ffuiRYt27NjB5CK+/PJLekLqkSNHqA9l0KBBaJ6OHTsGtz5niwKDVgNgVPGVKlcNWF+KmRjUY1Rc8VlHW7ZsEYx9KPXq1WMuPvPmzQsMDISDTp71hCZGx3FKAsSZlTtXiR4vKqBdu3aYijOhiD179iCnP/74I5P1ppgl/0KMKr5S5VwDVh8jGRBaobt168bkIkaMGHHx4kVMZugWM1pg2JMmTWICBzQ64jtJemJvb89cJcTVq1fpGUgY+FEfgBlv165daYPFBWMNpJy+v629oaVSgqgGbHAwEGUuDpgJh4eHV6xYkVutYQN//vknEzhgQit3KNGr5/PPP//tt9+YoKFMmTJLly5dvHgxkzl06dKF3hZFQ0Z9VEoW1YBfG7Vr13769Kng7ULMLdeuXcuEIoyn9mOuLt4oKyQkBFbNBJVXi2rArxPt0zwtY8eOnTVrFhOKED45eH1InoFYo0YN5lJ55agG/DqRnBaOGjXq9OnTTDAyHj9+jGktE1SMANWAjY7ly5d/+eWXTDAmME7esWMHE1SMA9WAjRG6jaOx8csvv8id/a3yulAN2BgRPPvJyMjIe9FhQoZAcK6SeMau8tpRDdgYuTV9+u2FC5mgObO3cuXKSu9F01tfxTlD8Pvvv2cuQvyOHr05fHgqk1SMBdWAS5JinriZmZmJz4czZrRZurTV7NlBRQeU9OjRo0yZMvl6r1KkWFparl692tra+ocffmBeCvnwww+p42loqHO/fm3//PNxkyYQU1JSqL/Ka4dnwIKlapIofaRhVPENnRgUIF3BI0liYuIHH3zABA0WnDPpzpw5g0kmHNb/+x/1KTNzJj4/+uijyMhIOJAYRemBwU+aNOnQoUOS+0iKkVTeoUMHfJrMnk3X/jYKCEAr4uvvP2PGDLldYBYtWnTy5EkmFAHl9In36NGj6TErulGUU1Cq4xdHuXq8qC4UKbfSHC/q7OyMAqxfv37z5s3r1q3bqFGj6tWra1cXtmrVysnJycXFpXHjxvhEBAcHB1wbFRWFaIgcb2sbrTltEMQQMmDIEJNnzy5duoTOGQYJtI0sHJgbL1iw4MSJEw8ePICb+mtB4suXL9+vX78jR47Qt21ZQBFI8LBhw2xsbCZPnoyvTk9P52aWZgcZqenmNuPEiV6pbPj8dqNGQXl5EcHBmzdvHjlyJIoUXx0cHBygASmJjY1FRbp9+7abmxvSEBcXB4sNCgry9fWFIyEh4dq1a/jE0OC/Ws2AoviKIuNH4R4vyjNgb29vVDsmyEAXHzNBD4wqvlIDVpqYvXv3njp1asCAAXfv3vXx8UG1vn//PpQ8ffq0WrVq6Jpyc3ObNGly69YtWtdDQ0NxFf0Jxo8f379//969eycQUlGjLYyQlT//XN/GJiIiYtmyZbBeeGoNmDJlyhQYUmqRdXHRJ/GffvopkgrTglscHx2ph4dHo/bt3RYv7l10FDjKbu+BA6uWL7948SJEtFZIHnLn6uqKVqlFixaYrq9btw7NSmFkTVEjy6BBgwatW7eGeaNkxMcXClBa8qU6vlLlMTExKGQmoPZoUVcjCVCaGLBr1y7mkmK3zv2ZT58+nVtQ8HDgQBg0/oKmToXntm3baCiMH1A3JTo62tHRkXvGLxd9Ev/777+/884727dvh1syPloHfD65fJkmKdzGJrugAA0QPAWJ0XLw4EHmkuLAgQPMpRODVgNgVPGVKleXE+rLa0k8vG61a3erTx+BfYgNmLa/6AmpKIAq5y7rF0NXKaJXT05O1l0yd2bNul2vXjRnNa+izEI5Cp8JevBaSl4HBo2vVLm6nNCoKUNI6+vXWx87pvuO9ptvvoneDI7OnTtTH0mGDx/OXFJgWIvPpKQkzJZ1zyzcFi58IySkMudAcBVjQDXgUsnWrVvt7OwE97QlgWUylzy2trZ//fWXeN2yivGjGnDpA8PdESNGHDt2jMklwSeffIJRLt1AQ6UUoRpwaYLegq5UqRJsmPqUIJ6enkOGDElISGCySmlANWDjRfzCA6apGDyvW7euXLlyzKtEefTo0bhx45jAAZNkQzQZKsVHNWAjpWPHjqdOnWJCERjlfvnll2PHjmVyiZKVlVWzZk3Jc1hiY2MrVKjABBVjQjVgY2T69OlVq1adOHEik4soEL1N9WqoX7/+vn37qlWrxmQVo0E14NeJ5OvEe/bs2b179969e5lsHAwYMODzzz/v378/k1WMA9WAXycYD3fq1IkJGvz8/IYMGYK5KJONiUWLFmEyLNh98ueff27RooVg5bDKK0M14JJE/C5EQkLCtGnTmEBIeno6dcyePRuRbW1tL1++TH2uXr2KEbKrq2tJjZPNzMyys7Otra0zNasUS4QLFy4sW7bM09Pz2rVrdPgwa9asyZMnIyMffvhhrmaLL/pJcXd3DwgIgAOZFey/qVIiqAZcklhaWs6ZMweOsLCwqVOnotba2dlFac49Avfv37948eKmTZvgT08qWrNmDQ0Cx44dg0nExsYyWYTSxcYwmB07dkRERLz0emBJYmJievfuvXHjRiZr9qlHXjp27GhhYTFq1KiMjIzly5fTIPi0bdsW+R08eDBaKPjs3LkzLi6OhqqUACh6LahhzCWPQU95AgaNj85B0bvQShMzY8aMvn37olTRI8H99OlTFqABo2UrK6s+ffrkFZ1axNWPqwRHCnFBpT937hwT9IO+ewy1ISEh1Ec33MSgJui4irYyXl5eTOYwU7OGme4fogVDAJh03bp1EYS5NPd4NzkMWg2AUcVXqpx7CJ66HlgXipTDONEDd+/eHXZIrypcfFB0FDB6V3z1Z599tn37dqiFPyJQ/egq0U+OGzcO4+eVK1cKVvaWLVv20KFDGKCeOHGiV69e2lBoS01N7dmzJz1TUm498Pr166FZHAqQ4Pr16yMaBgVvv/02tNFk4xufP39evXp1TNF///13wbW4at26dcePH//0008xXeeGIknIpoeHx9ChQ9EEuLi4QDn8kUFtMWIijVG3uh6Yi6LIqEvc9cBqD6wLpYkBmPEylxSY8TKXBv31u7m54ceKj49nchHo8Hv06MEEPvoonzdvnvakMm78Bg0aoIqgp2WyEjBPZi4OKHbalk2ZMoX66EZpyZfq+EqVc3tg3hwYpcxc8uAa5tIPo4pv6MRkZ2cvWbKECVJgoshcGvTXj74Oc2nMqA8fPsy8CFm4cCH6SXSeTOajj/LmzZtjhtyqVSsma/YGQRuPfnvy5Mm6D0ZDtWMuPnI7+ND0rFixgoq6MfQvZVTxi6UcghZ1PbAAY8ssqFSp0ugxY+Dw9fWtUKECHImJiZoQIVS5+BRfLmhx8InB8E8//QQHffgcExOjCXwBihKPYkfhM0EPjK3kDRpfqXJ1PXCphM4YMYqOzM937dIFI2eYLnx0v+SI+SpzSUGnXn/88cf+/fv7Dh064ocfUCfoNl0qpQLVgEsZz3x8/vz991kXL0byzxaWw9ramrl0Yl2zpqOHR+zDh4E6DV7F2FANuNSAqSm64NzWrcvn5w8j5MZnn2n9tx7YWujy0sgvxbIRI35Hh0xItQkT4qWOXFMxTlQDLjWYmJpGJyY6ZWdTsdr58/g8ee6kOTG3H2JPviWkDyG3aKBianh6UoctIUn79lG3ivGjGvDrRHIxA8Xf33/rVk2/WoQJIfmpqdrHheaaR6xvNH8jl+Qee/cYWU5Ib0La0EDFWHAe55oXve+pJSIiYunSpUxQMSZUA36dLFu2jLlEuLi4aE820VKuRo1nzEnWhYXhs7JD5eMnjq85oHkl84/Cj5fD/cIF5iIktWlT5iqidu3as2fPvi9zZiI9UELltaAasMGhu7eLmTp16tq1a5nAx9TUFD1wxYp0g/d/mTN79t8tW8KRSYj98uXfac7y792rt4WJvu/xSOJ1+3bYm28mara/83V1ff+bb6g/l8zMzJYtW9IXyASgf26iOTNJjPY9cBVDQZ8mUdTnwAKKnxgLCwsYKhM4DB069M0332QCH2dn5507dzKBD0wan7cPHgwPD4eDPgeWgyame/fuVNRB3bp18RmTnn5D870DBg68du2aJoRHTEwMt8JwM7t48WKaNgHnzp3DJcHBwXDTN7H0pPglrxujiq9UOfc5sGrAulCaGO47cX/++Sfq7tmzZ5nMoUuXLv3794eDvkfBZcyYMWPHjmUCn759+wrWD/zxxx/z589nggia+Bca8MOHD6EZjmyOgZUvX565+Jw+fVq7UEFQOEiMoD+g0IfVI0eOZLJ+GLQaAKOKr1S5asD6ojQxgL7tjBls/fr1qY8W+pKwq6vr+PHjqQ9X/9atWw8fPtygQQMmc4iNjV2xYkXz5s2ZzMHR0XH9+vVM4IOcent7Dxo06Pr168xLBK5t06YNfUeKm5hZs2YtXbp07969TOYwZ86cIUOGSJ4gQzfxggONF/XRAgNGUFxcXFJSEh0+6Mag1QAYVXylymUNmK5r0Y1B3+oGBo2v1ICVJmbfvn2LFi1CTaWnDQmYO3du48aN3d3dmczXjz4Z1sgEPiEhIdCZkJDAZA4bN250cnJigogTJ05YWlouWLCAySLQ2w8YMIC6BZmtWrXqli1bmMDno48+atSokWS1wxhBrr9Fa4IgDBnmzZvHvOQxaDUARhVfqXKuAfOWE2LmgwlYpUqVUMuZFx8TExN6khr3Kh0YVXxExjRM/+WEShODmNWrV7exsfH19cXUl3ZrNAiq4INPzIfRs9EgrX4kCQ5ra+slS5ZMmzYNbnoVBRFOnjzZu3dvBCGCVi3V2bNnTzpKF1yFUMSETjhSU1OtrKzE95+guXbt2vh2DIwxXkhPT6eZxSe60OHDh2M8v2HDBnF6MLPt0aMH+ueBAwfKhT5//hztEdJA/aGWPjP7+OOP6QlvSM9/spoBRfGVKsfvhYEMypaKPAO+detW06ZNUdA6dNEvY4IeGFV8VBozMzMUGZNfhCLl0Izu9x8NFSpU4C52xTeiSFevXv3o0SMMhukoAP5UP34SDCyPHj0KK2rfvr1glSzUYpoKC6xVqxbsAZFZgEYtNb+3335bvLYWynEVWhMM2iVX3kLzmTNn0ATAjQjczCIIZYUGvXPnzuL0+Pn5BQQE1K1b183NTRyKDhat2NChQ9GcaUORX+Qa+nv16oX0YFCAtMkZMFBU8qBUx1cUGb84PZWSijwDvn//fosWLZggQ6kuKYMa8EugSD+t7lwD1o2hSx7p0T8xqGYwZv23xTJ04o0qvlLlMOAqVapQN+8H4BqzHPrE4WJs8RWhVDkmM8ylH4r0I7L+TQ8wdElqh8eGwNCJN6r4SpVzUV/kKDWgu5M04M+KVjVIojt0/PjxzKVSOlENuNQA623bti0TOERERDCXFLpDJTegfuutt5hLxehRDdgYwaSIufjQ9fcCdE8sdYdq96nm0qFDh3v37jGBg/g+tsprRzXg14mcdaGnTRKt1/fy8urevTsTSgjJMTl90sMEDrq3yFJ5LagG/Nrw9PT09fVlAoeYmBgzMzPxRjkwqsGDBzPBkLRs2fLixYtM4DBr1qz169czgc/KlSuZS+XVohqwYZE0UUrXrl0lF/HAX9J+Ll261KxZMyYYGMHTXcr3338/efJkJvBxd3f38/NjAp+7d+8yl4oBUA3YgGDQ21S0tpZSq1Yt1GzxnPbx48d2dnY2NjZM5iD32kNxHkLI6XRzcwvTrDcWsGLFCsk1zHFxca6urkzgM378+Llz5yp6AKaiP6oBGwp/f/82bdpIWte8efP69euHkar4uXGPHj1OnjzJBA5BQUHQxgQ+xbENuTcxMA3es2cPEzhMmDCBHv4k5sKFC5I2fO3atb/++mvp0qX6v8Whoj+qAZckWlt68uSJi4uLpPWiZ1u1atWvv/7KZA4hISE1a9aU3EcSE2AYFRP4GKJz69KlC11aJAadMF2wITB+XNKiRQtkjckcgoODly9fzj0PTaXEQCXToi4nFKA0MVR5fHy8oGApNJQbJNDfoEEDuYUp9PwUycS//fbbzMWHKqcXyoH5NnOJEkOHD5LY2triU/LgFXSzGE5ni9Y5AzRM6NWZ8CKUlnypjq9UOXc1ktoDlyQ7duzw9fXFJFbyQe7KlSu7det27NgxJnPIzc0dPXp0q1atJN+J/fnnn+lSHvxg1EfLrl27YE6SnRsu2blzp729vdyt49WrV9euXfv3339nMp+OHTuOHTuWCXxwyaeffnrjxg0mc8jIyHBycuIem6olLS3tk08+8fT0pB24SslA7ZiiHm4mQGlipk2bhi4oPT2dyXwwqBbstqHVDwd+C5gEFQX8+OOP6L4wk2QyH1y4ePFiJvDBSB6hkouTAWanCD1x4gQVuZl9/Pgx7LB169ZM5oNQpOfgwYNM5kO30WFCEdpir1y5su5BAUVpyZfq+EqVq8eL6jtpVKTcysoKmjEV3LdvX7ly5bhlCP+yZcvis3PnzhcuXKAjTPhT/SA0NLRRo0Zr166dMGGC+DhPTCD9/Pw2b96MTkww80Ro27ZtDx065ODgIHhTCsrLly9fo0YNmDEdpLGAInBthQoVkpKS6DdyM4ugI0eOYMhw9uxZQXrQscNEBw0aNGfOnKlTp4pTi6EEknrx4kX04aia1B/fDhvGYGHSpEnon/GlKJD/ajUDiuIrioxaxD1elGfA3t7ezZs3Z4IMSpc+GVV8pQasNDERERHQX61aNTOp0/RTUlJg2EzQoNWPik4HyZLA/FDd8UsBgQEDGIbYE1DlcqEUbqg4s7orFqb6mCwwgQ/SCW3cHMEH34ViefToEb4F/bBkEWlRWvKlOr5S5TExMShA6ub9tChi5pIHvwRz6YdRxTd0YmpqkKuaAusFWv06rBfAevGJX0cyPXL2SSPrsF7ADRUr190tiLOjBU2kOEdUf61atTA41229QDKnOijV8YujXNevq6IUdFnMZQBgFS+s968SfZp7FUOjGnCpAb3l/v37mcBH7h0PILkCkSIXdOPGDboFtIrxoxqw0REVFUX3UhaAOSfde1mMra0tc4nQEST5wiYICgo6dOgQE/j4+/szl4pxoBrwayNXs0UmEzhMmzYtMDCQCRxOnjw5aNAgJvDRMYnScccOc1HJMX///v3PnDnDBD50BzwxSmdxKiWFasCvB1jI1KlTJe8SnTt3TnJwe/To0ffee48JJQEMODIykgkcypUrJ3eeU7NmzRISEpjA4dKlS3TrdpVXjGrABmTVqlU7duxgAp8BAwYgVLzHxalTp0aMGMEEPuiWxYuEKbpvNcvh6OgoacBA8n1ssGzZMrQ7TODw1ltvHTt2TPK2VlJSUqdOnfR/dKeiCNWADUV6evqUKVMk95TbuHEjguAQv8kwc+ZMd3d3JvDR8aipUqVKzKUE9MCYbzOBj5ubm+Qw3tXVVW6Rw9mzZyU3DEGjY2lp+ffff6urkQyBasCGwsbGRnLHKTBx4sSffvqJCXzkXk4KCQlpqTlYVAx6UZgiE5RQvXp1+q6lmPfff//IkSNM4IMmSXKG7OLikpiY+Pz5cyZzwKRg8ODBOt67UnlpVAM2CB999NGGDRusrKyYzGHSpEn04EIx8+fPX7x4MRP46JgAc/fpVwSukuuBu3Xr5unpyQQ+P//88w8//MAEPpcvX+7YsSMT+MCwxccdqxQf1YBLEnpTClU/ICBgzJgx1FPAzp075ba22rx5c+/evZnA5/z58zAqJvB5+vRpjRo1mKAE9MCSHSbl2bNnzCWC3rsWD+ltbW0xTLhy5QqTOWCMgMmzug11iaMacEly//59fHbt2tXHx4f6cIFVyz2hwQj5+vXrcptOYpAcExMDg5EchcLS6tWrxwQO9M6Wjtch7e3t0XuLb6RRatasKZkL8OOPPy5btuzWrVtM5rB//37kUbwZdUFBwbx5844dO+bn56c+TC5BVAMuSWCcTZs2pedoikGlT05OdnNzYzKHuLi4jz/+eNOmTUzms3r1avSWd+/eFb9KiQuXLFmydu1aJnOA6dJ1ud9//z31EbBw4UIYsOR9cvg3atRowoQJTOYDE92yZQttrcTMnDkTeRHP/2HD4eHhrVq1ktysR+UlQbFqUdcDC1CaGBcXF0xxmSACpT1jxgwmaNDqp7d8v/jiCyoKoNtQxcfHM5mPtbW15KH+yCw+ceHFixepjwD6uhUTRJmtU6cOGiMm8KH7AS1fvpzJfOjrYoJTvFHsND2nT5/mfqkcBq0GwKjiK1Wurgc21HpgBweH9u3bo0+DUXEfiuIbLTWnB2/duhWzXO0aWqof+Pr6Ll682MPDQ7C8FkAt5sb4UXr27Cm5Hvibb75xd3eHfsGvBuXly5dHo7Bt2zaxWoBrP/nkE+2XcjNLtyVAc7N+/XrJJG3YsAGJ+fbbbwWh0ICZArru2bNn9+jRA1WT+qOaoUAwSR45cuTff/+NOCir/2o1A4riK4qMuqSuBzbUemClKNJPWwT939kwdMkrghqw/qupDJ14o4qvVLm6HlhflMbXdjh6ojTxSuMzl34ojW/ozDKXfpTq+MVRrt7EKjWg+5LrwSIjIzEMYwKf8+fPM5cIuReeVUoRqgGXGh49eiS3n+PEiRPl3vrCPJa5RMitbbp9+/aWLVuYwEdpX6FiaFQDNjoaNGjAXHzQl0o+7wVxcXFy6xx0rAeW2xOnYcOGJ06cYAKfAQMGxMbGMkHFCFAN2IDIDWtBlSpVmIuPt7d3r169mMDnzJkz77zzDhNKArmbeTBsyYO/wbRp0yTPRgJubm7ZMscap6am6n/jUEURqgEbELk3HI8fP/75558zgQ8GyXPnzmUCn6CgoJdbdSSHjuVNVlJvcYOOHTvKbeuzceNGubdHR48e7enpqa5GMgSqARuKt956S27l3YQJE5YsWcIEPjdv3pTrnHV0Yvo8PhBTq1YtegqMmCZNmjx+/JgJfHCV5NuXbdq0kXxLFHh4eMi94/26MDdX8FAXGDS+UuWmpv/ey+Q9B753757cmjUtWTp3MBZjVPFR88zMzPQfzr10Yr744otnz55JGnBISAgGogcOHIBboD80NNTd3X3r1q1M5gBLmzx5styeWF26dBEvHqLKe/TocfbsWebFZ/78+R988EGLFi2oyE3MwYMH8Y2SWwtgeox6MmPGDHHh7Ny588mTJ5JvbmLgjQH2zJkzmfwixMp1I46fmpoRGZnEreta8PvTR6963pIzaPyXUJ6Vldy4cX0mqgasg5dODL7i/PnzXbt2pf5c2rdvDxug95wE+sePH4/OWfKQzt27d2dmZsoNvAcMGCAe2VLlOgx4+/btdnZ2/fr1oyI3MQkJCZMmTZJrL5o1a+bj4yNZOA4ODnJ3uSwsLHTcFBAgqVwH4viBgUtq1PjupYYmRo2pKQkP7+Xiwu4yqkPokmfXrl3Vq1evVq0akzmgBmdkZMjdMUaPLXdMNowQpsgEPi+9nLBmzZpy42RMtjHlZoIIemdb8p2wr7766vDhw0zggxbtVQ6kLSzKWlsjqf+1P2SqTJl/NzxSDbgkoZ3AJ598gpFkw4YNqSeX4cOHo99jAh8MWXUMf/z8/GClknNdfFfdunWZoARcJXkMP0XHy30YKWzZskXy9d0FCxZILvrFQK9Tp05oL+T2AClxzC3Jk7tkA6ewAziLxB77k2t+ZM1GcvUMuXSVXLlJ9uwnF8+TC8fIvRAS8Zgc3EP8NWWzdCaJS9FcAw13mYNy+wa56UM8b5Hjh4hPAPG8Ti4fJ8GxxPMI2fdPYYQ7t4lvgCYqIZEPifZJ/Zmr5DS+6AG5dJ/8uY3cuEY8r5Cla0m4L3kcTfZsJ4+k91mQQLEBK30eYFTxDZ2YPXv26OiCMMr18vLSzjmBVv+xY8d+/vlnucPvjx49KvfMNjExEZ2z5PNhGBgaBVwYFxfHvPjQBf1oGqgoyGzr1q03b97MBD5ohjw8POT23MHEYd++fZKLDe/cuQMz/ucfTe3WSfF/KRNTkhJDKlQlu1aQNdvIpt/JuSMk8BG5cYl4BxAbS1K2GunXjZy/QTp3IDERJOYxiXxO8lPJtVvkWQKpVZM00bSKWWnk4kly9DQZN4b4eZG/j5O0BOKxn+Rlk1btSHocScwlffqTA6eIhSXxu0uiw0h4GhnYt/Da5HSSE0W+mkwO7yNb1mOuSzZqSjTdjKRFknB/TOrIw0DSrj3aG9K/N0mIIU8jSZMWpJbeO6woNmDJdS06MKr4mEYqumGrNDGenp7e3t7aWaUAzGAFR/Vq9efl5R04cEBuoQJMND09HfYvjlCxYsX//e9/CxcuZDIH6ES7gMmq3DY9U6ZMOXnyZGpqKhW5mcUcOCQkRO6RL4KQErllz9u2bRs2bJjgnS0Ue1paGkYoI0eO1PFymJYSqAYFJC+fONcmzVuQ+CRiX53Y2xRatSaElLUiackkN4e41iGrl5IWb5LUHNKpC3kcRszySK4JeRJBbl4tjFy7LnGoQMpXJKbWxNmVWGqyhdYiL49s+43Ub0LsK5Idv5J33yRxUcTNmew8T1xrkCNHC6NZ55HUsqRlc5KUQerVJ6a4THO5tSVxa08sypHcKFLehmxaT5o3JXlp5NiVwkEyRgoPWKMqTXY2p2xR0FrQQDKXPBh0MZd+GFX8yMhI1CQm6IHSxKA80cPAcpjMB6EffPABEzRo9VNjwByYigLmzp3r6OgIB4yN+nBxdnZesWIFEzjQFblQGxMTQ30E4Nu5FUCQ2TFjxjRp0oQJfOhtqtmzZzOZz7x58xAqPusYhY9P+qyY+uhAacmL4z9+sgy5Dw7FdxX+ZeeS3Dzmxt/jCObIySbZWSQppTA0I+3fCJkZJDuZ5BWQpxEkN588eoo2iBTkF5qWNk56KklKLnTERJF8qOLof/CQJMX/K+LCf92av1TNhbloZXKJrw/JyCwUkRh8JmuCdPzdvNmNZVKwHhgt67179ypVqsT1FJCbm6voibyi+BgI0bWROhLARVF8REZi0HXoPzxTlHgkIyAgoGrVqhUqVBDfboWe0NDQ5s2bJyUl0dRqEw83vggdFMa0KSlF860ikGDYrY2NjTb9LECDmZkZRsgw7+yiM4e1ILK1tXVUVBSShKEH8+WAUExKcS1iQuRmFt+F0IiICISKV+2iI8XXYfRuZ2cnDsWgIDg42NbWVrAoGjExr0aWYWz169fHV8j9atqS0bMaAG7igYmJaVZWOtKI8kECtT849OEPItpYczMTaIebhSJIE4GCYi505hNT80Lzy80tMDcvjG9uSnKKnoLTnwJZNDMr/ARUucazwMzcJB9fDYHz7VpwLS6h347EmJmZUBFxaBA3MpeCglw7O6cuXdgRGbKFqKKiYvy8ZgN+FB6SnJSQnZ1j71jDwtwUDhZQ0qBRT05OdnFxkVuRVyJkZmb4P7iHRtKqnL29XcW09Ax0VlkK183qD3rjWrVqMeGVcOPKBVvbcjkFptWr10hPS7OwLJOTk2WgGoTeW27xhoEI8PXOz8uNS0hs7No8Iy3NzMIiLycHMy4WXHKgNmJM1KhRIyYXBxjwC5k/bezte7c3/3WcySXHk4iw/Lzsh/4P/Hzu3LwXyHwNA0anGNg8C/VfsWJ5Ug7zLFkSkxKSE2Ojnj1KiXu2acc++Jy/eJ4GGYLo6MLJ7ZplS/YeP019rl88/euvv8MRl1g4UC9xHoUFZmWmRYQF7djxF8Qrlwyeu91bf1vz5x7qE+57b9nqZfjpYmPjqE/J8ig8uCAv29/fZ//fhd949/olw1STQuiNCc+TB9wXrqU+SZFhq1avjIhOgztP7xs10rc9BYz4fu7dOz7D+nZPSoi5du0andbk5mTn5eYU56+gIB9N0UO/B6amZsGhvi2bSy+jKykwB8Mc49Cpc1OmfLPtlyWbthbuxojsPI8pfB8YobmiFCr6y8dUJj8vOioyPiExPvx2zRaFB5TdPXRXeoVOSWBuWcbnrEf3z6cN7M3e8bgXGv1l3yYL1/+5ZUPhgl7fu7cDwwqfu+ajZ8kRJljpH6pLQnx85LNneRlJVpXtoDbKNyjoMbuJXeKYmJrmJYbmV31j4rCPqM+JC7e+/frbH35ctGnbNojhQb73HxRuBoi+ukRyh1/wob+fmalJtknhSDA19vnNa4ba8wB9CT4fhibPnsW2/ty55/ikryef+ufg6a2LnmSTuMjHN2550SAdmNF7hrpJSM9JDLtrVaNZRkzogcPHOnbtimFosO+d5IS4xLiYl/5LiotOTUkyMzNHxa/t6Hz55uVGDUpiUCEDhrJly5a9ddurTes2gY/imlQvX6Oe8+9btthXr1PTqXLM00fRzyKS4mMFidT/Lzk+Ji7qWRkr67ycbGvrag98rjdv2jToQmDDHi0V7HekhMys7JTngVmVGlctx+YFt+/7uFSr4NSsew176+rVqx3b4xGXX9a1QZ346MjIR6HFyV0SPmOjcgtIGUvLAlOz5CB/x+Zu8QGPylWt6WAnvXSpmKRnZFiZZt8JTWzZiE0Tbt+807pt88Rs6/Jmqc2atbxy7h+fkIQ2b7imJsY/CXtYnNzhD7URw1pTM7N8UmCTmpRmV88kKSE/p2yNumz3qZIlLS3dxsbmxuUbbd5sRX28bt5q067NjSue9Z3qOLi6PPHxOnn+6ludpE+6+BdNP/wCVi92T0mO8Q6NL8jLSUhIYL4lwZPw0DvXPX3ue93wPHfl5gPmaxgSExPz8vPjnoVO+ubbgrzc72a5wxPZgRnQCMUnNS3F2+vKnRuXngT5b962Jy83Y+1va1iYAYjSbC+6ZNGCgLCn1Ofu9XPzFq31uXJqxux5EFOTElPTM2hQiXD94pmA+7fCgnzWr/k9Iydj57Z1mSyk5ImKisLn9o2rr97yoz5PQ/y/nfZdWnb+vXP7AuNyszJSk5Mlnqu9NEH+3ndvXAp4cHvbb1uiEpKO790amS79RLD40NydPvz3geNnqE924vPJ334bGxX3w9jhl/3jMJhPSEykQTp43TexwoIrVSgXEhbeslU75mUwMAcuUwb9h+WVE/srNezkUk961V5xSElJTk+MycjItLVzcnCwZ74GIzo6Wrz2cMeGtUPGTlSwDkAJD33uOFapEp2U2rBhY+ZlMLh7L2o5+89e64qOd7zDJ4wbzrxKjtBA3yoODoGh4W+0NnhtlMyd95Xz6ZWdW1impFV3cdBvieFrNuBAP5+k+OgCU3MHJwyTDJsSDKEbN26MWTeTDUBaeuq965dy8/JqN2iGaSd8DPd1+OEqVKhgb2/wZoLL6X/2VyxfwdrO0drahtYcA2UQyjHCdHypQ9temjs3Lufn5WTm5Neo44z5MPM1AMidhYVFiTxBUJ8DGxYUbnpaGhNKGvx29MUyzO3pOopXT5rBcgfoWyKo63I7hKioBmwo7nldt7AwT0pJa/tmp5SUJMsyZXOysgz0UBGzg1f8QNjP525+Xm58QlL7zl3TUlPMLSzzcnLy6OtIJYqpqWlCQsLLLbf6fwEMWMUQ0IeKgQF+mzZuhnjyyF7DPVSkh+Uc9Ph9waLV1OdpkPeK1SvDniceP7w/LVvB69968iQ8pCA/J8DPZ8/uv7ILCm54Ho/LNNT9Hpq7kwc95sz6hfqoaNHrOfD/K3JzcjLT0zIzivWXk52VlZkZHBRoZpaXllk4yLTIzPO5F0m/osSh3XpcStkfZnytcZKDZy5M+XryqT9/dajb0NrC5ObFEx5/H4d/Xl5uRnqqILVK/3KyMjG4DfD1MTc3i45+akFIfpbJw+uGOjSUjloinmX/tHC6xkPlX9QhtJCE2Oj46GeCNQNKweVpGZkWlpZ5JJ88C7d664Mn/+y3rt3ezY2dSVWyREfHVKlSedXq3yZP+or6bNqwbvTY8X9s22NjGtdp8LjQq0cCnuV/8Wn/tJSkyMehkjtF6Y+JiWlmduEblPmmpo5lzMNJRbNnIZkFldt3ld5OpJjQ3K1ZtvbrqROZl0oRqgEbigCfO+iHy1pZel4K+GzEwDP/HOj5wScGeqODPk+6dvZIvIl93+4dCr3y078cPXn1mlUxwfeemdbp1FRif5/iEB4SkBATXdbWxufuw659+wbfu9igfZ/KVgqWqekPzZ33jYtBMRkD35PeNPv/LaoBG4oQf58qjlWCwx+5vdGGeRkMyYeKTwPuRCQWPAwJ+nLYx8yr5AgL9q9sZ/cwKLhVuxe9KlRsJHOnQlEN2FDcvXmFFOTnm1rYV3biLostcfAL2tjYODk5MfmV4Ot9JzsjLbfAtLJTdUPnrkyZMi+3a9//B1QDVlEpxah3oVVUSi2E/B/n2wti4To1cAAAAABJRU5ErkJggg==";
