/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JOptionPane;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.tools.RemoteTool;
import org.opensourcephysics.tools.Tool;
import org.opensourcephysics.tools.ToolsRes;

public class Toolbox {
    private static final String HOST = "localhost";
    private static final int PORT = 1099;
    protected static Map<String, Tool> tools = new HashMap<String, Tool>();
    protected static Registry registry;
    protected static int allowRMI;

    static {
        allowRMI = -1;
    }

    protected Toolbox() {
    }

    public static void addTool(String name, Tool tool) {
        if (tools.get(name) == null) {
            tools.put(name, tool);
            OSPLog.fine("Added to toolbox: " + name);
        }
    }

    public static boolean addRMITool(String name, Tool tool) {
        Toolbox.initRMI();
        if (allowRMI == 0) {
            return false;
        }
        try {
            RemoteTool remote = new RemoteTool(tool);
            registry.bind(name, remote);
            OSPLog.fine("Added to RMI registry: " + name);
            return true;
        }
        catch (Exception ex) {
            OSPLog.warning("RMI registration failed: " + name + " [" + ex + "]");
            return false;
        }
    }

    public static Tool getTool(String name) {
        if (tools.containsKey(name)) {
            Tool tool = tools.get(name);
            OSPLog.fine("Found local tool: " + name);
            return tool;
        }
        Toolbox.initRMI();
        if (allowRMI == 0) {
            return null;
        }
        try {
            Tool tool = (Tool)registry.lookup(name);
            OSPLog.fine("Found RMI tool " + name);
            return new RemoteTool(tool);
        }
        catch (Exception ex) {
            OSPLog.info("RMI lookup failed: " + name + " [" + ex + "]");
            System.out.println("RMI lookup failed: " + name + " [" + ex + "]");
            return null;
        }
    }

    private static void initRMI() {
        if (allowRMI == 0) {
            return;
        }
        if (allowRMI < 0) {
            int selection = JOptionPane.showConfirmDialog(null, ToolsRes.getString("Toolbox.Dialog.UseRemote.Query"), ToolsRes.getString("Toolbox.Dialog.UseRemote.Title"), 0, 3);
            if (selection == 0) {
                allowRMI = 1;
            } else {
                allowRMI = 0;
                return;
            }
        }
        if (registry == null) {
            try {
                registry = LocateRegistry.getRegistry(HOST, 1099);
            }
            catch (RemoteException ex) {
                OSPLog.info(ex.getMessage());
                try {
                    registry = LocateRegistry.createRegistry(1099);
                }
                catch (RemoteException ex1) {
                    OSPLog.info(ex1.getMessage());
                }
            }
        }
    }
}

