/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.SwingPropertyChangeSupport;
import org.opensourcephysics.display.ResizableIcon;

public class FontSizer {
    public static final Font TEXT_FONT = new JTextField().getFont();
    public static final Font BUTTON_FONT = new JButton().getFont();
    public static final int MAX_LEVEL = 20;
    static Object levelObj = new FontSizer();
    static PropertyChangeSupport support = new SwingPropertyChangeSupport(levelObj);
    static int level;
    static int integerFactor;
    static double levelFactor;
    static double factor;
    static Map<Font, Font> fontMap;

    static {
        levelFactor = 1.25;
        fontMap = new HashMap<Font, Font>();
    }

    private FontSizer() {
    }

    public static void setLevel(int n) {
        n = Math.min(n, 20);
        level = Math.max(n, 0);
        factor = FontSizer.getFactor(level);
        integerFactor = FontSizer.getIntegerFactor(level);
        Font font = FontSizer.getResizedFont(TEXT_FONT, level);
        UIManager.put("OptionPane.messageFont", font);
        UIManager.put("TextField.font", font);
        UIManager.put("ToolTip.font", font);
        font = FontSizer.getResizedFont(BUTTON_FONT, level);
        UIManager.put("OptionPane.buttonFont", font);
        support.firePropertyChange("level", null, new Integer(level));
    }

    public static int getLevel() {
        return level;
    }

    public static void levelUp() {
        FontSizer.setLevel(level + 1);
    }

    public static void levelDown() {
        FontSizer.setLevel(level - 1);
    }

    public static double getFactor() {
        return factor;
    }

    public static int getIntegerFactor() {
        return integerFactor;
    }

    public static void setFonts(Object obj, int level) {
        if (obj instanceof Object[]) {
            Object[] objectArray = (Object[])obj;
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object next = objectArray[n2];
                FontSizer.setFonts(next, level);
                ++n2;
            }
            return;
        }
        if (obj instanceof Collection) {
            for (Object next : (Collection)obj) {
                FontSizer.setFonts(next, level);
            }
            return;
        }
        double factor = FontSizer.getFactor(level);
        if (obj instanceof Container) {
            FontSizer.setFontFactor((Container)obj, factor);
        } else if (obj instanceof TitledBorder) {
            FontSizer.setFontFactor((TitledBorder)obj, factor);
        } else if (obj instanceof Component) {
            FontSizer.setFontFactor((Component)obj, factor);
        }
    }

    public static Font getResizedFont(Font font, int level) {
        return FontSizer.getResizedFont(font, FontSizer.getFactor(level));
    }

    public static Font getResizedFont(Font font, double factor) {
        if (font == null) {
            return null;
        }
        Font base = fontMap.get(font);
        if (base == null) {
            base = font;
            fontMap.put(font, base);
        }
        float size = (float)((double)base.getSize() * factor);
        font = base.deriveFont(size);
        fontMap.put(font, base);
        return font;
    }

    public static double getFactor(int level) {
        double factor = 1.0;
        int i = 0;
        while (i < level) {
            factor *= levelFactor;
            ++i;
        }
        return factor;
    }

    public static int getIntegerFactor(int level) {
        return Math.round(Math.round(FontSizer.getFactor(level)));
    }

    public static void addPropertyChangeListener(String property, PropertyChangeListener listener) {
        if (property.equals("level")) {
            support.addPropertyChangeListener(property, listener);
        }
    }

    public static void removePropertyChangeListener(String property, PropertyChangeListener listener) {
        support.removePropertyChangeListener(property, listener);
    }

    /*
     * Unable to fully structure code
     */
    private static void setFontFactor(Container c, double factor) {
        font = FontSizer.getResizedFont(c.getFont(), factor);
        if (c instanceof JComponent && (border = ((JComponent)c).getBorder()) instanceof TitledBorder) {
            FontSizer.setFontFactor((TitledBorder)border, factor);
        }
        if (c instanceof JMenu) {
            FontSizer.setMenuFont((JMenu)c, font);
        } else {
            c.setFont(font);
            i = 0;
            while (i < c.getComponentCount()) {
                co = c.getComponent(i);
                if (co instanceof Container) {
                    FontSizer.setFontFactor((Container)co, factor);
                } else {
                    FontSizer.setFontFactor(co, factor);
                }
                ++i;
            }
        }
        if (c instanceof JButton) {
            button = (JButton)c;
            i = 0;
            while (i < 5) {
                v0 = i == 0 ? button.getIcon() : (i == 2 ? button.getSelectedIcon() : (i == 3 ? button.getRolloverIcon() : (icon = i == 4 ? button.getRolloverSelectedIcon() : button.getDisabledIcon())));
                if (icon != null && icon instanceof ResizableIcon) {
                    ((ResizableIcon)icon).resize(FontSizer.getIntegerFactor());
                }
                ++i;
            }
        } else if (c instanceof JMenu) {
            menu = (JMenu)c;
            icon = menu.getIcon();
            if (icon != null && icon instanceof ResizableIcon) {
                ((ResizableIcon)icon).resize(FontSizer.getIntegerFactor());
            }
            i = 0;
            while (i < menu.getItemCount()) {
                item = menu.getItem(i);
                if (item != null) {
                    FontSizer.setFontFactor(item, factor);
                }
                ++i;
            }
        } else {
            try {
                m = c.getClass().getMethod("getIcon", null);
                icon = (Icon)m.invoke((Object)c, null);
                if (icon == null || !(icon instanceof ResizableIcon)) ** GOTO lbl48
                ((ResizableIcon)icon).resize(FontSizer.getIntegerFactor());
            }
            catch (Exception var4_5) {
                // empty catch block
            }
        }
lbl48:
        // 5 sources

        c.repaint();
    }

    private static void setFontFactor(Component c, double factor) {
        Border border;
        Font font = FontSizer.getResizedFont(c.getFont(), factor);
        c.setFont(font);
        if (c instanceof JComponent && (border = ((JComponent)c).getBorder()) instanceof TitledBorder) {
            FontSizer.setFontFactor((TitledBorder)border, factor);
        }
    }

    private static void setFontFactor(TitledBorder b, double factor) {
        Font font = b.getTitleFont();
        if (font == null) {
            font = UIManager.getFont("TitledBorder.font");
        }
        font = FontSizer.getResizedFont(font, factor);
        b.setTitleFont(font);
    }

    private static void setMenuFont(JMenu m, Font font) {
        m.setFont(font);
        int i = 0;
        while (i < m.getMenuComponentCount()) {
            m.getMenuComponent(i).setFont(font);
            if (m.getMenuComponent(i) instanceof JMenu) {
                FontSizer.setMenuFont((JMenu)m.getMenuComponent(i), font);
            }
            ++i;
        }
    }
}

