/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.awt.Component;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URLDecoder;
import java.security.CodeSource;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Map;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.tools.ExtensionsManager;
import org.opensourcephysics.tools.ToolsRes;
import org.opensourcephysics.tools.XuggleRes;

public class Diagnostics {
    public static final String TRACKER_INSTALLER_URL = "http://www.compadre.org/osp/items/detail.cfm?ID=7365";
    static final String JAVA_3D_URL = "http://java3d.java.net/binary-builds.html";
    static final String NEWLINE = System.getProperty("line.separator", "\n");
    static String requester;
    static Component dialogOwner;

    public static void aboutJava() {
        String version = System.getProperty("java.version", "unknown version");
        String rtName = System.getProperty("java.runtime.name");
        String rtVersion = System.getProperty("java.runtime.version");
        String vmName = System.getProperty("java.vm.name");
        String vmVersion = System.getProperty("java.vm.version");
        String path = System.getProperty("java.home");
        String bitness = OSPRuntime.getVMBitness() == 64 ? " (64-bit)" : " (32-bit)";
        String aboutString = String.valueOf(ToolsRes.getString("Diagnostics.Java.About.Version")) + " " + version + bitness + NEWLINE + rtName + " (build " + rtVersion + ")" + NEWLINE + vmName + " (build " + vmVersion + ")" + NEWLINE + "JRE path " + path + NEWLINE + NEWLINE + "Available Processors: " + Runtime.getRuntime().availableProcessors() + NEWLINE + "Total Memory: " + Runtime.getRuntime().totalMemory() / 1000000L + " MB" + NEWLINE + "Free Memory: " + Runtime.getRuntime().freeMemory() / 1000000L + " MB" + NEWLINE;
        JOptionPane.showMessageDialog(dialogOwner, aboutString, ToolsRes.getString("Diagnostics.Java.About.Title"), 1);
    }

    public static void setDialogOwner(Component owner) {
        dialogOwner = owner;
    }

    public static void aboutQTJava(String request) {
        requester = request;
        Diagnostics.aboutQTJava();
    }

    public static void aboutQTJava() {
        String aboutString;
        String path;
        if (OSPRuntime.isLinux()) {
            JOptionPane.showMessageDialog(dialogOwner, ToolsRes.getString("Diagnostics.QTJava.Linux"), ToolsRes.getString("Diagnostics.QTJava.About.Title"), 1);
            return;
        }
        String qtJavaVersion = null;
        String qtVersion = null;
        File qtJavaFile = null;
        try {
            Class<?> type = Class.forName("quicktime.util.QTBuild");
            Method method = type.getMethod("info", null);
            qtJavaVersion = (String)method.invoke(null, null);
            type = Class.forName("org.opensourcephysics.media.quicktime.QT");
            method = type.getMethod("start", null);
            method.invoke(null, null);
            type = Class.forName("quicktime.QTSession");
            method = type.getMethod("getMajorVersion", null);
            qtVersion = "" + method.invoke(null, null);
            method = type.getMethod("getMinorVersion", null);
            qtVersion = String.valueOf(qtVersion) + "." + method.invoke(null, null);
            qtJavaFile = Diagnostics.getJarFile(type);
        }
        catch (Exception type) {
        }
        catch (Error type) {
            // empty catch block
        }
        if (qtJavaFile == null) {
            String extdirs = System.getProperty("java.ext.dirs");
            String separator = System.getProperty("path.separator");
            ArrayList<String> pathList = new ArrayList<String>();
            int n = extdirs.indexOf(separator);
            while (n > -1) {
                pathList.add(extdirs.substring(0, n));
                extdirs = extdirs.substring(n + 1);
                n = extdirs.indexOf(separator);
            }
            if (!"".equals(extdirs)) {
                pathList.add(extdirs);
            }
            String slash = System.getProperty("file.separator", "/");
            for (String path2 : pathList) {
                qtJavaFile = new File(String.valueOf(path2) + slash + "QTJava.zip");
                if (qtJavaFile.exists()) break;
            }
            if (!qtJavaFile.exists()) {
                qtJavaFile = null;
            }
        }
        String trackerStarterWarning = System.getenv("QTJAVA_WARNING");
        String string = path = qtJavaFile == null ? ToolsRes.getString("Diagnostics.About.Unknown") : qtJavaFile.getAbsolutePath();
        if (qtVersion != null && qtJavaVersion != null) {
            aboutString = String.valueOf(ToolsRes.getString("Diagnostics.QuickTime.About.Version")) + " " + qtVersion;
            aboutString = String.valueOf(aboutString) + NEWLINE + ToolsRes.getString("Diagnostics.QTJava.About.Version") + " ";
            aboutString = String.valueOf(aboutString) + qtJavaVersion.substring(qtJavaVersion.indexOf(":") + 1, qtJavaVersion.indexOf("]"));
            if (qtJavaFile != null) {
                DateFormat format = DateFormat.getDateInstance(3);
                Date date = new Date(qtJavaFile.lastModified());
                aboutString = String.valueOf(aboutString) + " (" + format.format(date) + ")";
            }
            aboutString = String.valueOf(aboutString) + NEWLINE + ToolsRes.getString("Diagnostics.QTJava.About.JarPath");
            aboutString = String.valueOf(aboutString) + " " + path;
            JOptionPane.showMessageDialog(dialogOwner, aboutString, ToolsRes.getString("Diagnostics.QTJava.About.Title"), 1);
        } else if (qtJavaFile != null) {
            if (OSPRuntime.getVMBitness() == 64) {
                TreeSet<String> jreDirs = ExtensionsManager.getManager().getPublicJREs(32);
                ArrayList<String> message = new ArrayList<String>();
                message.add(ToolsRes.getString("Diagnostics.QTJava.About.WrongBitness.Message1"));
                message.add(String.valueOf(ToolsRes.getString("Diagnostics.QTJava.About.WrongBitness.Message2")) + "\n");
                message.add(" ");
                boolean showPrefsQuestionForTracker = false;
                if (OSPRuntime.isWindows() && jreDirs.isEmpty()) {
                    if ("Tracker".equals(requester)) {
                        message.add(ToolsRes.getString("Diagnostics.QTJava.About.No32BitVM.Message1"));
                        message.add(ToolsRes.getString("Diagnostics.QTJava.About.No32BitVM.Message2"));
                    } else {
                        message.add(XuggleRes.getString("Xuggle.Dialog.NoVM.Message1"));
                        message.add(XuggleRes.getString("Xuggle.Dialog.NoVM.Message2"));
                        message.add(XuggleRes.getString("Xuggle.Dialog.NoVM.Message3"));
                        message.add(XuggleRes.getString("Xuggle.Dialog.NoVM.Message4"));
                    }
                } else if ("Tracker".equals(requester)) {
                    showPrefsQuestionForTracker = true;
                    message.add(ToolsRes.getString("Diagnostics.QTJava.About.SwitchVM.Message1"));
                    message.add(ToolsRes.getString("Diagnostics.QTJava.About.SwitchVM.Message2"));
                } else {
                    message.add(ToolsRes.getString("Diagnostics.QTJava.About.SwitchVM.Message3"));
                }
                Box box = Box.createVerticalBox();
                box.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
                for (String line : message) {
                    box.add(new JLabel(line));
                }
                if (dialogOwner != null && showPrefsQuestionForTracker) {
                    box.add(new JLabel("  "));
                    String question = ToolsRes.getString("Diagnostics.QTJava.About.ShowPrefs.Question");
                    box.add(new JLabel(question));
                    int response = JOptionPane.showConfirmDialog(dialogOwner, box, ToolsRes.getString("Diagnostics.QTJava.About.Title"), 0, 1);
                    if (response == 0) {
                        try {
                            Class<?> trackerClass = Class.forName("org.opensourcephysics.cabrillo.tracker.TFrame");
                            if (dialogOwner.getClass().equals(trackerClass)) {
                                Method m = trackerClass.getMethod("showPrefsDialog", String.class);
                                m.invoke((Object)dialogOwner, "runtime");
                            }
                        }
                        catch (Exception exception) {}
                    }
                } else {
                    JOptionPane.showMessageDialog(dialogOwner, box, ToolsRes.getString("Diagnostics.QTJava.About.Title"), 2);
                }
                return;
            }
            aboutString = ToolsRes.getString("Diagnostics.QTJava.Error.Message");
            if (trackerStarterWarning == null) {
                aboutString = String.valueOf(aboutString) + NEWLINE + ToolsRes.getString("Diagnostics.QTJava.About.JarPath");
                aboutString = String.valueOf(aboutString) + " " + path;
            } else {
                aboutString = String.valueOf(aboutString) + "\n\nError: " + trackerStarterWarning;
            }
            JOptionPane.showMessageDialog(dialogOwner, aboutString, ToolsRes.getString("Diagnostics.QTJava.About.Title"), 2);
        } else if ("Tracker".equals(requester) && OSPRuntime.isMac()) {
            JOptionPane.showMessageDialog(dialogOwner, String.valueOf(ToolsRes.getString("Diagnostics.QTJava.NotFound.OSX.Message1")) + NEWLINE + ToolsRes.getString("Diagnostics.QTJava.NotFound.OSX.Message2") + NEWLINE + NEWLINE + ToolsRes.getString("Diagnostics.DownloadTrackerInstaller.Message") + NEWLINE + TRACKER_INSTALLER_URL, ToolsRes.getString("Diagnostics.QTJava.About.Title"), 2);
        } else {
            JOptionPane.showMessageDialog(dialogOwner, String.valueOf(ToolsRes.getString("Diagnostics.QTJava.NotFound.Message1")) + NEWLINE + ToolsRes.getString("Diagnostics.QTJava.NotFound.Message2"), ToolsRes.getString("Diagnostics.QTJava.About.Title"), 2);
        }
    }

    public static File getJarFile(Class<?> classInJar) throws Exception {
        CodeSource codeSource = classInJar.getProtectionDomain().getCodeSource();
        File jarFile = null;
        if (codeSource.getLocation() != null) {
            jarFile = new File(codeSource.getLocation().toURI());
        } else {
            String path = classInJar.getResource(String.valueOf(classInJar.getSimpleName()) + ".class").getPath();
            String jarFilePath = path.substring(path.indexOf(":") + 1, path.indexOf("!"));
            jarFilePath = URLDecoder.decode(jarFilePath, "UTF-8");
            jarFile = new File(jarFilePath);
        }
        return jarFile;
    }

    public static void aboutJava3D() {
        if (OSPRuntime.isMac() && !OSPRuntime.hasJava3D()) {
            return;
        }
        Map props = null;
        try {
            Class<?> type = Class.forName("javax.media.j3d.VirtualUniverse");
            Method method = type.getMethod("getProperties", null);
            props = (Map)method.invoke(null, null);
        }
        catch (Exception type) {
        }
        catch (Error type) {
            // empty catch block
        }
        String extdirs = System.getProperty("java.ext.dirs");
        String separator = System.getProperty("path.separator");
        ArrayList<String> pathList = new ArrayList<String>();
        int n = extdirs.indexOf(separator);
        while (n > -1) {
            pathList.add(extdirs.substring(0, n));
            extdirs = extdirs.substring(n + 1);
            n = extdirs.indexOf(separator);
        }
        if (!"".equals(extdirs)) {
            pathList.add(extdirs);
        }
        File j3djar = null;
        String slash = System.getProperty("file.separator", "/");
        for (String path : pathList) {
            j3djar = new File(String.valueOf(path) + slash + "j3dcore.jar");
            if (j3djar.exists()) continue;
            j3djar = null;
        }
        if (props != null) {
            String version = (String)props.get("j3d.version");
            String vendor = (String)props.get("j3d.vendor");
            String jarPath = j3djar == null ? ToolsRes.getString("Diagnostics.About.Unknown") : j3djar.getPath();
            String aboutString = String.valueOf(ToolsRes.getString("Diagnostics.Java3D.About.Version")) + " " + version + NEWLINE + vendor + NEWLINE + ToolsRes.getString("Diagnostics.Java3D.About.JarPath") + " " + jarPath;
            JOptionPane.showMessageDialog(dialogOwner, aboutString, ToolsRes.getString("Diagnostics.Java3D.About.Title"), 1);
        } else if (j3djar != null) {
            JOptionPane.showMessageDialog(dialogOwner, ToolsRes.getString("Diagnostics.Java3D.Error.Message"), ToolsRes.getString("Diagnostics.Java3D.About.Title"), 2);
        } else {
            JOptionPane.showMessageDialog(dialogOwner, String.valueOf(ToolsRes.getString("Diagnostics.Java3D.NotFound.Message1")) + NEWLINE + ToolsRes.getString("Diagnostics.Download.Message") + NEWLINE + JAVA_3D_URL, ToolsRes.getString("Diagnostics.Java3D.About.Title"), 2);
        }
    }

    public static void aboutJOGL() {
        String aboutString;
        String jarPath;
        String version = null;
        try {
            Class<?> type = Class.forName("javax.media.opengl.glu.GLU");
            Field field = type.getField("versionString");
            version = (String)field.get(null);
        }
        catch (Exception type) {
        }
        catch (Error type) {
            // empty catch block
        }
        String extdirs = System.getProperty("java.ext.dirs");
        String separator = System.getProperty("path.separator");
        ArrayList<String> pathList = new ArrayList<String>();
        int n = extdirs.indexOf(separator);
        while (n > -1) {
            pathList.add(extdirs.substring(0, n));
            extdirs = extdirs.substring(n + 1);
            n = extdirs.indexOf(separator);
        }
        if (!"".equals(extdirs)) {
            pathList.add(extdirs);
        }
        File jogljar = null;
        String slash = System.getProperty("file.separator", "/");
        for (String path : pathList) {
            jogljar = new File(String.valueOf(path) + slash + "jogl.jar");
            if (jogljar.exists()) continue;
            jogljar = null;
        }
        String string = jarPath = jogljar == null ? ToolsRes.getString("Diagnostics.About.Unknown") : jogljar.getPath();
        if (version != null) {
            aboutString = String.valueOf(ToolsRes.getString("Diagnostics.JOGL.About.Version")) + " " + version + NEWLINE + ToolsRes.getString("Diagnostics.JOGL.About.JarPath") + " " + jarPath;
            JOptionPane.showMessageDialog(dialogOwner, aboutString, ToolsRes.getString("Diagnostics.JOGL.About.Title"), 1);
        } else if (jogljar != null) {
            aboutString = String.valueOf(ToolsRes.getString("Diagnostics.JOGL.Error.Message")) + NEWLINE + ToolsRes.getString("Diagnostics.JOGL.About.JarPath") + " " + jarPath;
            JOptionPane.showMessageDialog(dialogOwner, aboutString, ToolsRes.getString("Diagnostics.JOGL.About.Title"), 2);
        } else {
            JOptionPane.showMessageDialog(dialogOwner, String.valueOf(ToolsRes.getString("Diagnostics.JOGL.NotFound.Message1")) + NEWLINE + ToolsRes.getString("Diagnostics.JOGL.NotFound.Message2"), ToolsRes.getString("Diagnostics.JOGL.About.Title"), 2);
        }
    }

    public static void aboutLaunchJar() {
        if (OSPRuntime.getLaunchJarPath() != null) {
            JarFile jar = OSPRuntime.getLaunchJar();
            try {
                if (jar != null) {
                    String aboutString = String.valueOf(ToolsRes.getString("Diagnostics.Jar.About.Message.JarFile")) + " \"" + XML.getName(OSPRuntime.getLaunchJarPath()) + "\". ";
                    Enumeration<JarEntry> e = jar.entries();
                    while (e.hasMoreElements()) {
                        JarEntry entry = e.nextElement();
                        String name = entry.getName().toLowerCase();
                        if (!name.endsWith(".dsa") || !name.startsWith("meta-inf")) continue;
                        aboutString = String.valueOf(aboutString) + ToolsRes.getString("Diagnostics.Jar.About.Message.Signed");
                        JOptionPane.showMessageDialog(dialogOwner, aboutString, ToolsRes.getString("Diagnostics.Jar.About.Title"), 1);
                        return;
                    }
                    aboutString = String.valueOf(aboutString) + ToolsRes.getString("Diagnostics.Jar.About.Message.NotSigned");
                    JOptionPane.showMessageDialog(dialogOwner, aboutString, ToolsRes.getString("Diagnostics.Jar.About.Title"), 1);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else {
            JOptionPane.showMessageDialog(dialogOwner, ToolsRes.getString("Diagnostics.Jar.About.Message.NoJarFile"), ToolsRes.getString("Diagnostics.Jar.About.Title"), 1);
        }
    }

    public static void aboutOS() {
        String osName = System.getProperty("os.name");
        String version = System.getProperty("os.version");
        String aboutString = String.valueOf(ToolsRes.getString("Diagnostics.OS.About.Name")) + " " + osName + NEWLINE;
        aboutString = String.valueOf(aboutString) + ToolsRes.getString("Diagnostics.OS.About.Version") + " " + version + NEWLINE;
        Enumeration<?> e = System.getProperties().propertyNames();
        while (e.hasMoreElements()) {
            String val;
            String next = (String)e.nextElement();
            if (!next.startsWith("os.") || (val = System.getProperty(next)).equals(osName) || val.equals(version)) continue;
            aboutString = String.valueOf(aboutString) + next + ":  " + val + NEWLINE;
        }
        JOptionPane.showMessageDialog(dialogOwner, aboutString, ToolsRes.getString("Diagnostics.OS.About.Title"), 1);
    }

    public static void main(String[] args) {
        Diagnostics.aboutJava();
    }
}

