/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.core;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.SwingUtilities;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display.Data;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.display.InteractivePanel;
import org.opensourcephysics.display.TextPanel;
import org.opensourcephysics.media.core.DataTrack;
import org.opensourcephysics.media.core.Filter;
import org.opensourcephysics.media.core.ImageCoordSystem;
import org.opensourcephysics.media.core.Trackable;
import org.opensourcephysics.media.core.VidCartesianCoordinateStringBuilder;
import org.opensourcephysics.media.core.Video;
import org.opensourcephysics.media.core.VideoClip;
import org.opensourcephysics.media.core.VideoPlayer;

public class VideoPanel
extends InteractivePanel
implements PropertyChangeListener {
    protected static int defaultWidth = 640;
    protected static int defaultHeight = 480;
    public boolean changed = false;
    public String defaultFileName;
    protected VideoPlayer player;
    protected TextPanel mousePanel;
    protected TextPanel messagePanel;
    protected Video video = null;
    protected boolean playerVisible = true;
    protected boolean drawingInImageSpace = false;
    protected double imageWidth;
    protected double imageHeight;
    protected double xOffset;
    protected double yOffset;
    protected double imageBorder;
    protected ImageCoordSystem coords;
    protected Point2D pt = new Point2D.Double();
    protected File dataFile;
    protected Map<String, Class<? extends Filter>> filterClasses = new TreeMap<String, Class<? extends Filter>>();

    public VideoPanel() {
        this((Video)null);
    }

    public VideoPanel(Video video2) {
        this.setSquareAspect(true);
        this.player = new VideoPlayer(this);
        this.player.addPropertyChangeListener("videoclip", this);
        this.player.addPropertyChangeListener("stepnumber", this);
        this.player.addPropertyChangeListener("frameduration", this);
        this.add((Component)this.player, "South");
        VideoClip clip = this.player.getVideoClip();
        clip.addPropertyChangeListener("startframe", this);
        clip.addPropertyChangeListener("stepsize", this);
        clip.addPropertyChangeListener("stepcount", this);
        clip.addPropertyChangeListener("framecount", this);
        clip.addPropertyChangeListener("starttime", this);
        clip.addPropertyChangeListener("adjusting", this);
        this.mousePanel = this.blMessageBox;
        this.messagePanel = this.brMessageBox;
        this.setCoordinateStringBuilder(new VidCartesianCoordinateStringBuilder());
        this.coords = new ImageCoordSystem();
        this.setVideo(video2);
        if (video2 != null && video2.getImage().getWidth() > 0) {
            this.setImageWidth(video2.getImage().getWidth());
            this.setImageHeight(video2.getImage().getHeight());
        } else {
            this.setImageWidth(defaultWidth);
            this.setImageHeight(defaultHeight);
        }
        int w = (int)this.getImageWidth();
        int h = (int)this.getImageHeight();
        this.setPreferredSize(new Dimension(w, h + this.player.height));
        this.coords.setAllOriginsXY(this.imageWidth / 2.0, this.imageHeight / 2.0);
    }

    public void setVideo(Video newVideo, boolean playAllSteps) {
        if (newVideo == this.video) {
            return;
        }
        Video prev = this.video;
        VideoClip clip = new VideoClip(newVideo);
        clip.setPlayAllSteps(playAllSteps);
        this.getPlayer().setVideoClip(clip);
        if (prev != null) {
            prev.dispose();
        }
    }

    public void setVideo(Video newVideo) {
        this.setVideo(newVideo, false);
    }

    public Video getVideo() {
        return this.video;
    }

    public double getImageWidth() {
        return this.imageWidth;
    }

    public void setImageWidth(double w) {
        BufferedImage vidImage;
        if (this.video != null && (vidImage = this.video.getImage()) != null) {
            w = Math.max(w, (double)vidImage.getWidth());
        }
        this.imageWidth = w;
    }

    public double getImageHeight() {
        return this.imageHeight;
    }

    public void setImageHeight(double h) {
        BufferedImage vidImage;
        if (this.video != null && (vidImage = this.video.getImage()) != null) {
            h = Math.max(h, (double)vidImage.getHeight());
        }
        this.imageHeight = h;
    }

    public double getImageBorder() {
        return this.imageBorder;
    }

    public void setImageBorder(double borderFraction) {
        this.imageBorder = borderFraction;
    }

    public void setCoords(ImageCoordSystem newCoords) {
        if (this.video != null) {
            this.video.setCoords(newCoords);
        } else {
            this.coords = newCoords;
        }
    }

    public ImageCoordSystem getCoords() {
        return this.coords;
    }

    public void setDataFile(File file) {
        File prev = this.dataFile;
        this.dataFile = file;
        if (file != null) {
            this.defaultFileName = XML.forwardSlash(file.getName());
        }
        this.firePropertyChange("datafile", prev, this.dataFile);
        OSPLog.fine("Data file: " + file);
    }

    public File getDataFile() {
        return this.dataFile;
    }

    public String getFilePath() {
        return this.defaultFileName;
    }

    public void setDrawingInImageSpace(boolean imagespace) {
        this.drawingInImageSpace = imagespace;
        if (imagespace) {
            this.setAutoscaleX(false);
            this.setAutoscaleY(false);
        } else {
            this.setAutoscaleX(true);
            this.setAutoscaleY(true);
        }
        this.firePropertyChange("imagespace", null, new Boolean(imagespace));
        this.repaint();
    }

    public boolean isDrawingInImageSpace() {
        return this.drawingInImageSpace;
    }

    public VideoPlayer getPlayer() {
        return this.player;
    }

    public void setPlayerVisible(final boolean visible) {
        if (visible == this.playerVisible) {
            return;
        }
        Runnable setPlayerVis = new Runnable(){

            @Override
            public void run() {
                VideoPanel.this.playerVisible = visible;
                if (VideoPanel.this.playerVisible) {
                    VideoPanel.this.add((Component)VideoPanel.this.player, "South");
                } else {
                    VideoPanel.this.remove(VideoPanel.this.player);
                }
                VideoPanel.this.repaint();
            }
        };
        SwingUtilities.invokeLater(setPlayerVis);
    }

    public boolean isPlayerVisible() {
        return this.playerVisible;
    }

    public int getStepNumber() {
        return this.getPlayer().getStepNumber();
    }

    public int getFrameNumber() {
        return this.getPlayer().getFrameNumber();
    }

    @Override
    public ArrayList<Drawable> getDrawables() {
        ArrayList<Drawable> list = super.getDrawables();
        if (this.isDrawingInImageSpace()) {
            for (Drawable d : list) {
                if (Trackable.class.isInstance(d)) continue;
                list.remove(d);
            }
        }
        return list;
    }

    @Override
    public synchronized void addDrawable(Drawable drawable) {
        if (drawable == null) {
            return;
        }
        if (drawable instanceof Video) {
            this.setVideo((Video)drawable);
        } else {
            super.addDrawable(drawable);
        }
        this.repaint();
    }

    @Override
    public synchronized void removeDrawable(Drawable drawable) {
        if (drawable == this.video) {
            this.setVideo(null);
        } else {
            super.removeDrawable(drawable);
        }
    }

    @Override
    public synchronized <T extends Drawable> void removeObjectsOfClass(Class<T> c) {
        if (this.video.getClass() == c) {
            this.setVideo(null);
        } else {
            super.removeObjectsOfClass(c);
        }
    }

    @Override
    public synchronized void clear() {
        super.clear();
        if (this.video != null) {
            super.addDrawable(this.video);
        }
    }

    public void addFilter(Class<? extends Filter> filterClass) {
        if (Filter.class.isAssignableFrom(filterClass)) {
            String name = filterClass.getName();
            this.filterClasses.put(name, filterClass);
        }
    }

    public void removeFilter(Class<?> filterClass) {
        if (Filter.class.isAssignableFrom(filterClass)) {
            String name = filterClass.getName();
            this.filterClasses.remove(name);
        }
    }

    public Map<String, Class<? extends Filter>> getFilters() {
        return this.filterClasses;
    }

    public boolean isShowCoordinates() {
        return this.showCoordinates;
    }

    public void hideMouseBox() {
        if (this.mousePanel.isVisible()) {
            this.mousePanel.setText(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String name = e.getPropertyName();
        if (name.equals("size")) {
            Dimension dim = (Dimension)e.getNewValue();
            this.setImageWidth(dim.width);
            this.setImageHeight(dim.height);
        } else if (name.equals("coords")) {
            this.coords = this.video.getCoords();
        } else if (name.equals("image") || name.equals("videoVisible")) {
            this.repaint();
        } else if (name.equals("stepnumber")) {
            this.repaint();
        } else if (name.equals("videoclip")) {
            VideoClip oldClip = (VideoClip)e.getOldValue();
            oldClip.removePropertyChangeListener("startframe", this);
            oldClip.removePropertyChangeListener("stepsize", this);
            oldClip.removePropertyChangeListener("stepcount", this);
            oldClip.removePropertyChangeListener("framecount", this);
            oldClip.removePropertyChangeListener("starttime", this);
            oldClip.removePropertyChangeListener("adjusting", this);
            VideoClip clip = (VideoClip)e.getNewValue();
            clip.addPropertyChangeListener("startframe", this);
            clip.addPropertyChangeListener("stepsize", this);
            clip.addPropertyChangeListener("stepcount", this);
            clip.addPropertyChangeListener("framecount", this);
            clip.addPropertyChangeListener("starttime", this);
            clip.addPropertyChangeListener("adjusting", this);
            if (this.video != null) {
                this.video.removePropertyChangeListener("coords", this);
                this.video.removePropertyChangeListener("image", this);
                this.video.removePropertyChangeListener("filterChanged", this);
                this.video.removePropertyChangeListener("videoVisible", this);
                this.video.removePropertyChangeListener("size", this);
                super.removeDrawable(this.video);
            }
            this.video = clip.getVideo();
            if (this.video != null) {
                this.video.addPropertyChangeListener("coords", this);
                this.video.addPropertyChangeListener("image", this);
                this.video.addPropertyChangeListener("filterChanged", this);
                this.video.addPropertyChangeListener("videoVisible", this);
                this.video.addPropertyChangeListener("size", this);
                if (this.video.isMeasured()) {
                    this.coords = this.video.getCoords();
                } else {
                    this.video.setCoords(this.coords);
                }
                ArrayList arrayList = this.drawableList;
                synchronized (arrayList) {
                    this.drawableList.add(0, this.video);
                }
                BufferedImage vidImage = this.video.getImage();
                if (vidImage != null) {
                    this.setImageWidth(vidImage.getWidth());
                    this.setImageHeight(vidImage.getHeight());
                }
            }
            this.repaint();
        }
    }

    public DataTrack importData(Data data, Object source) {
        return null;
    }

    @Override
    protected void paintEverything(Graphics g) {
        if (this.playerVisible) {
            this.bottomGutter += this.player.height;
        }
        super.paintEverything(g);
        if (this.playerVisible) {
            this.bottomGutter -= this.player.height;
        }
    }

    @Override
    protected void scale(ArrayList<Drawable> drawables) {
        if (this.drawingInImageSpace) {
            this.xminPreferred = -this.imageBorder * this.imageWidth + this.xOffset;
            this.xmaxPreferred = this.imageWidth + this.imageBorder * this.imageWidth + this.xOffset;
            this.yminPreferred = this.imageHeight + this.imageBorder * this.imageHeight + this.yOffset;
            this.ymaxPreferred = -this.imageBorder * this.imageHeight + this.yOffset;
        }
        super.scale(drawables);
    }

    protected boolean checkImage() {
        Dimension d = this.getSize();
        if (this.playerVisible) {
            d.height -= this.player.height;
        }
        if (d.width <= 2 || d.height <= 2) {
            return false;
        }
        if (this.offscreenImage == null || d.width != this.offscreenImage.getWidth() || d.height != this.offscreenImage.getHeight()) {
            this.offscreenImage = new BufferedImage(d.width, d.height, 1);
        }
        return this.offscreenImage != null;
    }

    public Point2D getWorldMousePoint() {
        this.pt.setLocation(this.getMouseX(), this.getMouseY());
        if (this.isDrawingInImageSpace()) {
            int n = this.getFrameNumber();
            AffineTransform toWorld = this.getCoords().getToWorldTransform(n);
            toWorld.transform(this.pt, this.pt);
        }
        return this.pt;
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    static class Loader
    implements XML.ObjectLoader {
        Loader() {
        }

        @Override
        public void saveObject(XMLControl control, Object obj) {
            VideoPanel vidPanel = (VideoPanel)obj;
            control.setValue("videoclip", vidPanel.getPlayer().getVideoClip());
            control.setValue("coords", vidPanel.getCoords());
            ArrayList<Drawable> list = vidPanel.getDrawables();
            list.remove(vidPanel.getVideo());
            if (!list.isEmpty()) {
                control.setValue("drawables", list);
            }
        }

        @Override
        public Object createObject(XMLControl control) {
            return new VideoPanel();
        }

        @Override
        public Object loadObject(XMLControl control, Object obj) {
            VideoPanel vidPanel = (VideoPanel)obj;
            VideoClip clip = (VideoClip)control.getObject("videoclip");
            if (clip != null) {
                vidPanel.getPlayer().setVideoClip(clip);
            }
            vidPanel.setCoords((ImageCoordSystem)control.getObject("coords"));
            Collection drawables = (Collection)control.getObject("drawables");
            if (drawables != null) {
                Iterator it = drawables.iterator();
                while (it.hasNext()) {
                    vidPanel.addDrawable((Drawable)it.next());
                }
            }
            return obj;
        }
    }
}

