/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.drawing2d;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Paint;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.opensourcephysics.display.Data;
import org.opensourcephysics.display.Dataset;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.drawing2d.Element;
import org.opensourcephysics.drawing2d.ElementTrail;

public class Group
extends Element
implements Data {
    private ArrayList<Element> elementList = new ArrayList();
    private int elementInteracted = -1;
    protected int datasetID = this.hashCode();

    public void clear() {
        for (Element el : this.getElements()) {
            if (!(el instanceof ElementTrail)) continue;
            ((ElementTrail)el).clear();
        }
    }

    public void initialize() {
        for (Element el : this.getElements()) {
            if (!(el instanceof ElementTrail)) continue;
            ((ElementTrail)el).initialize();
        }
    }

    public void addElement(Element element) {
        if (!this.elementList.contains(element)) {
            this.elementList.add(element);
        }
        element.setGroup(this);
    }

    public void addElementAtIndex(int index, Element element) {
        if (!this.elementList.contains(element)) {
            index = Math.max(index, this.elementList.size() - 1);
            this.elementList.add(index, element);
        }
        element.setGroup(this);
    }

    public void addElements(Collection<Element> elements) {
        if (elements != null) {
            for (Element el : elements) {
                this.addElement(el);
            }
        }
    }

    public void removeElement(Element element) {
        this.elementList.remove(element);
        element.setGroup(null);
    }

    public void removeAllElements() {
        for (Element element : this.elementList) {
            element.setGroup(null);
        }
        this.elementList.clear();
    }

    public synchronized List<Element> getElements() {
        return (List)this.elementList.clone();
    }

    public Element getElement(int index) {
        try {
            return this.elementList.get(index);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    @Override
    public void setID(int id) {
        this.datasetID = id;
    }

    @Override
    public int getID() {
        return this.datasetID;
    }

    @Override
    public double[][] getData2D() {
        return null;
    }

    @Override
    public double[][][] getData3D() {
        return null;
    }

    @Override
    public String[] getColumnNames() {
        for (Element el : this.getElements()) {
            if (!(el instanceof Data)) continue;
            return ((Data)((Object)el)).getColumnNames();
        }
        return null;
    }

    @Override
    public Color[] getLineColors() {
        return new Color[]{Color.BLACK, this.getStyle().getLineColor()};
    }

    @Override
    public Color[] getFillColors() {
        Paint fill = this.getStyle().getFillColor();
        if (fill instanceof Color) {
            return new Color[]{Color.BLACK, (Color)fill};
        }
        return new Color[]{Color.BLACK, Color.BLUE};
    }

    @Override
    public List<Data> getDataList() {
        ArrayList<Data> list = new ArrayList<Data>();
        for (Element el : this.getElements()) {
            if (!(el instanceof Data)) continue;
            list.add((Data)((Object)el));
        }
        return list;
    }

    @Override
    public ArrayList<Dataset> getDatasets() {
        return null;
    }

    @Override
    public boolean hasChanged() {
        if (super.hasChanged()) {
            return true;
        }
        for (Element el : this.getElements()) {
            if (!el.hasChanged()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void draw(DrawingPanel _panel, Graphics _g) {
        for (Element el : this.getElements()) {
            el.draw(_panel, _g);
        }
    }

    @Override
    public void setNeedToProject(boolean _need) {
        for (Element el : this.getElements()) {
            el.setNeedToProject(_need);
        }
    }

    @Override
    public boolean isMeasured() {
        if (!super.isMeasured()) {
            return false;
        }
        for (Element el : this.getElements()) {
            if (!el.isMeasured()) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void updateExtrema() {
        if (!this.hasChanged()) {
            return;
        }
        this.initExtrema();
        for (Element el : this.getElements()) {
            if (!el.isMeasured()) continue;
            double minx = el.getXMin();
            double maxx = el.getXMax();
            double miny = el.getYMin();
            double maxy = el.getYMax();
            this.compareToExtrema(minx, miny);
            this.compareToExtrema(maxx, miny);
            this.compareToExtrema(maxx, maxy);
            this.compareToExtrema(minx, maxy);
            double logminx = el.getXMinLogscale();
            double logmaxx = el.getXMaxLogscale();
            double logminy = el.getYMinLogscale();
            double logmaxy = el.getYMaxLogscale();
            this.compareToLogExtrema(logminx, logminy);
            this.compareToLogExtrema(logmaxx, logminy);
            this.compareToLogExtrema(logmaxx, logmaxy);
            this.compareToLogExtrema(logminx, logmaxy);
        }
    }

    public int getInteractedIndex() {
        return this.elementInteracted;
    }

    @Override
    public Interactive findInteractive(DrawingPanel _panel, int _xpix, int _ypix) {
        if (!this.isReallyVisible()) {
            return null;
        }
        List<Element> elList = this.getElements();
        int i = elList.size() - 1;
        while (i >= 0) {
            Interactive target = elList.get(i).findInteractive(_panel, _xpix, _ypix);
            if (target != null) {
                this.elementInteracted = i;
                return target;
            }
            --i;
        }
        return null;
    }
}

