/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.drawing2d;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.util.ArrayList;
import java.util.List;
import org.opensourcephysics.display.Data;
import org.opensourcephysics.display.Dataset;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.drawing2d.Element;
import org.opensourcephysics.drawing2d.Style;

public class ElementTrail
extends Element
implements Data {
    public static final int NO_CONNECTION = 0;
    public static final int LINE_CONNECTION = 1;
    private static TrailPoint nullPoint = new TrailPoint(Double.NaN, Double.NaN, 1);
    private int maximum = 0;
    private int connectionType = 1;
    private boolean active = true;
    private boolean noRepeat = false;
    private boolean clearAtInput = false;
    private int skip = 0;
    private String[] inputLabels = new String[]{"x", "y"};
    private List<TrailPoint> currentList = new ArrayList<TrailPoint>();
    private GeneralPath currentPath = new GeneralPath();
    private PathAndStyle currentSegment = new PathAndStyle(this, null, 0, this.currentList);
    private List<PathAndStyle> segmentList = new ArrayList<PathAndStyle>();
    private TrailPoint flushPoint = nullPoint;
    private boolean isEmpty = true;
    private int counter = 0;
    private double lastX = Double.NaN;
    private double lastY = Double.NaN;
    private int dataID = this.hashCode();

    public void setActive(boolean _active) {
        this.active = _active;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setNoRepeat(boolean _noRepeat) {
        this.noRepeat = _noRepeat;
    }

    public boolean isNoRepeat() {
        return this.noRepeat;
    }

    public void setClearAtInput(boolean _clear) {
        this.clearAtInput = _clear;
    }

    public boolean isClearAtInput() {
        return this.clearAtInput;
    }

    public void setSkipPoints(int _skip) {
        if (this.skip != _skip) {
            this.skip = _skip;
            this.counter = 0;
        }
    }

    public int getSkipPoints() {
        return this.skip;
    }

    public void setXLabel(String _label) {
        this.inputLabels[0] = _label;
    }

    public void setYLabel(String _label) {
        this.inputLabels[1] = _label;
    }

    public void addPoint(double x, double y) {
        if (this.clearAtInput) {
            this.initialize();
        }
        this.addPoint(x, y, this.connectionType);
    }

    public void addPoint(double[] point) {
        if (this.clearAtInput) {
            this.initialize();
        }
        this.addPoint(point[0], point[1], this.connectionType);
    }

    public void moveToPoint(double x, double y) {
        if (this.clearAtInput) {
            this.initialize();
        }
        this.addPoint(x, y, 0);
    }

    public void moveToPoint(double[] point) {
        if (this.clearAtInput) {
            this.initialize();
        }
        this.addPoint(point[0], point[1], 0);
    }

    public void addPoints(double[][] input) {
        if (this.clearAtInput) {
            this.initialize();
        }
        int i = 0;
        int n = input.length;
        while (i < n) {
            this.addPoint(input[i][0], input[i][1], this.connectionType);
            ++i;
        }
    }

    public void addPoints(double[] x, double y) {
        if (this.clearAtInput) {
            this.initialize();
        }
        int i = 0;
        int n = x.length;
        while (i < n) {
            this.addPoint(x[i], y, this.connectionType);
            ++i;
        }
    }

    public void addPoints(double x, double[] y) {
        if (this.clearAtInput) {
            this.initialize();
        }
        int i = 0;
        int n = y.length;
        while (i < n) {
            this.addPoint(x, y[i], this.connectionType);
            ++i;
        }
    }

    public void addPoints(double[] xInput, double[] yInput) {
        if (this.clearAtInput) {
            this.initialize();
        }
        int n = Math.min(xInput.length, yInput.length);
        int i = 0;
        while (i < n) {
            this.addPoint(xInput[i], yInput[i], this.connectionType);
            ++i;
        }
    }

    public void setMaximumPoints(int maximum) {
        this.maximum = Math.max(maximum, 0);
    }

    public int getMaximumPoints() {
        return this.maximum;
    }

    public void setConnectionType(int type) {
        this.connectionType = type;
    }

    public int getConnectionType() {
        return this.connectionType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        List<PathAndStyle> list = this.segmentList;
        synchronized (list) {
            this.segmentList.clear();
        }
        this.currentSegment.index = 0;
        this.initialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() {
        List<TrailPoint> list = this.currentList;
        synchronized (list) {
            this.currentList.clear();
            this.currentPath.reset();
            this.flushPoint = nullPoint;
            this.isEmpty = true;
            this.counter = 0;
            this.lastX = Double.NaN;
            this.lastY = Double.NaN;
            this.setNeedToProject(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void newSegment() {
        TrailPoint extraPoint = null;
        TrailPoint trailPoint = this.flushPoint;
        synchronized (trailPoint) {
            if (this.flushPoint != nullPoint) {
                extraPoint = new TrailPoint(this.flushPoint.x, this.flushPoint.y, this.flushPoint.type);
            }
        }
        if (extraPoint != null) {
            this.currentList.add(extraPoint);
            int type = this.isEmpty ? 0 : extraPoint.type;
            switch (type) {
                default: {
                    this.currentPath.lineTo((float)extraPoint.x, (float)extraPoint.y);
                    break;
                }
                case 0: {
                    this.currentPath.moveTo((float)extraPoint.x, (float)extraPoint.y);
                    this.currentPath.lineTo((float)extraPoint.x, (float)extraPoint.y);
                }
            }
        }
        List<TrailPoint> list = this.currentList;
        synchronized (list) {
            this.segmentList.add(new PathAndStyle(this, this.currentPath, this.segmentList.size(), this.currentList));
            this.currentList = new ArrayList<TrailPoint>();
            this.currentPath = new GeneralPath();
            this.currentSegment.pointsList = this.currentList;
            this.currentSegment.path = this.currentPath;
            PathAndStyle pathAndStyle = this.currentSegment;
            pathAndStyle.index = pathAndStyle.index + 1;
            this.flushPoint = nullPoint;
            this.isEmpty = true;
            this.counter = 0;
            this.lastX = Double.NaN;
            this.lastY = Double.NaN;
        }
    }

    @Override
    public void setID(int id) {
        this.dataID = id;
    }

    @Override
    public int getID() {
        return this.dataID;
    }

    @Override
    public double[][] getData2D() {
        return null;
    }

    @Override
    public double[][][] getData3D() {
        return null;
    }

    @Override
    public String[] getColumnNames() {
        return this.inputLabels;
    }

    @Override
    public Color[] getLineColors() {
        return new Color[]{Color.BLACK, this.getStyle().getLineColor()};
    }

    @Override
    public Color[] getFillColors() {
        Paint fill = this.getStyle().getFillColor();
        if (fill instanceof Color) {
            return new Color[]{Color.BLACK, (Color)fill};
        }
        return new Color[]{Color.BLACK, Color.BLUE};
    }

    @Override
    public List<Data> getDataList() {
        ArrayList<Data> dataList = new ArrayList<Data>();
        dataList.addAll(this.segmentList);
        int n = this.segmentList.size();
        this.currentSegment.update(this.getCurrentSegmentPath(), n > 0 ? n + 1 : -1);
        dataList.add(this.currentSegment);
        return dataList;
    }

    @Override
    public ArrayList<Dataset> getDatasets() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GeneralPath getCurrentSegmentPath() {
        TrailPoint extraPoint = null;
        TrailPoint trailPoint = this.flushPoint;
        synchronized (trailPoint) {
            if (this.flushPoint != nullPoint) {
                extraPoint = new TrailPoint(this.flushPoint.x, this.flushPoint.y, this.flushPoint.type);
            }
        }
        if (extraPoint == null) {
            return this.currentPath;
        }
        GeneralPath path = new GeneralPath(this.currentPath);
        int type = this.isEmpty ? 0 : extraPoint.type;
        switch (type) {
            default: {
                path.lineTo((float)extraPoint.x, (float)extraPoint.y);
                break;
            }
            case 0: {
                path.moveTo((float)extraPoint.x, (float)extraPoint.y);
                path.lineTo((float)extraPoint.x, (float)extraPoint.y);
            }
        }
        return path;
    }

    @Override
    public void draw(DrawingPanel _panel, Graphics _g) {
        if (!this.isReallyVisible()) {
            return;
        }
        Graphics2D g2 = (Graphics2D)_g;
        for (PathAndStyle pas : this.segmentList) {
            Color color = pas.style.getLineColor();
            if (color == null) continue;
            g2.setStroke(pas.style.getLineStroke());
            g2.setColor(color);
            Shape trShape = this.getPixelTransform(_panel).createTransformedShape(pas.path);
            g2.draw(trShape);
        }
        Color color = this.getStyle().getLineColor();
        if (color == null) {
            return;
        }
        g2.setStroke(this.getStyle().getLineStroke());
        g2.setColor(color);
        Shape trShape = this.getPixelTransform(_panel).createTransformedShape(this.getCurrentSegmentPath());
        g2.draw(trShape);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Interactive findInteractive(DrawingPanel _panel, int _xpix, int _ypix) {
        if (!this.targetPosition.isEnabled()) {
            return null;
        }
        if (!this.isReallyVisible()) {
            return null;
        }
        if (this.hasChanged() || this.needsToProject()) {
            this.projectPoints(_panel);
        }
        int sensitivity = this.getStyle().getSensitivity();
        if (this.targetPosition.isEnabled()) {
            for (PathAndStyle pas : this.segmentList) {
                for (TrailPoint point : pas.pointsList) {
                    if (!(Math.abs(point.pixel[0] - (double)_xpix) < (double)sensitivity) || !(Math.abs(point.pixel[1] - (double)_ypix) < (double)sensitivity)) continue;
                    return this.targetPosition;
                }
            }
            for (TrailPoint point : this.currentList) {
                if (!(Math.abs(point.pixel[0] - (double)_xpix) < (double)sensitivity) || !(Math.abs(point.pixel[1] - (double)_ypix) < (double)sensitivity)) continue;
                return this.targetPosition;
            }
            TrailPoint trailPoint = this.flushPoint;
            synchronized (trailPoint) {
                if (this.flushPoint != nullPoint && Math.abs(this.flushPoint.pixel[0] - (double)_xpix) < (double)sensitivity && Math.abs(this.flushPoint.pixel[1] - (double)_ypix) < (double)sensitivity) {
                    return this.targetPosition;
                }
            }
        }
        return null;
    }

    @Override
    public boolean isMeasured() {
        return (!this.currentList.isEmpty() || !this.segmentList.isEmpty()) && super.getCanBeMeasured();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void updateExtrema() {
        if (!this.hasChanged()) {
            return;
        }
        this.initExtrema();
        double[] aPoint = new double[2];
        for (PathAndStyle pas : this.segmentList) {
            for (TrailPoint point : pas.pointsList) {
                aPoint[0] = point.x;
                aPoint[1] = point.y;
                this.getTotalTransform().transform(aPoint, 0, aPoint, 0, 1);
                if (Double.isNaN(aPoint[0]) || Double.isNaN(aPoint[1])) continue;
                this.compareToAllExtrema(aPoint[0], aPoint[1]);
            }
        }
        for (TrailPoint point : this.currentList) {
            aPoint[0] = point.x;
            aPoint[1] = point.y;
            this.getTotalTransform().transform(aPoint, 0, aPoint, 0, 1);
            if (Double.isNaN(aPoint[0]) || Double.isNaN(aPoint[1])) continue;
            this.compareToAllExtrema(aPoint[0], aPoint[1]);
        }
        boolean hasFlush = false;
        TrailPoint trailPoint = this.flushPoint;
        synchronized (trailPoint) {
            if (this.flushPoint != nullPoint) {
                aPoint[0] = this.flushPoint.x;
                aPoint[1] = this.flushPoint.y;
                hasFlush = true;
            }
        }
        if (hasFlush) {
            this.getTotalTransform().transform(aPoint, 0, aPoint, 0, 1);
            if (!Double.isNaN(aPoint[0]) && !Double.isNaN(aPoint[1])) {
                this.compareToAllExtrema(aPoint[0], aPoint[1]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void projectPoints(DrawingPanel _panel) {
        AffineTransform tr = this.getPixelTransform(_panel);
        for (PathAndStyle pas : this.segmentList) {
            for (TrailPoint point : pas.pointsList) {
                point.project(tr);
            }
        }
        for (TrailPoint point : this.currentList) {
            point.project(tr);
        }
        TrailPoint trailPoint = this.flushPoint;
        synchronized (trailPoint) {
            if (this.flushPoint != nullPoint) {
                this.flushPoint.project(tr);
            }
        }
        this.setNeedToProject(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPoint(double _x, double _y, int _type) {
        if (Double.isNaN(_x) || Double.isNaN(_y)) {
            this.isEmpty = true;
            return;
        }
        if (this.noRepeat && this.lastX == _x && this.lastY == _y) {
            return;
        }
        if (this.skip > 0) {
            if (this.counter > 0) {
                ++this.counter;
                if (this.counter >= this.skip) {
                    this.counter = 0;
                }
                this.flushPoint = new TrailPoint(_x, _y, _type);
                this.lastX = _x;
                this.lastY = _y;
                return;
            }
            ++this.counter;
        }
        this.flushPoint = nullPoint;
        List<TrailPoint> list = this.currentList;
        synchronized (list) {
            this.lastX = _x;
            this.lastY = _y;
            int size = this.currentList.size();
            if (this.maximum > 2 && size >= this.maximum) {
                this.currentList.remove(0);
                GeneralPath generalPath = this.currentPath;
                synchronized (generalPath) {
                    this.currentPath.reset();
                    TrailPoint initialPoint = this.currentList.get(0);
                    this.currentPath.moveTo((float)initialPoint.x, (float)initialPoint.y);
                    this.currentPath.lineTo((float)initialPoint.x, (float)initialPoint.y);
                    for (TrailPoint point : this.currentList) {
                        switch (point.type) {
                            default: {
                                this.currentPath.lineTo((float)point.x, (float)point.y);
                                break;
                            }
                            case 0: {
                                this.currentPath.moveTo((float)point.x, (float)point.y);
                                this.currentPath.lineTo((float)point.x, (float)point.y);
                            }
                        }
                    }
                }
            }
            TrailPoint point = new TrailPoint(_x, _y, _type);
            this.currentList.add(point);
            GeneralPath generalPath = this.currentPath;
            synchronized (generalPath) {
                if (this.isEmpty) {
                    this.currentPath.moveTo((float)_x, (float)_y);
                    this.currentPath.lineTo((float)_x, (float)_y);
                } else {
                    switch (point.type) {
                        default: {
                            this.currentPath.lineTo((float)_x, (float)_y);
                            break;
                        }
                        case 0: {
                            this.currentPath.moveTo((float)_x, (float)_y);
                            this.currentPath.lineTo((float)_x, (float)_y);
                        }
                    }
                }
            }
            this.isEmpty = false;
            this.setElementChanged();
        }
    }

    private static class PathAndStyle
    implements Data {
        private ElementTrail trail;
        private GeneralPath path;
        private Style style;
        private List<TrailPoint> pointsList;
        private int index;
        private int id = this.hashCode();

        PathAndStyle(ElementTrail _trail, GeneralPath _path, int _index, List<TrailPoint> _pointsList) {
            this.trail = _trail;
            this.path = _path;
            this.style = _trail.getStyle().clone();
            this.index = _index;
            this.pointsList = _pointsList;
        }

        void update(GeneralPath _path, int _index) {
            this.path = _path;
            this.style = this.trail.getStyle().clone();
        }

        @Override
        public String getName() {
            return this.trail.getName();
        }

        @Override
        public void setID(int _id) {
            this.id = _id;
        }

        @Override
        public int getID() {
            return this.id;
        }

        @Override
        public double[][] getData2D() {
            int n = this.pointsList.size();
            double[][] data = new double[2][n];
            int i = 0;
            while (i < n) {
                TrailPoint point = this.pointsList.get(i);
                data[0][i] = point.x;
                data[1][i] = point.y;
                ++i;
            }
            return data;
        }

        @Override
        public double[][][] getData3D() {
            return null;
        }

        @Override
        public String[] getColumnNames() {
            return this.trail.inputLabels;
        }

        @Override
        public Color[] getLineColors() {
            return new Color[]{Color.BLACK, this.style.getLineColor()};
        }

        @Override
        public Color[] getFillColors() {
            Paint fill = this.style.getFillColor();
            if (fill instanceof Color) {
                return new Color[]{Color.BLACK, (Color)fill};
            }
            return new Color[]{Color.BLACK, Color.BLUE};
        }

        @Override
        public List<Data> getDataList() {
            return null;
        }

        @Override
        public ArrayList<Dataset> getDatasets() {
            return null;
        }
    }

    private static class TrailPoint {
        private int type;
        private double x;
        private double y;
        private double[] pixel = new double[2];

        TrailPoint(double _x, double _y, int _type) {
            this.x = _x;
            this.y = _y;
            this.type = _type;
        }

        void project(AffineTransform tr) {
            this.pixel[0] = this.x;
            this.pixel[1] = this.y;
            tr.transform(this.pixel, 0, this.pixel, 0, 1);
        }
    }
}

