/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display2d;

import java.awt.Color;
import java.awt.Dimension;
import javax.swing.JFrame;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLLoader;
import org.opensourcephysics.display.DisplayRes;
import org.opensourcephysics.display.InteractivePanel;
import org.opensourcephysics.display.axes.XAxis;
import org.opensourcephysics.display2d.GridPlot;
import org.opensourcephysics.display2d.GridPointData;
import org.opensourcephysics.display2d.ZExpansion;

public class ColorMapper {
    private static final int CUSTOM = -1;
    public static final int SPECTRUM = 0;
    public static final int GRAYSCALE = 1;
    public static final int DUALSHADE = 2;
    public static final int RED = 3;
    public static final int GREEN = 4;
    public static final int BLUE = 5;
    public static final int BLACK = 6;
    public static final int WIREFRAME = 7;
    public static final int NORENDER = 8;
    public static final int REDBLUE_SHADE = 9;
    private Color[] colors;
    private double floor;
    private double ceil;
    private Color floorColor = Color.darkGray;
    private Color ceilColor = Color.lightGray;
    private int numColors;
    private int paletteType;
    private JFrame legendFrame;
    protected ZExpansion zMap = null;

    public ColorMapper(int _numColors, double _floor, double _ceil, int palette) {
        this.floor = _floor;
        this.ceil = _ceil;
        this.numColors = _numColors;
        this.setPaletteType(palette);
    }

    public void updateLegend(ZExpansion zMap) {
        if (this.legendFrame != null && this.legendFrame.isVisible() && this.legendFrame.isDisplayable()) {
            if (zMap == null) {
                zMap = this.zMap;
            }
            this.showLegend(zMap);
        }
    }

    public JFrame getLegendFrame() {
        return this.legendFrame;
    }

    public JFrame showLegend() {
        if (this.zMap != null) {
            return this.showLegend(this.zMap);
        }
        InteractivePanel dp = new InteractivePanel();
        dp.setPreferredSize(new Dimension(300, 66));
        dp.setPreferredGutters(0, 0, 0, 35);
        dp.setClipAtGutter(false);
        if (this.legendFrame == null || !this.legendFrame.isDisplayable()) {
            this.legendFrame = new JFrame(DisplayRes.getString("GUIUtils.Legend"));
        }
        this.legendFrame.setDefaultCloseOperation(2);
        this.legendFrame.setResizable(false);
        this.legendFrame.setContentPane(dp);
        GridPointData pointdata = new GridPointData(this.numColors + 2, 1, 1);
        double[][][] data = pointdata.getData();
        double delta = (this.ceil - this.floor) / (double)this.numColors;
        double cval = this.floor - delta / 2.0;
        int i = 0;
        int n = data.length;
        while (i < n) {
            data[i][0][2] = cval;
            cval += delta;
            ++i;
        }
        pointdata.setScale(this.floor - delta, this.ceil + delta, 0.0, 1.0);
        GridPlot cb = new GridPlot(pointdata);
        cb.setShowGridLines(false);
        cb.setAutoscaleZ(false, this.floor, this.ceil);
        cb.setColorPalette(this.colors);
        cb.update();
        dp.addDrawable(cb);
        XAxis xaxis = new XAxis("");
        xaxis.setLocationType(2);
        xaxis.setLocation(-0.5);
        xaxis.setEnabled(true);
        dp.addDrawable(xaxis);
        this.legendFrame.pack();
        this.legendFrame.setVisible(true);
        return this.legendFrame;
    }

    JFrame showLegend(ZExpansion zMap) {
        if (zMap == null) {
            return this.showLegend();
        }
        InteractivePanel dp = new InteractivePanel();
        dp.setPreferredSize(new Dimension(300, 66));
        dp.setPreferredGutters(0, 0, 0, 35);
        dp.setClipAtGutter(false);
        if (this.legendFrame == null || !this.legendFrame.isDisplayable()) {
            this.legendFrame = new JFrame(DisplayRes.getString("GUIUtils.Legend"));
        }
        this.legendFrame.setDefaultCloseOperation(2);
        this.legendFrame.setResizable(true);
        this.legendFrame.setContentPane(dp);
        int numColors = 256;
        if (this.paletteType == -1) {
            numColors = this.colors.length;
        }
        GridPointData pointdata = new GridPointData(numColors + 2, 1, 1);
        double[][][] data = pointdata.getData();
        double delta = (this.ceil - this.floor) / (double)numColors;
        double cval = this.floor - delta / 2.0;
        int i = 0;
        int n = data.length;
        while (i < n) {
            data[i][0][2] = zMap.evaluate(cval);
            cval += delta;
            ++i;
        }
        pointdata.setScale(this.floor - delta, this.ceil + delta, 0.0, 1.0);
        GridPlot cb = new GridPlot(pointdata);
        cb.setShowGridLines(false);
        cb.setAutoscaleZ(false, this.floor, this.ceil);
        if (this.paletteType == -1) {
            cb.setColorPalette(this.colors);
        } else {
            cb.setPaletteType(this.paletteType);
        }
        cb.update();
        dp.addDrawable(cb);
        XAxis xaxis = new XAxis("");
        xaxis.setLocationType(2);
        xaxis.setLocation(-0.5);
        xaxis.setEnabled(true);
        dp.addDrawable(xaxis);
        this.legendFrame.pack();
        this.legendFrame.setVisible(true);
        return this.legendFrame;
    }

    public void setScale(double _floor, double _ceil) {
        this.floor = _floor;
        this.ceil = _ceil;
        if (this.zMap != null) {
            this.zMap.setMinMax(this.floor, this.ceil);
        }
    }

    public byte[] doubleToComponents(double value, byte[] rgb) {
        if (this.zMap != null) {
            value = this.zMap.evaluate(value);
        }
        Color color = this.doubleToColor(value);
        rgb[0] = (byte)color.getRed();
        rgb[1] = (byte)color.getGreen();
        rgb[2] = (byte)color.getBlue();
        return rgb;
    }

    public Color doubleToColor(double value) {
        int index = this.doubleToIndex(value);
        if (index < 0) {
            return this.floorColor;
        }
        if (index >= this.colors.length) {
            return this.ceilColor;
        }
        return this.colors[index];
    }

    public int doubleToIndex(double value) {
        if (this.zMap != null) {
            value = this.zMap.evaluate(value);
        }
        if ((float)this.floor - (float)value > Float.MIN_VALUE) {
            return -1;
        }
        if ((float)value - (float)this.ceil > Float.MIN_VALUE) {
            return this.colors.length;
        }
        int index = (int)((double)this.colors.length * (value - this.floor) / (this.ceil - this.floor));
        index = Math.max(0, index);
        return Math.min(index, this.colors.length - 1);
    }

    public Color indexToColor(int index) {
        if (index < 0) {
            return this.floorColor;
        }
        if (index >= this.colors.length) {
            return this.ceilColor;
        }
        return this.colors[index];
    }

    public double[] getColorThresholds() {
        double[] thresholds = new double[this.colors.length + 1];
        double delta = (this.ceil - this.floor) / (double)this.colors.length;
        int i = 0;
        int n = this.colors.length;
        while (i < n) {
            thresholds[i] = this.floor + (double)i * delta;
            ++i;
        }
        thresholds[this.colors.length] = this.ceil;
        return thresholds;
    }

    public void setZMap(ZExpansion map) {
        this.zMap = map;
        if (this.zMap != null) {
            this.zMap.setMinMax(this.floor, this.ceil);
        }
    }

    public double getFloor() {
        return this.floor;
    }

    public Color getFloorColor() {
        return this.floorColor;
    }

    public double getCeil() {
        return this.ceil;
    }

    public Color getCeilColor() {
        return this.ceilColor;
    }

    public int getNumColors() {
        return this.numColors;
    }

    public void setFloorCeilColor(Color _floorColor, Color _ceilColor) {
        this.floorColor = _floorColor;
        this.ceilColor = _ceilColor;
    }

    public int getPaletteType() {
        return this.paletteType;
    }

    public void setColorPalette(Color[] _colors) {
        this.floorColor = Color.darkGray;
        this.ceilColor = Color.lightGray;
        this.colors = _colors;
        this.numColors = this.colors.length;
        this.paletteType = -1;
    }

    public void setNumberOfColors(int _numColors) {
        if (_numColors == this.numColors) {
            return;
        }
        this.numColors = _numColors;
        if (this.paletteType == -1) {
            Color[] newColors = new Color[this.numColors];
            int i = 0;
            int n = Math.min(this.colors.length, this.numColors);
            while (i < n) {
                newColors[i] = this.colors[i];
                ++i;
            }
            i = this.colors.length;
            while (i < this.numColors) {
                newColors[i] = this.colors[this.colors.length - 1];
                ++i;
            }
            this.colors = newColors;
        } else {
            this.setPaletteType(this.paletteType);
        }
    }

    public void setPaletteType(int _paletteType) {
        this.paletteType = _paletteType;
        this.floorColor = Color.darkGray;
        this.ceilColor = Color.lightGray;
        if (this.paletteType == 1 || this.paletteType == 6) {
            this.floorColor = new Color(64, 64, 128);
            this.ceilColor = new Color(255, 191, 191);
        }
        this.colors = ColorMapper.getColorPalette(this.numColors, this.paletteType);
        this.numColors = Math.max(2, this.numColors);
    }

    public static Color[] getColorPalette(int numColors, int paletteType) {
        if (numColors < 2) {
            numColors = 2;
        }
        Color[] colors = new Color[numColors];
        int i = 0;
        while (i < numColors) {
            float level = (float)i / (float)(numColors - 1) * 0.8f;
            int r = 0;
            int b = 0;
            switch (paletteType) {
                case 9: {
                    r = Math.max(0, -numColors - 1 + i * 2) * 255 / (numColors - 1);
                    b = Math.max(0, numColors - 1 - i * 2) * 255 / (numColors - 1);
                    colors[i] = new Color(r, 0, b);
                    break;
                }
                case 0: {
                    level = 0.8f - level;
                    colors[i] = Color.getHSBColor(level, 1.0f, 1.0f);
                    break;
                }
                case 1: 
                case 6: {
                    colors[i] = new Color(i * 255 / (numColors - 1), i * 255 / (numColors - 1), i * 255 / (numColors - 1));
                    break;
                }
                case 3: {
                    colors[i] = new Color(i * 255 / (numColors - 1), 0, 0);
                    break;
                }
                case 4: {
                    colors[i] = new Color(0, i * 255 / (numColors - 1), 0);
                    break;
                }
                case 5: {
                    colors[i] = new Color(0, 0, i * 255 / (numColors - 1));
                    break;
                }
                default: {
                    level = (float)i / (float)(numColors - 1);
                    colors[i] = Color.getHSBColor(0.8f * (1.0f - level), 1.0f, 0.2f + 1.6f * Math.abs(0.5f - level));
                }
            }
            ++i;
        }
        return colors;
    }

    public static XML.ObjectLoader getLoader() {
        return new ColorMapperLoader();
    }

    private static class ColorMapperLoader
    extends XMLLoader {
        private ColorMapperLoader() {
        }

        @Override
        public void saveObject(XMLControl control, Object obj) {
            ColorMapper mapper = (ColorMapper)obj;
            control.setValue("palette type", mapper.paletteType);
            control.setValue("number of colors", mapper.numColors);
            control.setValue("floor", mapper.floor);
            control.setValue("ceiling", mapper.ceil);
            control.setValue("floor color", mapper.floorColor);
            control.setValue("ceiling color", mapper.ceilColor);
            if (mapper.paletteType == -1) {
                control.setValue("colors", mapper.colors);
            }
        }

        @Override
        public Object createObject(XMLControl control) {
            return new ColorMapper(100, -1.0, 1.0, 0);
        }

        @Override
        public Object loadObject(XMLControl control, Object obj) {
            ColorMapper mapper = (ColorMapper)obj;
            int paletteType = control.getInt("palette type");
            int numColors = control.getInt("number of colors");
            double floor = control.getDouble("floor");
            double ceil = control.getDouble("ceiling");
            if (paletteType == -1) {
                Color[] colors = (Color[])control.getObject("colors");
                mapper.setColorPalette(colors);
            } else {
                mapper.setPaletteType(paletteType);
                mapper.setNumberOfColors(numColors);
            }
            mapper.setScale(floor, ceil);
            Color floorColor = (Color)control.getObject("floor color");
            Color ceilColor = (Color)control.getObject("ceiling color");
            mapper.setFloorCeilColor(floorColor, ceilColor);
            return obj;
        }
    }
}

