/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display.axes;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.InputEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.event.MouseInputAdapter;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.display.PlottingPanel;
import org.opensourcephysics.display.Selectable;
import org.opensourcephysics.display.axes.CartesianType1;
import org.opensourcephysics.display.dialogs.DialogsRes;
import org.opensourcephysics.media.core.ScientificField;
import org.opensourcephysics.tools.FontSizer;
import org.opensourcephysics.tools.ResourceLoader;

public class CartesianInteractive
extends CartesianType1
implements Selectable {
    public static final int INSIDE = 0;
    public static final int HORZ_MIN = 1;
    public static final int HORZ_MAX = 2;
    public static final int VERT_MIN = 3;
    public static final int VERT_MAX = 4;
    public static final int HORZ_AXIS = 5;
    public static final int HORZ_AXIS_MIN = 6;
    public static final int HORZ_AXIS_MAX = 7;
    public static final int VERT_AXIS = 8;
    public static final int VERT_AXIS_MIN = 9;
    public static final int VERT_AXIS_MAX = 10;
    public static final int HORZ_VAR = 11;
    public static final int VERT_VAR = 12;
    Rectangle hitRect = new Rectangle();
    boolean drawHitRect;
    ScaleSetter scaleSetter;
    JPanel scaleSetterPanel;
    AxisMouseListener axisListener;
    int mouseRegion;
    Point mouseLoc;
    double mouseX;
    double mouseY;
    PlottingPanel plot;
    boolean enabled = true;
    boolean altDown;
    Cursor horzCenter;
    Cursor horzRight;
    Cursor horzLeft;
    Cursor vertCenter;
    Cursor vertUp;
    Cursor vertDown;
    Cursor move;
    List<ActionListener> axisListeners = new ArrayList<ActionListener>();

    public CartesianInteractive(PlottingPanel panel) {
        super(panel);
        this.plot = panel;
        this.axisListener = new AxisMouseListener();
        panel.addMouseListener(this.axisListener);
        panel.addMouseMotionListener(this.axisListener);
        panel.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (!CartesianInteractive.this.enabled) {
                    return;
                }
                if (CartesianInteractive.this.mouseRegion == 0 && !CartesianInteractive.this.drawingPanel.isFixedScale() && e.getKeyCode() == 18) {
                    CartesianInteractive.this.altDown = true;
                    CartesianInteractive.this.plot.setMouseCursor(CartesianInteractive.this.getPreferredCursor());
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (!CartesianInteractive.this.enabled) {
                    return;
                }
                if (e.getKeyCode() == 18) {
                    CartesianInteractive.this.altDown = false;
                    CartesianInteractive.this.plot.setMouseCursor(Cursor.getPredefinedCursor(1));
                }
            }
        });
        this.scaleSetter = new ScaleSetter();
        this.scaleSetterPanel = new JPanel(null);
        this.scaleSetterPanel.setOpaque(false);
        this.scaleSetterPanel.add(this.scaleSetter);
        this.plot.getGlassPanel().add((Component)this.scaleSetterPanel, "Center");
    }

    public int getMouseRegion() {
        return this.mouseRegion;
    }

    @Override
    public void draw(DrawingPanel panel, Graphics g) {
        super.draw(panel, g);
        if (this.drawHitRect) {
            g.drawRect(this.hitRect.x, this.hitRect.y, this.hitRect.width, this.hitRect.height);
        }
        if (!panel.isFixedScale() && this.scaleSetter.isVisible() && this.scaleSetter.scaleField.getBackground() != Color.yellow) {
            switch (this.scaleSetter.region) {
                case 1: {
                    this.scaleSetter.scaleField.setValue(this.drawingPanel.getXMin());
                    this.scaleSetter.autoscaleCheckbox.setSelected(this.drawingPanel.isAutoscaleXMin());
                    break;
                }
                case 2: {
                    this.scaleSetter.scaleField.setValue(this.drawingPanel.getXMax());
                    this.scaleSetter.autoscaleCheckbox.setSelected(this.drawingPanel.isAutoscaleXMax());
                    break;
                }
                case 3: {
                    this.scaleSetter.scaleField.setValue(this.drawingPanel.getYMin());
                    this.scaleSetter.autoscaleCheckbox.setSelected(this.drawingPanel.isAutoscaleYMin());
                    break;
                }
                case 4: {
                    this.scaleSetter.scaleField.setValue(this.drawingPanel.getYMax());
                    this.scaleSetter.autoscaleCheckbox.setSelected(this.drawingPanel.isAutoscaleYMax());
                }
            }
        }
    }

    @Override
    public double getX() {
        return Double.isNaN(this.mouseX) ? this.plot.pixToX(this.plot.getMouseIntX()) : this.mouseX;
    }

    @Override
    public double getY() {
        return Double.isNaN(this.mouseY) ? this.plot.pixToY(this.plot.getMouseIntY()) : this.mouseY;
    }

    @Override
    public void setSelected(boolean selectable) {
    }

    @Override
    public boolean isSelected() {
        return false;
    }

    @Override
    public void toggleSelected() {
    }

    @Override
    public Cursor getPreferredCursor() {
        switch (this.mouseRegion) {
            case 6: {
                if (this.horzLeft == null) {
                    String imageFile = "/org/opensourcephysics/resources/tools/images/horzleft.gif";
                    Image im = ResourceLoader.getImage(imageFile);
                    this.horzLeft = Toolkit.getDefaultToolkit().createCustomCursor(im, new Point(16, 16), "Horizontal Left");
                }
                return this.horzLeft;
            }
            case 7: {
                if (this.horzRight == null) {
                    String imageFile = "/org/opensourcephysics/resources/tools/images/horzright.gif";
                    Image im = ResourceLoader.getImage(imageFile);
                    this.horzRight = Toolkit.getDefaultToolkit().createCustomCursor(im, new Point(16, 16), "Horizontal Right");
                }
                return this.horzRight;
            }
            case 5: {
                if (this.horzCenter == null) {
                    String imageFile = "/org/opensourcephysics/resources/tools/images/horzcenter.gif";
                    Image im = ResourceLoader.getImage(imageFile);
                    this.horzCenter = Toolkit.getDefaultToolkit().createCustomCursor(im, new Point(16, 16), "Horizontal Center");
                }
                return this.horzCenter;
            }
            case 9: {
                if (this.vertDown == null) {
                    String imageFile = "/org/opensourcephysics/resources/tools/images/vertdown.gif";
                    Image im = ResourceLoader.getImage(imageFile);
                    this.vertDown = Toolkit.getDefaultToolkit().createCustomCursor(im, new Point(16, 16), "Vertical Down");
                }
                return this.vertDown;
            }
            case 10: {
                if (this.vertUp == null) {
                    String imageFile = "/org/opensourcephysics/resources/tools/images/vertup.gif";
                    Image im = ResourceLoader.getImage(imageFile);
                    this.vertUp = Toolkit.getDefaultToolkit().createCustomCursor(im, new Point(16, 16), "Vertical Up");
                }
                return this.vertUp;
            }
            case 8: {
                if (this.vertCenter == null) {
                    String imageFile = "/org/opensourcephysics/resources/tools/images/vertcenter.gif";
                    Image im = ResourceLoader.getImage(imageFile);
                    this.vertCenter = Toolkit.getDefaultToolkit().createCustomCursor(im, new Point(16, 16), "Vertical Center");
                }
                return this.vertCenter;
            }
            case 0: {
                if (this.move == null) {
                    String imageFile = "/org/opensourcephysics/resources/tools/images/movecursor.gif";
                    Image im = ResourceLoader.getImage(imageFile);
                    this.move = Toolkit.getDefaultToolkit().createCustomCursor(im, new Point(16, 16), "Move All Ways");
                }
                return this.move;
            }
            case 11: 
            case 12: {
                return Cursor.getPredefinedCursor(12);
            }
        }
        return Cursor.getDefaultCursor();
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enable) {
        this.enabled = enable;
    }

    public void addAxisListener(ActionListener listener) {
        this.axisListeners.add(listener);
    }

    @Override
    public Interactive findInteractive(DrawingPanel panel, int xpix, int ypix) {
        if (this.drawingPanel.isFixedScale()) {
            return null;
        }
        if (this.mouseRegion >= 1) {
            return this;
        }
        if (this.mouseRegion == -1) {
            return this;
        }
        if (this.mouseRegion == 0 && this.altDown) {
            return this;
        }
        return null;
    }

    @Override
    public void setXY(double x, double y) {
    }

    @Override
    public boolean isMeasured() {
        return true;
    }

    @Override
    public double getXMin() {
        return this.drawingPanel.getXMin();
    }

    @Override
    public double getXMax() {
        return this.drawingPanel.getXMax();
    }

    @Override
    public double getYMin() {
        return this.drawingPanel.getYMin();
    }

    @Override
    public double getYMax() {
        return this.drawingPanel.getYMax();
    }

    public void hideScaleSetter() {
        if (this.scaleSetter != null) {
            this.scaleSetter.autoscaleCheckbox.requestFocusInWindow();
            this.scaleSetter.setVisible(false);
        }
    }

    @Override
    public void resizeFonts(double factor, DrawingPanel panel) {
        super.resizeFonts(factor, panel);
        if (this.scaleSetter != null) {
            this.scaleSetter.scaleField.setFont(FontSizer.getResizedFont(this.scaleSetter.scaleField.getFont(), factor));
            this.scaleSetter.autoscaleCheckbox.setFont(FontSizer.getResizedFont(this.scaleSetter.autoscaleCheckbox.getFont(), factor));
        }
    }

    protected boolean hasHorzVariablesPopup() {
        return false;
    }

    protected JPopupMenu getHorzVariablesPopup() {
        return null;
    }

    protected boolean hasVertVariablesPopup() {
        return false;
    }

    protected JPopupMenu getVertVariablesPopup() {
        return null;
    }

    protected int findRegion(Point p) {
        int l = this.drawingPanel.getLeftGutter();
        int r = this.drawingPanel.getRightGutter();
        int t = this.drawingPanel.getTopGutter();
        int b = this.drawingPanel.getBottomGutter();
        Dimension plotDim = this.drawingPanel.getSize();
        int axisLen = plotDim.width - r - l;
        this.hitRect.setSize(axisLen / 4, 12);
        this.hitRect.setLocation(l + axisLen / 2 - this.hitRect.width / 2, plotDim.height - b - this.hitRect.height / 2);
        if (this.hitRect.contains(p)) {
            return 5;
        }
        this.hitRect.setLocation(l + 4, plotDim.height - b - this.hitRect.height / 2);
        if (this.hitRect.contains(p)) {
            return 6;
        }
        this.hitRect.setLocation(l + axisLen - this.hitRect.width - 4, plotDim.height - b - this.hitRect.height / 2);
        if (this.hitRect.contains(p)) {
            return 7;
        }
        axisLen = plotDim.height - t - b;
        this.hitRect.setSize(12, axisLen / 4);
        this.hitRect.setLocation(l - this.hitRect.width / 2, t + axisLen / 2 - this.hitRect.height / 2);
        if (this.hitRect.contains(p)) {
            return 8;
        }
        this.hitRect.setLocation(l - this.hitRect.width / 2, t + 4);
        if (this.hitRect.contains(p)) {
            return 10;
        }
        this.hitRect.setLocation(l - this.hitRect.width / 2, t + axisLen - this.hitRect.height - 4);
        if (this.hitRect.contains(p)) {
            return 9;
        }
        Graphics g = this.drawingPanel.getGraphics();
        int w = this.xLine.getWidth(g) + 8;
        int h = this.xLine.getHeight(g);
        this.hitRect.setSize(w, h);
        int x = (int)(this.xLine.getX() - (double)(w / 2));
        int y = (int)(this.xLine.getY() - (double)(h / 2) - (double)(this.xLine.getFontSize() / 3));
        this.hitRect.setLocation(x, y);
        if (this.hitRect.contains(p) && this.hasHorzVariablesPopup()) {
            return 11;
        }
        w = this.yLine.getHeight(g);
        h = this.yLine.getWidth(g) + 8;
        this.hitRect.setSize(w, h);
        x = (int)(this.yLine.getX() - (double)(w / 2) - (double)(this.yLine.getFontSize() / 3));
        y = (int)(this.yLine.getY() - (double)(h / 2) - 1.0);
        this.hitRect.setLocation(x, y);
        if (this.hitRect.contains(p) && this.hasVertVariablesPopup()) {
            return 12;
        }
        if (p.x >= l && p.y >= t && p.x <= plotDim.width - r && p.y <= plotDim.height - b) {
            return 0;
        }
        ScientificField field = this.scaleSetter.scaleField;
        Dimension fieldDim = field.getPreferredSize();
        this.hitRect.setSize(fieldDim);
        double xmin = this.drawingPanel.getXMin();
        double xmax = this.drawingPanel.getXMax();
        double ymin = this.drawingPanel.getYMin();
        double ymax = this.drawingPanel.getYMax();
        int offset = 8;
        this.hitRect.setLocation(l - 12, plotDim.height - b + 6 + offset);
        if (this.hitRect.contains(p)) {
            Point hitLoc = this.hitRect.getLocation();
            this.scaleSetter.add((Component)this.scaleSetter.autoscaleCheckbox, "North");
            this.scaleSetter.validate();
            Point fieldLoc = field.getLocation();
            Dimension size = this.scaleSetter.getPreferredSize();
            this.scaleSetter.setBounds(hitLoc.x - fieldLoc.x, hitLoc.y - fieldLoc.y - offset, size.width, size.height);
            return 1;
        }
        this.hitRect.setLocation(plotDim.width - r - fieldDim.width + 12, plotDim.height - b + 6 + offset);
        if (this.hitRect.contains(p)) {
            field.setExpectedRange(xmin, xmax);
            Point hitLoc = this.hitRect.getLocation();
            this.scaleSetter.add((Component)this.scaleSetter.autoscaleCheckbox, "North");
            this.scaleSetter.validate();
            Point fieldLoc = field.getLocation();
            Dimension size = this.scaleSetter.getPreferredSize();
            this.scaleSetter.setBounds(hitLoc.x - fieldLoc.x, hitLoc.y - fieldLoc.y - offset, size.width, size.height);
            return 2;
        }
        this.hitRect.setLocation(l - fieldDim.width - 1 - offset, plotDim.height - b - fieldDim.height + 8);
        if (this.hitRect.contains(p)) {
            field.setExpectedRange(ymin, ymax);
            Point hitLoc = this.hitRect.getLocation();
            this.scaleSetter.add((Component)this.scaleSetter.autoscaleCheckbox, "East");
            this.scaleSetter.validate();
            Point fieldLoc = field.getLocation();
            int minLoc = hitLoc.x - fieldLoc.x;
            Dimension size = this.scaleSetter.getPreferredSize();
            this.scaleSetter.setBounds(Math.max(minLoc, 1 - fieldLoc.x), hitLoc.y - fieldLoc.y, size.width, size.height);
            return 3;
        }
        this.hitRect.setLocation(l - fieldDim.width - 1 - offset, t - 8);
        if (this.hitRect.contains(p)) {
            field.setExpectedRange(ymin, ymax);
            Point hitLoc = this.hitRect.getLocation();
            this.scaleSetter.add((Component)this.scaleSetter.autoscaleCheckbox, "East");
            this.scaleSetter.validate();
            Point fieldLoc = field.getLocation();
            int minLoc = hitLoc.x - fieldLoc.x;
            Dimension size = this.scaleSetter.getPreferredSize();
            this.scaleSetter.setBounds(Math.max(minLoc, 1 - fieldLoc.x), hitLoc.y - fieldLoc.y, size.width, size.height);
            return 4;
        }
        return -1;
    }

    public ScaleSetter getScaleSetter() {
        String s = DialogsRes.SCALE_AUTO;
        if (!s.equals(this.scaleSetter.autoscaleCheckbox.getText())) {
            this.scaleSetter.autoscaleCheckbox.setText(s);
        }
        return this.scaleSetter;
    }

    class AxisMouseListener
    extends MouseInputAdapter {
        AxisMouseListener() {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (!CartesianInteractive.this.enabled) {
                return;
            }
            CartesianInteractive.this.altDown = e.isAltDown();
            Point p = e.getPoint();
            CartesianInteractive.this.mouseRegion = CartesianInteractive.this.findRegion(p);
            if (CartesianInteractive.this.mouseRegion > 0 && CartesianInteractive.this.mouseRegion < 5 && !CartesianInteractive.this.drawingPanel.isFixedScale()) {
                CartesianInteractive.this.getScaleSetter().setRegion(CartesianInteractive.this.mouseRegion);
                CartesianInteractive.this.scaleSetter.validate();
                CartesianInteractive.this.scaleSetter.setVisible(true);
            } else {
                CartesianInteractive.this.scaleSetter.hideIfInactive();
            }
            CartesianInteractive.this.drawHitRect = CartesianInteractive.this.mouseRegion == 11 || CartesianInteractive.this.mouseRegion == 12;
            CartesianInteractive.this.plot.repaint();
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (!CartesianInteractive.this.enabled) {
                return;
            }
            double dx = 0.0;
            double dy = 0.0;
            double min = 0.0;
            double max = 0.0;
            switch (CartesianInteractive.this.mouseRegion) {
                case 0: {
                    if (!CartesianInteractive.this.altDown || CartesianInteractive.this.drawingPanel.isFixedScale()) {
                        return;
                    }
                    dx = (double)(CartesianInteractive.this.mouseLoc.x - e.getX()) / CartesianInteractive.this.plot.getXPixPerUnit();
                    min = CartesianInteractive.this.plot.getXMin() + dx;
                    max = CartesianInteractive.this.plot.getXMax() + dx;
                    dx = 0.0;
                    CartesianInteractive.this.plot.setPreferredMinMaxX(min, max);
                    dy = (double)(e.getY() - CartesianInteractive.this.mouseLoc.y) / CartesianInteractive.this.plot.getYPixPerUnit();
                    min = CartesianInteractive.this.plot.getYMin() + dy;
                    max = CartesianInteractive.this.plot.getYMax() + dy;
                    break;
                }
                case 5: {
                    dx = (double)(CartesianInteractive.this.mouseLoc.x - e.getX()) / CartesianInteractive.this.plot.getXPixPerUnit();
                    min = CartesianInteractive.this.plot.getXMin() + dx;
                    max = CartesianInteractive.this.plot.getXMax() + dx;
                    break;
                }
                case 6: {
                    dx = (double)(2 * (CartesianInteractive.this.mouseLoc.x - e.getX())) / CartesianInteractive.this.plot.getXPixPerUnit();
                    min = CartesianInteractive.this.plot.getXMin() + dx;
                    max = CartesianInteractive.this.plot.isAutoscaleXMax() ? Double.NaN : CartesianInteractive.this.plot.getXMax();
                    break;
                }
                case 7: {
                    dx = (double)(2 * (CartesianInteractive.this.mouseLoc.x - e.getX())) / CartesianInteractive.this.plot.getXPixPerUnit();
                    min = CartesianInteractive.this.plot.isAutoscaleXMin() ? Double.NaN : CartesianInteractive.this.plot.getXMin();
                    max = CartesianInteractive.this.plot.getXMax() + dx;
                    break;
                }
                case 8: {
                    dy = (double)(e.getY() - CartesianInteractive.this.mouseLoc.y) / CartesianInteractive.this.plot.getYPixPerUnit();
                    min = CartesianInteractive.this.plot.getYMin() + dy;
                    max = CartesianInteractive.this.plot.getYMax() + dy;
                    break;
                }
                case 9: {
                    dy = (double)(2 * (e.getY() - CartesianInteractive.this.mouseLoc.y)) / CartesianInteractive.this.plot.getYPixPerUnit();
                    min = CartesianInteractive.this.plot.getYMin() + dy;
                    max = CartesianInteractive.this.plot.isAutoscaleYMax() ? Double.NaN : CartesianInteractive.this.plot.getYMax();
                    break;
                }
                case 10: {
                    dy = (double)(2 * (e.getY() - CartesianInteractive.this.mouseLoc.y)) / CartesianInteractive.this.plot.getYPixPerUnit();
                    min = CartesianInteractive.this.plot.isAutoscaleYMin() ? Double.NaN : CartesianInteractive.this.plot.getYMin();
                    max = CartesianInteractive.this.plot.getYMax() + dy;
                }
            }
            if (dx != 0.0) {
                CartesianInteractive.this.plot.setPreferredMinMaxX(min, max);
            } else if (dy != 0.0) {
                CartesianInteractive.this.plot.setPreferredMinMaxY(min, max);
            }
            for (ActionListener listener : CartesianInteractive.this.axisListeners) {
                listener.actionPerformed(new ActionEvent(CartesianInteractive.this, e.getID(), "axis dragged"));
            }
            CartesianInteractive.this.plot.invalidateImage();
            CartesianInteractive.this.plot.repaint();
            CartesianInteractive.this.mouseLoc = e.getPoint();
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (!CartesianInteractive.this.enabled) {
                return;
            }
            CartesianInteractive.this.plot.requestFocusInWindow();
            CartesianInteractive.this.altDown = e.isAltDown();
            CartesianInteractive.this.mouseLoc = e.getPoint();
            CartesianInteractive.this.mouseX = CartesianInteractive.this.plot.pixToX(CartesianInteractive.this.plot.getMouseIntX());
            CartesianInteractive.this.mouseY = CartesianInteractive.this.plot.pixToY(CartesianInteractive.this.plot.getMouseIntY());
            CartesianInteractive.this.mouseRegion = CartesianInteractive.this.findRegion(CartesianInteractive.this.mouseLoc);
            if (CartesianInteractive.this.scaleSetter == null) {
                return;
            }
            if (CartesianInteractive.this.mouseRegion > 0 && CartesianInteractive.this.mouseRegion < 5 && !CartesianInteractive.this.drawingPanel.isFixedScale()) {
                CartesianInteractive.this.scaleSetter.setVisible(true);
                return;
            }
            CartesianInteractive.this.hideScaleSetter();
            if (CartesianInteractive.this.mouseRegion == 11) {
                CartesianInteractive.this.drawHitRect = false;
                CartesianInteractive.this.getHorzVariablesPopup().show(CartesianInteractive.this.plot, CartesianInteractive.this.mouseLoc.x - 20, CartesianInteractive.this.mouseLoc.y - 12);
            } else if (CartesianInteractive.this.mouseRegion == 12) {
                CartesianInteractive.this.drawHitRect = false;
                CartesianInteractive.this.getVertVariablesPopup().show(CartesianInteractive.this.plot, CartesianInteractive.this.mouseLoc.x - 20, CartesianInteractive.this.mouseLoc.y - 12);
            }
            CartesianInteractive.this.plot.repaint();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (!CartesianInteractive.this.enabled) {
                return;
            }
            CartesianInteractive.this.mouseX = Double.NaN;
            CartesianInteractive.this.mouseY = Double.NaN;
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (!CartesianInteractive.this.enabled) {
                return;
            }
            Point p = e.getPoint();
            if (!new Rectangle(CartesianInteractive.this.plot.getSize()).contains(p) && CartesianInteractive.this.scaleSetter != null && "".equals(InputEvent.getModifiersExText(e.getModifiersEx()))) {
                CartesianInteractive.this.hideScaleSetter();
            }
        }
    }

    public class ScaleSetter
    extends JPanel {
        Action scaleAction;
        JCheckBox autoscaleCheckbox;
        ScientificField scaleField;
        int region;
        boolean pinned;

        private ScaleSetter() {
            super(new BorderLayout());
            this.pinned = false;
            this.scaleAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    double min;
                    ScaleSetter.this.scaleField.setBackground(Color.white);
                    ScaleSetter.this.pinned = false;
                    boolean auto = ScaleSetter.this.autoscaleCheckbox.isSelected();
                    boolean horzAxis = true;
                    double max = min = auto ? Double.NaN : ScaleSetter.this.scaleField.getValue();
                    switch (ScaleSetter.this.region) {
                        case 1: {
                            max = ((ScaleSetter)ScaleSetter.this).CartesianInteractive.this.drawingPanel.isAutoscaleXMax() ? Double.NaN : ((ScaleSetter)ScaleSetter.this).CartesianInteractive.this.drawingPanel.getXMax();
                            break;
                        }
                        case 2: {
                            min = ((ScaleSetter)ScaleSetter.this).CartesianInteractive.this.drawingPanel.isAutoscaleXMin() ? Double.NaN : ((ScaleSetter)ScaleSetter.this).CartesianInteractive.this.drawingPanel.getXMin();
                            break;
                        }
                        case 3: {
                            horzAxis = false;
                            max = ((ScaleSetter)ScaleSetter.this).CartesianInteractive.this.drawingPanel.isAutoscaleYMax() ? Double.NaN : ((ScaleSetter)ScaleSetter.this).CartesianInteractive.this.drawingPanel.getYMax();
                            break;
                        }
                        case 4: {
                            horzAxis = false;
                            double d = min = ((ScaleSetter)ScaleSetter.this).CartesianInteractive.this.drawingPanel.isAutoscaleYMin() ? Double.NaN : ((ScaleSetter)ScaleSetter.this).CartesianInteractive.this.drawingPanel.getYMin();
                        }
                    }
                    if (horzAxis) {
                        ((ScaleSetter)ScaleSetter.this).CartesianInteractive.this.drawingPanel.setPreferredMinMaxX(min, max);
                    } else {
                        ((ScaleSetter)ScaleSetter.this).CartesianInteractive.this.drawingPanel.setPreferredMinMaxY(min, max);
                    }
                    Rectangle bounds = ((ScaleSetter)ScaleSetter.this).CartesianInteractive.this.drawingPanel.getBounds();
                    bounds.setLocation(0, 0);
                    ((ScaleSetter)ScaleSetter.this).CartesianInteractive.this.drawingPanel.paintImmediately(bounds);
                }
            };
            this.autoscaleCheckbox = new JCheckBox();
            this.autoscaleCheckbox.setBorder(BorderFactory.createEmptyBorder(1, 2, 2, 1));
            this.autoscaleCheckbox.setBackground(CartesianInteractive.this.drawingPanel.getBackground());
            this.autoscaleCheckbox.setHorizontalTextPosition(4);
            this.autoscaleCheckbox.addActionListener(this.scaleAction);
            this.scaleField = new ScientificField(6, 3){

                @Override
                public Dimension getPreferredSize() {
                    Dimension dim = super.getPreferredSize();
                    dim.width -= 4;
                    return dim;
                }
            };
            this.scaleField.addActionListener(new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ScaleSetter.this.autoscaleCheckbox.setSelected(false);
                    ScaleSetter.this.scaleAction.actionPerformed(null);
                }
            });
            this.scaleField.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    if (ScaleSetter.this.scaleField.getBackground() == Color.yellow) {
                        ScaleSetter.this.autoscaleCheckbox.setSelected(false);
                        ScaleSetter.this.scaleAction.actionPerformed(null);
                    }
                }
            });
            this.scaleField.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    ScaleSetter.this.pinned = true;
                    if (e.getClickCount() == 2) {
                        ScaleSetter.this.scaleField.selectAll();
                    }
                }
            });
            this.add((Component)this.scaleField, "Center");
        }

        void hideIfInactive() {
            if (this.scaleField.getBackground() != Color.yellow && this.scaleField.getSelectedText() == null && !this.pinned) {
                CartesianInteractive.this.hideScaleSetter();
            }
        }

        void setRegion(int mouseRegion) {
            if (this.region != mouseRegion) {
                this.autoscaleCheckbox.requestFocusInWindow();
                if (this.scaleField.getBackground() == Color.yellow) {
                    this.autoscaleCheckbox.setSelected(false);
                    this.scaleAction.actionPerformed(null);
                }
                this.region = mouseRegion;
                this.pinned = false;
                this.scaleField.select(20, 20);
                this.scaleField.requestFocusInWindow();
            }
        }
    }
}

