/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class ResizableIcon
implements Icon {
    protected int baseWidth;
    protected int baseHeight;
    protected int w;
    protected int h;
    protected BufferedImage baseImage;
    protected Icon icon;

    public ResizableIcon(URL location) {
        this(new ImageIcon(location));
    }

    public ResizableIcon(Icon icon) {
        while (icon instanceof ResizableIcon) {
            icon = ((ResizableIcon)icon).icon;
        }
        this.icon = icon;
        this.baseWidth = this.w = icon.getIconWidth();
        this.baseHeight = this.h = icon.getIconHeight();
    }

    @Override
    public synchronized void paintIcon(Component c, Graphics g, int x, int y) {
        if (this.icon == null) {
            return;
        }
        if (this.baseImage == null || this.baseImage.getWidth() != this.baseWidth || this.baseImage.getHeight() != this.baseHeight) {
            this.baseImage = new BufferedImage(this.baseWidth, this.baseHeight, 2);
        }
        Graphics2D g2 = this.baseImage.createGraphics();
        g2.setComposite(AlphaComposite.Clear);
        g2.fillRect(0, 0, this.baseWidth, this.baseHeight);
        g2.setComposite(AlphaComposite.SrcOver);
        this.icon.paintIcon(c, g2, 0, 0);
        g.drawImage(this.baseImage, x, y, this.w, this.h, c);
    }

    @Override
    public int getIconWidth() {
        return this.w;
    }

    @Override
    public int getIconHeight() {
        return this.h;
    }

    public Icon getBaseIcon() {
        return this.icon;
    }

    public void resize(int factor) {
        int n = Math.max(factor, 1);
        this.w = n * this.baseWidth;
        this.h = n * this.baseHeight;
    }
}

