/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.awt.Color;
import java.util.Dictionary;
import java.util.Hashtable;

public class DisplayColors {
    static Color[] phaseColors = null;
    static Dictionary<Integer, Color> lineColors = new Hashtable<Integer, Color>();
    static Dictionary<Integer, Color> markerColors = new Hashtable<Integer, Color>();

    static {
        lineColors.put(0, Color.RED);
        lineColors.put(1, Color.GREEN.darker());
        lineColors.put(2, Color.BLUE);
        lineColors.put(3, Color.YELLOW.darker());
        lineColors.put(4, Color.CYAN.darker());
        lineColors.put(5, Color.MAGENTA);
        markerColors.put(0, Color.RED);
        markerColors.put(1, Color.GREEN.darker());
        markerColors.put(2, Color.BLUE);
        markerColors.put(3, Color.YELLOW.darker());
        markerColors.put(4, Color.CYAN.darker());
        markerColors.put(5, Color.MAGENTA);
    }

    private DisplayColors() {
    }

    public static Color[] getPhaseToColorArray() {
        if (phaseColors == null) {
            phaseColors = new Color[256];
            int i = 0;
            while (i < 256) {
                double val = Math.abs(Math.sin(Math.PI * (double)i / 255.0));
                int b = (int)(255.0 * val * val);
                val = Math.abs(Math.sin(Math.PI * (double)i / 255.0 + 1.0471975511965976));
                int g = (int)(255.0 * val * val * Math.sqrt(val));
                val = Math.abs(Math.sin(Math.PI * (double)i / 255.0 + 2.0943951023931953));
                int r = (int)(255.0 * val * val);
                DisplayColors.phaseColors[i] = new Color(r, g, b);
                ++i;
            }
        }
        return phaseColors;
    }

    public static Color phaseToColor(double phi) {
        int index = (int)(127.5 * (1.0 + phi / Math.PI));
        index %= 255;
        if (phaseColors == null) {
            return DisplayColors.getPhaseToColorArray()[index];
        }
        return phaseColors[index];
    }

    public static Color randomColor() {
        return new Color((int)(Math.random() * 255.0), (int)(Math.random() * 255.0), (int)(Math.random() * 255.0));
    }

    public static Color getLineColor(int index) {
        Color color = lineColors.get(index);
        if (color == null) {
            float h = (float)((double)index * Math.PI / 12.0) % 1.0f;
            float s = 1.0f;
            float b = 0.5f;
            color = Color.getHSBColor(h, s, b);
            lineColors.put(index, color);
        }
        return color;
    }

    public static Color getMarkerColor(int index) {
        Color color = markerColors.get(index);
        if (color == null) {
            color = DisplayColors.getLineColor(index).brighter().brighter();
            markerColors.put(index, color);
        }
        return color;
    }
}

