/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;
import org.opensourcephysics.display.TeXParser;

public class DataRowModel
extends AbstractTableModel {
    ArrayList<Object> rowList = new ArrayList();
    ArrayList<String> colNames = new ArrayList();
    boolean rowNumberVisible = true;
    int colCount = 0;
    int maxRows = -1;
    int firstRowIndex = 0;
    int stride = 1;

    public DataRowModel() {
        this.colNames.add(0, "row");
    }

    public void setStride(int stride) {
        this.stride = stride;
    }

    public void setMaxPoints(int max) {
        this.maxRows = max;
        if (this.maxRows <= 0 || this.rowList.size() <= max) {
            return;
        }
        int j = 0;
        int n = this.rowList.size() - max;
        while (j < n) {
            this.rowList.remove(0);
            ++j;
        }
        this.colCount = 0;
        j = 0;
        n = this.rowList.size();
        while (j < n) {
            Object r = this.rowList.get(j);
            if (r.getClass().isArray()) {
                int length = 0;
                if (r instanceof double[]) {
                    length = ((double[])r).length;
                } else if (r instanceof byte[]) {
                    length = ((byte[])r).length;
                } else if (r instanceof int[]) {
                    length = ((int[])r).length;
                } else if (r instanceof String[]) {
                    length = ((String[])r).length;
                }
                this.colCount = Math.max(this.colCount, length);
            }
            ++j;
        }
    }

    public void clear() {
        this.rowList.clear();
        this.colCount = 0;
    }

    public synchronized void appendRow(Object obj) throws IllegalArgumentException {
        if (!obj.getClass().isArray()) {
            throw new IllegalArgumentException("A TableData row must be an array.");
        }
        Class<?> componentType = obj.getClass().getComponentType();
        String type = componentType.getName();
        if (type.equals("double")) {
            this.appendDoubles((double[])obj);
        } else if (type.equals("int")) {
            this.appendInts((int[])obj);
        } else if (type.equals("byte")) {
            this.appendBytes((byte[])obj);
        } else if (type.equals("string")) {
            this.appendStrings((String[])obj);
        } else {
            Object[] row = (Object[])obj;
            String[] strings = new String[row.length];
            int i = 0;
            int n = row.length;
            while (i < n) {
                strings[i] = row[i].toString();
                ++i;
            }
            this.appendStrings(strings);
        }
    }

    void appendDoubles(double[] x) {
        if (x == null) {
            return;
        }
        double[] row = new double[x.length];
        System.arraycopy(x, 0, row, 0, x.length);
        if (this.maxRows > 0 && this.rowList.size() >= this.maxRows) {
            this.rowList.remove(0);
        }
        this.rowList.add(row);
        this.colCount = Math.max(this.colCount, row.length + 1);
    }

    void appendInts(int[] x) {
        if (x == null) {
            return;
        }
        int[] row = new int[x.length];
        System.arraycopy(x, 0, row, 0, x.length);
        if (this.maxRows > 0 && this.rowList.size() >= this.maxRows) {
            this.rowList.remove(0);
        }
        this.rowList.add(row);
        this.colCount = Math.max(this.colCount, row.length + 1);
    }

    void appendBytes(byte[] x) {
        if (x == null) {
            return;
        }
        byte[] row = new byte[x.length];
        System.arraycopy(x, 0, row, 0, x.length);
        if (this.maxRows > 0 && this.rowList.size() >= this.maxRows) {
            this.rowList.remove(0);
        }
        this.rowList.add(row);
        this.colCount = Math.max(this.colCount, row.length + 1);
    }

    void appendStrings(String[] x) {
        if (x == null) {
            return;
        }
        String[] row = new String[x.length];
        System.arraycopy(x, 0, row, 0, x.length);
        if (this.maxRows > 0 && this.rowList.size() >= this.maxRows) {
            this.rowList.remove(0);
        }
        this.rowList.add(row);
        this.colCount = Math.max(this.colCount, row.length + 1);
    }

    public boolean setRowNumberVisible(boolean vis) {
        if (this.rowNumberVisible == vis) {
            return false;
        }
        this.rowNumberVisible = vis;
        return true;
    }

    /*
     * Unable to fully structure code
     */
    public boolean setColumnNames(int column, String name) {
        name = TeXParser.parseTeX(name);
        if (this.colNames != null && (column >= this.colNames.size() || this.colNames.get(column) == null || !this.colNames.get(column).equals(name))) ** GOTO lbl6
        return false;
lbl-1000:
        // 1 sources

        {
            this.colNames.add("" + (char)(65 + column));
lbl6:
            // 2 sources

            ** while (column >= this.colNames.size())
        }
lbl7:
        // 1 sources

        this.colNames.set(column, name);
        return true;
    }

    public void setFirstRowIndex(int index) {
        this.firstRowIndex = index;
    }

    @Override
    public int getColumnCount() {
        int offset;
        int n = offset = this.rowNumberVisible ? 0 : 1;
        if (this.getRowCount() == 0) {
            return this.colNames == null ? 0 : this.colNames.size() - offset;
        }
        int count = this.rowNumberVisible ? this.colCount : this.colCount - 1;
        return count;
    }

    @Override
    public String getColumnName(int column) {
        if (column == 0 && this.rowNumberVisible) {
            return this.colNames.get(0);
        }
        if (!this.rowNumberVisible) {
            ++column;
        }
        if (column < this.colNames.size()) {
            return this.colNames.get(column);
        }
        return "" + (char)(65 + column - 1);
    }

    @Override
    public int getRowCount() {
        return (this.rowList.size() + this.stride - 1) / this.stride;
    }

    @Override
    public Object getValueAt(int row, int column) {
        row *= this.stride;
        if (column == 0 && this.rowNumberVisible) {
            return new Integer(row + this.firstRowIndex);
        }
        if (!this.rowNumberVisible) {
            ++column;
        }
        if (row >= this.rowList.size()) {
            return "";
        }
        Object r = this.rowList.get(row);
        if (!r.getClass().isArray()) {
            return "";
        }
        if (r instanceof double[]) {
            double[] array = (double[])r;
            if (column > array.length) {
                return "";
            }
            return new Double(array[column - 1]);
        }
        if (r instanceof byte[]) {
            byte[] array = (byte[])r;
            if (column > array.length) {
                return "";
            }
            return new Byte(array[column - 1]);
        }
        if (r instanceof int[]) {
            int[] array = (int[])r;
            if (column > array.length) {
                return "";
            }
            return new Integer(array[column - 1]);
        }
        if (r instanceof String[]) {
            String[] array = (String[])r;
            if (column > array.length) {
                return "";
            }
            return array[column - 1];
        }
        return "";
    }
}

