/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.AbstractBorder;

public class CellBorder
extends AbstractBorder {
    protected int thickness;
    protected Color lineColor;

    public CellBorder(Color color) {
        this(color, 1);
    }

    public CellBorder(Color color, int thickness) {
        this.lineColor = color;
        this.thickness = thickness;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Color oldColor = g.getColor();
        g.setColor(this.lineColor);
        int i = 0;
        while (i < this.thickness) {
            g.drawLine(x, y + i, x + width - 1, y + i);
            g.drawLine(x + i, y, x + i, y + height - 1);
            ++i;
        }
        g.setColor(oldColor);
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return new Insets(this.thickness + 1, this.thickness + 1, 1, 1);
    }

    @Override
    public Insets getBorderInsets(Component c, Insets insets) {
        insets.left = insets.top = this.thickness + 1;
        insets.bottom = 1;
        insets.right = 1;
        return insets;
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public int getThickness() {
        return this.thickness;
    }
}

