/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.util.Dictionary;
import java.util.Hashtable;
import javax.swing.table.AbstractTableModel;
import org.opensourcephysics.display.TeXParser;

public class ArrayTableModel
extends AbstractTableModel {
    double[] doubleArray1;
    double[][] doubleArray2;
    int[] intArray1;
    int[][] intArray2;
    String[] stringArray1;
    String[][] stringArray2;
    boolean[] booleanArray1;
    boolean[][] booleanArray2;
    boolean editable = false;
    String[] columnNames;
    boolean showRowNumber = true;
    int firstRow = 0;
    int firstCol = 0;
    boolean transposed = false;
    Dictionary<Integer, Boolean> lockedColumns = new Hashtable<Integer, Boolean>();

    public ArrayTableModel(int[] array) {
        this.intArray1 = array;
    }

    public ArrayTableModel(int[][] array) {
        this.intArray2 = array;
    }

    public ArrayTableModel(double[] array) {
        this.doubleArray1 = array;
    }

    public ArrayTableModel(double[][] array) {
        this.doubleArray2 = array;
    }

    public ArrayTableModel(String[] array) {
        this.stringArray1 = array;
    }

    public ArrayTableModel(String[][] array) {
        this.stringArray2 = array;
    }

    public ArrayTableModel(boolean[] array) {
        this.booleanArray1 = array;
    }

    public ArrayTableModel(boolean[][] array) {
        this.booleanArray2 = array;
    }

    public void setArray(Object arrayObj) {
        if (arrayObj instanceof double[]) {
            this.doubleArray1 = (double[])arrayObj;
        } else if (arrayObj instanceof double[][]) {
            this.doubleArray2 = (double[][])arrayObj;
        } else if (arrayObj instanceof int[]) {
            this.intArray1 = (int[])arrayObj;
        } else if (arrayObj instanceof int[][]) {
            this.intArray2 = (int[][])arrayObj;
        } else if (arrayObj instanceof String[]) {
            this.stringArray1 = (String[])arrayObj;
        } else if (arrayObj instanceof String[][]) {
            this.stringArray2 = (String[][])arrayObj;
        } else if (arrayObj instanceof boolean[]) {
            this.booleanArray1 = (boolean[])arrayObj;
        } else if (arrayObj instanceof boolean[][]) {
            this.booleanArray2 = (boolean[][])arrayObj;
        }
    }

    public boolean setColumnLock(int columnIndex, boolean locked) {
        Boolean val = this.lockedColumns.get(columnIndex);
        if (val != null && locked == val) {
            return false;
        }
        this.lockedColumns.put(columnIndex, locked);
        return true;
    }

    public boolean setColumnLocks(boolean[] locked) {
        int n;
        int i;
        boolean change = false;
        if (this.lockedColumns.size() != locked.length) {
            change = true;
        } else {
            i = 0;
            n = locked.length;
            while (i < n) {
                Boolean val = this.lockedColumns.get(i);
                if (!Boolean.valueOf(locked[i]).equals(val)) {
                    change = true;
                    break;
                }
                ++i;
            }
        }
        if (!change) {
            return false;
        }
        ((Hashtable)this.lockedColumns).clear();
        i = 0;
        n = locked.length;
        while (i < n) {
            this.lockedColumns.put(i, locked[i]);
            ++i;
        }
        return true;
    }

    public void setFirstRowIndex(int index) {
        this.firstRow = index;
    }

    public void setFirstColIndex(int index) {
        this.firstRow = index;
    }

    public void setRowNumberVisible(boolean vis) {
        this.showRowNumber = vis;
    }

    public void setTransposed(boolean transposed) {
        this.transposed = transposed;
    }

    public boolean isTransposed() {
        return this.transposed;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    @Override
    public int getColumnCount() {
        int offset;
        if (this.getArrayRowCount() == 0) {
            return 0;
        }
        int n = offset = this.showRowNumber ? 1 : 0;
        if (this.transposed) {
            return this.getArrayRowCount() + offset;
        }
        return this.getArrayColumnCount() + offset;
    }

    int getArrayColumnCount() {
        if (this.intArray1 != null || this.doubleArray1 != null || this.stringArray1 != null || this.booleanArray1 != null) {
            return 1;
        }
        if (this.intArray2 != null) {
            return this.intArray2[0].length;
        }
        if (this.doubleArray2 != null) {
            return this.doubleArray2[0].length;
        }
        if (this.stringArray2 != null) {
            return this.stringArray2[0].length;
        }
        if (this.booleanArray2 != null) {
            return this.booleanArray2[0].length;
        }
        return 0;
    }

    public boolean setColumnNames(String[] names) {
        if (names == null && this.columnNames == null) {
            return false;
        }
        if (names != null) {
            names = (String[])names.clone();
        }
        boolean changed = false;
        if (names != null && this.columnNames != null && this.columnNames.length == names.length) {
            int i = 0;
            int n = names.length;
            while (i < n) {
                names[i] = TeXParser.parseTeX(names[i]);
                if (!names[i].equals(this.columnNames[i])) {
                    changed = true;
                }
                ++i;
            }
        } else {
            changed = true;
            if (names != null) {
                int i = 0;
                int n = names.length;
                while (i < n) {
                    names[i] = TeXParser.parseTeX(names[i]);
                    ++i;
                }
            }
        }
        this.columnNames = names;
        return changed;
    }

    @Override
    public String getColumnName(int column) {
        if (!this.showRowNumber) {
            ++column;
        }
        if (this.columnNames != null && column < this.columnNames.length) {
            return this.columnNames[column];
        }
        if (column == 0) {
            return "";
        }
        if (this.intArray1 != null || this.doubleArray1 != null || this.stringArray1 != null || this.booleanArray1 != null) {
            return "value";
        }
        return "" + (column - 1 + this.firstCol);
    }

    @Override
    public int getRowCount() {
        if (this.transposed) {
            return this.getArrayColumnCount();
        }
        return this.getArrayRowCount();
    }

    int getArrayRowCount() {
        if (this.intArray1 != null) {
            return this.intArray1.length;
        }
        if (this.intArray2 != null) {
            return this.intArray2.length;
        }
        if (this.doubleArray1 != null) {
            return this.doubleArray1.length;
        }
        if (this.doubleArray2 != null) {
            return this.doubleArray2.length;
        }
        if (this.stringArray1 != null) {
            return this.stringArray1.length;
        }
        if (this.stringArray2 != null) {
            return this.stringArray2.length;
        }
        if (this.booleanArray1 != null) {
            return this.booleanArray1.length;
        }
        if (this.booleanArray2 != null) {
            return this.booleanArray2.length;
        }
        return 0;
    }

    @Override
    public Object getValueAt(int row, int column) {
        int col;
        int offset;
        if (this.showRowNumber && column == 0) {
            return new Integer(row + this.firstRow);
        }
        int n = offset = this.showRowNumber ? 1 : 0;
        if (this.transposed) {
            int temp = row;
            row = column - offset;
            column = temp;
        }
        if (this.intArray1 != null) {
            return new Integer(this.intArray1[row]);
        }
        if (this.intArray2 != null) {
            int n2 = col = this.transposed ? column : column - offset;
            if (row > this.intArray2.length - 1 || col > this.intArray2[row].length - 1 || col < 0) {
                return null;
            }
            return new Integer(this.intArray2[row][col]);
        }
        if (this.doubleArray1 != null) {
            return new Double(this.doubleArray1[row]);
        }
        if (this.doubleArray2 != null) {
            int n3 = col = this.transposed ? column : column - offset;
            if (row > this.doubleArray2.length - 1 || col > this.doubleArray2[row].length - 1 || col < 0) {
                return null;
            }
            return new Double(this.doubleArray2[row][col]);
        }
        if (this.stringArray1 != null) {
            return this.stringArray1[row];
        }
        if (this.stringArray2 != null) {
            int n4 = col = this.transposed ? column : column - offset;
            if (row > this.stringArray2.length - 1 || col > this.stringArray2[row].length - 1 || col < 0) {
                return null;
            }
            return this.stringArray2[row][col];
        }
        if (this.booleanArray1 != null) {
            return new Boolean(this.booleanArray1[row]);
        }
        if (this.booleanArray2 != null) {
            int n5 = col = this.transposed ? column : column - offset;
            if (row > this.booleanArray2.length - 1 || col > this.booleanArray2[row].length - 1 || col < 0) {
                return null;
            }
            return new Boolean(this.booleanArray2[row][col]);
        }
        return null;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        int offset;
        int n = offset = this.showRowNumber ? 1 : 0;
        if (this.transposed) {
            int temp = row;
            row = col - offset;
            col = temp;
        }
        try {
            if (value instanceof String) {
                String val = (String)value;
                int n2 = col = this.transposed ? col : col - offset;
                if (this.intArray1 != null) {
                    this.intArray1[row] = Integer.parseInt(val);
                } else if (this.intArray2 != null) {
                    this.intArray2[row][col] = Integer.parseInt(val);
                } else if (this.doubleArray1 != null) {
                    this.doubleArray1[row] = Double.parseDouble(val);
                } else if (this.doubleArray2 != null) {
                    this.doubleArray2[row][col] = Double.parseDouble(val);
                } else if (this.stringArray1 != null) {
                    this.stringArray1[row] = val;
                } else if (this.stringArray2 != null) {
                    this.stringArray2[row][col] = val;
                } else if (this.booleanArray1 != null) {
                    this.booleanArray1[row] = val.toLowerCase().startsWith("t");
                } else if (this.booleanArray2 != null) {
                    this.booleanArray2[row][col] = val.toLowerCase().startsWith("t");
                }
                if (this.transposed) {
                    this.fireTableCellUpdated(col, row);
                } else {
                    this.fireTableCellUpdated(row, col);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        if (this.showRowNumber && col == 0) {
            return false;
        }
        col = this.showRowNumber ? col - 1 : col;
        Boolean val = this.lockedColumns.get(col);
        if (val == null) {
            return this.editable;
        }
        return val == false && this.editable;
    }
}

