/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.Point;
import java.awt.Window;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.colos.ejs.library.control.ControlElement;
import org.colos.ejs.library.control.swing.ConstantParser;
import org.colos.ejs.library.control.swing.ControlContainer;
import org.colos.ejs.library.control.swing.ControlWindow;
import org.colos.ejs.library.control.value.IntegerValue;
import org.colos.ejs.library.control.value.ObjectValue;
import org.colos.ejs.library.control.value.Value;
import org.opensourcephysics.display.DisplayColors;
import org.opensourcephysics.display.TeXParser;
import org.opensourcephysics.tools.ResourceLoader;

public abstract class ControlSwingElement
extends ControlElement {
    public static final int SWING_ELEMENT_NAME = 0;
    public static final int POSITION = 1;
    public static final int PARENT = 2;
    public static final int ENABLED = 3;
    public static final int VISIBLE = 4;
    public static final int SIZE = 5;
    public static final int FOREGROUND = 6;
    public static final int BACKGROUND = 7;
    public static final int FONT = 8;
    public static final int TOOLTIP = 9;
    public static final int MENU_NAME = 10;
    public static final int PRINT_TARGET = 11;
    public static final int ACTION_IMMEDIATE = 12;
    public static final int MENU_ENABLED = 13;
    public static final int ACTION_PRESS = 10;
    public static final int ACTION_ON = 20;
    public static final int ACTION_OFF = 21;
    public static final int KEY_ACTION = 30;
    public static final int MOUSE_ENTERED_ACTION = 31;
    public static final int MOUSE_EXITED_ACTION = 32;
    public static final int MOUSE_MOVED_ACTION = 33;
    public static final int AXIS_DRAGGED_ACTION = 40;
    private static ArrayList<String> myInfoList = null;
    protected Component myVisual = this.createVisual();
    protected Color myDefaultBkgd;
    protected Color myDefaultFrgd;
    protected Font myDefaultFont;
    private Dimension mySize;
    private Dimension myDefaultSize;
    private String menuNameEntry = null;
    private ControlWindow myControlWindow = null;
    private String printTarget = null;
    private String tooltipText = null;
    private boolean menuEnabled = true;

    public ControlSwingElement() {
        this.myObject = this.myVisual;
        this.myDefaultFrgd = this.myVisual.getForeground();
        this.myDefaultBkgd = this.myVisual.getBackground();
        this.myDefaultFont = this.myVisual.getFont();
        this.mySize = this.myDefaultSize = this.myVisual.getPreferredSize();
    }

    protected abstract Component createVisual();

    @Override
    public final Component getVisual() {
        return this.myVisual;
    }

    @Override
    public Component getComponent() {
        return this.myVisual;
    }

    public Window getTopWindow() {
        Container parent = this.myVisual.getParent();
        while (parent != null) {
            if (parent instanceof Window) {
                return (Window)parent;
            }
            parent = parent.getParent();
        }
        return null;
    }

    public final void changeVisual(Component newVisual) {
        ControlElement parent;
        ControlElement parentElement;
        if (newVisual.equals(this.myVisual)) {
            return;
        }
        newVisual.setEnabled(this.myVisual.isEnabled());
        newVisual.setVisible(this.myVisual.isVisible());
        newVisual.setPreferredSize(this.mySize);
        if (newVisual instanceof Container) {
            ((Container)newVisual).validate();
        }
        if ((parentElement = this.myGroup.getElement(this.getProperty("parent"))) != null) {
            ((ControlContainer)parentElement).adjustSize();
        }
        newVisual.setForeground(this.myVisual.getForeground());
        newVisual.setBackground(this.myVisual.getBackground());
        newVisual.setFont(this.myVisual.getFont());
        if (newVisual instanceof JComponent) {
            ((JComponent)newVisual).setToolTipText(this.tooltipText);
        }
        if ((parent = this.myGroup.getElement(this.getProperty("parent"))) != null) {
            if (SwingUtilities.isEventDispatchThread()) {
                ((ControlContainer)parent).remove(this);
            } else {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public synchronized void run() {
                            ((ControlContainer)parent).remove(ControlSwingElement.this);
                        }
                    });
                }
                catch (Exception exception) {}
            }
        }
        this.myVisual = newVisual;
        this.myObject = this.myVisual;
        this.myDefaultFrgd = this.myVisual.getForeground();
        this.myDefaultBkgd = this.myVisual.getBackground();
        this.myDefaultFont = this.myVisual.getFont();
        this.mySize = this.myVisual.getPreferredSize();
        if (parent != null) {
            if (SwingUtilities.isEventDispatchThread()) {
                ((ControlContainer)parent).add(this);
                ((ControlContainer)parent).adjustSize();
            } else {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public synchronized void run() {
                            ((ControlContainer)parent).add(ControlSwingElement.this);
                            ((ControlContainer)parent).adjustSize();
                        }
                    });
                }
                catch (Exception exception) {}
            }
        }
    }

    private String getPrintTarget() {
        if (this.printTarget == null) {
            return this.getProperty("name");
        }
        return this.printTarget;
    }

    protected void getPopupMenu(int x, int y) {
        if (this.menuEnabled) {
            this.getSimulation().getPopupMenu(this.getVisual(), x, y, this.getPrintTarget());
        }
    }

    protected void printScreen() {
        this.getSimulation().saveImage(this.getPrintTarget());
    }

    public final void setControlWindow(ControlWindow _window) {
        this.myControlWindow = _window;
    }

    public final ControlWindow getControlWindow() {
        return this.myControlWindow;
    }

    public String getMenuNameEntry() {
        if (this.menuNameEntry != null) {
            if (this.menuNameEntry.equals("null")) {
                return null;
            }
            return this.menuNameEntry;
        }
        return this.getProperty("name");
    }

    @Override
    public List<String> getPropertyList() {
        if (myInfoList == null) {
            myInfoList = new ArrayList();
            myInfoList.add("name");
            myInfoList.add("position");
            myInfoList.add("parent");
            myInfoList.add("enabled");
            myInfoList.add("visible");
            myInfoList.add("size");
            myInfoList.add("foreground");
            myInfoList.add("background");
            myInfoList.add("font");
            myInfoList.add("tooltip");
            myInfoList.add("menuName");
            myInfoList.add("printTarget");
            myInfoList.add("immediateAction");
            myInfoList.add("menu");
        }
        return myInfoList;
    }

    @Override
    public String getPropertyInfo(String _property) {
        if (_property.equals("name")) {
            return "String         CONSTANT";
        }
        if (_property.equals("position")) {
            return "Position       CONSTANT PREVIOUS";
        }
        if (_property.equals("parent")) {
            return "ControlElement CONSTANT";
        }
        if (_property.equals("enabled")) {
            return "boolean";
        }
        if (_property.equals("visible")) {
            return "boolean";
        }
        if (_property.equals("size")) {
            return "Dimension|Object|String TRANSLATABLE";
        }
        if (_property.equals("foreground")) {
            return "int|Color|Object";
        }
        if (_property.equals("background")) {
            return "int|Color|Object";
        }
        if (_property.equals("font")) {
            return "Font|Object";
        }
        if (_property.equals("tooltip")) {
            return "String TRANSLATABLE";
        }
        if (_property.equals("menuName")) {
            return "String TRANSLATABLE";
        }
        if (_property.equals("printTarget")) {
            return "String";
        }
        if (_property.equals("immediateAction")) {
            return "boolean";
        }
        if (_property.equals("menu")) {
            return "boolean";
        }
        return null;
    }

    @Override
    public Value parseConstant(String _propertyType, String _value) {
        Value constantValue;
        if (_value == null) {
            return null;
        }
        if (_propertyType.indexOf("Alignment") >= 0 && (constantValue = ConstantParser.alignmentConstant(_value)) != null) {
            return constantValue;
        }
        if (_propertyType.indexOf("Dimension") >= 0 && (constantValue = ConstantParser.dimensionConstant(_value)) != null) {
            return constantValue;
        }
        if (_propertyType.indexOf("Layout") >= 0 && (constantValue = ConstantParser.layoutConstant(((ControlContainer)this).getContainer(), _value)) != null) {
            return constantValue;
        }
        if (_propertyType.indexOf("Orientation") >= 0 && (constantValue = ConstantParser.orientationConstant(_value)) != null) {
            return constantValue;
        }
        if (_propertyType.indexOf("Placement") >= 0 && (constantValue = ConstantParser.placementConstant(_value)) != null) {
            return constantValue;
        }
        if (_propertyType.indexOf("Point") >= 0 && (constantValue = ConstantParser.pointConstant(_value)) != null) {
            return constantValue;
        }
        if (_propertyType.indexOf("Mnemonic") >= 0 && (_value = _value.trim().toLowerCase()).length() > 0) {
            return new IntegerValue(_value.charAt(0));
        }
        return super.parseConstant(_propertyType, _value);
    }

    @Override
    public String toStringValue(Value _value) {
        if (_value instanceof ObjectValue) {
            ObjectValue obj = (ObjectValue)_value;
            if (obj.value instanceof Point) {
                return ConstantParser.toString((Point)obj.value);
            }
            if (obj.value instanceof Dimension) {
                return ConstantParser.toString((Dimension)obj.value);
            }
        }
        return super.toStringValue(_value);
    }

    @Override
    public void setValue(int _index, final Value _value) {
        switch (_index) {
            case 0: {
                super.setValue(0, _value);
                this.getComponent().setName(_value.toString());
                break;
            }
            case 1: {
                Runnable doIt = new Runnable(){

                    @Override
                    public synchronized void run() {
                        ControlElement parent = ControlSwingElement.this.myGroup.getElement(ControlSwingElement.this.getProperty("parent"));
                        if (parent != null && parent instanceof ControlContainer) {
                            ((ControlContainer)parent).remove(ControlSwingElement.this);
                        }
                        ControlSwingElement.this.myPropertiesTable.put("position", _value.toString());
                        if (parent != null && parent instanceof ControlContainer) {
                            ((ControlContainer)parent).add(ControlSwingElement.this);
                        }
                    }
                };
                if (SwingUtilities.isEventDispatchThread()) {
                    doIt.run();
                    break;
                }
                try {
                    SwingUtilities.invokeAndWait(doIt);
                }
                catch (Exception exception) {
                    doIt.run();
                }
                break;
            }
            case 2: {
                Runnable doIt = new Runnable(){

                    @Override
                    public synchronized void run() {
                        ControlElement parent = ControlSwingElement.this.myGroup.getElement(ControlSwingElement.this.getProperty("parent"));
                        if (parent != null && parent instanceof ControlContainer) {
                            ((ControlContainer)parent).remove(ControlSwingElement.this);
                        }
                        if ((parent = ControlSwingElement.this.myGroup.getElement(_value.toString())) == null) {
                            if (!(ControlSwingElement.this instanceof ControlWindow)) {
                                System.err.println(String.valueOf(this.getClass().getName()) + " : Error! Parent <" + _value + "> not found for " + this.toString());
                            }
                        } else if (parent instanceof ControlContainer) {
                            ((ControlContainer)parent).add(ControlSwingElement.this);
                        } else {
                            System.err.println(String.valueOf(this.getClass().getName()) + " : Error! Parent <" + _value + "> is not a ControlContainer");
                        }
                    }
                };
                if (SwingUtilities.isEventDispatchThread()) {
                    doIt.run();
                    break;
                }
                try {
                    SwingUtilities.invokeAndWait(doIt);
                }
                catch (Exception exception) {
                    doIt.run();
                }
                break;
            }
            case 3: {
                this.getVisual().setEnabled(_value.getBoolean());
                break;
            }
            case 4: {
                this.getVisual().setVisible(_value.getBoolean());
                break;
            }
            case 5: {
                if (_value.getObject() == null) {
                    System.err.println("Size invalid for element " + this.getProperty("name"));
                    return;
                }
                Runnable doIt = new Runnable(){

                    @Override
                    public synchronized void run() {
                        ControlElement parentElement;
                        Dimension size = (Dimension)_value.getObject();
                        if (size.width == ((ControlSwingElement)ControlSwingElement.this).mySize.width && size.height == ((ControlSwingElement)ControlSwingElement.this).mySize.height) {
                            return;
                        }
                        Component component = ControlSwingElement.this.getComponent();
                        Dimension dimension = size;
                        ControlSwingElement.this.mySize = dimension;
                        component.setPreferredSize(dimension);
                        if (ControlSwingElement.this instanceof ControlContainer) {
                            ((ControlContainer)ControlSwingElement.this).getContainer().validate();
                        }
                        if ((parentElement = ControlSwingElement.this.myGroup.getElement(ControlSwingElement.this.getProperty("parent"))) != null) {
                            ((ControlContainer)parentElement).adjustSize();
                        }
                    }
                };
                if (SwingUtilities.isEventDispatchThread()) {
                    doIt.run();
                    break;
                }
                try {
                    SwingUtilities.invokeAndWait(doIt);
                }
                catch (Exception exception) {
                    doIt.run();
                }
                break;
            }
            case 6: {
                if (_value.getObject() instanceof Color) {
                    this.getVisual().setForeground((Color)_value.getObject());
                    break;
                }
                this.getVisual().setForeground(DisplayColors.getLineColor(_value.getInteger()));
                break;
            }
            case 7: {
                if (_value.getObject() instanceof Color) {
                    this.getVisual().setBackground((Color)_value.getObject());
                    break;
                }
                this.getVisual().setBackground(DisplayColors.getLineColor(_value.getInteger()));
                break;
            }
            case 8: {
                if (!(_value.getObject() instanceof Font)) break;
                this.getVisual().setFont((Font)_value.getObject());
                break;
            }
            case 9: {
                this.tooltipText = TeXParser.parseTeX(_value.getString());
                if (!(this.getVisual() instanceof JComponent)) break;
                ((JComponent)this.getVisual()).setToolTipText(this.tooltipText);
                break;
            }
            case 10: {
                this.menuNameEntry = _value.getString();
                break;
            }
            case 11: {
                this.printTarget = _value.getString();
                break;
            }
            case 12: {
                this.setImmediateActions(_value.getBoolean());
                break;
            }
            case 13: {
                this.menuEnabled = _value.getBoolean();
            }
        }
    }

    @Override
    public void setDefaultValue(int _index) {
        switch (_index) {
            case 0: {
                super.setDefaultValue(0);
                this.getComponent().setName("");
                break;
            }
            case 1: {
                ControlElement parent = this.myGroup.getElement(this.getProperty("parent"));
                if (parent != null && parent instanceof ControlContainer) {
                    ((ControlContainer)parent).remove(this);
                }
                this.myPropertiesTable.remove("position");
                if (parent == null || !(parent instanceof ControlContainer)) break;
                ((ControlContainer)parent).add(this);
                break;
            }
            case 2: {
                ControlElement parent = this.myGroup.getElement(this.getProperty("parent"));
                if (parent == null || !(parent instanceof ControlContainer)) break;
                ((ControlContainer)parent).remove(this);
                break;
            }
            case 3: {
                this.getVisual().setEnabled(true);
                break;
            }
            case 4: {
                this.getVisual().setVisible(true);
                break;
            }
            case 5: {
                Runnable doIt = new Runnable(){

                    @Override
                    public synchronized void run() {
                        ControlElement parentElement;
                        Component component = ControlSwingElement.this.getComponent();
                        Dimension dimension = ControlSwingElement.this.myDefaultSize;
                        ControlSwingElement.this.mySize = dimension;
                        component.setPreferredSize(dimension);
                        if (ControlSwingElement.this instanceof ControlContainer) {
                            ((ControlContainer)ControlSwingElement.this).getContainer().validate();
                        }
                        if ((parentElement = ControlSwingElement.this.myGroup.getElement(ControlSwingElement.this.getProperty("parent"))) != null) {
                            ((ControlContainer)parentElement).adjustSize();
                        }
                    }
                };
                if (SwingUtilities.isEventDispatchThread()) {
                    doIt.run();
                    break;
                }
                try {
                    SwingUtilities.invokeAndWait(doIt);
                }
                catch (Exception exception) {
                    doIt.run();
                }
                break;
            }
            case 6: {
                this.getVisual().setForeground(this.myDefaultFrgd);
                break;
            }
            case 7: {
                this.getVisual().setBackground(this.myDefaultBkgd);
                break;
            }
            case 8: {
                this.getVisual().setFont(this.myDefaultFont);
                break;
            }
            case 9: {
                this.tooltipText = null;
                if (!(this.getComponent() instanceof JComponent)) break;
                ((JComponent)this.getVisual()).setToolTipText(this.tooltipText);
                break;
            }
            case 10: {
                this.menuNameEntry = null;
                break;
            }
            case 11: {
                this.printTarget = null;
                break;
            }
            case 12: {
                this.setImmediateActions(false);
                break;
            }
            case 13: {
                this.menuEnabled = true;
                break;
            }
        }
    }

    @Override
    public String getDefaultValueString(int _index) {
        switch (_index) {
            case 3: {
                return "true";
            }
            case 4: {
                return "true";
            }
            case 12: {
                return "false";
            }
            case 13: {
                return "true";
            }
        }
        return "<none>";
    }

    @Override
    public Value getValue(int _index) {
        return null;
    }

    protected static Icon getIcon(String _iconFile) {
        if (_iconFile.startsWith("\"") && _iconFile.endsWith("\"")) {
            _iconFile = _iconFile.substring(1, _iconFile.length() - 1);
        }
        return ResourceLoader.getIcon(_iconFile);
    }

    protected static Image getImage(String _iconFile) {
        if (_iconFile.startsWith("\"") && _iconFile.endsWith("\"")) {
            _iconFile = _iconFile.substring(1, _iconFile.length() - 1);
        }
        return ResourceLoader.getImage(_iconFile);
    }
}

