/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.displayejs;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Stroke;
import java.util.ArrayList;
import java.util.List;
import org.colos.ejs.library.control.displayejs.ControlDrawable3D;
import org.colos.ejs.library.control.value.IntegerValue;
import org.colos.ejs.library.control.value.Value;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.displayejs.InteractiveArrow;
import org.opensourcephysics.displayejs.Style;
import org.opensourcephysics.displayejs.VectorField3D;

public class ControlVectorField3D
extends ControlDrawable3D {
    private static final int VFIELD_ADDED = 13;
    protected VectorField3D vectorfield3d;
    private boolean auto;
    private double minC;
    private double maxC;
    private double zoom;
    private double lineWidth = 1.0;
    private int levels;
    private Color mincolor;
    private Color maxcolor;
    private static List<String> infoList = null;

    @Override
    protected Drawable createDrawable() {
        this.vectorfield3d = new VectorField3D();
        this.minC = 0.0;
        this.maxC = 1.0;
        this.zoom = 1.0;
        this.levels = 0;
        this.auto = true;
        this.vectorfield3d.setAutoscaleMagnitude(true);
        this.vectorfield3d.setInvisibleLevel(-1);
        return this.vectorfield3d;
    }

    @Override
    public List<String> getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList<String>();
            infoList.add("data");
            infoList.add("autoscale");
            infoList.add("minimum");
            infoList.add("maximum");
            infoList.add("levels");
            infoList.add("mincolor");
            infoList.add("maxcolor");
            infoList.add("zoom");
            infoList.add("visible");
            infoList.add("invisibleLevel");
            infoList.add("style");
            infoList.add("stroke");
            infoList.add("measured");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    @Override
    public String getPropertyInfo(String _property) {
        if (_property.equals("data")) {
            return "double[][][][]|double[][][]";
        }
        if (_property.equals("autoscale")) {
            return "boolean";
        }
        if (_property.equals("minimum")) {
            return "int|double";
        }
        if (_property.equals("maximum")) {
            return "int|double";
        }
        if (_property.equals("levels")) {
            return "int";
        }
        if (_property.equals("mincolor")) {
            return "Color|Object";
        }
        if (_property.equals("maxcolor")) {
            return "Color|Object";
        }
        if (_property.equals("zoom")) {
            return "int|double";
        }
        if (_property.equals("visible")) {
            return "boolean";
        }
        if (_property.equals("invisibleLevel")) {
            return "int";
        }
        if (_property.equals("style")) {
            return "ArrowStyle|int";
        }
        if (_property.equals("stroke")) {
            return "int|double|Object";
        }
        if (_property.equals("measured")) {
            return "boolean";
        }
        return super.getPropertyInfo(_property);
    }

    @Override
    public Value parseConstant(String _propertyType, String _value) {
        if (_value == null) {
            return null;
        }
        if (_propertyType.indexOf("ArrowStyle") >= 0) {
            if ((_value = _value.trim().toLowerCase()).equals("arrow")) {
                return new IntegerValue(0);
            }
            if (_value.equals("segment")) {
                return new IntegerValue(1);
            }
            if (_value.equals("box")) {
                return new IntegerValue(2);
            }
        }
        return super.parseConstant(_propertyType, _value);
    }

    @Override
    public void setValue(int _index, Value _value) {
        switch (_index) {
            case 0: {
                if (_value.getObject() instanceof double[][][][]) {
                    this.vectorfield3d.setDataArray((double[][][][])_value.getObject());
                    break;
                }
                if (!(_value.getObject() instanceof double[][][])) break;
                this.vectorfield3d.setDataArray((double[][][])_value.getObject());
                break;
            }
            case 1: {
                if (this.auto == _value.getBoolean()) break;
                this.auto = _value.getBoolean();
                this.vectorfield3d.setAutoscaleMagnitude(this.auto);
                break;
            }
            case 2: {
                if (_value.getDouble() == this.minC) break;
                this.minC = _value.getDouble();
                this.vectorfield3d.setColorExtrema(this.minC, this.maxC);
                break;
            }
            case 3: {
                if (_value.getDouble() == this.maxC) break;
                this.maxC = _value.getDouble();
                this.vectorfield3d.setColorExtrema(this.minC, this.maxC);
                break;
            }
            case 4: {
                if (_value.getInteger() == this.levels) break;
                this.levels = _value.getInteger();
                this.vectorfield3d.setNumberOfLevels(this.levels);
                break;
            }
            case 5: {
                if (this.mincolor == (Color)_value.getObject()) break;
                this.mincolor = (Color)_value.getObject();
                this.vectorfield3d.setMinColor(this.mincolor);
                break;
            }
            case 6: {
                if (this.maxcolor == (Color)_value.getObject()) break;
                this.maxcolor = (Color)_value.getObject();
                this.vectorfield3d.setMaxColor(this.maxcolor);
                break;
            }
            case 7: {
                if (_value.getDouble() == this.zoom) break;
                this.zoom = _value.getDouble();
                this.vectorfield3d.setZoom(this.zoom);
                break;
            }
            case 8: {
                this.vectorfield3d.setVisible(_value.getBoolean());
                break;
            }
            case 9: {
                this.vectorfield3d.setInvisibleLevel(_value.getInteger());
                break;
            }
            case 10: {
                if (_value.getObject() instanceof int[]) {
                    int[] val = (int[])_value.getObject();
                    int i = 0;
                    int n = Math.min(this.vectorfield3d.getNumberOfElements(), val.length);
                    while (i < n) {
                        ((InteractiveArrow)this.vectorfield3d.elementAt(i)).setArrowType(val[i]);
                        ++i;
                    }
                } else {
                    int val = _value.getInteger();
                    int i = 0;
                    int n = this.vectorfield3d.getNumberOfElements();
                    while (i < n) {
                        ((InteractiveArrow)this.vectorfield3d.elementAt(i)).setArrowType(val);
                        ++i;
                    }
                }
                break;
            }
            case 11: {
                if (_value.getObject() instanceof Object[]) {
                    Object[] val = (Object[])_value.getObject();
                    int i = 0;
                    int n = Math.min(this.vectorfield3d.getNumberOfElements(), val.length);
                    while (i < n) {
                        this.vectorfield3d.elementAt(i).getStyle().setEdgeStroke((Stroke)val[i]);
                        ++i;
                    }
                } else if (_value.getObject() instanceof Stroke) {
                    Stroke val = (Stroke)_value.getObject();
                    int i = 0;
                    int n = this.vectorfield3d.getNumberOfElements();
                    while (i < n) {
                        this.vectorfield3d.elementAt(i).getStyle().setEdgeStroke(val);
                        ++i;
                    }
                } else if (_value.getObject() instanceof double[]) {
                    double[] val = (double[])_value.getObject();
                    int i = 0;
                    int n = Math.min(this.vectorfield3d.getNumberOfElements(), val.length);
                    while (i < n) {
                        BasicStroke stroke = val[i] < 0.0 ? new BasicStroke((float)(-val[i]), 0, 0, 10.0f, Style.DASHED_STROKE, 0.0f) : new BasicStroke((float)val[i]);
                        this.vectorfield3d.elementAt(i).getStyle().setEdgeStroke(stroke);
                        ++i;
                    }
                } else {
                    if (this.lineWidth == _value.getDouble()) break;
                    this.lineWidth = _value.getDouble();
                    BasicStroke stroke = this.lineWidth < 0.0 ? new BasicStroke((float)(-this.lineWidth), 0, 0, 10.0f, Style.DASHED_STROKE, 0.0f) : new BasicStroke((float)this.lineWidth);
                    int i = 0;
                    int n = this.vectorfield3d.getNumberOfElements();
                    while (i < n) {
                        this.vectorfield3d.elementAt(i).getStyle().setEdgeStroke(stroke);
                        ++i;
                    }
                }
                break;
            }
            case 12: {
                int i = 0;
                int n = this.vectorfield3d.getNumberOfElements();
                while (i < n) {
                    this.vectorfield3d.elementAt(i).canBeMeasured(_value.getBoolean());
                    ++i;
                }
                break;
            }
            default: {
                super.setValue(_index - 13, _value);
            }
        }
    }

    @Override
    public void setDefaultValue(int _index) {
        switch (_index) {
            case 0: {
                this.vectorfield3d.setDataArray((double[][][])null);
                break;
            }
            case 1: {
                this.auto = true;
                this.vectorfield3d.setAutoscaleMagnitude(true);
                break;
            }
            case 2: {
                this.minC = 0.0;
                this.vectorfield3d.setColorExtrema(0.0, this.maxC);
                break;
            }
            case 3: {
                this.maxC = 1.0;
                this.vectorfield3d.setColorExtrema(this.minC, 1.0);
                break;
            }
            case 4: {
                this.levels = 16;
                this.vectorfield3d.setNumberOfLevels(16);
                break;
            }
            case 5: {
                this.mincolor = Color.blue;
                this.vectorfield3d.setMinColor(this.mincolor);
                break;
            }
            case 6: {
                this.maxcolor = Color.red;
                this.vectorfield3d.setMaxColor(this.maxcolor);
                break;
            }
            case 7: {
                this.zoom = 1.0;
                this.vectorfield3d.setZoom(1.0);
                break;
            }
            case 8: {
                this.vectorfield3d.setVisible(true);
                break;
            }
            case 9: {
                this.vectorfield3d.setInvisibleLevel(-1);
                break;
            }
            case 10: {
                int i = 0;
                int n = this.vectorfield3d.getNumberOfElements();
                while (i < n) {
                    ((InteractiveArrow)this.vectorfield3d.elementAt(i)).setArrowType(0);
                    ++i;
                }
                break;
            }
            case 11: {
                this.lineWidth = 1.0;
                BasicStroke stroke = new BasicStroke((float)1.0);
                int i = 0;
                int n = this.vectorfield3d.getNumberOfElements();
                while (i < n) {
                    this.vectorfield3d.elementAt(i).getStyle().setEdgeStroke(stroke);
                    ++i;
                }
                break;
            }
            case 12: {
                int i = 0;
                int n = this.vectorfield3d.getNumberOfElements();
                while (i < n) {
                    this.vectorfield3d.elementAt(i).canBeMeasured(true);
                    ++i;
                }
                break;
            }
            default: {
                super.setDefaultValue(_index - 13);
            }
        }
    }

    @Override
    public Value getValue(int _index) {
        switch (_index) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                return null;
            }
        }
        return super.getValue(_index - 13);
    }
}

