/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.displayejs;

import org.colos.ejs.library.control.displayejs.ControlElementSet;
import org.colos.ejs.library.control.value.IntegerValue;
import org.colos.ejs.library.control.value.Value;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.displayejs.ElementSet;
import org.opensourcephysics.displayejs.InteractiveArrow;

public class ControlArrowSet
extends ControlElementSet {
    @Override
    protected Drawable createDrawable() {
        this.elementSet = new ElementSet(1, InteractiveArrow.class);
        this.elementSet.setEnabled(1, true);
        return this.elementSet;
    }

    @Override
    protected int getPropertiesDisplacement() {
        return 0;
    }

    @Override
    public String getPropertyCommonName(String _property) {
        if (_property.equals("color")) {
            return "lineColor";
        }
        if (_property.equals("secondaryColor")) {
            return "fillColor";
        }
        if (_property.equals("enabled")) {
            return "enabledSize";
        }
        if (_property.equals("enabledSecondary")) {
            return "enabledPosition";
        }
        return super.getPropertyCommonName(_property);
    }

    @Override
    public String getPropertyInfo(String _property) {
        if (_property.equals("style")) {
            return "ArrowStyle|int";
        }
        return super.getPropertyInfo(_property);
    }

    @Override
    public Value parseConstant(String _propertyType, String _value) {
        if (_value == null) {
            return null;
        }
        if (_propertyType.indexOf("ArrowStyle") >= 0) {
            if ((_value = _value.trim().toLowerCase()).equals("arrow")) {
                return new IntegerValue(0);
            }
            if (_value.equals("segment")) {
                return new IntegerValue(1);
            }
            if (_value.equals("box")) {
                return new IntegerValue(2);
            }
        }
        return super.parseConstant(_propertyType, _value);
    }

    @Override
    public void setValue(int _index, Value _value) {
        switch (_index) {
            case 18: {
                if (_value.getObject() instanceof int[]) {
                    int[] val = (int[])_value.getObject();
                    int i = 0;
                    int n = Math.min(this.elementSet.getNumberOfElements(), val.length);
                    while (i < n) {
                        ((InteractiveArrow)this.elementSet.elementAt(i)).setArrowType(val[i]);
                        ++i;
                    }
                } else {
                    int val = _value.getInteger();
                    int i = 0;
                    int n = this.elementSet.getNumberOfElements();
                    while (i < n) {
                        ((InteractiveArrow)this.elementSet.elementAt(i)).setArrowType(val);
                        ++i;
                    }
                }
                break;
            }
            case 11: {
                if (_value.getObject() instanceof boolean[]) {
                    this.elementSet.setEnableds(1, (boolean[])_value.getObject());
                    break;
                }
                this.elementSet.setEnabled(1, _value.getBoolean());
                break;
            }
            case 12: {
                if (_value.getObject() instanceof boolean[]) {
                    this.elementSet.setEnableds(0, (boolean[])_value.getObject());
                    break;
                }
                this.elementSet.setEnabled(0, _value.getBoolean());
                break;
            }
            default: {
                super.setValue(_index, _value);
            }
        }
    }

    @Override
    public void setDefaultValue(int _index) {
        switch (_index) {
            case 11: {
                this.elementSet.setEnabled(1, true);
                break;
            }
            case 12: {
                this.elementSet.setEnabled(0, false);
                break;
            }
            case 18: {
                int i = 0;
                int n = this.elementSet.getNumberOfElements();
                while (i < n) {
                    ((InteractiveArrow)this.elementSet.elementAt(i)).setArrowType(0);
                    ++i;
                }
                break;
            }
            default: {
                super.setDefaultValue(_index);
            }
        }
    }

    @Override
    public String getDefaultValueString(int _index) {
        switch (_index) {
            case 11: {
                return "true";
            }
            case 12: {
                return "false";
            }
            case 18: {
                return "ARROW";
            }
        }
        return super.getDefaultValueString(_index);
    }
}

