/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library;

import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.text.DecimalFormat;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.JTextComponent;
import javax.swing.text.html.HTMLEditorKit;
import org.colos.ejs.library.Animation;
import org.colos.ejs.library.Experiment;
import org.colos.ejs.library.LauncherApplet;
import org.colos.ejs.library.Memory;
import org.colos.ejs.library.Model;
import org.colos.ejs.library.MoodleLink;
import org.colos.ejs.library.control.ControlElement;
import org.colos.ejs.library.control.EjsControl;
import org.colos.ejs.library.control.MethodWithOneParameter;
import org.colos.ejs.library.control.SpecialRender;
import org.colos.ejs.library.utils.FileUtils;
import org.colos.ejs.library.utils.HtmlPageInfo;
import org.colos.ejs.library.utils.LocaleItem;
import org.colos.ejs.library.utils.LocaleListener;
import org.colos.ejs.library.utils.VideoUtil;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.desktop.OSPDesktop;
import org.opensourcephysics.display.DisplayRes;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.display.dialogs.DialogsRes;
import org.opensourcephysics.tools.Diagnostics;
import org.opensourcephysics.tools.DiagnosticsForSystem;
import org.opensourcephysics.tools.DiagnosticsForThreads;
import org.opensourcephysics.tools.DiagnosticsForXuggle;
import org.opensourcephysics.tools.EjsTool;
import org.opensourcephysics.tools.FontSizer;
import org.opensourcephysics.tools.Resource;
import org.opensourcephysics.tools.ResourceLoader;
import org.opensourcephysics.tools.SnapshotTool;
import org.opensourcephysics.tools.ToolsRes;
import org.opensourcephysics.tools.XuggleRes;

public abstract class Simulation
extends Animation
implements LocaleListener {
    public static ResourceBundle ejsRes = ResourceBundle.getBundle("org.colos.ejs.library.resources.ejs_res", Locale.getDefault());
    private static final String DEFAULT_STATE_FILENAME = "DefaultState.out";
    private static String pathToLibrary = "";
    private static AWTEventListener focusListener = null;
    private static String homeDir = null;
    private static String userDir = null;
    private boolean isUnderEjs = false;
    private Component parentComponent = null;
    private String parentComponentName = null;
    private String captureElement = null;
    private URL codebase = null;
    private LocaleItem currentLocaleItem = LocaleItem.getDefaultLocaleItem();
    private List<String> stateVariablesList = null;
    private JLabel increaseFontButton;
    private JLabel decreaseFontButton;
    private JLabel openPageButton;
    protected VideoUtil videoUtil;
    private static Hashtable<String, File> resourcesExtracted = new Hashtable();
    private Set<LocaleItem> availableLocales = new HashSet<LocaleItem>();
    private boolean showDescriptionOnStart = true;
    private JFrame descriptionDialog = null;
    private JTabbedPane descriptionPanel = null;
    private List<EditorAndScroll> descriptionPagesList = null;
    private static final String dummy = "";
    private static final Class<?> strClass = "".getClass();
    private static Hashtable<String, Object> memory = new Hashtable();
    protected MoodleLink moodle = null;
    private MethodWithOneParameter _init_ = null;
    private LauncherApplet javascriptControledApplet = null;
    protected JPopupMenu popupMenu = null;
    private JMenu elementsMenu = null;
    private AbstractList<Object> popupMenuExtraEntries = null;
    private Component popupTriggeredBy = null;
    protected Experiment currentExperiment = null;
    JMenuItem snapshotMenuItem;
    private JDialog aboutThisDialog = null;

    public static String getEjsString(String key) {
        try {
            return ejsRes.getString(key);
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return key;
        }
    }

    public static String getPathToLibrary() {
        return pathToLibrary;
    }

    public static void setPathToLibrary(String _path) {
        try {
            File libDir = new File(_path);
            if (libDir.exists() && libDir.isDirectory()) {
                pathToLibrary = _path;
            }
        }
        catch (Exception exception) {}
    }

    public static String getUserDir() {
        if (userDir == null) {
            try {
                userDir = System.getProperty("user.dir").replace('\\', '/');
                if (!userDir.endsWith("/")) {
                    userDir = String.valueOf(userDir) + "/";
                }
            }
            catch (Exception exception) {
                return dummy;
            }
        }
        return userDir;
    }

    public static String getHomeDir() {
        if (homeDir == null) {
            try {
                homeDir = System.getProperty("user.home").replace('\\', '/');
                if (!homeDir.endsWith("/")) {
                    homeDir = String.valueOf(homeDir) + "/";
                }
            }
            catch (Exception exception) {
                return dummy;
            }
        }
        return homeDir;
    }

    public static String getTemporaryDir() {
        try {
            return String.valueOf(Simulation.getHomeDir()) + ".Ejs.tmp/";
        }
        catch (Exception exception) {
            return dummy;
        }
    }

    public static File getResourceFile(String _filename) {
        return Simulation.getResourceFile(_filename, true);
    }

    public static File getResourceFile(String _filename, boolean _deleteOnExit) {
        Resource res = ResourceLoader.getResource(_filename);
        if (res == null) {
            return null;
        }
        File resourceFile = res.getFile();
        if (resourceFile != null && resourceFile.exists()) {
            return resourceFile;
        }
        resourceFile = resourcesExtracted.get(_filename);
        if (resourceFile != null) {
            return resourceFile;
        }
        int index = _filename.lastIndexOf(46);
        String suffix = index >= 0 ? _filename.substring(index) : ".tmp";
        try {
            int c;
            resourceFile = File.createTempFile("ejs_tmp_", suffix);
            if (_deleteOnExit) {
                resourceFile.deleteOnExit();
            }
            InputStream inputStream = res.openInputStream();
            FileOutputStream fout = new FileOutputStream(resourceFile);
            BufferedInputStream in = new BufferedInputStream(inputStream);
            while ((c = in.read()) != -1) {
                fout.write(c);
            }
            in.close();
            fout.close();
            resourcesExtracted.put(_filename, resourceFile);
            System.out.println("Ejs simulation: resource " + _filename + " extracted into " + resourceFile.getAbsolutePath());
            return resourceFile;
        }
        catch (Exception exc) {
            System.out.println("Ejs simulation: resource " + _filename + " could NOT be extracted");
            exc.printStackTrace();
            return null;
        }
    }

    public static File extractToDirectory(String _resourceString, File _targetDirectory, boolean _verbose) {
        return Simulation.extractToDirectory(_resourceString, _targetDirectory, _verbose, true);
    }

    public static File extractToDirectory(String _resourceString, File _targetDirectory, boolean _verbose, boolean _deleteOnExit) {
        try {
            int c;
            File destFile = new File(_targetDirectory, _resourceString);
            if (_deleteOnExit) {
                destFile.deleteOnExit();
            }
            destFile.getParentFile().mkdirs();
            InputStream inputStream = ResourceLoader.openInputStream(_resourceString);
            FileOutputStream fout = new FileOutputStream(destFile);
            BufferedInputStream in = new BufferedInputStream(inputStream);
            while ((c = in.read()) != -1) {
                fout.write(c);
            }
            in.close();
            fout.close();
            if (_verbose) {
                System.out.println("Ejs simulation: resource " + _resourceString + " extracted into " + destFile.getAbsolutePath());
            }
            return destFile;
        }
        catch (Exception exc) {
            System.out.println("Ejs simulation: resource " + _resourceString + " could NOT be extracted");
            exc.printStackTrace();
            return null;
        }
    }

    public static File extractAs(String _resourceString, String filename, boolean _verbose) {
        return Simulation.extractAs(_resourceString, filename, _verbose, true);
    }

    public static File extractAs(String _resourceString, String filename, boolean _verbose, boolean _deleteOnExit) {
        try {
            int c;
            File destFile = new File(filename);
            if (_deleteOnExit) {
                destFile.deleteOnExit();
            }
            if (destFile.getParentFile() != null) {
                destFile.getParentFile().mkdirs();
            }
            InputStream inputStream = ResourceLoader.openInputStream(_resourceString);
            FileOutputStream fout = new FileOutputStream(destFile);
            BufferedInputStream in = new BufferedInputStream(inputStream);
            while ((c = in.read()) != -1) {
                fout.write(c);
            }
            in.close();
            fout.close();
            if (_verbose) {
                System.out.println("Ejs simulation: resource " + _resourceString + " extracted into " + destFile.getAbsolutePath());
            }
            return destFile;
        }
        catch (Exception exc) {
            System.err.println("Ejs simulation: resource " + _resourceString + " could NOT be extracted");
            exc.printStackTrace();
            return null;
        }
    }

    public boolean hasDefaultState() {
        if (this.isMoodleConnected()) {
            return false;
        }
        Resource res = ResourceLoader.getResource(DEFAULT_STATE_FILENAME);
        return res != null;
    }

    public boolean readDefaultState() {
        if (this.isMoodleConnected()) {
            return false;
        }
        if (this.hasDefaultState()) {
            return this.readVariables(DEFAULT_STATE_FILENAME, null);
        }
        return false;
    }

    public String getResetFilename() {
        return this.resetFile;
    }

    @Override
    protected void userDefinedReset() {
        if (this.resetFile != null && !this.isMoodleConnected()) {
            if (this.resetFile.equals(DEFAULT_STATE_FILENAME)) {
                this.readVariables(DEFAULT_STATE_FILENAME, null);
            } else {
                this.readState(this.resetFile);
            }
            if (this.view != null) {
                this.view.reset();
            }
        }
    }

    @Override
    protected void userDefinedViewUpdate() {
        this.videoUtil.captureVideoImage();
        this.getModel()._readFromViewAfterUpdate();
    }

    public void captureVideo(String element) {
        this.videoUtil.startVideoTool(this.getView(), element);
    }

    private String getClassname() {
        String classname = this.getClass().getName();
        int index = classname.lastIndexOf(46);
        if (index >= 0) {
            classname = classname.substring(index + 1);
        }
        return classname;
    }

    private String getModelClassname() {
        String classname = this.model.getClass().getName();
        int index = classname.lastIndexOf(46);
        if (index >= 0) {
            classname = classname.substring(index + 1);
        }
        return classname;
    }

    private void errorMessage(String _text) {
        System.err.println(String.valueOf(this.getClassname()) + ": " + _text);
    }

    private void errorMessage(Exception _exc) {
        System.err.println(String.valueOf(this.getClassname()) + ": Exception caught! Text follows:");
        _exc.printStackTrace(System.err);
    }

    public void setParentComponent(Component _component) {
        this.parentComponent = _component;
    }

    public void setParentComponent(String _componentName) {
        this.parentComponentName = _componentName;
        this.parentComponent = null;
    }

    public Component getParentComponent() {
        if (this.parentComponent == null && this.view != null) {
            this.parentComponent = this.view.getComponent(this.parentComponentName);
        }
        return this.parentComponent;
    }

    public void setCodebase(URL _codebase) {
        this.codebase = _codebase;
    }

    public URL getCodebase() {
        return this.codebase;
    }

    public void addAvailableLocale(String _language) {
        LocaleItem localeItem = LocaleItem.getLocaleItem(_language);
        if (localeItem != null) {
            this.availableLocales.add(localeItem);
        } else {
            System.out.println("Warning! Html editor is ignoring unrecognized locale name : " + _language + "\n");
        }
    }

    public Set<LocaleItem> getAvailableLocales() {
        return this.availableLocales;
    }

    public String translateString(String _property, String _default) {
        return Model._getTranslatorUtil().translateString(_property, _default);
    }

    public String translateString(String _property) {
        return Model._getTranslatorUtil().translateString(_property);
    }

    @Override
    public void setLocaleItem(LocaleItem _item) {
        this.setLocaleItem(_item, true);
    }

    protected void setLocaleItem(LocaleItem _item, boolean _resetModel) {
        this.currentLocaleItem = _item;
        Locale locale = _item.getLocale();
        if (locale == null) {
            locale = Locale.getDefault();
        }
        ToolsRes.setLocale(locale);
        DisplayRes.setLocale(locale);
        DialogsRes.setLocale(locale);
        ejsRes = ResourceBundle.getBundle("org.colos.ejs.library.resources.ejs_res", locale);
        Model._getTranslatorUtil().setLocaleItem(this.currentLocaleItem);
        this.setViewLocale();
        this.popupMenu = null;
        this.resetDescriptionPages();
        if (_resetModel) {
            this.model._reset();
        }
    }

    public LocaleItem getLocaleItem() {
        return this.currentLocaleItem;
    }

    public void setLocale(String _language) {
        LocaleItem item = LocaleItem.getLocaleItem(_language);
        if (item != null) {
            this.setLocaleItem(item);
        } else {
            System.out.println("Warning! Html editor is ignoring unrecognized locale name : " + _language + "\n");
            this.setLocaleItem(LocaleItem.getDefaultItem());
        }
    }

    public Locale getLocale() {
        Locale locale = this.currentLocaleItem.getLocale();
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return locale;
    }

    protected void setViewLocale() {
        this.elementsMenu = null;
        this.popupMenuExtraEntries = null;
        if (this.view instanceof EjsControl) {
            ((EjsControl)((Object)this.view)).addElementsMenuEntries();
        }
        this.view.update();
        this.view.finalUpdate();
    }

    private void createDescriptionDialog(int _width, int _height) {
        this.descriptionPanel = new JTabbedPane();
        final Border border = BorderFactory.createEmptyBorder(1, 1, 1, 1);
        final Border clickedBorder = BorderFactory.createLineBorder(new Color(128, 64, 255), 1);
        Cursor handCursor = Cursor.getPredefinedCursor(12);
        this.increaseFontButton = new JLabel(ResourceLoader.getIcon("/org/colos/ejs/library/resources/fontUp.gif"));
        this.increaseFontButton.setBorder(border);
        this.increaseFontButton.setCursor(handCursor);
        this.increaseFontButton.setToolTipText(DisplayRes.getString("DrawingFrame.IncreaseFontSize_menu_item"));
        this.increaseFontButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(final MouseEvent _evt) {
                ((JComponent)_evt.getComponent()).setBorder(clickedBorder);
                Timer timer = new Timer(1000, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent _actionEvent) {
                        ((JComponent)_evt.getComponent()).setBorder(border);
                    }
                });
                timer.setRepeats(false);
                timer.start();
                if (SwingUtilities.isLeftMouseButton(_evt)) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (Simulation.this.descriptionPagesList == null) {
                                return;
                            }
                            for (EditorAndScroll eas : Simulation.this.descriptionPagesList) {
                                Font oldFont = eas.editorPane.getFont();
                                float newSize = oldFont.getSize2D() * 1.1f;
                                eas.editorPane.setFont(oldFont.deriveFont(newSize));
                            }
                        }
                    });
                }
            }
        });
        this.decreaseFontButton = new JLabel(ResourceLoader.getIcon("/org/colos/ejs/library/resources/fontDown.gif"));
        this.decreaseFontButton.setBorder(border);
        this.decreaseFontButton.setCursor(handCursor);
        this.decreaseFontButton.setToolTipText(DisplayRes.getString("DrawingFrame.DecreaseFontSize_menu_item"));
        this.decreaseFontButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(final MouseEvent _evt) {
                ((JComponent)_evt.getComponent()).setBorder(clickedBorder);
                Timer timer = new Timer(1000, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent _actionEvent) {
                        ((JComponent)_evt.getComponent()).setBorder(border);
                    }
                });
                timer.setRepeats(false);
                timer.start();
                if (SwingUtilities.isLeftMouseButton(_evt)) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (Simulation.this.descriptionPagesList == null) {
                                return;
                            }
                            for (EditorAndScroll eas : Simulation.this.descriptionPagesList) {
                                Font oldFont = eas.editorPane.getFont();
                                float newSize = Math.max(10.0f, oldFont.getSize2D() / 1.1f);
                                eas.editorPane.setFont(oldFont.deriveFont(newSize));
                            }
                        }
                    });
                }
            }
        });
        this.openPageButton = new JLabel(ResourceLoader.getIcon("/org/colos/ejs/library/resources/fullScreen.gif"));
        this.openPageButton.setBorder(border);
        this.openPageButton.setCursor(handCursor);
        this.openPageButton.setToolTipText(Memory.getResource("DescriptionPages.OpenExternalBrowser"));
        this.openPageButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(final MouseEvent _evt) {
                ((JComponent)_evt.getComponent()).setBorder(clickedBorder);
                Timer timer = new Timer(1000, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent _actionEvent) {
                        ((JComponent)_evt.getComponent()).setBorder(border);
                    }
                });
                timer.setRepeats(false);
                timer.start();
                if (SwingUtilities.isLeftMouseButton(_evt)) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (Simulation.this.descriptionPagesList == null) {
                                return;
                            }
                            Component selectedComponent = Simulation.this.descriptionPanel.getSelectedComponent();
                            for (EditorAndScroll pane : Simulation.this.descriptionPagesList) {
                                if (selectedComponent != pane.scrollPane) continue;
                                if (!Simulation.this.openDescriptionPageInBrowser(pane.name)) {
                                    JOptionPane.showMessageDialog(Simulation.this.openPageButton, Memory.getResource("DescriptionPages.ErrorOpeningFiles"), Memory.getResource("Error"), 0);
                                }
                                return;
                            }
                            System.err.println("DescriptionPages : Could not find the selected page.");
                        }
                    });
                }
            }
        });
        JPanel buttonsPanel = new JPanel(new FlowLayout(1));
        buttonsPanel.add(this.increaseFontButton);
        buttonsPanel.add(this.decreaseFontButton);
        buttonsPanel.add(this.openPageButton);
        JPanel bottomPanel = new JPanel(new BorderLayout());
        bottomPanel.setBorder(new EtchedBorder(1));
        JComponent localeComponent = Model._getTranslatorUtil().getSelectorComponent(this);
        if (localeComponent != null) {
            localeComponent.setBorder(new EmptyBorder(0, 0, 0, 2));
            bottomPanel.add((Component)buttonsPanel, "West");
            bottomPanel.add((Component)localeComponent, "East");
        } else {
            bottomPanel.add((Component)buttonsPanel, "Center");
        }
        this.descriptionDialog = new JFrame(String.valueOf(Memory.getResource("DescriptionFor")) + " " + this.getModelClassname());
        this.descriptionDialog.getContentPane().add((Component)this.descriptionPanel, "Center");
        this.descriptionDialog.getContentPane().add((Component)bottomPanel, "South");
        if (_width <= 0) {
            _width = 600;
        }
        if (_height <= 0) {
            _height = 400;
        }
        Rectangle bounds = EjsControl.getDefaultScreenBounds();
        _width = Math.min(_width, bounds.width - 10);
        _height = Math.min(_height, bounds.height - 10);
        this.descriptionDialog.setLocation(bounds.x + (bounds.width - _width) / 2, bounds.y + (bounds.height - _height) / 2);
    }

    public void addDescriptionPage(String _htmlPage, int _width, int _height, boolean _visible) {
        HtmlPageInfo pageInfo = this.model._getHtmlPageInfo(_htmlPage, this.currentLocaleItem);
        if (pageInfo == null) {
            JOptionPane.showMessageDialog(this.popupTriggeredBy, "Html file not found: " + _htmlPage, "Description Error", 0);
            return;
        }
        Resource htmlRes = ResourceLoader.getResource(pageInfo.getLink());
        if (htmlRes == null) {
            System.err.println("Add description page error : Couldn't find description file: " + _htmlPage);
            System.err.println("Link = " + pageInfo.getLink());
            return;
        }
        if (this.descriptionDialog == null) {
            this.createDescriptionDialog(_width, _height);
        }
        try {
            JEditorPane editorPane = new JEditorPane(){};
            HTMLEditorKit kit = new HTMLEditorKit();
            editorPane.setEditorKit(kit);
            editorPane.setDocument(kit.createDefaultDocument());
            editorPane.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
            editorPane.setEditable(false);
            editorPane.addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent e) {
                    if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        Simulation.this.openURL(e.getSource(), e.getURL(), Simulation.this.getView().getComponent(Simulation.this.getMainWindow()), Simulation.this.model._getApplet() != null);
                    }
                }
            });
            editorPane.setPage(htmlRes.getURL());
            JScrollPane editorScrollPane = new JScrollPane(editorPane);
            editorScrollPane.setPreferredSize(new Dimension(_width, _height));
            if (this.descriptionPagesList == null) {
                this.descriptionPagesList = new ArrayList<EditorAndScroll>();
            }
            EditorAndScroll pane = new EditorAndScroll(_htmlPage, editorPane, editorScrollPane);
            pane.setVisible(_visible);
            this.descriptionPagesList.add(pane);
        }
        catch (IOException iOException) {
            System.err.println("Attempted to read a bad URL: " + htmlRes.getURL());
        }
    }

    public void addDescriptionPage(String _title, String _htmlPage, int width, int height) {
        this.addDescriptionPage(_htmlPage, width, height, true);
    }

    public void setDescriptionPageVisible(String _name, boolean _visible) {
        if (this.descriptionPagesList == null) {
            return;
        }
        for (EditorAndScroll pane : this.descriptionPagesList) {
            if (!pane.name.equals(_name)) continue;
            if (pane.isVisible() == _visible) break;
            pane.setVisible(_visible);
            this.recreateDescriptionPanel();
            break;
        }
    }

    protected void recreateDescriptionPanel() {
        if (this.descriptionPanel == null) {
            return;
        }
        this.descriptionPanel.removeAll();
        for (EditorAndScroll pane : this.descriptionPagesList) {
            HtmlPageInfo pageInfo;
            if (!pane.isVisible() || (pageInfo = this.model._getHtmlPageInfo(pane.name, this.currentLocaleItem)) == null) continue;
            this.descriptionPanel.add(pageInfo.getTitle(), pane.scrollPane);
        }
        this.descriptionDialog.pack();
        if (this.descriptionPanel.getTabCount() <= 0) {
            this.descriptionDialog.setVisible(false);
            this.showDescriptionOnStart = false;
        }
    }

    @Override
    protected void resetDescriptionPages() {
        if (this.descriptionPagesList == null) {
            return;
        }
        try {
            for (EditorAndScroll pane : this.descriptionPagesList) {
                HtmlPageInfo pageInfo = this.model._getHtmlPageInfo(pane.name, this.currentLocaleItem);
                if (pageInfo == null) continue;
                Resource htmlRes = ResourceLoader.getResource(pageInfo.getLink());
                URL url = htmlRes.getURL();
                if (pane.editorPane.getPage() == url) continue;
                pane.editorPane.setPage(url);
                this.descriptionPanel.setTitleAt(this.descriptionPanel.indexOfComponent(pane.scrollPane), pageInfo.getTitle());
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        if (this.increaseFontButton != null) {
            this.descriptionDialog.setTitle(String.valueOf(Memory.getResource("DescriptionFor")) + " " + this.getModelClassname());
            this.increaseFontButton.setToolTipText(DisplayRes.getString("DrawingFrame.IncreaseFontSize_menu_item"));
            this.decreaseFontButton.setToolTipText(DisplayRes.getString("DrawingFrame.DecreaseFontSize_menu_item"));
            this.openPageButton.setToolTipText(Memory.getResource("DescriptionPages.OpenExternalBrowser"));
        }
    }

    public void showDescriptionAtStartUp(boolean _show) {
        this.showDescriptionOnStart = _show;
    }

    public void showDescription() {
        this.showDescription(true);
    }

    public void showDescription(boolean _show) {
        if (this.descriptionDialog != null) {
            this.descriptionDialog.setVisible(_show);
        }
    }

    public URL getDescriptionPageURL(String _htmlPage) {
        HtmlPageInfo pageInfo = this.model._getHtmlPageInfo(_htmlPage, this.currentLocaleItem);
        if (pageInfo == null) {
            return null;
        }
        return ResourceLoader.getResource(pageInfo.getLink()).getURL();
    }

    public boolean openDescriptionPagesInBrowser() {
        File tempDir = this.extractResources();
        if (tempDir == null) {
            return false;
        }
        boolean failed = false;
        for (EditorAndScroll pane : this.descriptionPagesList) {
            HtmlPageInfo pageInfo = this.model._getHtmlPageInfo(pane.name, this.currentLocaleItem);
            if (pageInfo == null) {
                System.err.println("DescriptionPages : Could not find the page: " + pane.name);
                failed = true;
            }
            if (this.openExternalBrowser(tempDir, pageInfo)) continue;
            failed = true;
        }
        return failed;
    }

    public boolean openDescriptionPageInBrowser(String _name) {
        File tempDir = this.extractResources();
        if (tempDir == null) {
            return false;
        }
        HtmlPageInfo pageInfo = this.model._getHtmlPageInfo(_name, this.currentLocaleItem);
        if (pageInfo == null) {
            System.err.println("DescriptionPages : Could not find the page: " + _name);
            return false;
        }
        return this.openExternalBrowser(tempDir, pageInfo);
    }

    private File extractResources() {
        if (OSPRuntime.appletMode) {
            return null;
        }
        File descTempDirectory = new File(String.valueOf(Simulation.getTemporaryDir()) + "DescriptionPages/");
        if (!descTempDirectory.exists() && !descTempDirectory.mkdirs()) {
            System.err.println("DescriptionPages : Could not create directory : " + descTempDirectory.getAbsolutePath());
            JOptionPane.showMessageDialog(this.openPageButton, Memory.getResource("DescriptionPages.CannotExtractFiles"), Memory.getResource("Error"), 0);
            return null;
        }
        for (String filename : this.model._getClassEjsResources()) {
            if (Simulation.extractToDirectory(filename, descTempDirectory, false) != null) continue;
            return null;
        }
        Simulation.extractToDirectory("/_ejs_library/css/ejss.css", descTempDirectory, false);
        Simulation.extractToDirectory("/_ejs_library/css/ejsPage.css", descTempDirectory, false);
        return descTempDirectory;
    }

    private boolean openExternalBrowser(File _tmpDir, HtmlPageInfo _pageInfo) {
        String localPage = _pageInfo.getLink();
        if (localPage.startsWith("./")) {
            localPage = String.valueOf(this.model._getClassModelDirectory()) + localPage.substring(2);
        }
        if (Simulation.extractToDirectory(localPage, _tmpDir, false) == null) {
            return false;
        }
        localPage = "file:///" + FileUtils.correctUrlString(String.valueOf(FileUtils.getPath(_tmpDir)) + localPage);
        return OSPDesktop.displayURL(localPage);
    }

    public void openURL(Object _source, URL _url, Component _parentComponent, boolean _isApplet) {
        try {
            String path = _url.toString();
            int index = path.indexOf("jar!");
            if (index < 0) {
                this.tellTheUserToWait();
                OSPDesktop.displayURL(_url.toString());
                return;
            }
            if ((path = path.substring(index + 4)).startsWith("/")) {
                path = path.substring(1);
            }
            if (_isApplet) {
                this.tellTheUserToWait();
                OSPDesktop.displayURL(_url.toString());
            } else {
                boolean mustExtract;
                String lowerCase = path.toLowerCase();
                boolean bl = mustExtract = lowerCase.indexOf(".html") < 0 && lowerCase.indexOf(".htm") < 0;
                if (mustExtract) {
                    File resource = Simulation.getResourceFile(path);
                    if (resource == null) {
                        JOptionPane.showMessageDialog(_parentComponent, String.valueOf(ejsRes.getString("Simulation.ErrorWhenOpening")) + ":\n  " + _url.getFile());
                    } else {
                        this.tellTheUserToWait();
                        OSPDesktop.displayURL(resource.toURI().toString());
                    }
                } else {
                    int index2 = path.indexOf(35);
                    String name = index2 >= 0 ? path.substring(0, index2) : path;
                    for (EditorAndScroll pane : this.descriptionPagesList) {
                        if (!name.equals(pane.name)) continue;
                        this.descriptionPanel.setSelectedComponent(pane.scrollPane);
                        if (pane.editorPane.getPage() != _url) {
                            pane.editorPane.setPage(_url);
                        }
                        if (_url.getRef() != null) {
                            pane.editorPane.scrollToReference(_url.getRef());
                        }
                        return;
                    }
                    ((JEditorPane)_source).setPage(_url);
                }
            }
        }
        catch (Exception exc1) {
            JOptionPane.showMessageDialog(_parentComponent, String.valueOf(ejsRes.getString("Simulation.ErrorWhenOpening")) + ":\n  " + _url.getFile());
            exc1.printStackTrace();
        }
    }

    private void tellTheUserToWait() {
        final JDialog warningDialog = new JDialog((Frame)this.descriptionDialog, ejsRes.getString("Simulation.Opening"));
        final JLabel label = new JLabel(ejsRes.getString("Simulation.Opening"));
        label.setBorder(new EmptyBorder(5, 5, 5, 5));
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                warningDialog.getContentPane().setLayout(new BorderLayout());
                warningDialog.getContentPane().add((Component)label, "Center");
                warningDialog.validate();
                warningDialog.pack();
                warningDialog.setLocationRelativeTo(Simulation.this.descriptionDialog);
                warningDialog.setModal(false);
                warningDialog.setVisible(true);
            }
        });
        Timer timer = new Timer(3000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent _actionEvent) {
                warningDialog.setVisible(false);
                warningDialog.dispose();
            }
        });
        timer.setRepeats(false);
        timer.start();
    }

    public String getVariable(String _name) {
        return this.getVariable(_name, ",");
    }

    public String getVariable(String _name, String _sep) {
        if (this.model == null) {
            return null;
        }
        try {
            Field field = this.model.getClass().getField(_name);
            if (field.getType().isArray()) {
                String txt = dummy;
                Object array = field.get(this.model);
                int l = Array.getLength(array);
                int i = 0;
                while (i < l) {
                    txt = i > 0 ? String.valueOf(txt) + _sep + Array.get(array, i).toString() : String.valueOf(txt) + Array.get(array, i).toString();
                    ++i;
                }
                return txt;
            }
            return field.get(this.model).toString();
        }
        catch (Exception exc) {
            this.errorMessage(exc);
            return null;
        }
    }

    public boolean setVariable(String _name, String _value) {
        return this.setVariable(_name, _value, ",");
    }

    public boolean setVariable(String _variable, String _value, String _sep) {
        if (this.model == null) {
            return false;
        }
        try {
            Field field = this.model.getClass().getField(_variable);
            if (field.getType().isArray()) {
                boolean result = true;
                Object array = field.get(this.model);
                int i = 0;
                int l = Array.getLength(array);
                Class<?> type = field.getType().getComponentType();
                StringTokenizer line = new StringTokenizer(_value, _sep);
                if (l < line.countTokens()) {
                    this.errorMessage("Warning: there are less elements in the array than values provided!");
                } else if (l > line.countTokens()) {
                    this.errorMessage("Warning: there are more elements in the array than values provided!");
                }
                while (line.hasMoreTokens() && i < l) {
                    String token = line.nextToken();
                    if (type.equals(Double.TYPE)) {
                        Array.setDouble(array, i, Double.parseDouble(token));
                    } else if (type.equals(Float.TYPE)) {
                        Array.setFloat(array, i, Float.parseFloat(token));
                    } else if (type.equals(Byte.TYPE)) {
                        Array.setByte(array, i, Byte.parseByte(token));
                    } else if (type.equals(Short.TYPE)) {
                        Array.setShort(array, i, Short.parseShort(token));
                    } else if (type.equals(Integer.TYPE)) {
                        Array.setInt(array, i, Integer.parseInt(token));
                    } else if (type.equals(Long.TYPE)) {
                        Array.setLong(array, i, Long.parseLong(token));
                    } else if (type.equals(Boolean.TYPE)) {
                        if (token.trim().toLowerCase().equals("true")) {
                            Array.setBoolean(array, i, true);
                        } else {
                            Array.setBoolean(array, i, false);
                        }
                    } else if (type.equals(Character.TYPE)) {
                        Array.setChar(array, i, token.charAt(0));
                    } else if (type.equals(strClass)) {
                        Array.set(array, i, token);
                    } else {
                        result = false;
                    }
                    ++i;
                }
                return result;
            }
            Class<?> type = field.getType();
            if (type.equals(Double.TYPE)) {
                field.setDouble(this.model, Double.parseDouble(_value));
            } else if (type.equals(Float.TYPE)) {
                field.setFloat(this.model, Float.parseFloat(_value));
            } else if (type.equals(Byte.TYPE)) {
                field.setByte(this.model, Byte.parseByte(_value));
            } else if (type.equals(Short.TYPE)) {
                field.setShort(this.model, Short.parseShort(_value));
            } else if (type.equals(Integer.TYPE)) {
                field.setInt(this.model, Integer.parseInt(_value));
            } else if (type.equals(Long.TYPE)) {
                field.setLong(this.model, Long.parseLong(_value));
            } else if (type.equals(Boolean.TYPE)) {
                if (_value.trim().toLowerCase().equals("true")) {
                    field.setBoolean(this.model, true);
                } else {
                    field.setBoolean(this.model, false);
                }
            } else if (type.equals(Character.TYPE)) {
                field.setChar(this.model, _value.charAt(0));
            } else if (type.equals(strClass)) {
                field.set(this.model, _value);
            } else {
                return false;
            }
            return true;
        }
        catch (Exception exc) {
            this.errorMessage(exc);
            return false;
        }
    }

    public boolean setVariables(String _valueList) {
        return this.setVariables(_valueList, ";", ",");
    }

    public boolean setVariables(String _valueList, String _sep, String _arraySep) {
        boolean result = true;
        String name = dummy;
        String value = dummy;
        StringTokenizer line = new StringTokenizer(_valueList, _sep);
        while (line.hasMoreTokens()) {
            String token = line.nextToken();
            int index = token.indexOf(61);
            if (index < 0) {
                result = false;
                continue;
            }
            name = token.substring(0, index).trim();
            boolean partial = this.setVariable(name, value = token.substring(index + 1).trim(), _arraySep);
            if (partial) continue;
            result = false;
        }
        this.update();
        return result;
    }

    public LauncherApplet initMoodle() {
        LauncherApplet applet = this.model._getApplet();
        if (applet == null) {
            return null;
        }
        try {
            String s = applet.getParameter("init");
            if (s != null) {
                this._init_ = new MethodWithOneParameter(0, applet._model, s, null, null, applet);
                this._init_.invoke(0, applet);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return applet;
    }

    public boolean isMoodleConnected() {
        if (this.moodle == null) {
            return false;
        }
        return this.moodle.isConnected();
    }

    private boolean javascriptControlMode() {
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isImageFormatSupported(String _format) {
        try {
            String[] names = ImageIO.getWriterFormatNames();
            int i = 0;
            while (true) {
                if (i >= names.length) {
                    return false;
                }
                if (names[i].equalsIgnoreCase(_format)) {
                    return true;
                }
                ++i;
            }
        }
        catch (Exception exception) {}
        return false;
    }

    protected void setUnderEjs(boolean value) {
        this.isUnderEjs = value;
    }

    public boolean isUnderEjs() {
        return this.isUnderEjs;
    }

    public List<Experiment> getExperiments() {
        return null;
    }

    public Experiment createExperiment(String _experimentName) {
        return null;
    }

    public void runExperiment(Experiment _experiment) {
        if (_experiment == null) {
            return;
        }
        if (this.currentExperiment != null) {
            this.currentExperiment._abortExperiment();
        }
        this.currentExperiment = _experiment;
        _experiment._runExperiment();
    }

    public void runExperiment(String _experimentClassname) {
        this.runExperiment(this.createExperiment(_experimentClassname));
    }

    public void killExperiment() {
        if (this.currentExperiment != null) {
            this.currentExperiment._abortExperiment();
        }
        this.currentExperiment = null;
    }

    public void addMenuEntries(List<Object> _entries) {
        if (this.popupMenuExtraEntries == null) {
            this.popupMenuExtraEntries = new ArrayList<Object>();
        }
        this.popupMenuExtraEntries.addAll(_entries);
        this.popupMenu = null;
    }

    public void addElementMenuEntries(String elementName, List<Object> _entries) {
        if (this.elementsMenu == null) {
            this.elementsMenu = new JMenu(this.getMenuText("ejs_res:MenuItem.Elements"));
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(this.elementsMenu);
            this.addMenuEntries(list);
        }
        JMenu menu = new JMenu(elementName);
        for (Object entry : _entries) {
            this.addMenuItem(menu, entry);
        }
        this.addMenuItem(this.elementsMenu, menu);
    }

    public Component getTopLevelComponent(Component _component) {
        Component c = _component;
        while (c.getParent() != null) {
            c = c.getParent();
        }
        return c;
    }

    public void getPopupMenu(Component _component, String _element) {
        this.getPopupMenu(_component, -1, -1, _element);
    }

    public void getPopupMenu(final Component _component, int _x, int _y, String _element) {
        this.captureElement = _element;
        if (this.popupMenu == null) {
            boolean canAccessDisk = true;
            try {
                System.getProperty("user.home");
            }
            catch (Exception exception) {
                canAccessDisk = false;
            }
            this.popupMenu = new JPopupMenu();
            List<Experiment> customActions = this.getExperiments();
            if (customActions != null) {
                JMenu experimentsMenu = new JMenu(this.getMenuText("tools_res:MenuItem.Experiments"));
                for (final Experiment experiment : customActions) {
                    String name = this.translateString(experiment._getName());
                    String desc = this.translateString(experiment._getDescription());
                    AbstractAction action = new AbstractAction(name){

                        @Override
                        public void actionPerformed(ActionEvent evt) {
                            Simulation.this.runExperiment(experiment);
                        }
                    };
                    action.putValue("ShortDescription", desc);
                    experimentsMenu.add(action);
                }
                this.popupMenu.add(experimentsMenu);
                JMenuItem killExperimentMenuItem = new JMenuItem(this.getMenuText("tools_res:MenuItem.KillExperiment"));
                killExperimentMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        Simulation.this.killExperiment();
                    }
                });
                this.popupMenu.add(killExperimentMenuItem);
                this.popupMenu.addSeparator();
            }
            if (this.descriptionDialog != null) {
                this.popupMenu.add(new AbstractAction(Memory.getResource("ShowDescription")){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Simulation.this.descriptionDialog.setVisible(true);
                    }
                });
            }
            if (this.popupMenuExtraEntries != null && this.popupMenuExtraEntries.size() > 0) {
                for (Object entry : this.popupMenuExtraEntries) {
                    this.addMenuItem(this.popupMenu, entry);
                }
                this.popupMenu.addSeparator();
            }
            this.extraAction2();
            if (canAccessDisk || this.isMoodleConnected()) {
                boolean isLauncherMode;
                JMenu snapshotMenu = new JMenu(this.getMenuText("ejs_res:MenuItem.SnapshotTools"));
                snapshotMenu.add(new AbstractAction(this.getMenuText("tools_res:MenuItem.Snapshot")){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        boolean wasRunning = Simulation.this.isPlaying();
                        if (wasRunning) {
                            Simulation.this.pause();
                        }
                        Simulation.this.saveImageAs(Simulation.this.captureElement);
                        if (wasRunning) {
                            Simulation.this.play();
                        }
                    }
                });
                this.popupMenu.add(snapshotMenu);
                this.snapshotMenuItem = new JMenuItem(this.getMenuText("ejs_res:MenuItem.SnapshotTool"));
                this.snapshotMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent _evt) {
                        ((DrawingPanel)Simulation.this.view.getElement(Simulation.this.captureElement).getVisual()).snapshot();
                    }
                });
                snapshotMenu.add(this.snapshotMenuItem);
                if (this.videoUtil.isFullClass()) {
                    snapshotMenu.add(new AbstractAction(this.getMenuText("ejs_res:MenuItem.TakeEPSSnapshot")){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            Simulation.this.videoUtil.takeSnapshot(Simulation.this.getTopLevelComponent(_component));
                        }
                    });
                    snapshotMenu.add(new AbstractAction(this.getMenuText("ejs_res:MenuItem.TakeEPSSnapshotWindow")){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            focusListener = new AWTEventListener(){

                                @Override
                                public void eventDispatched(AWTEvent _event) {
                                    WindowEvent windowEvent = (WindowEvent)_event;
                                    if (windowEvent.getID() == 207) {
                                        Toolkit.getDefaultToolkit().removeAWTEventListener(focusListener);
                                        (this).Simulation.this.videoUtil.takeSnapshot(windowEvent.getWindow());
                                    }
                                }
                            };
                            System.out.println("Put the focus on the window you want to capture");
                            Toolkit.getDefaultToolkit().addAWTEventListener(focusListener, 64L);
                        }
                    });
                    snapshotMenu.add(new AbstractAction(this.getMenuText("tools_res:MenuItem.Video")){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            Simulation.this.videoUtil.startVideoTool(Simulation.this.getView(), Simulation.this.captureElement);
                        }
                    });
                }
                JMenu ioStateMenu = new JMenu(this.getMenuText("ejs_res:MenuItem.StateIO"));
                ioStateMenu.add(new AbstractAction(this.getMenuText("tools_res:MenuItem.SaveState")){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Simulation.this.saveState(null);
                    }
                });
                try {
                    isLauncherMode = OSPRuntime.isLauncherMode();
                }
                catch (Exception exception) {
                    isLauncherMode = false;
                }
                if (!(this.isUnderEjs || isLauncherMode || this.isMoodleConnected())) {
                    ioStateMenu.add(new AbstractAction(this.getMenuText("ejs_res:MenuItem.SaveDefaultState")){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            File jarFile = null;
                            try {
                                URL url = Simulation.class.getProtectionDomain().getCodeSource().getLocation();
                                jarFile = new File(url.toURI());
                            }
                            catch (Exception exception) {
                                JFileChooser chooser = OSPRuntime.createChooser("JAR", new String[]{"jar"});
                                String filename = OSPRuntime.chooseFilename(chooser, Simulation.this.getParentComponent(), false);
                                if (filename == null) {
                                    return;
                                }
                                jarFile = new File(filename);
                            }
                            Simulation.this.saveDefaultStateToJar(jarFile, null);
                        }
                    });
                }
                ioStateMenu.add(new AbstractAction(this.getMenuText("tools_res:MenuItem.ReadState")){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Simulation.this.updateView = false;
                        Simulation.this.readState(null);
                        Simulation.this.updateView = true;
                        Simulation.this.updateAfterModelAction();
                    }
                });
                ioStateMenu.add(new AbstractAction(this.getMenuText("ejs_res:MenuItem.DefaultResetState")){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Simulation.this.resetFile = null;
                        Simulation.this.reset();
                    }
                });
                this.popupMenu.add(ioStateMenu);
            }
            JMenu guiMenu = new JMenu(ejsRes.getString("MenuItem.GUI"));
            Model._getTranslatorUtil().addToMenu(guiMenu, this);
            JMenu fontMenu = new JMenu(DisplayRes.getString("DrawingFrame.Font_menu_title"));
            fontMenu.add(new AbstractAction(DisplayRes.getString("DrawingFrame.IncreaseFontSize_menu_item")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FontSizer.levelUp();
                    for (String windowName : Simulation.this.getWindowsList()) {
                        FontSizer.setFonts(Simulation.this.getView().getComponent(windowName), FontSizer.getLevel());
                    }
                }
            });
            fontMenu.add(new AbstractAction(DisplayRes.getString("DrawingFrame.DecreaseFontSize_menu_item")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FontSizer.levelDown();
                    for (String windowName : Simulation.this.getWindowsList()) {
                        FontSizer.setFonts(Simulation.this.getView().getComponent(windowName), FontSizer.getLevel());
                    }
                }
            });
            guiMenu.add(fontMenu);
            this.popupMenu.add(guiMenu);
            this.popupMenu.addSeparator();
            this.popupMenu.add(new AbstractAction(Memory.getResource("Simulation.AboutThisSimulation")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Simulation.this.aboutThisSimulation(_component);
                }
            });
            if (canAccessDisk && EjsTool.hasEjsModel(this.getModel().getClass())) {
                this.popupMenu.add(new AbstractAction(ejsRes.getString("Simulation.OpenEjsModel")){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        String systemPassword;
                        try {
                            systemPassword = System.getProperty("launcher.password");
                        }
                        catch (Exception exception) {
                            systemPassword = null;
                        }
                        boolean quit = EjsTool.runEjs(Simulation.this.getModel().getClass(), systemPassword);
                        if (!Simulation.this.model._isApplet() && !OSPRuntime.isLauncherMode() && quit) {
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (InterruptedException e1) {
                                e1.printStackTrace();
                            }
                            System.exit(0);
                        }
                    }
                });
            }
            if (!this.isUnderEjs && canAccessDisk && !this.model._isApplet()) {
                this.popupMenu.add(new AbstractAction(Memory.getResource("CreateHTMLPage")){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Simulation.this.createHTMLpage(Simulation.this.getJarName());
                    }
                });
            }
            if (canAccessDisk) {
                JMenu diagnosticsMenu = new JMenu(Memory.getResource("Diagnostics.Menu"));
                diagnosticsMenu.add(new AbstractAction(this.getMenuText("tools_res:Diagnostics.OS.About.Title")){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Diagnostics.aboutOS();
                    }
                });
                diagnosticsMenu.add(new AbstractAction(this.getMenuText("tools_res:Diagnostics.Java.About.Title")){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Diagnostics.aboutJava();
                    }
                });
                diagnosticsMenu.add(new AbstractAction(this.getMenuText("ejs_res:Diagnostics.Properties")){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        DiagnosticsForSystem.aboutSystem(null);
                    }
                });
                diagnosticsMenu.add(new AbstractAction(this.getMenuText("ejs_res:Diagnostics.Threads")){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        DiagnosticsForThreads.aboutThreads();
                    }
                });
                diagnosticsMenu.add(new AbstractAction(this.getMenuText("tools_res:Diagnostics.Java3D.About.Title")){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Diagnostics.aboutJava3D();
                    }
                });
                diagnosticsMenu.add(new AbstractAction(this.getMenuText("xuggle_res:Xuggle.Dialog.AboutXuggle.Title")){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        DiagnosticsForXuggle.aboutXuggle();
                    }
                });
                this.popupMenu.add(diagnosticsMenu);
            }
            this.popupMenu.add(new AbstractAction("OSP " + ToolsRes.getString("MenuItem.Log")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    OSPLog log = OSPLog.getOSPLog();
                    if (log != null) {
                        log.setLocationRelativeTo(Simulation.this.parentComponent);
                    }
                    OSPLog.showLog();
                }
            });
        }
        if (this.snapshotMenuItem != null) {
            this.snapshotMenuItem.setVisible(_component instanceof DrawingPanel);
        }
        Model._getTranslatorUtil().refreshMenu();
        this.popupTriggeredBy = _component;
        if (_x >= 0 && _y >= 0) {
            this.popupMenu.show(_component, _x, _y);
        } else {
            this.popupMenu.show(_component, (_component.getWidth() - this.popupMenu.getWidth()) / 2, (_component.getHeight() - this.popupMenu.getHeight()) / 2);
        }
    }

    public JPanel makeLabel(String _label, Set<JComponent> _labelSet) {
        JLabel label = new JLabel(ejsRes.getString(_label), 4);
        if (_labelSet != null) {
            _labelSet.add(label);
        }
        label.setBorder(new EmptyBorder(4, 2, 0, 2));
        JPanel toppanel = new JPanel(new BorderLayout());
        toppanel.add((Component)label, "North");
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(new EmptyBorder(0, 0, 0, 0));
        panel.add((Component)toppanel, "West");
        return panel;
    }

    public static JTextComponent makeField(Container _parent, int _lines, int _cols) {
        if (_lines < 2) {
            JTextField field = new JTextField(_cols);
            _parent.add((Component)field, "Center");
            field.setEditable(false);
            return field;
        }
        JTextArea area = new JTextArea(_lines, _cols);
        area.setEditable(false);
        area.setLineWrap(true);
        area.setWrapStyleWord(true);
        JScrollPane scroll = new JScrollPane(area);
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(new EmptyBorder(0, 0, 0, 0));
        panel.add((Component)scroll, "Center");
        _parent.add((Component)panel, "Center");
        return area;
    }

    private static void getTag(String input, String delim, JTextComponent textComponent) {
        String beginTag = "<" + delim + "><![CDATA[";
        String endTag = "]]></" + delim + ">";
        int beginIndex = input.indexOf(beginTag);
        if (beginIndex < 0) {
            return;
        }
        int endIndex = input.indexOf(endTag);
        if (endIndex < beginIndex) {
            return;
        }
        textComponent.setText(input.substring(beginIndex + beginTag.length(), endIndex));
    }

    public void aboutThisSimulation(Component _component) {
        if (this.aboutThisDialog == null) {
            String metadata;
            String filename = this.getModel()._getClassEjsModel();
            int index = filename.indexOf(46);
            if (index > 0) {
                filename = filename.substring(0, index);
            }
            if ((metadata = ResourceLoader.getString(filename = String.valueOf(filename) + ".metadata")) == null) {
                System.err.println("Metadata file not found for " + filename);
                return;
            }
            int COLUMNS = 35;
            HashSet<JComponent> labelSet = new HashSet<JComponent>();
            JPanel titlePanel = this.makeLabel("Simulation.Title", labelSet);
            JTextComponent titleField = Simulation.makeField(titlePanel, 1, COLUMNS);
            Simulation.getTag(metadata, "Title", titleField);
            JPanel authorPanel = this.makeLabel("Simulation.Author", labelSet);
            JTextComponent authorField = Simulation.makeField(authorPanel, 1, COLUMNS);
            Simulation.getTag(metadata, "Author", authorField);
            JPanel keyPanel = this.makeLabel("Simulation.Keywords", labelSet);
            JTextComponent keyField = Simulation.makeField(keyPanel, 1, COLUMNS);
            Simulation.getTag(metadata, "Keywords", keyField);
            JPanel levelPanel = this.makeLabel("Simulation.Level", labelSet);
            JTextComponent levelField = Simulation.makeField(levelPanel, 1, COLUMNS);
            Simulation.getTag(metadata, "Level", levelField);
            JPanel languagePanel = this.makeLabel("Simulation.Language", labelSet);
            JTextComponent languageField = Simulation.makeField(languagePanel, 1, COLUMNS);
            Simulation.getTag(metadata, "Language", languageField);
            JPanel abstractPanel = this.makeLabel("Simulation.Abstract", labelSet);
            JTextComponent abstractField = Simulation.makeField(abstractPanel, 7, COLUMNS);
            Simulation.getTag(metadata, "Abstract", abstractField);
            int maxWidth = 0;
            int maxHeight = 0;
            for (JComponent label : labelSet) {
                maxWidth = Math.max(maxWidth, label.getPreferredSize().width);
                maxHeight = Math.max(maxHeight, label.getPreferredSize().height);
            }
            Dimension dim = new Dimension(maxWidth, maxHeight);
            for (JComponent label : labelSet) {
                label.setPreferredSize(dim);
            }
            Box infoPanel = Box.createVerticalBox();
            infoPanel.setBorder(BorderFactory.createEmptyBorder(1, 0, 1, 0));
            infoPanel.add(titlePanel);
            infoPanel.add(authorPanel);
            infoPanel.add(keyPanel);
            infoPanel.add(levelPanel);
            infoPanel.add(languagePanel);
            JPanel metadataPanel = new JPanel(new BorderLayout());
            metadataPanel.add((Component)infoPanel, "North");
            metadataPanel.add((Component)abstractPanel, "Center");
            metadataPanel.setBorder(new EtchedBorder(0));
            this.aboutThisDialog = new JDialog();
            this.aboutThisDialog.setTitle(Memory.getResource("Simulation.AboutThisSimulation"));
            this.aboutThisDialog.getContentPane().setLayout(new BorderLayout());
            this.aboutThisDialog.getContentPane().add((Component)metadataPanel, "Center");
            this.aboutThisDialog.setModal(false);
            this.aboutThisDialog.setResizable(true);
            this.aboutThisDialog.pack();
        }
        this.aboutThisDialog.setLocationRelativeTo(_component);
        this.aboutThisDialog.setVisible(true);
    }

    private String getMenuText(String name) {
        String text = name.startsWith("ejs_res:") ? ejsRes.getString(name.substring(name.indexOf(58) + 1)) : (name.startsWith("tools_res:") ? ToolsRes.getString(name.substring(name.indexOf(58) + 1)) : (name.startsWith("display_res:") ? DisplayRes.getString(name.substring(name.indexOf(58) + 1)) : (name.startsWith("xuggle_res:") ? XuggleRes.getString(name.substring(name.indexOf(58) + 1)) : ToolsRes.getString(name))));
        if (text.startsWith("!") && text.endsWith("!")) {
            text = DisplayRes.getString(name);
        }
        if (text.startsWith("!") && text.endsWith("!")) {
            text = name;
        }
        return text;
    }

    private void processMenuTexts(Object object) {
        if (object instanceof JMenu) {
            JMenu menu = (JMenu)object;
            menu.setText(this.getMenuText(menu.getActionCommand()));
            int i = 0;
            int n = menu.getItemCount();
            while (i < n) {
                this.processMenuTexts(menu.getItem(i));
                ++i;
            }
        } else if (object instanceof JMenuItem) {
            JMenuItem menuItem = (JMenuItem)object;
            menuItem.setText(this.getMenuText(menuItem.getActionCommand()));
        }
    }

    private void addMenuItem(JComponent targetMenu, Object object) {
        if (object instanceof Action) {
            final Action item = (Action)object;
            String name = (String)item.getValue("Name");
            String text = this.getMenuText(name);
            AbstractAction action = new AbstractAction(text){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent evt) {
                    item.actionPerformed(evt);
                }
            };
            action.putValue("ShortDescription", text);
            if (targetMenu instanceof JMenu) {
                ((JMenu)targetMenu).add(action);
            } else if (targetMenu instanceof JPopupMenu) {
                ((JPopupMenu)targetMenu).add(action);
            }
        } else if (object instanceof JMenu) {
            JMenu menu = (JMenu)object;
            this.processMenuTexts(menu);
            if (targetMenu instanceof JMenu) {
                ((JMenu)targetMenu).add(menu);
            } else if (targetMenu instanceof JPopupMenu) {
                ((JPopupMenu)targetMenu).add(menu);
            }
        } else if (object instanceof JMenuItem) {
            JMenuItem menuItem = (JMenuItem)object;
            this.processMenuTexts(menuItem);
            if (targetMenu instanceof JMenu) {
                ((JMenu)targetMenu).add(menuItem);
            } else if (targetMenu instanceof JPopupMenu) {
                ((JPopupMenu)targetMenu).add(menuItem);
            }
        }
    }

    public List<String> getWindowsList() {
        return new ArrayList<String>();
    }

    public String getMainWindow() {
        return null;
    }

    public String getJarName() {
        URL clsUrl = this.getClass().getResource(String.valueOf(this.getClass().getSimpleName()) + ".class");
        if (clsUrl != null) {
            try {
                URLConnection conn = clsUrl.openConnection();
                if (conn instanceof JarURLConnection) {
                    JarURLConnection connection = (JarURLConnection)conn;
                    String path = connection.getJarFileURL().getPath();
                    int index = path.lastIndexOf(47);
                    if (index >= 0) {
                        path = path.substring(index + 1);
                    }
                    return path;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public void createHTMLpage(String jarFilename) {
        String name;
        JFileChooser chooser = OSPRuntime.createChooser("HTML", new String[]{"html"});
        chooser.setSelectedFile(new File(String.valueOf(this.getModelClassname()) + ".html"));
        String filename = OSPRuntime.chooseFilename(chooser, this.popupTriggeredBy, true);
        if (filename == null) {
            return;
        }
        if (filename.lastIndexOf(46) < 0) {
            filename = String.valueOf(filename) + ".html";
        }
        Component mainWindow = this.getView().getComponent(this.getMainWindow());
        Dimension size = new Dimension(100, 100);
        if (mainWindow != null) {
            size = mainWindow.getSize();
        }
        if ((name = this.getClass().getName()).endsWith("Simulation")) {
            name = name.substring(0, name.length() - 10);
        }
        name = String.valueOf(name) + "Applet.class";
        String programName = this.getModelClassname();
        StringBuffer buffer = new StringBuffer();
        buffer.append("<html>\n");
        buffer.append("  <head>\n");
        buffer.append("    <title>" + programName + " HTML</title>\n");
        buffer.append("  </head>\n");
        buffer.append("  <body >\n");
        buffer.append("    <applet code=\"" + name + "\"\n");
        buffer.append("            codebase=\".\" archive=\"" + jarFilename + "\"\n");
        buffer.append("            name=\"" + programName + "\"  id=\"" + programName + "\"\n");
        buffer.append("            width=\"" + size.width + "\" height=\"" + size.height + "\">\n");
        buffer.append("      <param name=\"permissions\" value=\"sandbox\">\n");
        buffer.append("  </applet>\n");
        buffer.append("  </body>\n");
        buffer.append("</html>\n");
        try {
            FileWriter fout = new FileWriter(filename);
            fout.write(buffer.toString());
            fout.close();
        }
        catch (Exception exc) {
            exc.printStackTrace();
            JOptionPane.showMessageDialog(this.popupTriggeredBy, "Error saving file: " + filename, "File Error", 0);
        }
    }

    public boolean saveImage(String _element) {
        GregorianCalendar cal = new GregorianCalendar();
        DecimalFormat format = new DecimalFormat("00");
        String date = String.valueOf(cal.get(1)) + format.format(cal.get(2)) + format.format(cal.get(5)) + "_" + format.format(cal.get(11)) + format.format(cal.get(12)) + format.format(cal.get(13));
        return this.saveImage(String.valueOf(this.getClassname()) + "_" + date + ".jpg", _element);
    }

    public boolean saveImageAs(String _element) {
        return this.saveImage(null, _element);
    }

    public boolean saveImage(String _filename, String _element) {
        if (this.view == null) {
            return false;
        }
        ControlElement ctrlEl = this.view.getElement(_element);
        if (ctrlEl == null) {
            System.err.println("Component not found: " + _element);
            return false;
        }
        Component comp = ctrlEl.getComponent();
        if (this.isMoodleConnected() || this.javascriptControlMode()) {
            OutputStream out;
            block20: {
                boolean supported;
                String format;
                BufferedImage bi;
                block19: {
                    if (comp instanceof JFrame) {
                        comp = ((JFrame)comp).getContentPane();
                    } else if (comp instanceof JDialog) {
                        comp = ((JDialog)comp).getContentPane();
                    }
                    bi = new BufferedImage(comp.getWidth(), comp.getHeight(), 5);
                    if (ctrlEl instanceof SpecialRender) {
                        ((SpecialRender)((Object)ctrlEl)).render(bi);
                    } else {
                        Graphics g = bi.getGraphics();
                        comp.paint(g);
                        g.dispose();
                    }
                    if (_filename == null) {
                        _filename = String.valueOf(this.getModelClassname()) + ".gif";
                    }
                    if (this.isMoodleConnected()) {
                        return this.moodle.saveImage(_filename, "GIF image", bi) != null;
                    }
                    try {
                        format = "jpg";
                        int index = _filename.lastIndexOf(46);
                        if (index >= 0) {
                            format = _filename.substring(index + 1).toLowerCase();
                        } else {
                            _filename = String.valueOf(_filename) + "." + format;
                        }
                        supported = Simulation.isImageFormatSupported(format);
                        if (supported || this.videoUtil.isFullClass() && "gif".equalsIgnoreCase(format)) break block19;
                        System.err.println("Format not supported : " + format);
                        return false;
                    }
                    catch (Exception _exc) {
                        _exc.printStackTrace();
                        return false;
                    }
                }
                out = null;
                out = this.javascriptControlMode() || _filename.startsWith("ejs:") ? new ByteArrayOutputStream() : new FileOutputStream(_filename);
                boolean result = true;
                result = supported ? ImageIO.write((RenderedImage)bi, format, out) : this.videoUtil.writeGIF(out, bi);
                out.close();
                if (result) break block20;
                return false;
            }
            if (_filename.startsWith("ejs:")) {
                memory.put(_filename, ((ByteArrayOutputStream)out).toByteArray());
            } else if (this.javascriptControlMode()) {
                this.javascriptControledApplet.setImageByteArray(((ByteArrayOutputStream)out).toByteArray());
            }
            return true;
        }
        return SnapshotTool.getTool().saveImage(_filename, comp, null);
    }

    public void processArguments(String[] _args) {
        LauncherApplet applet = this.model._getApplet();
        boolean stateRead = false;
        if (applet != null) {
            try {
                String arg0 = applet.getParameter("initialState");
                if (arg0 != null) {
                    stateRead = this.readState(arg0, applet.getCodeBase());
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else if (_args != null && _args.length > 0) {
            int i = 0;
            while (i < _args.length) {
                if (_args[i].toLowerCase().endsWith(".xml")) {
                    this.resetFile = _args[i];
                    stateRead = this.readState(this.resetFile);
                } else if (_args[i].equals("-_initialState")) {
                    this.resetFile = _args[++i];
                    stateRead = this.readState(this.resetFile);
                } else if (_args[i].equals("-_noDescription")) {
                    this.showDescriptionOnStart = false;
                }
                ++i;
            }
        }
        if (!stateRead && !this.isMoodleConnected() && ResourceLoader.getResource(DEFAULT_STATE_FILENAME) != null) {
            OSPLog.fine("Reading default state from jar DefaultState.out");
            this.readVariables(DEFAULT_STATE_FILENAME, null);
            this.resetFile = DEFAULT_STATE_FILENAME;
            if (this.view != null) {
                this.view.reset();
            }
        }
        if (applet == null) {
            boolean showIt;
            boolean bl = showIt = !this.isUnderEjs;
            if (OSPRuntime.isLauncherMode()) {
                showIt = false;
            } else {
                try {
                    if ("true".equals(System.getProperty("osp_launcher"))) {
                        showIt = false;
                    }
                }
                catch (Exception exception) {}
            }
            if (showIt && this.showDescriptionOnStart) {
                this.showDescription();
            }
        }
    }

    public static List<String> toArrayList(String _list) {
        if (_list == null) {
            return null;
        }
        StringTokenizer tkn = new StringTokenizer(_list, " ;,");
        ArrayList<String> arrayList = new ArrayList<String>();
        while (tkn.hasMoreTokens()) {
            arrayList.add(tkn.nextToken());
        }
        return arrayList;
    }

    public List<String> getStateVariablesList() {
        return this.stateVariablesList;
    }

    public void setStateVariablesList(List<String> _list) {
        this.stateVariablesList = _list;
    }

    public void setStateVariablesList(String _varList) {
        this.stateVariablesList = Simulation.toArrayList(_varList);
    }

    public boolean saveState(String _filename) {
        return this.saveVariables(_filename, this.stateVariablesList);
    }

    public boolean readState(String _filename) {
        return this.readVariables(_filename, this.stateVariablesList);
    }

    public boolean readState(String _filename, URL _codebase) {
        return this.readVariables(_filename, this.stateVariablesList);
    }

    public boolean saveVariables(String _filename, String _varList) {
        return this.saveVariables(_filename, Simulation.toArrayList(_varList));
    }

    public boolean readVariables(String _filename, URL _codebase, String _varList) {
        return this.readVariables(_filename, Simulation.toArrayList(_varList));
    }

    public boolean readVariables(String _filename, URL _codebase, List<String> _varList) {
        return this.readVariables(_filename, _varList);
    }

    public boolean readVariables(String _filename, List<String> _varList) {
        boolean success;
        if (this.model == null) {
            return false;
        }
        if (this.isMoodleConnected()) {
            if ((_filename = this.moodle.readXML(_filename)).equals("url:")) {
                return false;
            }
        } else if (_filename == null) {
            JFileChooser chooser = OSPRuntime.createChooser("XML", new String[]{"xml"});
            chooser.setSelectedFile(new File(String.valueOf(this.getModelClassname()) + "_Variables.xml"));
            _filename = OSPRuntime.chooseFilename(chooser, this.popupTriggeredBy, false);
            if (_filename == null) {
                return false;
            }
        }
        if (success = this.justReadVariables(_filename, _varList)) {
            if (this.view != null) {
                this.view.initialize();
                this.view.update();
            }
            this.updateAfterModelAction();
        }
        return success;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private boolean justReadVariables(String _filename, List<String> _varList) {
        try {
            boolean exists = true;
            URLConnection urlConnection = null;
            Reader reader = null;
            if (_filename.startsWith("ejs:")) {
                exists = memory.get(_filename) != null;
            } else if (_filename.startsWith("url:")) {
                String urlStr = _filename.substring(4);
                try {
                    urlConnection = new URL(urlStr).openConnection();
                }
                catch (Exception _exc) {
                    _exc.printStackTrace();
                    exists = false;
                }
            } else {
                reader = ResourceLoader.openReader(_filename);
                boolean bl = exists = reader != null;
            }
            if (!exists) {
                this.errorMessage("File does not exist " + _filename);
                return false;
            }
            XMLControlElement control = null;
            ObjectInputStream din = null;
            if (_filename.toLowerCase().endsWith(".xml")) {
                String xmlString = null;
                Reader in = null;
                if (urlConnection != null) {
                    in = new InputStreamReader((InputStream)urlConnection.getContent());
                } else if (_filename.startsWith("ejs:")) {
                    in = new CharArrayReader((char[])memory.get(_filename));
                } else if (this.isMoodleConnected()) {
                    xmlString = this.moodle.readXML(_filename);
                } else {
                    in = reader;
                }
                if (in != null) {
                    LineNumberReader l = new LineNumberReader(in);
                    StringBuffer txt = new StringBuffer();
                    String sl = l.readLine();
                    while (sl != null) {
                        txt.append(String.valueOf(sl) + "\n");
                        sl = l.readLine();
                    }
                    in.close();
                    xmlString = txt.toString();
                }
                if (!(control = new XMLControlElement(this.getClass())).readXMLForClass(xmlString, this.getClass())) {
                    return true;
                }
            } else {
                InputStream in = urlConnection != null ? urlConnection.getInputStream() : (_filename.startsWith("ejs:") ? new ByteArrayInputStream((byte[])memory.get(_filename)) : ResourceLoader.openInputStream(_filename));
                if (in == null) {
                    return false;
                }
                din = new ObjectInputStream(new BufferedInputStream(in));
            }
            Field[] fields = this.model.getClass().getFields();
            if (_varList == null) {
                int i = 0;
                while (i < fields.length) {
                    Object objectToRead = fields[i].get(this.model);
                    if (objectToRead == null || objectToRead instanceof Serializable) {
                        if (control != null) {
                            Object object = control.getObject(fields[i].getName());
                            if (object != null) {
                                fields[i].set(this.model, object);
                            }
                        } else if (din != null) {
                            Object objectRead = din.readObject();
                            fields[i].set(this.model, objectRead);
                        }
                    }
                    ++i;
                }
            } else {
                int j = 0;
                int n = _varList.size();
                while (j < n) {
                    String varName = _varList.get(j).trim();
                    int i = 0;
                    while (i < fields.length) {
                        Object objectToRead = fields[i].get(this.model);
                        if ((objectToRead == null || objectToRead instanceof Serializable) && fields[i].getName().equals(varName)) {
                            if (control != null) {
                                Object object = control.getObject(varName);
                                if (object == null) break;
                                fields[i].set(this.model, object);
                                break;
                            }
                            if (din == null) break;
                            fields[i].set(this.model, din.readObject());
                            break;
                        }
                        ++i;
                    }
                    ++j;
                }
            }
            if (din != null) {
                din.close();
            }
            return true;
        }
        catch (Exception ioe) {
            this.errorMessage("Error when trying to read " + _filename);
            ioe.printStackTrace(System.err);
            JOptionPane.showMessageDialog(this.getParentComponent(), ioe.getLocalizedMessage());
            return false;
        }
    }

    public boolean saveVariables(String _filename, List<String> _varList) {
        if (this.model == null) {
            return false;
        }
        boolean saveAsXML = true;
        if (_filename == null) {
            if (this.isMoodleConnected()) {
                _filename = String.valueOf(this.getModelClassname()) + "_Variables.xml";
            } else {
                JFileChooser chooser = OSPRuntime.createChooser("XML", new String[]{"xml"});
                chooser.setSelectedFile(new File(String.valueOf(this.getModelClassname()) + "_Variables.xml"));
                final MyXMLAccessory accesory = new MyXMLAccessory(chooser);
                chooser.setAccessory(accesory);
                chooser.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        JFileChooser theFileChooser = (JFileChooser)actionEvent.getSource();
                        String command = actionEvent.getActionCommand();
                        if (command.equals("ApproveSelection")) {
                            File selectedFile = theFileChooser.getSelectedFile();
                            String selectedFilename = selectedFile.getName();
                            boolean nameChanged = false;
                            if (accesory.saveAsXML()) {
                                if (!selectedFilename.toLowerCase().endsWith(".xml")) {
                                    theFileChooser.setSelectedFile(new File(selectedFile.getParent(), String.valueOf(selectedFilename) + ".xml"));
                                    nameChanged = true;
                                }
                            } else if (selectedFilename.toLowerCase().endsWith(".xml")) {
                                theFileChooser.setSelectedFile(new File(selectedFile.getParent(), String.valueOf(selectedFilename) + ".bin"));
                                nameChanged = true;
                            }
                            if (nameChanged) {
                                JOptionPane.showMessageDialog(Simulation.this.popupTriggeredBy, String.valueOf(ejsRes.getString("Simulation.XMLFileRenamed")) + ":\n  " + theFileChooser.getSelectedFile().getName());
                            }
                        }
                    }
                });
                _filename = OSPRuntime.chooseFilename(chooser, this.popupTriggeredBy, true);
                if (_filename == null) {
                    return false;
                }
                saveAsXML = accesory.saveAsXML();
            }
        } else {
            saveAsXML = _filename.toLowerCase().endsWith(".xml");
        }
        try {
            XMLControlElement control = null;
            OutputStream out = null;
            ObjectOutputStream dout = null;
            if (saveAsXML) {
                control = new XMLControlElement(this.getClass());
            } else {
                out = this.javascriptControlMode() || _filename.startsWith("ejs:") || this.isMoodleConnected() ? new ByteArrayOutputStream() : new FileOutputStream(_filename);
                BufferedOutputStream bout = new BufferedOutputStream(out);
                dout = new ObjectOutputStream(bout);
            }
            Field[] fields = this.model.getClass().getFields();
            if (_varList == null) {
                int i = 0;
                while (i < fields.length) {
                    Object objectToSave = fields[i].get(this.model);
                    if (objectToSave == null || objectToSave instanceof Serializable) {
                        if (control != null) {
                            control.setValue(fields[i].getName(), objectToSave);
                        } else if (dout != null) {
                            dout.writeObject(objectToSave);
                        }
                    }
                    ++i;
                }
            } else {
                int j = 0;
                int n = _varList.size();
                while (j < n) {
                    String varName = _varList.get(j).trim();
                    int i = 0;
                    while (i < fields.length) {
                        Object objectToSave = fields[i].get(this.model);
                        if ((objectToSave == null || objectToSave instanceof Serializable) && fields[i].getName().equals(varName)) {
                            if (control != null) {
                                control.setValue(fields[i].getName(), fields[i].get(this.model));
                                break;
                            }
                            if (dout == null) break;
                            dout.writeObject(fields[i].get(this.model));
                            break;
                        }
                        ++i;
                    }
                    ++j;
                }
            }
            if (control != null) {
                if (this.isMoodleConnected()) {
                    return this.moodle.saveXML(_filename, "XML file", control.toXML()) != null;
                }
                Writer writer = _filename.startsWith("ejs:") ? new CharArrayWriter() : new FileWriter(_filename);
                control.write(writer);
                if (_filename.startsWith("ejs:")) {
                    memory.put(_filename, ((CharArrayWriter)writer).toCharArray());
                }
            } else {
                if (dout != null) {
                    dout.close();
                }
                if (out != null) {
                    if (this.isMoodleConnected()) {
                        return this.moodle.saveBinary(_filename, "Binary data", ((ByteArrayOutputStream)out).toByteArray()) != null;
                    }
                    if (_filename.startsWith("ejs:")) {
                        memory.put(_filename, ((ByteArrayOutputStream)out).toByteArray());
                    } else if (this.javascriptControlMode()) {
                        this.javascriptControledApplet.setStateByteArray(((ByteArrayOutputStream)out).toByteArray());
                    }
                }
            }
            return true;
        }
        catch (Exception ioe) {
            this.errorMessage("Error when trying to save " + _filename);
            ioe.printStackTrace(System.err);
            return false;
        }
    }

    private void addFileToJar(JarOutputStream _jarOut, String _name, File _file) throws Exception {
        int len;
        byte[] buf = new byte[1024];
        FileInputStream in = new FileInputStream(_file);
        _jarOut.putNextEntry(new JarEntry(_name));
        while ((len = ((InputStream)in).read(buf)) > 0) {
            _jarOut.write(buf, 0, len);
        }
        ((InputStream)in).close();
        _jarOut.closeEntry();
    }

    public static boolean isDisplayable(String filename) {
        return !filename.toLowerCase().startsWith("http://");
    }

    public boolean saveDefaultStateToJar(File _jarFile, String _filenames) {
        String filename;
        File newJarFile;
        JCheckBox htmlCheckBox;
        HashSet<File> extraFilesSet;
        File tempFile;
        block22: {
            block21: {
                if (OSPRuntime.isLauncherMode()) {
                    OSPLog.warning("Simulation cannot save state to JAR when in Launcher mode. Ignored!");
                    return false;
                }
                tempFile = File.createTempFile(DEFAULT_STATE_FILENAME, null);
                tempFile.delete();
                boolean savedOk = this.saveVariables(tempFile.getAbsolutePath(), (List<String>)null);
                if (savedOk) break block21;
                JOptionPane.showMessageDialog(this.getParentComponent(), "Cannot save data file", "Could not create temp file", 0);
                return false;
            }
            extraFilesSet = new HashSet<File>();
            if (_filenames != null) {
                StringTokenizer tkn = new StringTokenizer(_filenames, ";,");
                while (tkn.hasMoreTokens()) {
                    String extraFileName = tkn.nextToken();
                    if (!Simulation.isDisplayable(extraFileName)) continue;
                    Resource res = ResourceLoader.getResource(extraFileName);
                    File extraFile = null;
                    if (res != null) {
                        extraFile = res.getFile();
                    }
                    if (extraFile == null || !extraFile.exists()) {
                        if (res == null || res.openReader() == null) {
                            JOptionPane.showMessageDialog(this.getParentComponent(), String.valueOf(ejsRes.getString("Simulation.CantFindExtraFile")) + " " + extraFileName, ejsRes.getString("Simulation.IgnoringExtraFile"), 2);
                            continue;
                        }
                        JOptionPane.showMessageDialog(this.getParentComponent(), String.valueOf(ejsRes.getString("Simulation.ExtraFileAlreadyIn")) + " " + extraFileName + "\n" + ejsRes.getString("Simulation.RenameDocument"), ejsRes.getString("Simulation.IgnoringExtraFile"), 2);
                        continue;
                    }
                    extraFilesSet.add(extraFile);
                }
            }
            JPanel accesoryPanel = new JPanel(new BorderLayout());
            htmlCheckBox = new JCheckBox(Memory.getResource("CreateHTMLPage"), false);
            accesoryPanel.add((Component)htmlCheckBox, "North");
            String proposedName = String.valueOf(FileUtils.getPlainName(_jarFile)) + "_StateAdded.jar";
            File proposedFile = new File(proposedName);
            int counter = 2;
            while (proposedFile.exists()) {
                proposedName = String.valueOf(FileUtils.getPlainName(_jarFile)) + "_StateAdded_" + counter + ".jar";
                proposedFile = new File(proposedName);
                ++counter;
            }
            newJarFile = new File(_jarFile.getParentFile(), proposedName);
            JFileChooser chooser = OSPRuntime.createChooser("JAR", new String[]{"jar"});
            chooser.setSelectedFile(newJarFile);
            chooser.setAccessory(accesoryPanel);
            filename = OSPRuntime.chooseFilename(chooser, this.getParentComponent(), true);
            if (filename != null) break block22;
            return false;
        }
        try {
            if (filename.lastIndexOf(46) < 0) {
                filename = String.valueOf(filename) + ".jar";
            }
            newJarFile = new File(filename);
            JarInputStream jarIn = new JarInputStream(new FileInputStream(_jarFile));
            JarFile tmpJarFile = new JarFile(_jarFile);
            JarOutputStream jarOut = new JarOutputStream((OutputStream)new FileOutputStream(newJarFile), tmpJarFile.getManifest());
            HashSet<File> extraFilesRemoveSet = new HashSet<File>();
            JarEntry entry = jarIn.getNextJarEntry();
            while (entry != null) {
                int len;
                String name = entry.getName();
                if (name.equals(DEFAULT_STATE_FILENAME)) {
                    OSPLog.fine("Saving state to JAR : removing previous state file " + name);
                    entry = jarIn.getNextJarEntry();
                    continue;
                }
                String lowercaseName = name.toLowerCase();
                if (lowercaseName.startsWith("meta-inf/") && (lowercaseName.endsWith(".sf") || lowercaseName.endsWith(".rsa") || lowercaseName.endsWith(".dsa"))) {
                    OSPLog.fine("Saving state to JAR : Ignoring signature file : " + name);
                    entry = jarIn.getNextJarEntry();
                    continue;
                }
                boolean overwrite = false;
                for (File extraFile : extraFilesSet) {
                    if (!extraFile.getName().equals(name)) continue;
                    int option = JOptionPane.showConfirmDialog(this.getParentComponent(), "File already exists in JAR:" + name + "\nDo you want to overwrite it?", "Conflict with existing file", 0);
                    if (option == 1) {
                        extraFilesRemoveSet.add(extraFile);
                        break;
                    }
                    overwrite = true;
                    break;
                }
                if (overwrite) {
                    entry = jarIn.getNextJarEntry();
                    continue;
                }
                byte[] buf = new byte[1024];
                jarOut.putNextEntry(new JarEntry(name));
                while ((len = jarIn.read(buf)) > 0) {
                    jarOut.write(buf, 0, len);
                }
                entry = jarIn.getNextJarEntry();
            }
            jarIn.close();
            extraFilesSet.removeAll(extraFilesRemoveSet);
            this.addFileToJar(jarOut, DEFAULT_STATE_FILENAME, tempFile);
            tempFile.delete();
            for (File extraFile : extraFilesSet) {
                this.addFileToJar(jarOut, extraFile.getName(), extraFile);
            }
            jarOut.close();
            tmpJarFile.close();
            if (htmlCheckBox.isSelected()) {
                this.createHTMLpage(newJarFile.getName());
            }
            return true;
        }
        catch (Exception ioe) {
            this.errorMessage("Error when trying to save state to " + _jarFile.getName());
            ioe.printStackTrace(System.err);
            return false;
        }
    }

    public String getVariablesXML(String _varList) {
        return this.getVariablesXML(Simulation.toArrayList(_varList));
    }

    public String getVariablesXML(List<String> _varList) {
        if (this.model == null) {
            return null;
        }
        try {
            XMLControlElement control = new XMLControlElement(this.getClass());
            Field[] fields = this.model.getClass().getFields();
            if (_varList == null) {
                int i = 0;
                while (i < fields.length) {
                    Object objectToRead = fields[i].get(this.model);
                    if (objectToRead == null || objectToRead instanceof Serializable) {
                        control.setValue(fields[i].getName(), fields[i].get(this.model));
                    }
                    ++i;
                }
            } else {
                int j = 0;
                int n = _varList.size();
                while (j < n) {
                    String varName = _varList.get(j).trim();
                    int i = 0;
                    while (i < fields.length) {
                        Object objectToRead = fields[i].get(this.model);
                        if ((objectToRead == null || objectToRead instanceof Serializable) && fields[i].getName().equals(varName)) {
                            control.setValue(fields[i].getName(), fields[i].get(this.model));
                            break;
                        }
                        ++i;
                    }
                    ++j;
                }
            }
            CharArrayWriter writer = new CharArrayWriter();
            control.write(writer);
            return writer.toString();
        }
        catch (Exception ioe) {
            this.errorMessage("Error when trying to get XML of variables!");
            ioe.printStackTrace(System.err);
            return null;
        }
    }

    public boolean saveText(String _filename, String _type, String _text) {
        try {
            Writer out;
            if (_filename.startsWith("ejs:")) {
                out = new CharArrayWriter();
            } else {
                if (this.isMoodleConnected()) {
                    if (_filename.toLowerCase().endsWith(".xml")) {
                        return this.moodle.saveXML(_filename, "XML file", _text) != null;
                    }
                    return this.moodle.saveText(_filename, _type, _text) != null;
                }
                out = new FileWriter(_filename);
            }
            BufferedWriter bout = new BufferedWriter(out);
            bout.write(_text);
            bout.close();
            if (_filename.startsWith("ejs:")) {
                memory.put(_filename, ((CharArrayWriter)out).toCharArray());
            }
            return true;
        }
        catch (Exception ioe) {
            System.err.println("Error when trying to save" + _filename);
            ioe.printStackTrace(System.err);
            return false;
        }
    }

    public boolean saveText(String _filename, StringBuffer _info) {
        return this.saveText(_filename, _info.toString());
    }

    public boolean saveText(String _filename, String _text) {
        return this.saveText(_filename, "Text file", _text);
    }

    public String readText(String _filename) {
        return this.readText(_filename, "text", null);
    }

    public String readText(String _filename, String _type) {
        return this.readText(_filename, _type, null);
    }

    public String readText(String _filename, URL _codebase) {
        return this.readText(_filename, "text", _codebase);
    }

    public String readText(String _filename, String _type, URL _codebase) {
        if (this.isMoodleConnected() || _filename.startsWith("url:")) {
            String url = dummy;
            if (this.isMoodleConnected()) {
                url = _filename.toLowerCase().endsWith(".xml") ? this.moodle.readXML(_filename) : this.moodle.readText(_filename, _type);
                if (url.equals("url:")) {
                    return null;
                }
            } else if (_filename.startsWith("url:")) {
                url = _filename.substring(4);
                if (_codebase != null && !url.startsWith("http:")) {
                    url = _codebase + url;
                }
            }
            try {
                URL urlConn = new URL(url);
                InputStream is = (InputStream)urlConn.getContent();
                BufferedReader br = new BufferedReader(new InputStreamReader(is));
                String line = null;
                StringBuffer sb = new StringBuffer();
                while ((line = br.readLine()) != null) {
                    sb.append(String.valueOf(line) + "\n");
                }
                return sb.toString();
            }
            catch (Exception ioe) {
                System.err.println("Error when trying to read " + _filename);
                ioe.printStackTrace(System.err);
                return null;
            }
        }
        try {
            Reader in = _filename.startsWith("ejs:") ? new CharArrayReader((char[])memory.get(_filename)) : new FileReader(_filename);
            LineNumberReader l = new LineNumberReader(in);
            StringBuffer txt = new StringBuffer();
            String sl = l.readLine();
            while (sl != null) {
                txt.append(String.valueOf(sl) + "\n");
                sl = l.readLine();
            }
            in.close();
            return txt.toString();
        }
        catch (Exception ioe) {
            System.err.println("Error when trying to read " + _filename);
            ioe.printStackTrace(System.err);
            return null;
        }
    }

    protected void extraAction2() {
    }

    protected void extraAction3() {
    }

    private static class EditorAndScroll {
        String name;
        JEditorPane editorPane;
        JScrollPane scrollPane;
        boolean visible = true;

        EditorAndScroll(String _name, JEditorPane _editor, JScrollPane _scroll) {
            this.name = _name;
            this.editorPane = _editor;
            this.scrollPane = _scroll;
        }

        public void setVisible(boolean _visible) {
            this.visible = _visible;
        }

        public boolean isVisible() {
            return this.visible;
        }
    }

    private static class MyXMLAccessory
    extends JPanel {
        private JRadioButton xmlButton = new JRadioButton("XML", true);

        public MyXMLAccessory(JFileChooser _chooser) {
            JRadioButton binaryButton = new JRadioButton("BIN", false);
            ButtonGroup group = new ButtonGroup();
            group.add(this.xmlButton);
            group.add(binaryButton);
            this.setLayout(new BoxLayout(this, 1));
            this.add(new JLabel(ejsRes.getString("Simulation.StateFormat")));
            this.add(this.xmlButton);
            this.add(binaryButton);
        }

        public boolean saveAsXML() {
            return this.xmlButton.isSelected();
        }
    }
}

