/*
 * Decompiled with CFR 0.152.
 */
package users.ntnu.fkh.ParticlesAndWalls_pkg;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.colos.ejs.library.LauncherApplet;
import org.colos.ejs.library.Model;
import org.colos.ejs.library.Simulation;
import org.colos.ejs.library.View;
import org.colos.ejs.library.control.EjsControl;
import org.colos.ejs.library.control.swing.ControlWindow;
import org.colos.ejs.library.utils.HtmlPageInfo;
import org.colos.ejs.library.utils.LocaleItem;
import org.colos.ejs.library.utils.TranslatorUtil;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.numerics.ode_solvers.EjsS_ODE;
import org.opensourcephysics.numerics.ode_solvers.InterpolatorEventSolver;
import org.opensourcephysics.numerics.ode_solvers.SolverEngine;
import org.opensourcephysics.numerics.ode_solvers.rk.EulerRichardson;
import org.opensourcephysics.numerics.ode_solvers.symplectic.VelocityVerletSavvy;
import org.opensourcephysics.tools.ResourceLoader;
import users.ntnu.fkh.ParticlesAndWalls_pkg.ParticlesAndWallsSimulation;
import users.ntnu.fkh.ParticlesAndWalls_pkg.ParticlesAndWallsView;

public class ParticlesAndWalls
extends Model {
    public static boolean _sSwingView;
    public static int _sServerPort;
    public ParticlesAndWallsSimulation _simulation = null;
    public ParticlesAndWallsView _view = null;
    public ParticlesAndWalls _model = this;
    private static Map<String, Set<HtmlPageInfo>> __htmlPagesMap;
    protected Hashtable<String, EjsS_ODE> _privateOdesList = new Hashtable();
    public double minimum = -100.0;
    public double maximum = 100.0;
    public double time = 0.0;
    public double deltaTime = 0.1;
    public double resistance = 0.05;
    public double K = 10.0;
    public double threshold = (this.maximum - this.minimum) / 100.0;
    public double Ex = 0.0;
    public double Ey = 0.0;
    public int resolution = 32;
    public double[][][] field;
    public double[][][] potential;
    public int maxParticles = 500;
    public int numParticles = 0;
    public double speed = 10.0;
    public int[] type;
    public Object[] color;
    public double[] mass;
    public double[] charge;
    public double[] size;
    public boolean[] visible;
    public boolean[] showVel;
    public double[] x;
    public double[] y;
    public double[] vx;
    public double[] vy;
    public double[] xPrev;
    public double[] yPrev;
    public int wallMaxPoints = 500;
    public int wallNumPoints = 0;
    public boolean wallStartNewOne = true;
    public int wallPointSelected = -1;
    public double wallMinDistance = (this.maximum - this.minimum) / 20.0;
    public double wallAbsortion = 0.0;
    public double[] wallX;
    public double[] wallY;
    public int[] wallConnectedTo;
    public boolean[] wallVisible;
    public double[] wallDx;
    public double[] wallDy;
    public double[] wallC;
    public double[] wallR2;
    public boolean addPositive = false;
    public boolean addNegative = false;
    public boolean addWall = false;
    public boolean showField = false;
    public boolean showVectorField = false;
    public boolean showPotential = false;
    public boolean showPotential3D = false;
    public boolean showCheckerPotential = false;
    public double potentialMinimum = 0.0;
    public double potentialMaximum = 0.0;
    public double newX = 0.0;
    public double newY = 0.0;
    public int howMany = 10;
    public boolean showSpeeds = false;
    public String filename = "_examples/_data/particles.data";
    private boolean _isEnabled_initialization1 = true;
    private boolean _isEnabled_initialization2 = true;
    private boolean _isEnabled_evolution1 = true;
    private boolean _isEnabled_evolution2 = true;
    private boolean _isEnabled_evolution3 = true;
    private boolean _isEnabled_constraints1 = true;
    private _ODE_evolution1 _ODEi_evolution1;

    public static int _getServerPort() {
        return _sServerPort;
    }

    public static void _addHtmlPageInfo(String string, String string2, String string3, String string4) {
        LocaleItem localeItem;
        Set<HtmlPageInfo> set = __htmlPagesMap.get(string);
        if (set == null) {
            set = new HashSet<HtmlPageInfo>();
            __htmlPagesMap.put(string, set);
        }
        if ((localeItem = LocaleItem.getLocaleItem(string2)) != null) {
            set.add(new HtmlPageInfo(localeItem, string3, string4));
        }
    }

    public static HtmlPageInfo _getHtmlPageClassInfo(String string, LocaleItem localeItem) {
        Set<HtmlPageInfo> set = __htmlPagesMap.get(string);
        if (set == null) {
            return null;
        }
        HtmlPageInfo htmlPageInfo = null;
        for (HtmlPageInfo htmlPageInfo2 : set) {
            if (htmlPageInfo2.getLocaleItem().isDefaultItem()) {
                htmlPageInfo = htmlPageInfo2;
            }
            if (!htmlPageInfo2.getLocaleItem().equals(localeItem)) continue;
            return htmlPageInfo2;
        }
        return htmlPageInfo;
    }

    @Override
    public HtmlPageInfo _getHtmlPageInfo(String string, LocaleItem localeItem) {
        return ParticlesAndWalls._getHtmlPageClassInfo(string, localeItem);
    }

    public static String _getEjsModel() {
        return "/users/ntnu/fkh/ParticlesAndWalls.xml";
    }

    public static String _getModelDirectory() {
        return "users/ntnu/fkh/";
    }

    public static Dimension _getEjsAppletDimension() {
        return new Dimension(621, 311);
    }

    public static Set<String> _getEjsResources() {
        HashSet<String> hashSet = new HashSet<String>();
        return hashSet;
    }

    public static boolean _common_initialization(String[] stringArray) {
        int n;
        String string = null;
        boolean bl = true;
        if (stringArray != null) {
            for (n = 0; n < stringArray.length; ++n) {
                if (stringArray[n].equals("-_lookAndFeel")) {
                    string = stringArray[++n];
                    continue;
                }
                if (stringArray[n].equals("-_decorateWindows")) {
                    bl = true;
                    continue;
                }
                if (stringArray[n].equals("-_doNotDecorateWindows")) {
                    bl = false;
                    continue;
                }
                if (stringArray[n].equals("-_noSwingView")) {
                    _sSwingView = false;
                    continue;
                }
                if (!stringArray[n].equals("-_serverPort")) continue;
                try {
                    _sServerPort = Integer.parseInt(stringArray[++n]);
                    continue;
                }
                catch (Exception exception) {
                    _sServerPort = -1;
                    exception.printStackTrace();
                }
            }
        }
        if (string != null) {
            OSPRuntime.setLookAndFeel(bl, string);
        }
        ResourceLoader.addSearchPath("users/ntnu/fkh/");
        n = 0;
        boolean bl2 = false;
        try {
            if ("true".equals(System.getProperty("org.osp.launcher"))) {
                OSPRuntime.setLauncherMode(true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (System.getProperty("osp_ejs") != null) {
                bl2 = true;
                Simulation.setPathToLibrary("C:/Users/lookang/Dropbox/Public/EjsS_5.2_160712/EjsS_5.2/bin/config/");
                n = 1;
            }
        }
        catch (Exception exception) {
            n = 0;
        }
        try {
            EjsControl.setDefaultScreen(Integer.parseInt(System.getProperty("screen")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (n == 0) {
            Simulation.setPathToLibrary("C:/Users/lookang/Dropbox/Public/EjsS_5.2_160712/EjsS_5.2/bin/config/");
        }
        ParticlesAndWalls._addHtmlPageInfo("Particles and Walls", "_default_", "Particles and Walls", "./ParticlesAndWalls_Intro_1.html");
        ParticlesAndWalls._addHtmlPageInfo("Activities", "_default_", "Activities", "./ParticlesAndWalls_Intro_2.html");
        ParticlesAndWalls._addHtmlPageInfo("Author", "_default_", "Author", "./ParticlesAndWalls_Intro_3.html");
        if (!bl2) {
            // empty if block
        }
        return true;
    }

    public static void main(String[] stringArray) {
        if (!ParticlesAndWalls._common_initialization(stringArray)) {
            if (OSPRuntime.isLauncherMode()) {
                return;
            }
            System.exit(-1);
        }
        ParticlesAndWalls particlesAndWalls = new ParticlesAndWalls(stringArray);
    }

    public static JComponent getModelPane(String[] stringArray, JFrame jFrame) {
        if (!ParticlesAndWalls._common_initialization(stringArray)) {
            return null;
        }
        ParticlesAndWalls particlesAndWalls = new ParticlesAndWalls("mainFrame", jFrame, null, null, stringArray, true);
        return (JComponent)particlesAndWalls._getView().getComponent("mainFrame");
    }

    public ParticlesAndWalls() {
        this(null, null, null, null, null, false);
    }

    public ParticlesAndWalls(String[] stringArray) {
        this(null, null, null, null, stringArray, true);
    }

    public ParticlesAndWalls(String string, Frame frame, URL uRL, LauncherApplet launcherApplet, String[] stringArray, boolean bl) {
        ControlWindow.setKeepHidden(true);
        this.__theArguments = stringArray;
        this.__theApplet = launcherApplet;
        NumberFormat numberFormat = NumberFormat.getInstance();
        if (numberFormat instanceof DecimalFormat) {
            ((DecimalFormat)numberFormat).getDecimalFormatSymbols().setDecimalSeparator('.');
        }
        this._simulation = new ParticlesAndWallsSimulation(this, string, frame, uRL, bl);
        this._simulation.processArguments(stringArray);
        if (_sSwingView) {
            ControlWindow.setKeepHidden(false);
        }
    }

    @Override
    public String _getClassEjsModel() {
        return ParticlesAndWalls._getEjsModel();
    }

    @Override
    public Set<String> _getClassEjsResources() {
        return ParticlesAndWalls._getEjsResources();
    }

    @Override
    public String _getClassModelDirectory() {
        return ParticlesAndWalls._getModelDirectory();
    }

    @Override
    public View _getView() {
        return this._view;
    }

    @Override
    public Simulation _getSimulation() {
        return this._simulation;
    }

    @Override
    public int _getPreferredStepsPerDisplay() {
        return 1;
    }

    @Override
    public void _resetModel() {
        int n;
        int n2;
        int n3;
        this._isEnabled_initialization1 = true;
        this._isEnabled_initialization2 = true;
        this._isEnabled_evolution1 = true;
        this._isEnabled_evolution2 = true;
        this._isEnabled_evolution3 = true;
        this._isEnabled_constraints1 = true;
        this.minimum = -100.0;
        this.maximum = 100.0;
        this.time = 0.0;
        this.deltaTime = 0.1;
        this.resistance = 0.05;
        this.K = 10.0;
        this.threshold = (this.maximum - this.minimum) / 100.0;
        this.Ex = 0.0;
        this.Ey = 0.0;
        this.resolution = 32;
        this.field = new double[this.resolution][this.resolution][5];
        for (n3 = 0; n3 < this.resolution; ++n3) {
            for (n2 = 0; n2 < this.resolution; ++n2) {
                for (n = 0; n < 5; ++n) {
                    this.field[n3][n2][n] = 0.0;
                }
            }
        }
        this.potential = new double[this.resolution][this.resolution][3];
        for (n3 = 0; n3 < this.resolution; ++n3) {
            for (n2 = 0; n2 < this.resolution; ++n2) {
                for (n = 0; n < 3; ++n) {
                    this.potential[n3][n2][n] = 0.0;
                }
            }
        }
        this.maxParticles = 500;
        this.numParticles = 0;
        this.speed = 10.0;
        this.type = new int[this.maxParticles];
        for (n3 = 0; n3 < this.maxParticles; ++n3) {
            this.type[n3] = 1;
        }
        this.color = new Object[this.maxParticles];
        this.mass = new double[this.maxParticles];
        for (n3 = 0; n3 < this.maxParticles; ++n3) {
            this.mass[n3] = 1.0;
        }
        this.charge = new double[this.maxParticles];
        for (n3 = 0; n3 < this.maxParticles; ++n3) {
            this.charge[n3] = 1.0;
        }
        this.size = new double[this.maxParticles];
        for (n3 = 0; n3 < this.maxParticles; ++n3) {
            this.size[n3] = 0.1;
        }
        this.visible = new boolean[this.maxParticles];
        for (n3 = 0; n3 < this.maxParticles; ++n3) {
            this.visible[n3] = false;
        }
        this.showVel = new boolean[this.maxParticles];
        for (n3 = 0; n3 < this.maxParticles; ++n3) {
            this.showVel[n3] = false;
        }
        this.x = new double[this.maxParticles];
        for (n3 = 0; n3 < this.maxParticles; ++n3) {
            this.x[n3] = 0.0;
        }
        this.y = new double[this.maxParticles];
        for (n3 = 0; n3 < this.maxParticles; ++n3) {
            this.y[n3] = 0.0;
        }
        this.vx = new double[this.maxParticles];
        for (n3 = 0; n3 < this.maxParticles; ++n3) {
            this.vx[n3] = 10.0;
        }
        this.vy = new double[this.maxParticles];
        for (n3 = 0; n3 < this.maxParticles; ++n3) {
            this.vy[n3] = 10.0;
        }
        this.xPrev = new double[this.maxParticles];
        for (n3 = 0; n3 < this.maxParticles; ++n3) {
            this.xPrev[n3] = 0.0;
        }
        this.yPrev = new double[this.maxParticles];
        for (n3 = 0; n3 < this.maxParticles; ++n3) {
            this.yPrev[n3] = 0.0;
        }
        this.wallMaxPoints = 500;
        this.wallNumPoints = 0;
        this.wallStartNewOne = true;
        this.wallPointSelected = -1;
        this.wallMinDistance = (this.maximum - this.minimum) / 20.0;
        this.wallAbsortion = 0.0;
        this.wallX = new double[this.wallMaxPoints];
        for (n3 = 0; n3 < this.wallMaxPoints; ++n3) {
            this.wallX[n3] = 0.0;
        }
        this.wallY = new double[this.wallMaxPoints];
        for (n3 = 0; n3 < this.wallMaxPoints; ++n3) {
            this.wallY[n3] = 0.0;
        }
        this.wallConnectedTo = new int[this.wallMaxPoints];
        for (n3 = 0; n3 < this.wallMaxPoints; ++n3) {
            this.wallConnectedTo[n3] = -1;
        }
        this.wallVisible = new boolean[this.wallMaxPoints];
        for (n3 = 0; n3 < this.wallMaxPoints; ++n3) {
            this.wallVisible[n3] = false;
        }
        this.wallDx = new double[this.wallMaxPoints];
        this.wallDy = new double[this.wallMaxPoints];
        this.wallC = new double[this.wallMaxPoints];
        this.wallR2 = new double[this.wallMaxPoints];
        this.addPositive = false;
        this.addNegative = false;
        this.addWall = false;
        this.showField = false;
        this.showVectorField = false;
        this.showPotential = false;
        this.showPotential3D = false;
        this.showCheckerPotential = false;
        this.potentialMinimum = 0.0;
        this.potentialMaximum = 0.0;
        this.newX = 0.0;
        this.newY = 0.0;
        this.howMany = 10;
        this.showSpeeds = false;
        this.filename = "_examples/_data/particles.data";
        this._ODEi_evolution1 = new _ODE_evolution1();
    }

    public void _initializeSolvers() {
        for (EjsS_ODE ejsS_ODE : this._privateOdesList.values()) {
            ejsS_ODE.initializeSolver();
        }
    }

    @Override
    public void _initializeModel() {
        this.__shouldBreak = false;
        boolean bl = this._isEnabled_initialization1;
        boolean bl2 = this._isEnabled_initialization2;
        if (bl) {
            this._initialization1();
        }
        if (this.__shouldBreak) {
            return;
        }
        if (bl2) {
            this._initialization2();
        }
        if (this.__shouldBreak) {
            return;
        }
        this._initializeSolvers();
    }

    @Override
    public void _automaticResetSolvers() {
        this._ODEi_evolution1.automaticResetSolver();
    }

    @Override
    public void _resetSolvers() {
        this._ODEi_evolution1.resetSolver();
    }

    @Override
    public void _stepModel() {
        this.__shouldBreak = false;
        boolean bl = this._isEnabled_evolution1;
        boolean bl2 = this._isEnabled_evolution2;
        boolean bl3 = this._isEnabled_evolution3;
        if (bl) {
            this._ODEi_evolution1.step();
        }
        if (this.__shouldBreak) {
            return;
        }
        if (bl2) {
            this._evolution2();
        }
        if (this.__shouldBreak) {
            return;
        }
        if (bl3) {
            this._evolution3();
        }
        if (this.__shouldBreak) {
            return;
        }
    }

    @Override
    public void _updateModel() {
        this.__shouldBreak = false;
        boolean bl = this._isEnabled_constraints1;
        if (bl) {
            this._constraints1();
        }
        if (this.__shouldBreak) {
            return;
        }
    }

    @Override
    public void _readFromViewAfterUpdate() {
    }

    @Override
    public void _freeMemory() {
        this.getSimulation().setEnded();
        this.field = null;
        this.potential = null;
        this.type = null;
        this.color = null;
        this.mass = null;
        this.charge = null;
        this.size = null;
        this.visible = null;
        this.showVel = null;
        this.x = null;
        this.y = null;
        this.vx = null;
        this.vy = null;
        this.xPrev = null;
        this.yPrev = null;
        this.wallX = null;
        this.wallY = null;
        this.wallConnectedTo = null;
        this.wallVisible = null;
        this.wallDx = null;
        this.wallDy = null;
        this.wallC = null;
        this.wallR2 = null;
        this._ODEi_evolution1 = null;
        System.gc();
    }

    public EjsS_ODE _getODE(String string) {
        try {
            return this._privateOdesList.get(string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public InterpolatorEventSolver _getEventSolver(String string) {
        try {
            return this._privateOdesList.get(string).getEventSolver();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void _setSolverClass(String string, Class<?> clazz) {
        try {
            this._privateOdesList.get(string).setSolverClass(clazz);
        }
        catch (Exception exception) {
            System.err.println("There is no ODE with this name " + string);
        }
    }

    public String _setSolverClass(String string, String string2) {
        if (string2 == null) {
            System.err.println("Null solver class name!");
            return null;
        }
        try {
            return this._privateOdesList.get(string).setSolverClass(string2);
        }
        catch (Exception exception) {
            System.err.println("There is no ODE with this name " + string);
            return null;
        }
    }

    public void _setPageEnabled(String string, boolean bl) {
        boolean bl2 = false;
        if ("Initialization".equals(string)) {
            bl2 = true;
            this._isEnabled_initialization1 = bl;
        }
        if ("Initialize X and Y for the vector field".equals(string)) {
            bl2 = true;
            this._isEnabled_initialization2 = bl;
        }
        if ("Move the particles".equals(string)) {
            bl2 = true;
            this._isEnabled_evolution1 = bl;
            this._automaticResetSolvers();
        }
        if ("Check boundaries".equals(string)) {
            bl2 = true;
            this._isEnabled_evolution2 = bl;
        }
        if ("Apply resistance".equals(string)) {
            bl2 = true;
            this._isEnabled_evolution3 = bl;
        }
        if ("Compute derived variables".equals(string)) {
            bl2 = true;
            this._isEnabled_constraints1 = bl;
        }
        if (!bl2) {
            System.out.println("_setPageEnabled() warning. Page not found: " + string);
        }
    }

    public void _initialization1() {
        this.numParticles = 10;
        this.resistance = 0.01;
        for (int i = 0; i < this.maxParticles; ++i) {
            if (i % 2 == 0) {
                this.type[i] = 1;
                this.size[i] = (this.maximum - this.minimum) / 40.0;
                this.charge[i] = 1.0;
                this.color[i] = Color.blue;
            } else {
                this.type[i] = 10;
                this.size[i] = (this.maximum - this.minimum) / 50.0;
                this.charge[i] = -1.0;
                this.color[i] = Color.red;
            }
            this.visible[i] = i < this.numParticles;
            this.x[i] = this.minimum + (this.maximum - this.minimum) * Math.random();
            this.y[i] = this.minimum + (this.maximum - this.minimum) * Math.random();
            double d = Math.PI * 2 * Math.random();
            this.vx[i] = this.speed * (Math.random() - 0.5);
            this.vy[i] = this.speed * (Math.random() - 0.5);
        }
    }

    public void _initialization2() {
        double d = (this.maximum - this.minimum) / (double)(this.resolution - 1);
        for (int i = 0; i < this.resolution; ++i) {
            for (int j = 0; j < this.resolution; ++j) {
                this.field[i][j][0] = this.minimum + d * (double)i;
                this.field[i][j][1] = this.minimum + d * (double)j;
                this.potential[i][j][0] = this.minimum + d * (double)i;
                this.potential[i][j][1] = this.minimum + d * (double)j;
            }
        }
    }

    public void _evolution2() {
        for (int i = 0; i < this.numParticles; ++i) {
            this.checkWallsIntersection(i, this.deltaTime, -1);
            if (this.x[i] > this.maximum) {
                this.x[i] = this.maximum + (this.maximum - this.x[i]);
                this.vx[i] = -this.vx[i] * (1.0 - this.wallAbsortion);
            }
            if (this.x[i] < this.minimum) {
                this.x[i] = this.minimum + (this.minimum - this.x[i]);
                this.vx[i] = -this.vx[i] * (1.0 - this.wallAbsortion);
            }
            if (this.y[i] > this.maximum) {
                this.y[i] = this.maximum + (this.maximum - this.y[i]);
                this.vy[i] = -this.vy[i] * (1.0 - this.wallAbsortion);
            }
            if (!(this.y[i] < this.minimum)) continue;
            this.y[i] = this.minimum + (this.minimum - this.y[i]);
            this.vy[i] = -this.vy[i] * (1.0 - this.wallAbsortion);
        }
    }

    public void _evolution3() {
        int n = 0;
        while (n < this.numParticles) {
            int n2 = n;
            this.vx[n2] = this.vx[n2] * (1.0 - this.resistance);
            int n3 = n++;
            this.vy[n3] = this.vy[n3] * (1.0 - this.resistance);
        }
    }

    public void _constraints1() {
        for (int i = 0; i < this.numParticles; ++i) {
            this.xPrev[i] = this.x[i];
            this.yPrev[i] = this.y[i];
        }
        this.computeVectorField();
        this.computePotential();
        this.computeField(this.newX, this.newY);
    }

    private double force(int n, double[] dArray, double[] dArray2, boolean bl) {
        double d = 0.0;
        if (n >= this.numParticles) {
            return 0.0;
        }
        for (int i = 0; i < this.numParticles; ++i) {
            double d2;
            if (i == n || (d2 = (dArray[i] - dArray[n]) * (dArray[i] - dArray[n]) + (dArray2[i] - dArray2[n]) * (dArray2[i] - dArray2[n])) < this.threshold) continue;
            if (bl) {
                d += this.K * this.charge[i] * this.charge[n] * (dArray[n] - dArray[i]) / d2;
                continue;
            }
            d += this.K * this.charge[i] * this.charge[n] * (dArray2[n] - dArray2[i]) / d2;
        }
        return d;
    }

    private void computeField(double d, double d2) {
        double d3 = 0.0;
        this.Ex = 0.0;
        this.Ey = 0.0;
        for (int i = 0; i < this.numParticles; ++i) {
            double d4 = (this.x[i] - d) * (this.x[i] - d) + (this.y[i] - d2) * (this.y[i] - d2);
            if (d4 < this.threshold) continue;
            this.Ex += this.K * this.charge[i] * (d - this.x[i]) / d4;
            this.Ey += this.K * this.charge[i] * (d2 - this.y[i]) / d4;
        }
    }

    public void computeVectorField() {
        if (this.showVectorField) {
            for (int i = 0; i < this.resolution; ++i) {
                for (int j = 0; j < this.resolution; ++j) {
                    this.computeField(this.field[i][j][0], this.field[i][j][1]);
                    double d = Math.sqrt(this.Ex * this.Ex + this.Ey * this.Ey);
                    this.field[i][j][2] = this.Ex / d;
                    this.field[i][j][3] = this.Ey / d;
                    this.field[i][j][4] = d;
                }
            }
        }
    }

    private double computePotential(double d, double d2) {
        double d3 = 0.0;
        for (int i = 0; i < this.numParticles; ++i) {
            double d4 = (this.x[i] - d) * (this.x[i] - d) + (this.y[i] - d2) * (this.y[i] - d2);
            if (d4 < this.threshold) continue;
            d3 -= this.K * this.charge[i] * Math.log(d4) * 0.5;
        }
        return d3;
    }

    public void computePotential() {
        if (this.showPotential || this.showCheckerPotential || this.showPotential3D) {
            for (int i = 0; i < this.resolution; ++i) {
                for (int j = 0; j < this.resolution; ++j) {
                    this.potential[i][j][2] = this.computePotential(this.potential[i][j][0], this.potential[i][j][1]);
                }
            }
        }
    }

    public void computePotentialExtrema() {
        if (!(this.showPotential || this.showCheckerPotential || this.showPotential3D)) {
            this.potentialMinimum = 0.0;
            this.potentialMaximum = 1.0;
            return;
        }
        this.computePotential();
        double d = Double.MAX_VALUE;
        double d2 = Double.MIN_VALUE;
        for (int i = 0; i < this.resolution; ++i) {
            for (int j = 0; j < this.resolution; ++j) {
                d = Math.min(d, this.potential[i][j][2]);
                d2 = Math.max(d2, this.potential[i][j][2]);
            }
        }
        this.potentialMinimum = d;
        this.potentialMaximum = d2;
    }

    public void clearParticles() {
        for (int i = 0; i < this.maxParticles; ++i) {
            this.visible[i] = false;
            this.showVel[i] = false;
        }
        this.numParticles = 0;
    }

    public void freeze() {
        for (int i = 0; i < this.maxParticles; ++i) {
            this.vx[i] = 0.0;
            this.vy[i] = 0.0;
        }
    }

    public void collapse() {
        for (int i = 0; i < this.maxParticles; ++i) {
            this.x[i] = 0.0;
            this.y[i] = 0.0;
            this.vx[i] = this.speed * (Math.random() - 0.5);
            this.vy[i] = this.speed * (Math.random() - 0.5);
        }
    }

    public void showVelocities() {
        for (int i = 0; i < this.numParticles; ++i) {
            this.showVel[i] = this.showSpeeds;
        }
    }

    public void clearWalls() {
        for (int i = 0; i < this.wallMaxPoints; ++i) {
            this.wallVisible[i] = false;
        }
        this.wallNumPoints = 0;
    }

    public void addElements() {
        if (this.addPositive) {
            for (int i = 0; i < this.howMany; ++i) {
                this.addParticle(this.newX, this.newY, true);
            }
        } else if (this.addNegative) {
            for (int i = 0; i < this.howMany; ++i) {
                this.addParticle(this.newX, this.newY, false);
            }
        } else if (this.addWall) {
            this.addWallPoint(this.newX, this.newY);
        }
    }

    public void addWalls() {
        if (this.addWall) {
            this.addWallPoint(this.newX, this.newY);
        }
    }

    public void showField() {
        this.computeField(this.newX, this.newY);
    }

    private void addParticle(double d, double d2, boolean bl) {
        if (this.numParticles >= this.maxParticles) {
            return;
        }
        int n = this.numParticles;
        this.x[n] = d;
        this.y[n] = d2;
        this.vx[n] = this.speed * (Math.random() - 0.5);
        this.vy[n] = this.speed * (Math.random() - 0.5);
        if (bl) {
            this.type[n] = 1;
            this.size[n] = (this.maximum - this.minimum) / 40.0;
            this.charge[n] = 1.0;
            this.color[n] = Color.blue;
        } else {
            this.type[n] = 10;
            this.size[n] = (this.maximum - this.minimum) / 50.0;
            this.charge[n] = -1.0;
            this.color[n] = Color.red;
        }
        this.visible[n] = true;
        this.showVel[n] = this.showSpeeds;
        ++this.numParticles;
    }

    void checkWallsIntersection(int n, double d, int n2) {
        double d2;
        double d3;
        int n3 = -1;
        int n4 = -1;
        double d4 = this.xPrev[n];
        double d5 = this.yPrev[n];
        double d6 = this.x[n];
        double d7 = this.y[n];
        double d8 = 1.0E10;
        double d9 = 0.0;
        double d10 = 0.0;
        double d11 = 0.0;
        for (int i = 0; i < this.wallNumPoints; ++i) {
            double d12;
            n4 = this.wallConnectedTo[i];
            if (n4 < 0 || i == n2 || (d12 = this.wallDy[i] * d6 - this.wallDx[i] * d7 + this.wallC[i]) == 0.0) continue;
            double d13 = this.wallDy[i] * d4 - this.wallDx[i] * d5 + this.wallC[i];
            if (!(d12 > 0.0) ? d13 < 0.0 : d13 > 0.0) continue;
            double d14 = (d6 - d4) / d;
            double d15 = (d7 - d5) / d;
            d3 = -d13 / (this.wallDy[i] * d14 - this.wallDx[i] * d15);
            double d16 = d4 + d3 * d14;
            double d17 = d5 + d3 * d15;
            d2 = (this.wallX[i] - d16) * (this.wallX[n4] - d16) + (this.wallY[i] - d17) * (this.wallY[n4] - d17);
            if (d2 > 0.0 || !(d3 < d8)) continue;
            n3 = i;
            d8 = d3;
            d10 = d16;
            d11 = d17;
            d9 = d12;
        }
        if (n3 < 0) {
            this.x[n] = d6;
            this.y[n] = d7;
        } else {
            d3 = -d9 / this.wallR2[n3];
            this.xPrev[n] = d10;
            this.yPrev[n] = d11;
            this.x[n] = d6 + 2.0 * this.wallDy[n3] * d3;
            this.y[n] = d7 - 2.0 * this.wallDx[n3] * d3;
            d -= d8;
            d2 = (this.vx[n] * this.wallDy[n3] - this.vy[n] * this.wallDx[n3]) / this.wallR2[n3];
            int n5 = n;
            this.vx[n5] = this.vx[n5] - 2.0 * (1.0 - this.wallAbsortion) * d2 * this.wallDy[n3];
            int n6 = n;
            this.vy[n6] = this.vy[n6] - -2.0 * (1.0 - this.wallAbsortion) * d2 * this.wallDx[n3];
            this.checkWallsIntersection(n, d, n3);
        }
    }

    void addWallPoint(double d, double d2) {
        if (this.wallNumPoints >= this.wallMaxPoints) {
            return;
        }
        if (this.wallNumPoints > 0 && Math.abs(this.wallX[this.wallNumPoints - 1] - d) + Math.abs(this.wallY[this.wallNumPoints - 1] - d2) < this.wallMinDistance) {
            return;
        }
        int n = this.getWallPoint(d, d2);
        if (n >= 0) {
            d = this.wallX[n];
            d2 = this.wallY[n];
        }
        ++this.wallNumPoints;
        int n2 = this.wallNumPoints - 1;
        this.wallX[n2] = d;
        this.wallY[n2] = d2;
        this.wallConnectedTo[n2] = -1;
        if (n2 > 0 && !this.wallStartNewOne) {
            this.wallConnectedTo[n2 - 1] = n2;
            this.setWall(n2 - 1);
        }
        this.wallStartNewOne = n >= 0;
    }

    void setWall(int n) {
        int n2 = this.wallConnectedTo[n];
        this.wallVisible[n] = true;
        if (n2 >= 0) {
            this.wallDx[n] = this.wallX[n2] - this.wallX[n];
            this.wallDy[n] = this.wallY[n2] - this.wallY[n];
            this.wallC[n] = this.wallY[n] * this.wallX[n2] - this.wallX[n] * this.wallY[n2];
            this.wallR2[n] = this.wallDx[n] * this.wallDx[n] + this.wallDy[n] * this.wallDy[n];
        }
    }

    int getWallPoint(double d, double d2) {
        double d3 = (this.maximum - this.minimum) / 50.0;
        int n = -1;
        for (int i = 0; i < this.wallNumPoints; ++i) {
            if (!this.wallVisible[i]) continue;
            double d4 = Math.abs(this.wallX[i] - d) + Math.abs(this.wallY[i] - d2);
            if (d4 < d3) {
                n = i;
                d3 = d4;
            }
            if (this.wallConnectedTo[i] < 0 || !((d4 = Math.abs(this.wallX[this.wallConnectedTo[i]] - d) + Math.abs(this.wallY[this.wallConnectedTo[i]] - d2)) < d3)) continue;
            n = this.wallConnectedTo[i];
            d3 = d4;
        }
        return n;
    }

    public void saveFile() {
        this._saveState(this.filename);
    }

    public void readFile() {
        this._readState(this.filename);
    }

    public void _method_for_Play_action() {
        this._play();
    }

    public void _method_for_Pause_action() {
        this._pause();
    }

    public void _method_for_Step_action() {
        this._step();
    }

    public void _method_for_Reset_action() {
        this._reset();
    }

    public void _method_for_Freeze_action() {
        this.freeze();
    }

    public void _method_for_Collapse_action() {
        this.collapse();
    }

    public void _method_for_Velocities_action() {
        this.showVelocities();
    }

    public void _method_for_VectorField_action() {
        this.computeVectorField();
    }

    public void _method_for_Contour_action() {
        this.computePotentialExtrema();
    }

    public void _method_for_Checker_action() {
        this.computePotentialExtrema();
    }

    public void _method_for_Surface_action() {
        this.computePotentialExtrema();
    }

    public void _method_for_Field_action() {
        this.computeVectorField();
    }

    public void _method_for_clearParts_action() {
        this.clearParticles();
    }

    public void _method_for_clearWalls_action() {
        this.clearWalls();
    }

    public void _method_for_Save_action() {
        this.saveFile();
    }

    public void _method_for_Read_action() {
        this.readFile();
    }

    public void _method_for_drawingPanel_dragaction() {
        this.addWalls();
    }

    public void _method_for_drawingPanel_action() {
        this.addElements();
    }

    static {
        __translatorUtil = new TranslatorUtil();
        _sSwingView = true;
        _sServerPort = -1;
        __htmlPagesMap = new HashMap<String, Set<HtmlPageInfo>>();
    }

    private class _ODE_evolution1
    implements EjsS_ODE,
    VelocityVerletSavvy {
        private SolverEngine __solver = null;
        private InterpolatorEventSolver __eventSolver = null;
        private Class<?> __solverClass = EulerRichardson.class;
        private double[] __state = null;
        private boolean __ignoreErrors = false;
        private boolean __mustInitialize = true;
        private boolean __isEnabled = true;
        private boolean __mustUserReinitialize = false;
        private boolean __mustReinitialize = true;
        private double[] _x;
        private double[] _y;
        private double[] _vx;
        private double[] _vy;

        _ODE_evolution1() {
            this.__instantiateSolver();
            ParticlesAndWalls.this._privateOdesList.put("Move the particles", this);
        }

        @Override
        public InterpolatorEventSolver getEventSolver() {
            return this.__eventSolver;
        }

        @Override
        public void setSolverClass(Class<?> clazz) {
            this.__solverClass = clazz;
            this.__instantiateSolver();
        }

        @Override
        public String setSolverClass(String string) {
            String string2 = "org.opensourcephysics.numerics.ode_solvers.";
            if ((string = string.trim().toLowerCase()).indexOf("euler") >= 0) {
                string = string.indexOf("rich") >= 0 ? string2 + "rk.EulerRichardson" : string2 + "rk.Euler";
            } else if (string.indexOf("verlet") >= 0) {
                string = string2 + "symplectic.VelocityVerlet";
            } else if (string.indexOf("runge") >= 0) {
                string = string2 + "rk.RK4";
            } else if (string.indexOf("rk4") >= 0) {
                string = string2 + "rk.RK4";
            } else if (string.indexOf("boga") >= 0) {
                string = string2 + "rk.BogackiShampine23";
            } else if (string.indexOf("cash") >= 0) {
                string = string2 + "rk.CashKarp45";
            } else if (string.indexOf("fehl") >= 0) {
                string = string.indexOf("7") >= 0 ? string2 + "rk.Fehlberg78" : string2 + "rk.Fehlberg8";
            } else if (string.indexOf("dorm") >= 0 || string.indexOf("dopri") >= 0) {
                string = string.indexOf("8") >= 0 ? string2 + "rk.Dopri853" : string2 + "rk.Dopri5";
            } else if (string.indexOf("radau") >= 0) {
                string = string2 + "rk.Radau5";
            } else {
                System.err.println("There is no solver with this name " + string);
                return null;
            }
            try {
                this.setSolverClass(Class.forName(string));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return string;
        }

        private void __instantiateSolver() {
            this.__state = new double[1 + ParticlesAndWalls.this.x.length + ParticlesAndWalls.this.y.length + ParticlesAndWalls.this.vx.length + ParticlesAndWalls.this.vy.length];
            this._x = new double[ParticlesAndWalls.this.x.length];
            this._y = new double[ParticlesAndWalls.this.y.length];
            this._vx = new double[ParticlesAndWalls.this.vx.length];
            this._vy = new double[ParticlesAndWalls.this.vy.length];
            this.__pushState();
            try {
                Class[] classArray = new Class[]{};
                Object[] objectArray = new Object[]{};
                Constructor<?> constructor = this.__solverClass.getDeclaredConstructor(classArray);
                this.__solver = (SolverEngine)constructor.newInstance(objectArray);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.__eventSolver = new InterpolatorEventSolver(this.__solver, this);
            this.__mustInitialize = true;
        }

        @Override
        public void setEnabled(boolean bl) {
            this.__isEnabled = bl;
        }

        @Override
        public double getIndependentVariableValue() {
            return this.__eventSolver.getIndependentVariableValue();
        }

        @Override
        public double getInternalStepSize() {
            return this.__eventSolver.getInternalStepSize();
        }

        @Override
        public boolean isAccelerationIndependentOfVelocity() {
            return false;
        }

        @Override
        public void initializeSolver() {
            if (this.__arraysChanged()) {
                this.__instantiateSolver();
                this.initializeSolver();
                return;
            }
            this.__pushState();
            this.__eventSolver.initialize(ParticlesAndWalls.this.deltaTime);
            this.__eventSolver.setBestInterpolation(false);
            this.__eventSolver.setMaximumInternalSteps(10000);
            this.__eventSolver.removeAllEvents();
            this.__eventSolver.setEstimateFirstStep(false);
            this.__eventSolver.setEnableExceptions(false);
            this.__mustReinitialize = true;
            this.__mustInitialize = false;
        }

        private void __pushState() {
            int n;
            int n2;
            int n3 = 0;
            if (!this.__mustReinitialize) {
                n2 = n3;
                for (n = 0; n < ParticlesAndWalls.this.x.length; ++n) {
                    if (this.__state[n2++] == ParticlesAndWalls.this.x[n]) continue;
                    this.__mustReinitialize = true;
                    break;
                }
            }
            System.arraycopy(ParticlesAndWalls.this.x, 0, this.__state, n3, ParticlesAndWalls.this.x.length);
            n3 += ParticlesAndWalls.this.x.length;
            if (!this.__mustReinitialize) {
                n2 = n3;
                for (n = 0; n < ParticlesAndWalls.this.y.length; ++n) {
                    if (this.__state[n2++] == ParticlesAndWalls.this.y[n]) continue;
                    this.__mustReinitialize = true;
                    break;
                }
            }
            System.arraycopy(ParticlesAndWalls.this.y, 0, this.__state, n3, ParticlesAndWalls.this.y.length);
            n3 += ParticlesAndWalls.this.y.length;
            if (!this.__mustReinitialize) {
                n2 = n3;
                for (n = 0; n < ParticlesAndWalls.this.vx.length; ++n) {
                    if (this.__state[n2++] == ParticlesAndWalls.this.vx[n]) continue;
                    this.__mustReinitialize = true;
                    break;
                }
            }
            System.arraycopy(ParticlesAndWalls.this.vx, 0, this.__state, n3, ParticlesAndWalls.this.vx.length);
            n3 += ParticlesAndWalls.this.vx.length;
            if (!this.__mustReinitialize) {
                n2 = n3;
                for (n = 0; n < ParticlesAndWalls.this.vy.length; ++n) {
                    if (this.__state[n2++] == ParticlesAndWalls.this.vy[n]) continue;
                    this.__mustReinitialize = true;
                    break;
                }
            }
            System.arraycopy(ParticlesAndWalls.this.vy, 0, this.__state, n3, ParticlesAndWalls.this.vy.length);
            if (this.__state[n3 += ParticlesAndWalls.this.vy.length] != ParticlesAndWalls.this.time) {
                this.__mustReinitialize = true;
            }
            this.__state[n3++] = ParticlesAndWalls.this.time;
        }

        private boolean __arraysChanged() {
            if (ParticlesAndWalls.this.x.length != this._x.length) {
                return true;
            }
            if (ParticlesAndWalls.this.y.length != this._y.length) {
                return true;
            }
            if (ParticlesAndWalls.this.vx.length != this._vx.length) {
                return true;
            }
            return ParticlesAndWalls.this.vy.length != this._vy.length;
        }

        public void resetSolver() {
            this.__mustUserReinitialize = true;
        }

        public void automaticResetSolver() {
            this.__mustReinitialize = true;
        }

        private void __errorAction() {
            if (this.__ignoreErrors) {
                return;
            }
            System.err.println(this.__eventSolver.getErrorMessage());
            int n = JOptionPane.showConfirmDialog(ParticlesAndWalls.this._view.getComponent(ParticlesAndWalls.this._simulation.getMainWindow()), Simulation.getEjsString("ODEError.Continue"), Simulation.getEjsString("Error"), 1);
            if (n == 0) {
                this.__ignoreErrors = true;
            } else if (n == 2) {
                ParticlesAndWalls.this._pause();
            }
            this.__mustReinitialize = true;
        }

        @Override
        public double step() {
            return this.__privateStep(false);
        }

        @Override
        public double solverStep() {
            return this.__privateStep(true);
        }

        private double __privateStep(boolean bl) {
            if (!this.__isEnabled) {
                return 0.0;
            }
            if (ParticlesAndWalls.this.deltaTime == 0.0) {
                return 0.0;
            }
            if (this.__mustInitialize) {
                this.initializeSolver();
            }
            if (this.__arraysChanged()) {
                this.__instantiateSolver();
                this.initializeSolver();
            }
            this.__eventSolver.setStepSize(ParticlesAndWalls.this.deltaTime);
            this.__eventSolver.setInternalStepSize(ParticlesAndWalls.this.deltaTime);
            this.__eventSolver.setMaximumInternalSteps(10000);
            this.__pushState();
            if (this.__mustUserReinitialize) {
                this.__eventSolver.userReinitialize();
                this.__mustUserReinitialize = false;
                this.__mustReinitialize = false;
                if (this.__eventSolver.getErrorCode() != InterpolatorEventSolver.ERROR.NO_ERROR) {
                    this.__errorAction();
                }
            } else if (this.__mustReinitialize) {
                this.__eventSolver.reinitialize();
                this.__mustReinitialize = false;
                if (this.__eventSolver.getErrorCode() != InterpolatorEventSolver.ERROR.NO_ERROR) {
                    this.__errorAction();
                }
            }
            double d = bl ? this.__eventSolver.maxStep() : this.__eventSolver.step();
            int n = 0;
            System.arraycopy(this.__state, n, ParticlesAndWalls.this.x, 0, ParticlesAndWalls.this.x.length);
            System.arraycopy(this.__state, n += ParticlesAndWalls.this.x.length, ParticlesAndWalls.this.y, 0, ParticlesAndWalls.this.y.length);
            System.arraycopy(this.__state, n += ParticlesAndWalls.this.y.length, ParticlesAndWalls.this.vx, 0, ParticlesAndWalls.this.vx.length);
            System.arraycopy(this.__state, n += ParticlesAndWalls.this.vx.length, ParticlesAndWalls.this.vy, 0, ParticlesAndWalls.this.vy.length);
            n += ParticlesAndWalls.this.vy.length;
            ParticlesAndWalls.this.time = this.__state[n++];
            if (this.__eventSolver.getErrorCode() != InterpolatorEventSolver.ERROR.NO_ERROR) {
                this.__errorAction();
            }
            return d;
        }

        @Override
        public double[] getState() {
            return this.__state;
        }

        @Override
        public void getRate(double[] dArray, double[] dArray2) {
            int n;
            dArray2[dArray2.length - 1] = 0.0;
            int n2 = -1;
            int n3 = 0;
            double[] dArray3 = this._x;
            System.arraycopy(dArray, n3, dArray3, 0, dArray3.length);
            double[] dArray4 = this._y;
            System.arraycopy(dArray, n3 += dArray3.length, dArray4, 0, dArray4.length);
            double[] dArray5 = this._vx;
            System.arraycopy(dArray, n3 += dArray4.length, dArray5, 0, dArray5.length);
            double[] dArray6 = this._vy;
            System.arraycopy(dArray, n3 += dArray5.length, dArray6, 0, dArray6.length);
            n3 += dArray6.length;
            double d = dArray[n3++];
            int n4 = 0;
            for (n = 0; n < dArray3.length; ++n) {
                dArray2[n4++] = dArray5[n];
            }
            for (n = 0; n < dArray4.length; ++n) {
                dArray2[n4++] = dArray6[n];
            }
            for (n = 0; n < dArray5.length; ++n) {
                dArray2[n4++] = ParticlesAndWalls.this.force(n, dArray3, dArray4, true) / ParticlesAndWalls.this.mass[n];
            }
            for (n = 0; n < dArray6.length; ++n) {
                dArray2[n4++] = ParticlesAndWalls.this.force(n, dArray3, dArray4, false) / ParticlesAndWalls.this.mass[n];
            }
            dArray2[n4++] = 1.0;
        }
    }
}

