/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.rmi.RemoteException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.border.EmptyBorder;
import javax.swing.filechooser.FileSystemView;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.display.DisplayRes;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.tools.Job;
import org.opensourcephysics.tools.ResourceLoader;
import org.opensourcephysics.tools.Tool;
import org.opensourcephysics.tools.Toolbox;

public class JarTool
implements Tool,
Runnable {
    public static final int YES = 0;
    public static final int NO = 1;
    public static final int YES_TO_ALL = 2;
    public static final int NO_TO_ALL = 3;
    public static final int CANCEL = 4;
    private static final String BUNDLE_NAME = "org.opensourcephysics.resources.tools.tools";
    private static ResourceBundle res = ResourceBundle.getBundle("org.opensourcephysics.resources.tools.tools");
    private static JarTool TOOL = new JarTool();
    private static JFileChooser chooser;
    private static int overwritePolicy;
    private static Frame ownerFrame;
    private static Map<String, Map<String, ZipEntry>> jarContents;
    private ArrayList<String> instanceSources;
    private File instanceParent;
    private File instanceTarget;
    private Manifest instanceManifest;
    private OverwriteValue instancePolicy;
    private Frame instanceOwnerFrame;

    static {
        overwritePolicy = 1;
        ownerFrame = null;
        jarContents = new HashMap<String, Map<String, ZipEntry>>();
    }

    public static void setLocale(Locale locale) {
        res = ResourceBundle.getBundle(BUNDLE_NAME, locale);
    }

    public static String getString(String key) {
        try {
            return res.getString(key);
        }
        catch (MissingResourceException e) {
            return String.valueOf('!') + key + '!';
        }
    }

    public static JarTool getTool() {
        if (TOOL == null) {
            TOOL = new JarTool();
        }
        return TOOL;
    }

    private JarTool() {
        String name = "JarTool";
        chooser = OSPRuntime.createChooser("JAR, ZIP", new String[]{"zip", "jar", "trz"});
        Toolbox.addTool(name, this);
    }

    @Override
    public void run() {
        JarTool.compressList(this.instanceSources, this.instanceParent, this.instanceTarget, this.instanceManifest, this.instancePolicy, this.instanceOwnerFrame);
    }

    private JarTool(ArrayList<String> aSources, File aParent, File aTarget, Manifest aManifest, OverwriteValue aPolicy, Frame _anOwner) {
        this();
        this.instanceSources = aSources;
        this.instanceParent = aParent;
        this.instanceTarget = aTarget;
        this.instanceManifest = aManifest;
        this.instancePolicy = aPolicy;
        this.instanceOwnerFrame = _anOwner;
    }

    @Override
    public void send(Job job, Tool replyTo) throws RemoteException {
    }

    public static void disableWarning() {
        JarTool.alwaysOverwrite();
    }

    public static void neverOverwrite() {
        overwritePolicy = 3;
    }

    public static void alwaysOverwrite() {
        overwritePolicy = 2;
    }

    public static void setOwnerFrame(Frame owner) {
        ownerFrame = owner;
    }

    public File create(ArrayList<String> sources, File parent, File target, Manifest manifest) {
        OverwriteValue policy;
        block11: {
            int selected;
            String targetName;
            boolean warnBeforeOverwritting;
            block10: {
                policy = new OverwriteValue(overwritePolicy);
                overwritePolicy = 1;
                if (sources.size() <= 0) {
                    return null;
                }
                try {
                    warnBeforeOverwritting = true;
                    if (target != null) {
                        chooser.setCurrentDirectory(target.getParentFile());
                        chooser.setSelectedFile(target);
                    } else {
                        chooser.setSelectedFile(new File("default.jar"));
                    }
                    targetName = OSPRuntime.chooseFilename(chooser);
                    if (targetName != null) break block10;
                    return null;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    return null;
                }
            }
            if (!(targetName.toLowerCase().endsWith(".jar") || targetName.toLowerCase().endsWith(".trz") || targetName.toLowerCase().endsWith(".zip"))) {
                targetName = String.valueOf(targetName) + ".jar";
            } else {
                warnBeforeOverwritting = false;
            }
            target = new File(targetName);
            if (XML.forwardSlash(target.getAbsolutePath()).equals(OSPRuntime.getLaunchJarPath())) {
                String[] message = new String[]{res.getString("JarTool.JarNotCreated"), String.valueOf(res.getString("JarTool.FileIsForbidden")) + " " + target};
                JOptionPane.showMessageDialog(null, message, res.getString("JarTool.Error"), 2);
                return this.create(sources, parent, target, manifest);
            }
            if (!warnBeforeOverwritting || !target.exists() || (selected = JOptionPane.showConfirmDialog(null, String.valueOf(DisplayRes.getString("DrawingFrame.ReplaceExisting_message")) + " " + target.getName() + DisplayRes.getString("DrawingFrame.QuestionMark"), DisplayRes.getString("DrawingFrame.ReplaceFile_option_title"), 1)) == 0) break block11;
            return null;
        }
        JarTool builder = new JarTool(sources, parent, target, manifest, policy, ownerFrame);
        Thread thread = new Thread(builder);
        thread.setPriority(5);
        thread.start();
        return target;
    }

    public File append(ArrayList<String> sources, File parent, String target) {
        File targetFile;
        OverwriteValue policy;
        block5: {
            policy = new OverwriteValue(overwritePolicy);
            overwritePolicy = 1;
            if (sources.size() <= 0) {
                return null;
            }
            try {
                targetFile = new File(parent, target);
                if (targetFile.exists()) break block5;
                String[] message = new String[]{res.getString("JarTool.JarNotCreated"), String.valueOf(res.getString("JarTool.FileDoesntExist")) + " " + target};
                JOptionPane.showMessageDialog(null, message, res.getString("JarTool.Error"), 2);
                return null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return null;
            }
        }
        if (!sources.contains(target)) {
            sources.add(0, target);
        }
        return JarTool.compressList(sources, parent, targetFile, JarTool.getManifest(targetFile), policy, ownerFrame);
    }

    public static Manifest createManifest(String classpath, String mainclass) {
        SimpleDateFormat sdf = new SimpleDateFormat("dd MMM yyyy");
        Calendar cal = Calendar.getInstance();
        String date = sdf.format(cal.getTime());
        try {
            StringBuffer manifestStr = new StringBuffer();
            manifestStr.append("Manifest-Version: 1.0\n");
            manifestStr.append("Built-By: Open Source Physics JarTool\n");
            manifestStr.append("Build-Date: " + date + "\n");
            if (classpath != null) {
                classpath = classpath.replace(';', ' ');
                classpath = classpath.replace(',', ' ');
                classpath = classpath.replace(':', ' ');
                manifestStr.append("Class-Path: " + classpath + "\n");
            }
            if (mainclass != null) {
                manifestStr.append("Main-Class: " + mainclass + "\n");
            }
            manifestStr.append("\n");
            ByteArrayInputStream mis = new ByteArrayInputStream(manifestStr.toString().getBytes("UTF-8"));
            return new Manifest(mis);
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return null;
        }
    }

    public static Manifest getManifest(File file) {
        try {
            JarFile jar = new JarFile(file);
            Manifest manifest = jar.getManifest();
            jar.close();
            return manifest;
        }
        catch (Exception exc) {
            return null;
        }
    }

    public static File extract(File source, String filename, String destination) {
        return JarTool.extract(source, filename, new File(destination));
    }

    public static File extract(File source, String filename, File target) {
        if (!source.exists() || filename == null || filename.trim().length() < 1 || target == null) {
            return null;
        }
        boolean isDirectory = filename.lastIndexOf("/") == filename.length() - 1;
        try {
            int bytesRead;
            Map<String, ZipEntry> contents = jarContents.get(source.getPath());
            if (contents == null) {
                contents = new HashMap<String, ZipEntry>();
                jarContents.put(source.getPath(), contents);
                ZipInputStream input = new ZipInputStream(new FileInputStream(source));
                ZipEntry zipEntry = null;
                while ((zipEntry = input.getNextEntry()) != null) {
                    if (zipEntry.isDirectory()) continue;
                    contents.put(zipEntry.getName(), zipEntry);
                }
                input.close();
            }
            if (isDirectory) {
                for (String next : contents.keySet()) {
                    if (!next.startsWith(filename)) continue;
                    ZipEntry zipEntry = contents.get(next);
                    int n = filename.length();
                    File newTarget = new File(target, zipEntry.getName().substring(n));
                    JarTool.extract(source, next, newTarget);
                }
                return target;
            }
            ZipEntry entry = contents.get(filename);
            ZipFile input = new ZipFile(source);
            InputStream in = input.getInputStream(entry);
            File parent = target.getParentFile();
            if (parent != null) {
                parent.mkdirs();
            }
            byte[] buffer = new byte[1024];
            FileOutputStream output = new FileOutputStream(target);
            while ((bytesRead = in.read(buffer)) != -1) {
                output.write(buffer, 0, bytesRead);
            }
            output.close();
            input.close();
            return target;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static File extract(ClassLoader classLoader, String filename, File target) {
        URL url;
        block5: {
            if (filename == null || filename.trim().length() <= 0 || target == null) {
                return null;
            }
            url = classLoader.getResource(filename);
            if (url != null) break block5;
            return null;
        }
        try {
            int bytesRead;
            target.getParentFile().mkdirs();
            byte[] buffer = new byte[1024];
            FileOutputStream output = new FileOutputStream(target);
            BufferedInputStream input = new BufferedInputStream(url.openStream());
            while ((bytesRead = input.read(buffer)) != -1) {
                output.write(buffer, 0, bytesRead);
            }
            output.close();
            input.close();
            return target;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return null;
        }
    }

    public static File extract(String filename, File target) {
        InputStream inputStream;
        block12: {
            if (filename == null || filename.trim().length() <= 0 || target == null) {
                return null;
            }
            inputStream = null;
            if (OSPRuntime.applet != null) {
                inputStream = OSPRuntime.applet.getClass().getResourceAsStream(filename);
            }
            if (inputStream == null) {
                if (filename.indexOf("http:") > -1) {
                    File extracted;
                    int n = filename.toLowerCase().indexOf(".zip!/");
                    if (n == -1) {
                        n = filename.toLowerCase().indexOf(".jar!/");
                    }
                    if (n == -1) {
                        n = filename.toLowerCase().indexOf(".trz!/");
                    }
                    if (n > -1 && (extracted = ResourceLoader.extractFileFromZIP(filename, target, false)) != null) {
                        return extracted;
                    }
                } else {
                    inputStream = ResourceLoader.getResource(filename, false).openInputStream();
                }
            }
            if (inputStream != null) break block12;
            return null;
        }
        try {
            int bytesRead;
            BufferedInputStream input = new BufferedInputStream(inputStream);
            target.getParentFile().mkdirs();
            byte[] buffer = new byte[1024];
            FileOutputStream output = new FileOutputStream(target);
            while ((bytesRead = input.read(buffer)) != -1) {
                output.write(buffer, 0, bytesRead);
            }
            output.close();
            input.close();
            return target;
        }
        catch (Exception exc) {
            System.err.println("JarTool extract resource error.  Filename=" + filename);
            exc.printStackTrace();
            return null;
        }
    }

    /*
     * Exception decompiling
     */
    public static boolean extract(Object source, List<?> files, File targetDirectory) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CASE], 0[SWITCH]], but top level block is 4[SWITCH]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static boolean copy(File source, File target) {
        block4: {
            if (source.exists()) break block4;
            return false;
        }
        try {
            int len;
            target.getParentFile().mkdirs();
            FileInputStream input = new FileInputStream(source);
            FileOutputStream output = new FileOutputStream(target);
            byte[] buf = new byte[1024];
            while ((len = ((InputStream)input).read(buf)) > 0) {
                ((OutputStream)output).write(buf, 0, len);
            }
            ((InputStream)input).close();
            ((OutputStream)output).close();
            return true;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return false;
        }
    }

    public static boolean compress(File source, File target, Manifest manifest) {
        block12: {
            if (source.exists() & source.isDirectory()) break block12;
            return false;
        }
        try {
            if (target.exists()) {
                target.delete();
            }
            ZipOutputStream output = null;
            boolean isJar = target.getName().toLowerCase().endsWith(".jar");
            if (isJar) {
                File manifestDir = new File(source, "META-INF");
                JarTool.remove(manifestDir);
                output = manifest != null ? new JarOutputStream((OutputStream)new FileOutputStream(target), manifest) : new JarOutputStream(new FileOutputStream(target));
            } else {
                output = new ZipOutputStream(new FileOutputStream(target));
            }
            Collection<File> list = JarTool.getContents(source);
            String baseDir = source.getAbsolutePath().replace('\\', '/');
            if (!baseDir.endsWith("/")) {
                baseDir = String.valueOf(baseDir) + "/";
            }
            int baseDirLength = baseDir.length();
            byte[] buffer = new byte[1024];
            for (File file : list) {
                int bytesRead;
                FileInputStream f_in = new FileInputStream(file);
                String filename = file.getAbsolutePath().replace('\\', '/');
                if (filename.startsWith(baseDir)) {
                    filename = filename.substring(baseDirLength);
                }
                if (isJar) {
                    output.putNextEntry(new JarEntry(filename));
                } else {
                    output.putNextEntry(new ZipEntry(filename));
                }
                while ((bytesRead = f_in.read(buffer)) != -1) {
                    output.write(buffer, 0, bytesRead);
                }
                f_in.close();
                output.closeEntry();
            }
            output.close();
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return false;
        }
        return true;
    }

    public static boolean compress(ArrayList<File> sources, File target, Manifest manifest) {
        block12: {
            if (sources != null && sources.size() != 0) break block12;
            return false;
        }
        try {
            if (target.exists()) {
                target.delete();
            }
            ZipOutputStream output = null;
            boolean isJar = target.getName().toLowerCase().endsWith(".jar");
            output = isJar ? (manifest != null ? new JarOutputStream((OutputStream)new FileOutputStream(target), manifest) : new JarOutputStream(new FileOutputStream(target))) : new ZipOutputStream(new FileOutputStream(target));
            String baseDir = sources.get(0).getParentFile().getAbsolutePath().replace('\\', '/');
            if (!baseDir.endsWith("/")) {
                baseDir = String.valueOf(baseDir) + "/";
            }
            int baseDirLength = baseDir.length();
            ArrayList<File> list = new ArrayList<File>();
            for (File fileOrDir : sources) {
                if (isJar && manifest != null && fileOrDir.getName().equals("META-INF")) continue;
                if (fileOrDir.isDirectory()) {
                    list.addAll(JarTool.getContents(fileOrDir));
                    continue;
                }
                list.add(fileOrDir);
            }
            byte[] buffer = new byte[1024];
            int i = 0;
            int n = list.size();
            while (i < n) {
                int bytesRead;
                File file = (File)list.get(i);
                FileInputStream f_in = new FileInputStream(file);
                String filename = file.getAbsolutePath().replace('\\', '/');
                if (filename.startsWith(baseDir)) {
                    filename = filename.substring(baseDirLength);
                }
                if (isJar) {
                    output.putNextEntry(new JarEntry(filename));
                } else {
                    output.putNextEntry(new ZipEntry(filename));
                }
                while ((bytesRead = f_in.read(buffer)) != -1) {
                    output.write(buffer, 0, bytesRead);
                }
                f_in.close();
                output.closeEntry();
                ++i;
            }
            output.close();
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return false;
        }
        return true;
    }

    public static boolean remove(File directory) {
        if (directory.exists() && directory.isDirectory()) {
            return JarTool.recursiveClearDirectory(directory, FileSystemView.getFileSystemView());
        }
        return false;
    }

    public static Collection<File> getContents(File directory) {
        if (directory.exists() && directory.isDirectory()) {
            return JarTool.recursiveGetDirectory(directory, FileSystemView.getFileSystemView());
        }
        return new HashSet<File>();
    }

    public static boolean unzip(File source, File targetDirectory) {
        return JarTool.unzipWithWarning(source, targetDirectory, new OverwriteValue(2));
    }

    public static boolean unzipNoOverwrite(File source, File targetDirectory) {
        return JarTool.unzipWithWarning(source, targetDirectory, new OverwriteValue(3));
    }

    public static boolean unzipWithAWarning(File source, File targetDirectory) {
        return JarTool.unzipWithWarning(source, targetDirectory, new OverwriteValue(1));
    }

    public static int confirmOverwrite(String filename) {
        return JarTool.confirmOverwrite(filename, false);
    }

    public static int confirmOverwrite(String filename, boolean canCancel) {
        final JDialog dialog = new JDialog();
        final OverwriteValue returnValue = new OverwriteValue(1);
        MouseAdapter mouseListener = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                AbstractButton button = (AbstractButton)evt.getSource();
                String aCmd = button.getActionCommand();
                if (aCmd.equals("yes")) {
                    returnValue.value = 0;
                } else if (aCmd.equals("no")) {
                    returnValue.value = 1;
                } else if (aCmd.equals("yesToAll")) {
                    returnValue.value = 2;
                } else if (aCmd.equals("noToAll")) {
                    returnValue.value = 3;
                } else if (aCmd.equals("cancel")) {
                    returnValue.value = 4;
                }
                dialog.setVisible(false);
            }
        };
        JButton yesButton = new JButton(res.getString("JarTool.Yes"));
        yesButton.setActionCommand("yes");
        yesButton.addMouseListener(mouseListener);
        JButton noButton = new JButton(res.getString("JarTool.No"));
        noButton.setActionCommand("no");
        noButton.addMouseListener(mouseListener);
        JButton yesToAllButton = new JButton(res.getString("JarTool.YesToAll"));
        yesToAllButton.setActionCommand("yesToAll");
        yesToAllButton.addMouseListener(mouseListener);
        JButton noToAllButton = new JButton(res.getString("JarTool.NoToAll"));
        noToAllButton.setActionCommand("noToAll");
        noToAllButton.addMouseListener(mouseListener);
        JButton cancelButton = new JButton(res.getString("JarTreeDialog.Button.Cancel"));
        cancelButton.setActionCommand("cancel");
        cancelButton.addMouseListener(mouseListener);
        JPanel buttonPanel = new JPanel(new FlowLayout(1));
        buttonPanel.add(yesButton);
        buttonPanel.add(yesToAllButton);
        buttonPanel.add(noButton);
        buttonPanel.add(noToAllButton);
        if (canCancel) {
            buttonPanel.add(cancelButton);
        }
        JLabel label = new JLabel(String.valueOf(DisplayRes.getString("DrawingFrame.ReplaceExisting_message")) + " " + filename + DisplayRes.getString("DrawingFrame.QuestionMark"));
        label.setHorizontalAlignment(0);
        label.setBorder(new EmptyBorder(10, 10, 10, 10));
        dialog.setTitle(DisplayRes.getString("DrawingFrame.ReplaceFile_option_title"));
        dialog.getContentPane().setLayout(new BorderLayout(5, 0));
        dialog.getContentPane().add((Component)label, "Center");
        dialog.getContentPane().add((Component)buttonPanel, "South");
        dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                returnValue.value = 1;
            }
        });
        dialog.validate();
        dialog.pack();
        dialog.setLocationRelativeTo(null);
        dialog.setModal(true);
        dialog.setVisible(true);
        return returnValue.value;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean unzipWithWarning(File source, File targetDirectory, OverwriteValue policy) {
        try {
            if (!source.exists()) {
                return false;
            }
            input = new ZipInputStream(new FileInputStream(source));
            zipEntry = null;
            buffer = new byte[1024];
            block9: while (true) lbl-1000:
            // 5 sources

            {
                if ((zipEntry = input.getNextEntry()) == null) {
                    input.close();
                    return true;
                }
                if (zipEntry.isDirectory()) continue;
                newFile = new File(targetDirectory, zipEntry.getName());
                if (newFile.exists()) {
                    switch (policy.value) {
                        case 3: {
                            continue block9;
                        }
                        case 2: {
                            break;
                        }
                        default: {
                            policy.value = JarTool.confirmOverwrite(zipEntry.getName());
                            switch (policy.value) {
                                case 1: 
                                case 3: {
                                    ** break;
                                }
                            }
                        }
                    }
                }
                newFile.getParentFile().mkdirs();
                output = new FileOutputStream(newFile);
                while (true) {
                    if ((bytesRead = input.read(buffer)) == -1) {
                        output.close();
                        input.closeEntry();
                        continue block9;
                    }
                    output.write(buffer, 0, bytesRead);
                }
                break;
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return false;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<File> unzipWithWarning(InputStream zipStream, File targetDirectory, JLabel label, String prefix) {
        try {
            policy = new OverwriteValue(1);
            bufIn = new BufferedInputStream(zipStream);
            input = new ZipInputStream(bufIn);
            zipEntry = null;
            fileSet = new ArrayList<File>();
            buffer = new byte[1024];
            block10: while (true) lbl-1000:
            // 5 sources

            {
                if ((zipEntry = input.getNextEntry()) == null) {
                    input.close();
                    return fileSet;
                }
                if (zipEntry.isDirectory()) continue;
                if (label != null) {
                    label.setText(String.valueOf(prefix) + zipEntry.getName());
                }
                if ((newFile = new File(targetDirectory, zipEntry.getName())).exists()) {
                    switch (policy.value) {
                        case 3: {
                            continue block10;
                        }
                        case 2: {
                            break;
                        }
                        default: {
                            policy.value = JarTool.confirmOverwrite(zipEntry.getName(), true);
                            switch (policy.value) {
                                case 1: 
                                case 3: {
                                    ** break;
                                }
                                case 4: {
                                    return null;
                                }
                            }
                        }
                    }
                }
                newFile.getParentFile().mkdirs();
                output = new FileOutputStream(newFile);
                while (true) {
                    if ((bytesRead = input.read(buffer)) == -1) {
                        output.close();
                        input.closeEntry();
                        fileSet.add(newFile);
                        continue block10;
                    }
                    output.write(buffer, 0, bytesRead);
                }
                break;
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return null;
        }
    }

    private static File compressList(ArrayList<String> sources, File parent, File target, Manifest manifest, OverwriteValue policy, Frame owner) {
        File temporaryDirectory = null;
        try {
            temporaryDirectory = File.createTempFile("JarTool", ".tmp", target.getParentFile());
            temporaryDirectory.delete();
        }
        catch (Exception exc) {
            temporaryDirectory = null;
        }
        if (temporaryDirectory == null || !temporaryDirectory.mkdirs()) {
            String[] message = new String[]{res.getString("JarTool.JarNotCreated"), res.getString("JarTool.CantCreateTemp")};
            JOptionPane.showMessageDialog(null, message, res.getString("JarTool.Error"), 2);
            return null;
        }
        StringBuffer errorMessage = new StringBuffer();
        int steps = sources.size();
        int interval = 1;
        int counter = 0;
        if (steps > 10) {
            interval = Math.round((float)steps / 10.0f);
            steps = 10;
        }
        ProgressDialog pD = new ProgressDialog(owner, steps + 2, "JarTool", new Dimension(350, 150));
        String pdMessage = res.getString("JarTool.ProcessingFile");
        Iterator<String> it = sources.iterator();
        while (it.hasNext()) {
            if (counter % interval == 0) {
                pD.reportProgress(pdMessage);
            }
            ++counter;
            String filename = it.next().toString();
            if (filename == null) continue;
            errorMessage.append(JarTool.processFile(filename, new File(parent, filename), temporaryDirectory, policy));
        }
        boolean success = false;
        String error = errorMessage.toString().trim();
        if (error.length() > 0) {
            String[] message = new String[]{res.getString("JarTool.JarNotCreated"), error};
            JOptionPane.showMessageDialog(null, message, res.getString("JarTool.Error"), 2);
        } else {
            pD.reportProgress(res.getString("JarTool.CompressingFile"));
            if (JarTool.compress(temporaryDirectory, target, manifest)) {
                success = true;
            } else {
                String[] message = new String[]{res.getString("JarTool.JarNotCreated"), String.valueOf(res.getString("JarTool.CantCompress")) + " " + target.getAbsolutePath()};
                JOptionPane.showMessageDialog(null, message, res.getString("JarTool.Error"), 2);
            }
        }
        pD.reportProgress(res.getString("JarTool.CleaningTempFile"));
        JarTool.remove(temporaryDirectory);
        pD.dispose();
        if (success) {
            return target;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private static StringBuffer processFile(String filename, File file, File targetDirectory, OverwriteValue policy) {
        if (!file.exists() && filename.indexOf("!") == -1) {
            return new StringBuffer(String.valueOf(JarTool.res.getString("JarTool.FileDoesntExist")) + " " + file.getAbsolutePath() + ".\n");
        }
        if (file.isDirectory()) {
            errorMessage = new StringBuffer();
            fsView = FileSystemView.getFileSystemView();
            filesInDir = fsView.getFiles(file, false);
            i = 0;
            n = filesInDir.length;
            while (i < n) {
                errorMessage.append(JarTool.processFile(String.valueOf(filename) + "/" + filesInDir[i].getName(), filesInDir[i], targetDirectory, policy));
                ++i;
            }
            return errorMessage;
        }
        filenameLowerCase = file.getName().toLowerCase();
        if (filenameLowerCase.endsWith(".jar") || filenameLowerCase.endsWith(".zip") || filenameLowerCase.endsWith(".trz")) {
            if (JarTool.unzipWithWarning(file, targetDirectory, policy)) {
                return new StringBuffer();
            }
            return new StringBuffer(String.valueOf(JarTool.res.getString("JarTool.CantUncompress")) + " " + file.getAbsolutePath() + ".\n");
        }
        n = filename.indexOf("!");
        if (n <= -1) ** GOTO lbl29
        entry = filename.substring(n + 2);
        filepath = file.getAbsolutePath();
        zipFile = new File(filepath.substring(0, filepath.indexOf("!")));
        if (JarTool.extract(zipFile, entry, target = new File(targetDirectory, entry)) != null) {
            return new StringBuffer();
        }
        return new StringBuffer(String.valueOf(JarTool.res.getString("JarTool.CantCopy")) + " " + filename + " --> " + targetDirectory.getName() + ".\n");
lbl-1000:
        // 1 sources

        {
            filename = filename.substring(3);
lbl29:
            // 2 sources

            ** while (filename.startsWith((String)"../"))
        }
lbl30:
        // 1 sources

        target = new File(targetDirectory, filename);
        if (target.exists()) {
            switch (policy.value) {
                case 3: {
                    return new StringBuffer();
                }
                case 2: {
                    break;
                }
                default: {
                    policy.value = JarTool.confirmOverwrite(filename);
                    switch (policy.value) {
                        case 1: 
                        case 3: {
                            return new StringBuffer();
                        }
                    }
                }
            }
        }
        if (JarTool.copy(file, target)) {
            return new StringBuffer();
        }
        return new StringBuffer(String.valueOf(JarTool.res.getString("JarTool.CantCopy")) + " " + filename + " --> " + targetDirectory.getName() + ".\n");
    }

    private static boolean recursiveClearDirectory(File directory, FileSystemView fsView) {
        File[] files = fsView.getFiles(directory, false);
        int i = 0;
        while (i < files.length) {
            if (files[i].isDirectory() ? !JarTool.recursiveClearDirectory(files[i], fsView) : !files[i].delete()) {
                return false;
            }
            ++i;
        }
        return directory.delete();
    }

    private static Collection<File> recursiveGetDirectory(File directory, FileSystemView fsView) {
        File[] files = fsView.getFiles(directory, false);
        ArrayList<File> list = new ArrayList<File>();
        int i = 0;
        while (i < files.length) {
            if (files[i].isDirectory()) {
                list.addAll(JarTool.recursiveGetDirectory(files[i], fsView));
            } else {
                list.add(files[i]);
            }
            ++i;
        }
        return list;
    }

    private static class OverwriteValue {
        int value = 1;

        OverwriteValue(int val) {
            this.value = val;
        }
    }

    private static class ProgressDialog
    extends JDialog {
        private int totalSteps;
        private int currentStep = 0;
        private JLabel progressLabel = null;
        private JProgressBar progressBar = null;

        public ProgressDialog(Frame _owner, int _steps, String _title, Dimension _size) {
            super(_owner);
            this.totalSteps = _steps;
            this.setTitle(_title);
            this.setSize(_size);
            this.setModal(false);
            this.getContentPane().setLayout(new BorderLayout());
            JPanel progressPanel = new JPanel(){

                @Override
                public Insets getInsets() {
                    return new Insets(15, 10, 5, 10);
                }
            };
            progressPanel.setLayout(new BoxLayout(progressPanel, 1));
            this.getContentPane().add((Component)progressPanel, "Center");
            Dimension d = new Dimension(_size.width, 20);
            this.progressLabel = new JLabel(_title);
            this.progressLabel.setAlignmentX(0.5f);
            this.progressLabel.setMaximumSize(d);
            this.progressLabel.setPreferredSize(d);
            progressPanel.add(this.progressLabel);
            progressPanel.add(Box.createRigidArea(new Dimension(1, 20)));
            this.progressBar = new JProgressBar(0, this.totalSteps);
            this.progressBar.setStringPainted(true);
            this.progressLabel.setLabelFor(this.progressBar);
            this.progressBar.setAlignmentX(0.5f);
            progressPanel.add(this.progressBar);
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            this.setLocation((screenSize.width - _size.width) / 2, (screenSize.height - _size.width) / 2);
            this.getContentPane().add((Component)progressPanel, "Center");
            this.setCursor(new Cursor(3));
            this.setVisible(true);
        }

        public void reportProgress(String _process) {
            ++this.currentStep;
            this.progressBar.setValue(this.currentStep);
            this.progressLabel.setText(_process);
        }
    }
}

