/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics;

import org.opensourcephysics.numerics.InvertibleFunction;
import org.opensourcephysics.numerics.Util;

public final class LogBase10Function
implements InvertibleFunction {
    @Override
    public final double evaluate(double x) {
        if (x <= 0.0) {
            x = 1.4E-45f;
        }
        return Math.log(x) / Util.LOG10;
    }

    @Override
    public final double getInverse(double y) {
        return Math.pow(10.0, y);
    }
}

