/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.core;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.NumberFormat;
import java.util.Hashtable;
import java.util.TreeMap;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MouseInputAdapter;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.media.core.ClipControl;
import org.opensourcephysics.media.core.ClipInspector;
import org.opensourcephysics.media.core.MediaRes;
import org.opensourcephysics.media.core.Video;
import org.opensourcephysics.media.core.VideoClip;
import org.opensourcephysics.media.core.VideoPanel;
import org.opensourcephysics.tools.FontSizer;
import org.opensourcephysics.tools.ResourceLoader;

public class VideoPlayer
extends JComponent
implements PropertyChangeListener {
    protected static Icon inOutIcon;
    protected static Icon playIcon;
    protected static Icon grayPlayIcon;
    protected static Icon pauseIcon;
    protected static Icon resetIcon;
    protected static Icon loopIcon;
    protected static Icon noloopIcon;
    protected static Icon videoClipIcon;
    protected static Icon stepIcon;
    protected static Icon grayStepIcon;
    protected static Icon backIcon;
    protected static Icon grayBackIcon;
    protected VideoPanel vidPanel;
    protected ClipControl clipControl;
    private String[] readoutTypes;
    private String readoutType;
    private boolean inspectorButtonVisible = true;
    protected int height = 54;
    private JToolBar toolbar;
    protected JButton readout;
    private JButton playButton;
    private JButton resetButton;
    private JSpinner rateSpinner;
    private JButton stepButton;
    private JButton stepSizeButton;
    private JButton backButton;
    private JButton loopButton;
    private JButton inspectorButton;
    private JSlider slider;
    private Hashtable<Integer, JLabel> sliderLabels;
    private JLabel inLabel;
    private JLabel outLabel;
    private NumberFormat timeFormat = NumberFormat.getNumberInstance();
    private ActionListener readoutListener;
    private ActionListener timeSetListener;
    private String active;
    private boolean disabled = false;

    static {
        String path = "/org/opensourcephysics/resources/media/images/in_out.gif";
        inOutIcon = ResourceLoader.getIcon(path);
        path = "/org/opensourcephysics/resources/media/images/play.gif";
        playIcon = ResourceLoader.getIcon(path);
        path = "/org/opensourcephysics/resources/media/images/play_gray.gif";
        grayPlayIcon = ResourceLoader.getIcon(path);
        path = "/org/opensourcephysics/resources/media/images/pause.gif";
        pauseIcon = ResourceLoader.getIcon(path);
        path = "/org/opensourcephysics/resources/media/images/reset.gif";
        resetIcon = ResourceLoader.getIcon(path);
        path = "/org/opensourcephysics/resources/media/images/looping_on.gif";
        loopIcon = ResourceLoader.getIcon(path);
        path = "/org/opensourcephysics/resources/media/images/looping_off.gif";
        noloopIcon = ResourceLoader.getIcon(path);
        path = "/org/opensourcephysics/resources/media/images/video_clip.gif";
        videoClipIcon = ResourceLoader.getIcon(path);
        path = "/org/opensourcephysics/resources/media/images/step.gif";
        stepIcon = ResourceLoader.getIcon(path);
        path = "/org/opensourcephysics/resources/media/images/step_gray.gif";
        grayStepIcon = ResourceLoader.getIcon(path);
        path = "/org/opensourcephysics/resources/media/images/back.gif";
        backIcon = ResourceLoader.getIcon(path);
        path = "/org/opensourcephysics/resources/media/images/back_gray.gif";
        grayBackIcon = ResourceLoader.getIcon(path);
    }

    public VideoPlayer(VideoPanel panel, VideoClip clip) {
        this(panel);
        this.setVideoClip(clip);
    }

    public VideoPlayer(VideoPanel panel) {
        this.vidPanel = panel;
        this.vidPanel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                if (VideoPlayer.this.vidPanel.isPlayerVisible()) {
                    VideoPlayer.this.setBounds();
                    VideoPlayer.this.vidPanel.repaint();
                }
            }
        });
        this.createGUI();
        this.timeFormat.setMinimumIntegerDigits(1);
        this.timeFormat.setMaximumFractionDigits(3);
        this.timeFormat.setMinimumFractionDigits(3);
        this.clipControl = ClipControl.getControl(new VideoClip(null));
        this.clipControl.addPropertyChangeListener(this);
        this.getVideoClip().addPropertyChangeListener(this);
        this.updatePlayButtons(false);
        this.updateSlider();
        this.setReadoutTypes("frame time step", "frame");
        this.refresh();
    }

    public void setVideoClip(VideoClip clip) {
        boolean playing = this.clipControl.isPlaying();
        this.stop();
        if (this.getVideoClip() == clip) {
            ClipInspector inspector;
            boolean looping = this.clipControl.isLooping();
            double rate = this.clipControl.getRate();
            double duration = this.clipControl.getMeanFrameDuration();
            this.clipControl.removePropertyChangeListener(this);
            this.clipControl.dispose();
            this.clipControl = ClipControl.getControl(clip);
            this.clipControl.addPropertyChangeListener(this);
            this.clipControl.setLooping(looping);
            this.clipControl.setRate(rate);
            this.clipControl.setFrameDuration(duration);
            if (playing) {
                this.clipControl.play();
            }
            if ((inspector = this.getVideoClip().inspector) != null) {
                inspector.clipControl = this.clipControl;
            }
        } else {
            VideoClip oldClip = this.getVideoClip();
            oldClip.removePropertyChangeListener(this);
            oldClip.hideClipInspector();
            Video video2 = oldClip.getVideo();
            if (video2 != null) {
                video2.dispose();
            }
            oldClip.video = null;
            if (clip == null) {
                clip = new VideoClip(null);
            }
            clip.addPropertyChangeListener(this);
            this.clipControl.removePropertyChangeListener(this);
            this.clipControl.dispose();
            this.clipControl = ClipControl.getControl(clip);
            this.clipControl.addPropertyChangeListener(this);
            this.setReadoutTypes("frame time step", clip.readoutType);
            this.updatePlayButtons(this.clipControl.isPlaying());
            this.updateLoopButton(this.clipControl.isLooping());
            this.updateReadout();
            this.updateSlider();
            this.firePropertyChange("videoclip", oldClip, clip);
            System.gc();
        }
    }

    public VideoClip getVideoClip() {
        return this.clipControl.getVideoClip();
    }

    public ClipControl getClipControl() {
        return this.clipControl;
    }

    public void setReadoutTypes(String types, String typeToSelect) {
        TreeMap<Integer, String> map = new TreeMap<Integer, String>();
        String list = types.toLowerCase();
        int i = list.indexOf("time");
        if (i >= 0) {
            map.put(new Integer(i), "time");
        }
        if ((i = list.indexOf("step")) >= 0) {
            map.put(new Integer(i), "step");
        }
        if ((i = list.indexOf("frame")) >= 0) {
            map.put(new Integer(i), "frame");
        }
        if (map.isEmpty()) {
            return;
        }
        this.readoutTypes = map.values().toArray(new String[0]);
        if (typeToSelect == null) {
            typeToSelect = this.readoutTypes[0];
        }
        this.setReadoutType(typeToSelect);
    }

    public void setReadoutType(String type) {
        String name = type.toLowerCase();
        String tip = " " + MediaRes.getString("VideoPlayer.Readout.ToolTip");
        if (name.indexOf("time") >= 0) {
            this.readoutType = "time";
            this.readout.setToolTipText(String.valueOf(MediaRes.getString("VideoPlayer.Readout.ToolTip.Time")) + tip);
        } else if (name.indexOf("step") >= 0) {
            this.readoutType = "step";
            this.readout.setToolTipText(String.valueOf(MediaRes.getString("VideoPlayer.Readout.ToolTip.Step")) + tip);
        } else if (name.indexOf("frame") >= 0) {
            this.readoutType = "frame";
            this.readout.setToolTipText(String.valueOf(MediaRes.getString("VideoPlayer.Readout.ToolTip.Frame")) + tip);
        }
        boolean isListed = false;
        int i = 0;
        while (i < this.readoutTypes.length) {
            isListed = isListed || this.readoutTypes[i].equals(this.readoutType);
            ++i;
        }
        if (!isListed) {
            String[] newList = new String[this.readoutTypes.length + 1];
            newList[0] = this.readoutType;
            int i2 = 0;
            while (i2 < this.readoutTypes.length) {
                newList[i2 + 1] = this.readoutTypes[i2];
                ++i2;
            }
            this.readoutTypes = newList;
        }
        this.getVideoClip().readoutType = this.readoutType;
        this.updateReadout();
    }

    public void play() {
        this.clipControl.play();
    }

    public void stop() {
        this.clipControl.stop();
    }

    public void step() {
        this.stop();
        this.clipControl.step();
    }

    public void back() {
        this.stop();
        this.clipControl.back();
    }

    public void setRate(double rate) {
        this.clipControl.setRate(rate);
    }

    public double getRate() {
        return this.clipControl.getRate();
    }

    public void setLooping(boolean looping) {
        this.clipControl.setLooping(looping);
    }

    public boolean isLooping() {
        return this.clipControl.isLooping();
    }

    public void setStepNumber(int n) {
        this.clipControl.setStepNumber(n);
    }

    public int getStepNumber() {
        return this.clipControl.getStepNumber();
    }

    public int getFrameNumber() {
        return this.clipControl.getFrameNumber();
    }

    public double getTime() {
        return this.clipControl.getTime() + this.clipControl.clip.getStartTime();
    }

    public double getStepTime(int stepNumber) {
        if (stepNumber < 0 || stepNumber >= this.clipControl.clip.getStepCount()) {
            return Double.NaN;
        }
        return this.clipControl.getStepTime(stepNumber) + this.clipControl.clip.getStartTime();
    }

    public double getFrameTime(int frameNumber) {
        return this.clipControl.clip.getStartTime() + (double)(frameNumber - this.clipControl.clip.getStartFrameNumber()) * this.clipControl.getMeanFrameDuration();
    }

    public double getMeanStepDuration() {
        double duration = this.getClipControl().getMeanFrameDuration() * (double)this.getVideoClip().getStepSize();
        return duration;
    }

    public void setInspectorButtonVisible(final boolean visible) {
        if (visible == this.inspectorButtonVisible) {
            return;
        }
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                VideoPlayer.this.inspectorButtonVisible = visible;
                if (visible) {
                    VideoPlayer.this.toolbar.add(VideoPlayer.this.inspectorButton);
                } else {
                    VideoPlayer.this.toolbar.remove(VideoPlayer.this.inspectorButton);
                }
                VideoPlayer.this.toolbar.revalidate();
            }
        };
        EventQueue.invokeLater(runner);
    }

    public void setLoopingButtonVisible(final boolean visible) {
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                if (visible) {
                    VideoPlayer.this.toolbar.add(VideoPlayer.this.loopButton);
                } else {
                    VideoPlayer.this.toolbar.remove(VideoPlayer.this.loopButton);
                }
                VideoPlayer.this.toolbar.revalidate();
            }
        };
        EventQueue.invokeLater(runner);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String name = e.getPropertyName();
        if (name.equals("stepnumber")) {
            this.updateReadout();
            this.updatePlayButtons(this.clipControl.isPlaying());
            this.firePropertyChange("stepnumber", null, e.getNewValue());
        } else if (name.equals("frameduration")) {
            this.updateReadout();
            this.firePropertyChange("frameduration", null, e.getNewValue());
        } else if (name.equals("playing")) {
            boolean playing = (Boolean)e.getNewValue();
            this.updatePlayButtons(playing);
            this.firePropertyChange("playing", null, e.getNewValue());
        } else if (name.equals("looping")) {
            boolean looping = (Boolean)e.getNewValue();
            this.updateLoopButton(looping);
        } else if (name.equals("rate")) {
            this.rateSpinner.setValue(new Double(this.getRate()));
        } else if (name.equals("stepcount")) {
            this.updatePlayButtons(this.clipControl.isPlaying());
            this.updateReadout();
            this.updateSlider();
        } else if (name.equals("framecount")) {
            this.updateSlider();
        } else if (name.equals("stepsize")) {
            this.updateReadout();
            this.updateSlider();
        } else if (name.equals("startframe")) {
            this.updateReadout();
            this.updateSlider();
        } else if (name.equals("starttime")) {
            this.updateReadout();
        }
    }

    public void refresh() {
        this.stepButton.setToolTipText(MediaRes.getString("VideoPlayer.Button.StepForward.ToolTip"));
        this.backButton.setToolTipText(MediaRes.getString("VideoPlayer.Button.StepBack.ToolTip"));
        this.resetButton.setToolTipText(MediaRes.getString("VideoPlayer.Button.Reset.ToolTip"));
        this.inspectorButton.setToolTipText(MediaRes.getString("VideoPlayer.Button.ClipSettings.ToolTip"));
        this.loopButton.setToolTipText(MediaRes.getString("VideoPlayer.Button.Looping.ToolTip"));
        this.setReadoutType(this.readoutType);
        this.updatePlayButtons(this.clipControl.isPlaying());
        this.updateLoopButton(this.clipControl.isLooping());
        if (this.getVideoClip().inspector != null) {
            this.getVideoClip().inspector.refresh();
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.disabled = !enabled;
    }

    private void setBounds() {
        this.toolbar.revalidate();
        this.height = this.playButton.getPreferredSize().height + 8;
        int y = this.vidPanel.getHeight() - this.height;
        int w = this.vidPanel.getWidth();
        this.setBounds(0, y, w, this.height);
        this.toolbar.revalidate();
    }

    private void createGUI() {
        this.setLayout(new BorderLayout());
        this.toolbar = new JToolBar();
        this.toolbar.setFloatable(false);
        this.add((Component)this.toolbar, "South");
        this.setBorder(BorderFactory.createEtchedBorder());
        this.playButton = new PlayerButton(playIcon, pauseIcon);
        this.playButton.setDisabledIcon(grayPlayIcon);
        this.playButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (VideoPlayer.this.disabled || !VideoPlayer.this.playButton.isEnabled()) {
                    return;
                }
                if (VideoPlayer.this.playButton.isSelected()) {
                    VideoPlayer.this.stop();
                } else {
                    VideoPlayer.this.play();
                }
            }
        });
        this.playButton.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (VideoPlayer.this.disabled || !VideoPlayer.this.playButton.isEnabled()) {
                    return;
                }
                if (e.getKeyCode() == 32) {
                    if (VideoPlayer.this.playButton.isSelected()) {
                        VideoPlayer.this.stop();
                    } else {
                        VideoPlayer.this.play();
                    }
                }
            }
        });
        this.resetButton = new PlayerButton(resetIcon);
        this.resetButton.setPressedIcon(resetIcon);
        this.resetButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (VideoPlayer.this.disabled) {
                    return;
                }
                VideoPlayer.this.stop();
                VideoPlayer.this.clipControl.setStepNumber(0);
                VideoPlayer.this.updatePlayButtons(false);
            }
        });
        double minRate = 0.01;
        double maxRate = 10.0;
        final SpinnerNumberModel model = new SpinnerNumberModel(1.0, 0.01, 10.0, 0.1);
        this.rateSpinner = new JSpinner(model){

            @Override
            public Dimension getPreferredSize() {
                return this.getMinimumSize();
            }

            @Override
            public Dimension getMinimumSize() {
                Dimension dim = super.getMinimumSize();
                dim.height = Math.max(((VideoPlayer)VideoPlayer.this).playButton.getPreferredSize().height, dim.height);
                dim.width = 5 * this.getFont().getSize() - 10 * FontSizer.getLevel();
                return dim;
            }

            @Override
            public Dimension getMaximumSize() {
                return this.getMinimumSize();
            }
        };
        final JSpinner.NumberEditor editor = new JSpinner.NumberEditor(this.rateSpinner, "0%");
        editor.getTextField().setHorizontalAlignment(2);
        editor.getTextField().setFont(new Font("Dialog", 0, 12));
        this.rateSpinner.setEditor(editor);
        this.rateSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Double rate = (Double)VideoPlayer.this.rateSpinner.getValue();
                VideoPlayer.this.setRate(rate);
                model.setStepSize(rate >= 2.0 ? 0.5 : (rate >= 0.2 ? 0.1 : 0.01));
            }
        });
        editor.getTextField().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    double prev = (Double)VideoPlayer.this.rateSpinner.getValue();
                    try {
                        String s = editor.getTextField().getText();
                        if (s.endsWith("%")) {
                            s = s.substring(0, s.length() - 1);
                        }
                        int i = Integer.parseInt(s);
                        double rate = Math.max((double)i / 100.0, 0.01);
                        if ((rate = Math.min(rate, 10.0)) != prev) {
                            VideoPlayer.this.rateSpinner.setValue(new Double(rate));
                        } else {
                            int r = (int)(prev * 100.0);
                            editor.getTextField().setText(String.valueOf(String.valueOf(r)) + "%");
                        }
                    }
                    catch (NumberFormatException ex) {
                        int r = (int)(prev * 100.0);
                        editor.getTextField().setText(String.valueOf(String.valueOf(r)) + "%");
                    }
                    editor.getTextField().selectAll();
                }
            }
        });
        this.stepButton = new PlayerButton(stepIcon);
        this.stepButton.setDisabledIcon(grayStepIcon);
        this.stepButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (VideoPlayer.this.disabled) {
                    return;
                }
                if ((e.getModifiers() & 1) == 1) {
                    VideoPlayer.this.stop();
                    VideoPlayer.this.setStepNumber(VideoPlayer.this.getStepNumber() + 5);
                } else {
                    VideoPlayer.this.step();
                }
            }
        });
        this.backButton = new PlayerButton(backIcon);
        this.backButton.setDisabledIcon(grayBackIcon);
        this.backButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (VideoPlayer.this.disabled) {
                    return;
                }
                if ((e.getModifiers() & 1) == 1) {
                    VideoPlayer.this.stop();
                    VideoPlayer.this.setStepNumber(VideoPlayer.this.getStepNumber() - 5);
                } else {
                    VideoPlayer.this.back();
                }
            }
        });
        MouseAdapter stepListener = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (VideoPlayer.this.disabled) {
                    return;
                }
                if (e.getSource() == VideoPlayer.this.stepButton) {
                    VideoPlayer.this.firePropertyChange("stepbutton", null, new Boolean(true));
                } else {
                    VideoPlayer.this.firePropertyChange("backbutton", null, new Boolean(true));
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (VideoPlayer.this.disabled) {
                    return;
                }
                if (e.getSource() == VideoPlayer.this.stepButton) {
                    VideoPlayer.this.firePropertyChange("stepbutton", null, new Boolean(false));
                } else {
                    VideoPlayer.this.firePropertyChange("backbutton", null, new Boolean(false));
                }
            }
        };
        this.stepButton.addMouseListener(stepListener);
        this.backButton.addMouseListener(stepListener);
        this.readoutListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VideoPlayer.this.setReadoutType(e.getActionCommand());
            }
        };
        this.timeSetListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ClipInspector inspector;
                VideoClip clip = VideoPlayer.this.getVideoClip();
                Object response = JOptionPane.showInputDialog(VideoPlayer.this.vidPanel, MediaRes.getString("VideoPlayer.Dialog.SetTime.Message"), String.valueOf(MediaRes.getString("VideoPlayer.Dialog.SetTime.Title")) + " " + VideoPlayer.this.getFrameNumber(), -1, null, null, VideoPlayer.this.getTime() / 1000.0);
                if (response != null) {
                    if (response.equals("")) {
                        clip.setStartTime(Double.NaN);
                    } else {
                        try {
                            double t = Double.parseDouble(response.toString());
                            double t0 = t * 1000.0 - VideoPlayer.this.clipControl.getTime();
                            clip.setStartTime(t0);
                        }
                        catch (NumberFormatException t) {
                            // empty catch block
                        }
                    }
                }
                if ((inspector = clip.inspector) != null && inspector.isVisible()) {
                    inspector.t0Field.setValue(clip.getStartTime() / 1000.0);
                }
            }
        };
        this.slider = new JSlider(0, 0, 0);
        this.slider.setOpaque(false);
        this.slider.setMinorTickSpacing(1);
        this.slider.setSnapToTicks(true);
        this.slider.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        this.slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                VideoClip clip = VideoPlayer.this.getVideoClip();
                int i = VideoPlayer.this.slider.getValue();
                if (i < clip.getStartFrameNumber()) {
                    VideoPlayer.this.slider.setValue(clip.getStartFrameNumber());
                } else if (i > clip.getEndFrameNumber()) {
                    VideoPlayer.this.slider.setValue(clip.getEndFrameNumber());
                } else {
                    int n = clip.frameToStep(i);
                    if (n != VideoPlayer.this.getStepNumber() && !VideoPlayer.this.disabled) {
                        VideoPlayer.this.setStepNumber(n);
                    } else if (!clip.includesFrame(i)) {
                        VideoPlayer.this.slider.setValue(clip.stepToFrame(n));
                    }
                }
            }
        });
        this.inLabel = new JLabel(inOutIcon);
        this.outLabel = new JLabel(inOutIcon);
        this.sliderLabels = new Hashtable();
        this.sliderLabels.put(new Integer(0), this.inLabel);
        this.sliderLabels.put(new Integer(9), this.outLabel);
        this.slider.setLabelTable(this.sliderLabels);
        this.slider.setPaintLabels(true);
        final MouseListener slideMouseListener = this.slider.getMouseListeners()[0];
        this.slider.removeMouseListener(slideMouseListener);
        final MouseMotionListener slideMouseMotionListener = this.slider.getMouseMotionListeners()[0];
        this.slider.removeMouseMotionListener(slideMouseMotionListener);
        MouseInputAdapter inOutSetter = new MouseInputAdapter(){
            float inset = 0.0f;
            int x;
            int maxEndFrame;

            @Override
            public void mousePressed(MouseEvent e) {
                if (VideoPlayer.this.disabled) {
                    return;
                }
                VideoPlayer.this.stop();
                this.maxEndFrame = VideoPlayer.this.getVideoClip().getEndFrameNumber();
                if (OSPRuntime.isPopupTrigger(e)) {
                    String s;
                    ActionListener listener = new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            VideoClip clip = VideoPlayer.this.getVideoClip();
                            int val = (this).VideoPlayer.this.clipControl.getFrameNumber();
                            if ("in".equals(e.getActionCommand())) {
                                clip.setStartFrameNumber(val, maxEndFrame);
                                if (clip.inspector != null && clip.inspector.isVisible()) {
                                    clip.inspector.startField.setValue(clip.getStartFrameNumber());
                                }
                            } else {
                                clip.setEndFrameNumber(val);
                                if (clip.inspector != null && clip.inspector.isVisible()) {
                                    clip.inspector.endField.setValue(clip.getEndFrameNumber());
                                }
                            }
                            VideoPlayer.this.refresh();
                        }
                    };
                    JPopupMenu popup = new JPopupMenu();
                    JMenuItem item = new JMenuItem(String.valueOf(MediaRes.getString("ClipInspector.Title")) + "...");
                    item.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            ClipInspector inspector;
                            if (VideoPlayer.this.disabled) {
                                return;
                            }
                            Frame frame = null;
                            Container c = (this).VideoPlayer.this.vidPanel.getTopLevelAncestor();
                            if (c instanceof Frame) {
                                frame = (Frame)c;
                            }
                            if ((inspector = VideoPlayer.this.getVideoClip().getClipInspector((this).VideoPlayer.this.clipControl, frame)).isVisible()) {
                                return;
                            }
                            Point p0 = new Frame().getLocation();
                            Point loc = inspector.getLocation();
                            if (loc.x == p0.x && loc.y == p0.y) {
                                Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
                                int x = (dim.width - inspector.getBounds().width) / 2;
                                int y = (dim.height - inspector.getBounds().height) / 2;
                                inspector.setLocation(x, y);
                            }
                            inspector.initialize();
                            inspector.setVisible(true);
                        }
                    });
                    popup.add(item);
                    popup.addSeparator();
                    int frameNum = VideoPlayer.this.clipControl.getFrameNumber();
                    if (VideoPlayer.this.active == null || VideoPlayer.this.active.equals("in")) {
                        s = MediaRes.getString("VideoPlayer.Slider.Popup.Menu.SetIn");
                        s = String.valueOf(s) + " (" + frameNum + ")";
                        item = new JMenuItem(s);
                        item.setActionCommand("in");
                        item.addActionListener(listener);
                        popup.add(item);
                    }
                    if (VideoPlayer.this.active == null || VideoPlayer.this.active.equals("out")) {
                        s = MediaRes.getString("VideoPlayer.Slider.Popup.Menu.SetOut");
                        s = String.valueOf(s) + " (" + frameNum + ")";
                        item = new JMenuItem(s);
                        item.setActionCommand("out");
                        item.addActionListener(listener);
                        popup.add(item);
                    }
                    VideoPlayer.this.active = null;
                    boolean includeTimeItems = false;
                    String[] stringArray = VideoPlayer.this.readoutTypes;
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String type = stringArray[n2];
                        if (type.equals("time")) {
                            includeTimeItems = true;
                        }
                        ++n2;
                    }
                    if (includeTimeItems) {
                        popup.addSeparator();
                        if (VideoPlayer.this.getTime() != 0.0) {
                            String s2 = MediaRes.getString("VideoPlayer.Popup.Menu.SetTimeToZero");
                            item = new JMenuItem(s2);
                            item.addActionListener(new ActionListener(){

                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    if (VideoPlayer.this.disabled) {
                                        return;
                                    }
                                    double t0 = -(this).VideoPlayer.this.clipControl.getTime();
                                    VideoPlayer.this.getVideoClip().setStartTime(t0);
                                }
                            });
                            item.addActionListener(VideoPlayer.this.readoutListener);
                            popup.add(item);
                        }
                        item = new JMenuItem(MediaRes.getString("VideoPlayer.Readout.Menu.SetTime"));
                        item.setActionCommand("time");
                        item.addActionListener(VideoPlayer.this.timeSetListener);
                        item.addActionListener(VideoPlayer.this.readoutListener);
                        popup.add(item);
                    }
                    popup.show(VideoPlayer.this.slider, e.getX(), e.getY());
                } else if (VideoPlayer.this.active == null) {
                    slideMouseListener.mousePressed(e);
                } else {
                    VideoPlayer.this.stop();
                    this.x = e.getX();
                    if (VideoPlayer.this.active == "in") {
                        int start = VideoPlayer.this.getVideoClip().getStartFrameNumber();
                        VideoPlayer.this.vidPanel.setMessage(String.valueOf(MediaRes.getString("VideoPlayer.InMarker.ToolTip")) + ": " + start);
                    } else if (VideoPlayer.this.active == "out") {
                        int end = VideoPlayer.this.getVideoClip().getEndFrameNumber();
                        VideoPlayer.this.vidPanel.setMessage(String.valueOf(MediaRes.getString("VideoPlayer.OutMarker.ToolTip")) + ": " + end);
                    }
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (VideoPlayer.this.disabled) {
                    return;
                }
                VideoClip clip = VideoPlayer.this.getVideoClip();
                if (VideoPlayer.this.active == null) {
                    slideMouseListener.mouseReleased(e);
                } else {
                    clip.trimFrameCount();
                    VideoPlayer.this.vidPanel.setMessage(null);
                }
                clip.setAdjusting(false);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                VideoPlayer.this.vidPanel.setMouseCursor(Cursor.getDefaultCursor());
                if (VideoPlayer.this.disabled) {
                    return;
                }
                slideMouseListener.mouseExited(e);
                VideoPlayer.this.firePropertyChange("slider", null, new Boolean(false));
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                VideoPlayer.this.active = null;
                if (VideoPlayer.this.disabled) {
                    return;
                }
                int yMin = VideoPlayer.this.slider.getHeight() - VideoPlayer.this.inLabel.getHeight() - 2;
                if (this.inset == 0.0f) {
                    this.inset = ((VideoPlayer)VideoPlayer.this).slider.getInsets().left + 7;
                }
                int offset = Math.min(0, VideoPlayer.this.getVideoClip().getFrameShift());
                if (e.getY() > yMin) {
                    VideoClip clip = VideoPlayer.this.getVideoClip();
                    double pixPerFrame = ((float)VideoPlayer.this.slider.getWidth() - 2.0f * this.inset) / (float)(clip.getFrameCount() - 1);
                    int start = VideoPlayer.this.getVideoClip().getStartFrameNumber();
                    int x = (int)((double)this.inset + (double)(start + offset) * pixPerFrame);
                    String hint = " " + MediaRes.getString("VideoPlayer.InOutMarker.ToolTip");
                    if (e.getX() < x + 8 && e.getX() > x - 8) {
                        VideoPlayer.this.active = "in";
                        VideoPlayer.this.slider.setToolTipText(String.valueOf(MediaRes.getString("VideoPlayer.InMarker.ToolTip")) + ": " + start + hint);
                    } else {
                        int end = VideoPlayer.this.getVideoClip().getEndFrameNumber();
                        x = (int)((double)this.inset + (double)(end + offset) * pixPerFrame);
                        if (e.getX() < x + 8 && e.getX() > x - 8) {
                            VideoPlayer.this.active = "out";
                            VideoPlayer.this.slider.setToolTipText(String.valueOf(MediaRes.getString("VideoPlayer.OutMarker.ToolTip")) + ": " + end + hint);
                        }
                    }
                }
                if (VideoPlayer.this.active == null) {
                    slideMouseMotionListener.mouseMoved(e);
                    VideoPlayer.this.vidPanel.setMouseCursor(Cursor.getDefaultCursor());
                    VideoPlayer.this.slider.setToolTipText(MediaRes.getString("VideoPlayer.Slider.ToolTip"));
                } else {
                    VideoPlayer.this.vidPanel.setMouseCursor(Cursor.getPredefinedCursor(12));
                }
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                if (VideoPlayer.this.disabled) {
                    return;
                }
                if (VideoPlayer.this.active == null) {
                    slideMouseMotionListener.mouseDragged(e);
                    return;
                }
                VideoClip clip = VideoPlayer.this.getVideoClip();
                clip.setAdjusting(true);
                boolean increasing = e.getX() > this.x;
                this.x = e.getX();
                int offset = Math.min(0, VideoPlayer.this.getVideoClip().getFrameShift());
                int val = Math.round((float)(clip.getFrameCount() - 1) * ((float)e.getX() - this.inset) / ((float)VideoPlayer.this.slider.getWidth() - 2.0f * this.inset));
                val = increasing ? Math.min(val, clip.getFrameCount() - 1 + VideoPlayer.this.getVideoClip().getStepSize()) : Math.min(val, clip.getFrameCount() - 1);
                val = Math.max(val - offset, 0);
                if (VideoPlayer.this.active.equals("in")) {
                    int prevStart = clip.getStartFrameNumber();
                    if (clip.setStartFrameNumber(val, this.maxEndFrame)) {
                        int newStart = clip.getStartFrameNumber();
                        VideoPlayer.this.vidPanel.setMessage(String.valueOf(MediaRes.getString("VideoPlayer.InMarker.ToolTip")) + ": " + newStart);
                        if (!clip.isDefaultStartTime) {
                            double startTime = clip.getStartTime();
                            clip.setStartTime(startTime += (double)(newStart - prevStart) * VideoPlayer.this.clipControl.getMeanFrameDuration());
                        }
                        VideoPlayer.this.clipControl.setStepNumber(0);
                        if (clip.inspector != null && clip.inspector.isVisible()) {
                            clip.inspector.startField.setValue(newStart);
                            clip.inspector.t0Field.setValue(clip.getStartTime() / 1000.0);
                        }
                        VideoPlayer.this.updateReadout();
                    }
                } else if (VideoPlayer.this.active.equals("out") && clip.setEndFrameNumber(val)) {
                    int end = clip.getEndFrameNumber();
                    VideoPlayer.this.vidPanel.setMessage(String.valueOf(MediaRes.getString("VideoPlayer.OutMarker.ToolTip")) + ": " + end);
                    VideoPlayer.this.clipControl.setStepNumber(clip.getStepCount() - 1);
                    if (clip.inspector != null && clip.inspector.isVisible()) {
                        clip.inspector.endField.setValue(clip.getEndFrameNumber());
                    }
                }
            }
        };
        this.slider.addMouseListener(inOutSetter);
        this.slider.addMouseMotionListener(inOutSetter);
        InputMap im = this.slider.getInputMap(0);
        ActionMap am = SwingUtilities.getUIActionMap(this.slider);
        am.put(im.get(KeyStroke.getKeyStroke(33, 0)), null);
        am.put(im.get(KeyStroke.getKeyStroke(34, 0)), null);
        this.slider.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (VideoPlayer.this.disabled) {
                    return;
                }
                switch (e.getKeyCode()) {
                    case 33: {
                        VideoPlayer.this.back();
                        break;
                    }
                    case 34: {
                        VideoPlayer.this.step();
                    }
                }
            }
        });
        this.readout = new PlayerButton(this){

            @Override
            public Dimension getPreferredSize() {
                Dimension dim = super.getPreferredSize();
                dim.height = ((VideoPlayer)this).rateSpinner.getPreferredSize().height;
                return dim;
            }

            @Override
            public Dimension getMinimumSize() {
                Dimension dim = super.getMinimumSize();
                dim.height = ((VideoPlayer)this).rateSpinner.getPreferredSize().height;
                return dim;
            }

            @Override
            public Dimension getMaximumSize() {
                Dimension dim = super.getMaximumSize();
                dim.height = ((VideoPlayer)this).rateSpinner.getPreferredSize().height;
                return dim;
            }
        };
        this.readout.setForeground(new Color(204, 51, 51));
        this.readout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (VideoPlayer.this.disabled) {
                    return;
                }
                if (VideoPlayer.this.readoutTypes.length < 2) {
                    return;
                }
                JPopupMenu popup = new JPopupMenu();
                JMenu displayMenu = new JMenu(MediaRes.getString("VideoPlayer.Readout.Menu.Display"));
                popup.add(displayMenu);
                int i = 0;
                while (i < VideoPlayer.this.readoutTypes.length) {
                    JMenuItem item;
                    String type = VideoPlayer.this.readoutTypes[i];
                    if (type.equals("step")) {
                        item = new JCheckBoxMenuItem(MediaRes.getString("VideoPlayer.Readout.MenuItem.Step"));
                        item.setSelected(type.equals(VideoPlayer.this.readoutType));
                        item.setActionCommand(type);
                        item.addActionListener(VideoPlayer.this.readoutListener);
                        displayMenu.add(item);
                    } else if (type.equals("time")) {
                        item = new JCheckBoxMenuItem(MediaRes.getString("VideoPlayer.Readout.MenuItem.Time"));
                        item.setSelected(type.equals(VideoPlayer.this.readoutType));
                        item.setActionCommand(type);
                        item.addActionListener(VideoPlayer.this.readoutListener);
                        displayMenu.add(item);
                        popup.addSeparator();
                        if (VideoPlayer.this.getTime() != 0.0) {
                            String s = MediaRes.getString("VideoPlayer.Popup.Menu.SetTimeToZero");
                            item = new JMenuItem(s);
                            item.addActionListener(new ActionListener(){

                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    if (VideoPlayer.this.disabled) {
                                        return;
                                    }
                                    double t0 = -(this).VideoPlayer.this.clipControl.getTime();
                                    VideoPlayer.this.getVideoClip().setStartTime(t0);
                                }
                            });
                            item.addActionListener(VideoPlayer.this.readoutListener);
                            popup.add(item);
                        }
                        item = new JMenuItem(MediaRes.getString("VideoPlayer.Readout.Menu.SetTime"));
                        item.setActionCommand(type);
                        item.addActionListener(VideoPlayer.this.timeSetListener);
                        item.addActionListener(VideoPlayer.this.readoutListener);
                        popup.add(item);
                    } else {
                        item = new JCheckBoxMenuItem(MediaRes.getString("VideoPlayer.Readout.MenuItem.Frame"));
                        item.setSelected(type.equals(VideoPlayer.this.readoutType));
                        item.setActionCommand(type);
                        item.addActionListener(VideoPlayer.this.readoutListener);
                        displayMenu.add(item);
                    }
                    ++i;
                }
                popup.show(VideoPlayer.this.readout, 0, VideoPlayer.this.readout.getHeight());
            }
        });
        this.readout.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (OSPRuntime.isPopupTrigger(e)) {
                    VideoPlayer.this.readout.doClick(0);
                }
            }
        });
        this.stepSizeButton = new PlayerButton(this){

            @Override
            public Dimension getPreferredSize() {
                Dimension dim = super.getPreferredSize();
                dim.height = ((VideoPlayer)this).rateSpinner.getPreferredSize().height;
                return dim;
            }

            @Override
            public Dimension getMinimumSize() {
                Dimension dim = super.getMinimumSize();
                dim.height = ((VideoPlayer)this).rateSpinner.getPreferredSize().height;
                return dim;
            }

            @Override
            public Dimension getMaximumSize() {
                Dimension dim = super.getMaximumSize();
                dim.height = ((VideoPlayer)this).rateSpinner.getPreferredSize().height;
                return dim;
            }
        };
        this.stepSizeButton.setForeground(new Color(204, 51, 51));
        this.stepSizeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (VideoPlayer.this.disabled) {
                    return;
                }
                ActionListener listener = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        VideoClip clip;
                        int frameNumber;
                        block3: {
                            frameNumber = VideoPlayer.this.getFrameNumber();
                            clip = VideoPlayer.this.getVideoClip();
                            try {
                                int n = Integer.parseInt(e.getActionCommand());
                                clip.setStepSize(n);
                            }
                            catch (NumberFormatException ex) {
                                String cur = String.valueOf(VideoPlayer.this.getVideoClip().getStepSize());
                                Object input = JOptionPane.showInputDialog((this).VideoPlayer.this.vidPanel, MediaRes.getString("VideoPlayer.Dialog.StepSize.Message"), MediaRes.getString("VideoPlayer.Dialog.StepSize.Title"), -1, null, null, cur);
                                if (input == null) break block3;
                                int n = Integer.parseInt(input.toString());
                                clip.setStepSize(n);
                            }
                        }
                        VideoPlayer.this.setStepNumber(clip.frameToStep(frameNumber));
                        if (clip.inspector != null && clip.inspector.isVisible()) {
                            clip.inspector.stepSizeField.setValue(clip.getStepSize());
                        }
                    }
                };
                JPopupMenu popup = new JPopupMenu();
                int i = 1;
                while (i < 6) {
                    JMenuItem item = new JMenuItem(String.valueOf(i));
                    item.addActionListener(listener);
                    popup.add(item);
                    ++i;
                }
                popup.addSeparator();
                JMenuItem item = new JMenuItem(MediaRes.getString("VideoPlayer.Button.StepSize.Other"));
                item.addActionListener(listener);
                popup.add(item);
                popup.show(VideoPlayer.this.stepSizeButton, 0, VideoPlayer.this.stepSizeButton.getHeight());
            }
        });
        this.stepSizeButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (OSPRuntime.isPopupTrigger(e)) {
                    VideoPlayer.this.stepSizeButton.doClick(0);
                }
            }
        });
        this.inspectorButton = new PlayerButton(videoClipIcon);
        this.inspectorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ClipInspector inspector;
                if (VideoPlayer.this.disabled) {
                    return;
                }
                Frame frame = null;
                Container c = VideoPlayer.this.vidPanel.getTopLevelAncestor();
                if (c instanceof Frame) {
                    frame = (Frame)c;
                }
                if ((inspector = VideoPlayer.this.getVideoClip().getClipInspector(VideoPlayer.this.clipControl, frame)).isVisible()) {
                    return;
                }
                Point p0 = new Frame().getLocation();
                Point loc = inspector.getLocation();
                if (loc.x == p0.x && loc.y == p0.y) {
                    Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
                    int x = (dim.width - inspector.getBounds().width) / 2;
                    int y = (dim.height - inspector.getBounds().height) / 2;
                    inspector.setLocation(x, y);
                }
                inspector.initialize();
                inspector.setVisible(true);
            }
        });
        this.loopButton = new PlayerButton(noloopIcon, loopIcon);
        this.loopButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                VideoPlayer.this.setLooping(!VideoPlayer.this.loopButton.isSelected());
            }
        });
        this.loopButton.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 32) {
                    VideoPlayer.this.setLooping(!VideoPlayer.this.loopButton.isSelected());
                }
            }
        });
        this.toolbar.add(this.readout);
        this.toolbar.add(this.rateSpinner);
        this.toolbar.add(this.resetButton);
        this.toolbar.add(this.playButton);
        this.toolbar.add(this.slider);
        this.toolbar.add(this.backButton);
        this.toolbar.add(this.stepSizeButton);
        this.toolbar.add(this.stepButton);
        this.toolbar.add(this.loopButton);
        if (this.inspectorButtonVisible) {
            this.toolbar.add(this.inspectorButton);
        }
    }

    private void updatePlayButtons(final boolean playing) {
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                int stepCount = VideoPlayer.this.getVideoClip().getStepCount();
                boolean canPlay = stepCount > 1;
                VideoPlayer.this.playButton.setEnabled(canPlay && (playing || VideoPlayer.this.getStepNumber() < stepCount - 1));
                VideoPlayer.this.stepButton.setEnabled(canPlay && (playing || VideoPlayer.this.getStepNumber() < stepCount - 1));
                VideoPlayer.this.backButton.setEnabled(canPlay && (playing || VideoPlayer.this.getStepNumber() > 0));
                VideoPlayer.this.playButton.setSelected(playing);
                if (playing) {
                    VideoPlayer.this.playButton.setToolTipText(MediaRes.getString("VideoPlayer.Button.Pause.ToolTip"));
                    VideoPlayer.this.playButton.setPressedIcon(pauseIcon);
                    VideoPlayer.this.playButton.setIcon(pauseIcon);
                } else {
                    VideoPlayer.this.playButton.setToolTipText(MediaRes.getString("VideoPlayer.Button.Play.ToolTip"));
                    VideoPlayer.this.playButton.setPressedIcon(playIcon);
                    VideoPlayer.this.playButton.setIcon(playIcon);
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runner.run();
        } else {
            SwingUtilities.invokeLater(runner);
        }
    }

    private void updateLoopButton(boolean looping) {
        if (looping == this.loopButton.isSelected()) {
            return;
        }
        this.loopButton.setSelected(looping);
        if (looping) {
            this.loopButton.setPressedIcon(loopIcon);
            this.loopButton.setIcon(loopIcon);
        } else {
            this.loopButton.setPressedIcon(noloopIcon);
            this.loopButton.setIcon(noloopIcon);
        }
    }

    private void updateReadout() {
        int n;
        int frameNumber = this.clipControl.getFrameNumber();
        int startFrame = this.getVideoClip().getStartFrameNumber();
        int endFrame = this.getVideoClip().getEndFrameNumber();
        if (frameNumber < startFrame) {
            this.clipControl.setStepNumber(0);
        } else if (frameNumber > endFrame) {
            this.clipControl.setStepNumber(this.getVideoClip().getStepCount());
        }
        this.slider.setValue(this.clipControl.getFrameNumber());
        int stepNumber = this.clipControl.getStepNumber();
        String display = this.readoutType.equals("step") ? (stepNumber < 10 ? "00" + stepNumber : (stepNumber < 100 ? "0" + stepNumber : "" + stepNumber)) : (this.readoutType.equals("frame") ? ((n = this.clipControl.getFrameNumber()) < 10 ? "00" + n : (n < 100 ? "0" + n : "" + n)) : this.timeFormat.format(this.getTime() / 1000.0));
        this.readout.setText(display);
        this.rateSpinner.setValue(this.getRate());
        this.stepSizeButton.setText("" + this.getVideoClip().getStepSize());
        FontSizer.setFonts(this.readout, FontSizer.getLevel());
        FontSizer.setFonts(this.rateSpinner, FontSizer.getLevel());
        FontSizer.setFonts(this.stepSizeButton, FontSizer.getLevel());
        this.stepSizeButton.setToolTipText(MediaRes.getString("VideoPlayer.Button.StepSize.ToolTip"));
        this.rateSpinner.setToolTipText(MediaRes.getString("VideoPlayer.Spinner.Rate.ToolTip"));
        if (stepNumber == this.getVideoClip().getStepCount() - 1) {
            this.updatePlayButtons(this.clipControl.isPlaying());
        }
    }

    private void updateSlider() {
        VideoClip clip = this.getVideoClip();
        this.slider.setMinimum(Math.max(0, -clip.getFrameShift()));
        this.slider.setMaximum(this.slider.getMinimum() + clip.getFrameCount() - 1);
        this.sliderLabels.clear();
        this.sliderLabels.put(new Integer(clip.getStartFrameNumber()), this.inLabel);
        this.sliderLabels.put(new Integer(clip.getEndFrameNumber()), this.outLabel);
        this.slider.repaint();
    }

    protected class PlayerButton
    extends JButton {
        public PlayerButton() {
            this.setOpaque(false);
            this.setBorderPainted(false);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    PlayerButton.this.setBorderPainted(true);
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    PlayerButton.this.setBorderPainted(false);
                }
            });
        }

        public PlayerButton(Icon icon) {
            this();
            this.setIcon(icon);
        }

        public PlayerButton(Icon off, Icon on) {
            this();
            this.setIcon(off);
            this.setSelectedIcon(on);
        }
    }
}

