/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.core;

import java.io.File;
import java.util.TreeSet;
import javax.swing.filechooser.FileFilter;
import org.opensourcephysics.media.core.MediaRes;
import org.opensourcephysics.media.core.VideoIO;

public class VideoFileFilter
extends FileFilter
implements Comparable<VideoFileFilter> {
    String[] extensions;
    String type = "Video";

    public VideoFileFilter() {
    }

    public VideoFileFilter(String containerType, String[] extensions) {
        if (containerType != null && extensions != null && extensions.length > 0) {
            this.type = containerType;
            this.extensions = extensions;
        }
    }

    @Override
    public boolean accept(File f) {
        block6: {
            block5: {
                if (f == null) {
                    return false;
                }
                if (f.isDirectory()) {
                    return true;
                }
                if (this.extensions == null) break block5;
                String string = VideoIO.getExtension(f);
                if (string == null) break block6;
                String[] stringArray = this.extensions;
                int n = this.extensions.length;
                int n2 = 0;
                while (n2 < n) {
                    String next = stringArray[n2];
                    if (string.toLowerCase().equals(next.toLowerCase())) {
                        return true;
                    }
                    ++n2;
                }
                break block6;
            }
            for (FileFilter fileFilter : VideoIO.singleVideoTypeFilters) {
                if (!fileFilter.accept(f)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public String getDescription() {
        String description = MediaRes.getString(String.valueOf(this.type.toUpperCase()) + "FileFilter.Description");
        if (this.extensions != null) {
            description = String.valueOf(description) + " (";
            int i = 0;
            while (i < this.extensions.length) {
                if (i > 0) {
                    description = String.valueOf(description) + ", ";
                }
                description = String.valueOf(description) + "." + this.extensions[i];
                ++i;
            }
            description = String.valueOf(description) + ")";
        }
        return description;
    }

    public String getDefaultExtension() {
        if (this.extensions != null) {
            return this.extensions[0];
        }
        for (VideoFileFilter next : VideoIO.singleVideoTypeFilters) {
            String ext = next.getDefaultExtension();
            if (ext == null) continue;
            return ext;
        }
        return null;
    }

    public String[] getExtensions() {
        if (this.extensions != null) {
            return this.extensions;
        }
        TreeSet<String> set = new TreeSet<String>();
        for (VideoFileFilter next : VideoIO.singleVideoTypeFilters) {
            String[] exts;
            String[] stringArray = exts = next.getExtensions();
            int n = exts.length;
            int n2 = 0;
            while (n2 < n) {
                String ext = stringArray[n2];
                set.add(ext);
                ++n2;
            }
        }
        return set.toArray(new String[set.size()]);
    }

    public String getContainerType() {
        return this.type;
    }

    @Override
    public int compareTo(VideoFileFilter filter) {
        return this.getDescription().compareTo(filter.getDescription());
    }
}

