/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.core;

import java.awt.Dimension;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.media.core.ImageVideo;
import org.opensourcephysics.media.core.ImageVideoType;
import org.opensourcephysics.media.core.ScratchVideoRecorder;
import org.opensourcephysics.media.core.Video;
import org.opensourcephysics.media.core.VideoFileFilter;
import org.opensourcephysics.media.core.VideoIO;
import org.opensourcephysics.tools.ResourceLoader;

public class ImageVideoRecorder
extends ScratchVideoRecorder {
    protected int frameCount;
    private String tempFileBasePath;
    private String tempFileType = "png";
    private String[] savedFilePaths;

    public ImageVideoRecorder() {
        super(new ImageVideoType());
    }

    public ImageVideoRecorder(ImageVideoType type) {
        super(type);
        String ext = type.getDefaultExtension();
        if (ext != null) {
            this.tempFileType = ext;
        }
    }

    @Override
    public Video getVideo() throws IOException {
        if (this.saveFile != null) {
            if (!this.isSaved) {
                this.saveScratch();
            }
            if (this.savedFilePaths != null && this.savedFilePaths.length > 0) {
                ImageVideo video2 = new ImageVideo(this.savedFilePaths[0], this.savedFilePaths.length > 1);
                video2.setFrameDuration(this.frameDuration);
                return video2;
            }
        }
        return null;
    }

    @Override
    public String saveVideo(String fileName) throws IOException {
        if (fileName == null) {
            return this.saveVideoAs();
        }
        this.setFileName(fileName);
        if (this.saveFile == null) {
            throw new IOException("Read-only file");
        }
        this.saveScratch();
        return this.savedFilePaths == null || this.savedFilePaths.length == 0 ? null : this.savedFilePaths[0];
    }

    public void setExpectedFrameCount(int n) {
        this.frameCount = n;
    }

    @Override
    public void reset() {
        this.frameCount = 0;
        this.deleteTempFiles();
        super.reset();
    }

    @Override
    protected void finalize() {
        this.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void saveScratch() throws IOException {
        if (!this.hasContent) {
            return;
        }
        if (this.chosenExtension != null && !(chooser.getFileFilter() instanceof VideoFileFilter)) {
            return;
        }
        ArrayList arrayList = this.tempFiles;
        synchronized (arrayList) {
            String fileName = this.saveFile.getAbsolutePath();
            this.savedFilePaths = ImageVideoRecorder.getFileNames(fileName, this.tempFiles.size());
            int i = 0;
            while (i < this.tempFiles.size()) {
                String path = this.savedFilePaths[i];
                File tempFile = (File)this.tempFiles.get(i);
                if (!tempFile.exists()) {
                    this.savedFilePaths = null;
                    throw new IOException("temp image file not found");
                }
                if (ext == this.tempFileType) {
                    File targetFile = new File(path);
                    VideoIO.copyFile(tempFile, targetFile);
                } else {
                    BufferedImage image = ResourceLoader.getBufferedImage(tempFile.getAbsolutePath());
                    if (image == null) {
                        throw new IOException("unable to load temp image file");
                    }
                    ImageIO.write((RenderedImage)image, ext, new BufferedOutputStream(new FileOutputStream(path)));
                }
                ++i;
            }
        }
        this.deleteTempFiles();
        this.isSaved = true;
        this.hasContent = false;
        this.canRecord = false;
        if (this.savedFilePaths != null && this.savedFilePaths.length > 0) {
            Video video2 = this.getVideo();
            XMLControlElement control = new XMLControlElement(video2);
            String fileName = this.savedFilePaths[0];
            fileName = String.valueOf(XML.stripExtension(fileName)) + ".xml";
            control.write(fileName);
        }
    }

    @Override
    protected boolean startRecording() {
        if (this.dim == null) {
            if (this.frameImage != null) {
                this.dim = new Dimension(this.frameImage.getWidth(null), this.frameImage.getHeight(null));
            } else {
                return false;
            }
        }
        try {
            this.tempFileBasePath = XML.stripExtension(this.scratchFile.getAbsolutePath());
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean append(Image image) {
        int w = image.getWidth(null);
        int h = image.getHeight(null);
        if (this.dim == null) {
            this.dim = new Dimension(w, h);
        }
        if (this.dim.width != w || this.dim.height != h) {
            return false;
        }
        if (!(image instanceof BufferedImage)) {
            BufferedImage img = new BufferedImage(w, h, 1);
            img.getGraphics().drawImage(image, 0, 0, null);
            image = img;
        }
        BufferedImage source = (BufferedImage)image;
        String fileName = String.valueOf(this.tempFileBasePath) + "_" + this.tempFiles.size() + ".tmp";
        try {
            ImageIO.write((RenderedImage)source, this.tempFileType, new BufferedOutputStream(new FileOutputStream(fileName)));
        }
        catch (Exception e) {
            return false;
        }
        File imageFile = new File(fileName);
        if (imageFile.exists()) {
            ArrayList arrayList = this.tempFiles;
            synchronized (arrayList) {
                this.tempFiles.add(imageFile);
            }
            imageFile.deleteOnExit();
        }
        return true;
    }

    @Override
    protected File getFileToBeSaved(File file) {
        int n;
        int n2 = n = this.frameCount > 0 ? this.frameCount : this.tempFiles.size();
        if (n <= 1) {
            return file;
        }
        String fileName = file.getAbsolutePath();
        int i = ImageVideoRecorder.getAppendedNumber(fileName);
        String base = ImageVideoRecorder.getBase(fileName);
        fileName = i > 0 ? String.valueOf(base) + (n + i < 10 ? String.valueOf(i) : (n + i < 100 && i < 10 ? "0" + i : (n + i < 100 ? String.valueOf(i) : (n + i < 1000 && i < 10 ? "00" + i : (n + i < 1000 && i < 100 ? "0" + i : (n + i < 1000 ? String.valueOf(i) : (i < 10 ? "000" + i : (i < 100 ? "00" + i : (i < 1000 ? "0" + i : String.valueOf(i)))))))))) : String.valueOf(base) + (n < 10 ? "0" : (n < 100 ? "00" : (n < 1000 ? "000" : "0000")));
        if (ext != null) {
            fileName = String.valueOf(fileName) + "." + ext;
        }
        return new File(fileName);
    }

    protected static String[] saveImages(String fileName, BufferedImage[] images) throws IOException {
        String[] fileNames = ImageVideoRecorder.getFileNames(fileName, images.length);
        int i = 0;
        while (i < images.length) {
            String next = fileNames[i];
            ImageIO.write((RenderedImage)images[i], ext, new BufferedOutputStream(new FileOutputStream(next)));
            ++i;
        }
        return fileNames;
    }

    protected static String[] getFileNames(String fileName, int length) {
        if (length == 1) {
            return new String[]{fileName};
        }
        int k = ImageVideoRecorder.getAppendedNumber(fileName);
        ArrayList<String> paths = new ArrayList<String>();
        int digits = length + k < 10 ? 1 : (length + k < 100 ? 2 : (length + k < 1000 ? 3 : 4));
        String base = ImageVideoRecorder.getBase(fileName);
        int i = 0;
        while (i < length) {
            String num = String.valueOf(i + k);
            if (digits == 2 && i + k < 10) {
                num = "0" + num;
            } else if (digits == 3 && i + k < 10) {
                num = "00" + num;
            } else if (digits == 3 && i + k < 100) {
                num = "0" + num;
            } else if (digits == 4 && i + k < 10) {
                num = "000" + num;
            } else if (digits == 4 && i + k < 100) {
                num = "00" + num;
            } else if (digits == 4 && i + k < 1000) {
                num = "0" + num;
            }
            fileName = String.valueOf(base) + num + "." + ext;
            paths.add(fileName);
            ++i;
        }
        return paths.toArray(new String[0]);
    }

    protected static String getBase(String path) {
        String base = XML.stripExtension(path);
        int len = base.length();
        int digits = 1;
        while (digits < len) {
            try {
                Integer.parseInt(base.substring(len - digits));
            }
            catch (NumberFormatException ex) {
                break;
            }
            ++digits;
        }
        if (--digits == 0) {
            return base;
        }
        return base.substring(0, len - digits);
    }

    protected static int getAppendedNumber(String path) {
        String base = XML.stripExtension(path);
        int len = base.length();
        int digits = 1;
        int n = 0;
        while (digits < len) {
            try {
                n = Integer.parseInt(base.substring(len - digits));
            }
            catch (NumberFormatException ex) {
                break;
            }
            ++digits;
        }
        return n;
    }
}

