/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.displayejs;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.displayejs.DrawingPanel3D;
import org.opensourcephysics.displayejs.ElementSet;
import org.opensourcephysics.displayejs.InteractiveArrow;
import org.opensourcephysics.displayejs.InteractiveElement;
import org.opensourcephysics.displayejs.Object3D;

public class VectorField3D
extends ElementSet {
    protected int levels = 0;
    protected int invisibleLevel = -1;
    protected boolean autoscaleMagnitude = false;
    protected double minMagnitude = -1.0;
    protected double maxMagnitude = 1.0;
    protected Color maxColor = null;
    protected Color minColor = null;
    protected boolean visibility = true;
    protected boolean hasData = false;
    protected double[][][] data2D = null;
    protected double[][][][] data3D = null;
    protected double zoom = 1.0;
    protected double magConstant = 0.0;
    protected double[] magnitude = new double[]{0.0};
    protected Color[] colors = null;

    public VectorField3D() {
        super(1, InteractiveArrow.class);
        this.maxColor = Color.red;
        this.minColor = Color.blue;
        this.setNumberOfLevels(16);
        this.setAutoscaleMagnitude(true);
    }

    @Override
    public void setVisible(boolean _visible) {
        this.visibility = _visible;
    }

    public void setNumberOfLevels(int _lev) {
        if (_lev <= 0) {
            this.levels = 0;
            return;
        }
        if (_lev != this.levels) {
            this.levels = _lev;
            this.colors = new Color[this.levels];
            this.initColors();
            this.magConstant = (double)this.levels / (this.maxMagnitude - this.minMagnitude);
            this.setInvisibleLevel(this.invisibleLevel);
        }
    }

    public void setMinColor(Color _aColor) {
        if (!_aColor.equals(this.minColor)) {
            this.minColor = _aColor;
            this.initColors();
        }
    }

    public void setMaxColor(Color _aColor) {
        if (!_aColor.equals(this.maxColor)) {
            this.maxColor = _aColor;
            this.initColors();
        }
    }

    public void setInvisibleLevel(int _lev) {
        this.invisibleLevel = _lev;
    }

    public void setZoom(double _scale) {
        block6: {
            block5: {
                this.zoom = _scale;
                if (this.data2D == null) break block5;
                int el = 0;
                int i = 0;
                int m = this.data2D.length;
                while (i < m) {
                    int j = 0;
                    int n = this.data2D[0].length;
                    while (j < n) {
                        InteractiveElement element = this.elementAt(el);
                        element.setSizeX(this.data2D[i][j][2] * this.zoom);
                        element.setSizeY(this.data2D[i][j][3] * this.zoom);
                        ++j;
                        ++el;
                    }
                    ++i;
                }
                break block6;
            }
            if (this.data3D == null) break block6;
            int el = 0;
            int i = 0;
            int m = this.data3D.length;
            while (i < m) {
                int j = 0;
                int n = this.data3D[0].length;
                while (j < n) {
                    int k = 0;
                    int p = this.data3D[0][0].length;
                    while (k < p) {
                        InteractiveElement element = this.elementAt(el);
                        element.setSizeX(this.data3D[i][j][k][3] * this.zoom);
                        element.setSizeY(this.data3D[i][j][k][4] * this.zoom);
                        element.setSizeZ(this.data3D[i][j][k][5] * this.zoom);
                        ++k;
                        ++el;
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    public void setAutoscaleMagnitude(boolean _auto) {
        this.autoscaleMagnitude = _auto;
        if (this.autoscaleMagnitude) {
            this.computeMagnitudeExtrema();
        }
    }

    public void setColorExtrema(double min, double max) {
        this.autoscaleMagnitude = false;
        this.minMagnitude = min;
        this.maxMagnitude = max;
        if (this.maxMagnitude == this.minMagnitude) {
            this.maxMagnitude = this.minMagnitude + 1.0;
        }
        this.magConstant = (double)this.levels / (this.maxMagnitude - this.minMagnitude);
    }

    public void setDataArray(double[][][][] _data) {
        if (_data == null) {
            this.hasData = false;
            return;
        }
        this.data3D = _data;
        this.data2D = null;
        this.hasData = true;
        int num = this.data3D.length * this.data3D[0].length * this.data3D[0][0].length;
        if (this.getNumberOfElements() != num) {
            this.magnitude = new double[num];
            this.setNumberOfElements(num);
        }
        int el = 0;
        int i = 0;
        int m = this.data3D.length;
        while (i < m) {
            int j = 0;
            int n = this.data3D[0].length;
            while (j < n) {
                int k = 0;
                int p = this.data3D[0][0].length;
                while (k < p) {
                    InteractiveElement element = this.elementAt(el);
                    element.setX(_data[i][j][k][0]);
                    element.setY(_data[i][j][k][1]);
                    element.setZ(_data[i][j][k][2]);
                    element.setSizeX(_data[i][j][k][3] * this.zoom);
                    element.setSizeY(_data[i][j][k][4] * this.zoom);
                    element.setSizeZ(_data[i][j][k][5] * this.zoom);
                    this.magnitude[el] = _data[i][j][k][6];
                    ++k;
                    ++el;
                }
                ++j;
            }
            ++i;
        }
        if (this.autoscaleMagnitude) {
            this.computeMagnitudeExtrema();
        }
    }

    public void setDataArray(double[][][] _data) {
        if (_data == null) {
            this.hasData = false;
            return;
        }
        this.data2D = _data;
        this.data3D = null;
        this.hasData = true;
        int num = this.data2D.length * this.data2D[0].length;
        if (this.getNumberOfElements() != num) {
            this.magnitude = new double[num];
            this.setNumberOfElements(num);
            this.setZoom(this.zoom);
        }
        int el = 0;
        int i = 0;
        int m = this.data2D.length;
        while (i < m) {
            int j = 0;
            int n = this.data2D[0].length;
            while (j < n) {
                InteractiveElement element = this.elementAt(el);
                element.setX(this.data2D[i][j][0]);
                element.setY(this.data2D[i][j][1]);
                element.setSizeX(this.data2D[i][j][2] * this.zoom);
                element.setSizeY(this.data2D[i][j][3] * this.zoom);
                this.magnitude[el] = this.data2D[i][j][4];
                ++j;
                ++el;
            }
            ++i;
        }
        if (this.autoscaleMagnitude) {
            this.computeMagnitudeExtrema();
        }
    }

    @Override
    public Interactive findInteractive(DrawingPanel _panel, int _xpix, int _ypix) {
        return null;
    }

    @Override
    public Object3D[] getObjects3D(DrawingPanel3D _panel) {
        if (!this.visibility || !this.hasData) {
            return null;
        }
        this.list3D.clear();
        int i = 0;
        int n = this.getNumberOfElements();
        while (i < n) {
            block6: {
                InteractiveElement element;
                block7: {
                    block5: {
                        element = this.elementAt(i);
                        this.elementAt(i).setVisible(true);
                        if (this.levels <= 0) break block5;
                        Color color = this.magToColor(this.magnitude[i]);
                        if (color == null) break block6;
                        element.getStyle().setEdgeColor(color);
                        element.getStyle().setFillPattern(color);
                        break block7;
                    }
                    element.getStyle().setEdgeColor(this.minColor);
                    element.getStyle().setFillPattern(this.minColor);
                }
                Object3D[] objects = element.getObjects3D(_panel);
                if (objects != null) {
                    int j = 0;
                    while (j < objects.length) {
                        this.list3D.add(objects[j]);
                        ++j;
                    }
                }
            }
            ++i;
        }
        if (this.list3D.size() == 0) {
            return null;
        }
        return this.list3D.toArray(this.minimalObjects);
    }

    @Override
    public void drawQuickly(DrawingPanel3D _panel, Graphics2D _g) {
        if (!this.visibility || !this.hasData) {
            return;
        }
        if (this.levels > 0) {
            int i = 0;
            int n = this.getNumberOfElements();
            while (i < n) {
                Color color = this.magToColor(this.magnitude[i]);
                if (color == null) {
                    this.elementAt(i).setVisible(false);
                } else {
                    this.elementAt(i).setVisible(true);
                    this.elementAt(i).getStyle().setEdgeColor(color);
                    this.elementAt(i).getStyle().setFillPattern(color);
                }
                ++i;
            }
        } else {
            int i = 0;
            int n = this.getNumberOfElements();
            while (i < n) {
                this.elementAt(i).setVisible(true);
                this.elementAt(i).getStyle().setEdgeColor(this.minColor);
                this.elementAt(i).getStyle().setFillPattern(this.minColor);
                ++i;
            }
        }
        super.drawQuickly(_panel, _g);
    }

    @Override
    public void draw(DrawingPanel _panel, Graphics _g) {
        if (!this.visibility || !this.hasData) {
            return;
        }
        if (this.levels > 0) {
            int i = 0;
            int n = this.getNumberOfElements();
            while (i < n) {
                Color color = this.magToColor(this.magnitude[i]);
                if (color == null) {
                    this.elementAt(i).setVisible(false);
                } else {
                    this.elementAt(i).setVisible(true);
                    this.elementAt(i).getStyle().setEdgeColor(color);
                    this.elementAt(i).getStyle().setFillPattern(color);
                }
                ++i;
            }
        } else {
            int i = 0;
            int n = this.getNumberOfElements();
            while (i < n) {
                this.elementAt(i).setVisible(true);
                this.elementAt(i).getStyle().setEdgeColor(this.minColor);
                this.elementAt(i).getStyle().setFillPattern(this.minColor);
                ++i;
            }
        }
        super.draw(_panel, _g);
    }

    protected void initColors() {
        int redStart = this.minColor.getRed();
        int greenStart = this.minColor.getGreen();
        int blueStart = this.minColor.getBlue();
        int redEnd = this.maxColor.getRed();
        int greenEnd = this.maxColor.getGreen();
        int blueEnd = this.maxColor.getBlue();
        int i = 0;
        while (i < this.levels) {
            int r = (int)((float)redStart + (float)((redEnd - redStart) * i) * 1.0f / (float)(this.levels - 1));
            int g = (int)((float)greenStart + (float)((greenEnd - greenStart) * i) * 1.0f / (float)(this.levels - 1));
            int b = (int)((float)blueStart + (float)((blueEnd - blueStart) * i) * 1.0f / (float)(this.levels - 1));
            this.colors[i] = new Color(r, g, b);
            ++i;
        }
    }

    protected void computeMagnitudeExtrema() {
        double[] temp = this.magnitude;
        if (temp == null) {
            return;
        }
        this.minMagnitude = temp[0];
        this.maxMagnitude = temp[0];
        int i = 0;
        while (i < temp.length) {
            double v = temp[i];
            if (v > this.maxMagnitude) {
                this.maxMagnitude = v;
            }
            if (v < this.minMagnitude) {
                this.minMagnitude = v;
            }
            ++i;
        }
        this.magConstant = (double)this.levels / (this.maxMagnitude - this.minMagnitude);
    }

    protected Color magToColor(double mag) {
        int index = (int)(this.magConstant * (mag - this.minMagnitude));
        if (index <= this.invisibleLevel) {
            return null;
        }
        if (index <= 0) {
            return this.colors[0];
        }
        if (index >= this.levels) {
            return this.colors[this.levels - 1];
        }
        return this.colors[index];
    }
}

