/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display2d;

import org.opensourcephysics.numerics.Function;

public class ZExpansion
implements Function {
    double expansion = 1.0;
    double k = 1.0;
    double min = -1.0;
    double max = 1.0;
    double center = 0.0;
    double a1;
    double a2 = 1.0;

    public ZExpansion(double expansion) {
        this.expansion = Math.abs(expansion);
    }

    public void setExpansion(double expansion) {
        this.expansion = Math.abs(expansion);
        this.setMinMax(this.min, this.max);
    }

    public void setMinMax(double min, double max) {
        this.min = min;
        this.max = max;
        if (min == max) {
            this.k = 0.0;
            this.a2 = this.center = min;
            this.a1 = this.center;
        } else if (min <= 0.0 && max >= 0.0) {
            this.center = 0.0;
            this.k = this.expansion / Math.max(-min, max);
            this.a1 = max / (1.0 - Math.exp(-this.k * max));
            this.a2 = -min / (1.0 - Math.exp(this.k * min));
        } else if (min > 0.0) {
            this.center = min;
            this.k = this.expansion / (max - min);
            this.a1 = this.a2 = max / (1.0 - Math.exp(-this.k * (max - min)));
        } else {
            this.center = max;
            this.k = this.expansion / (max - min);
            this.a1 = this.a2 = -min / (1.0 - Math.exp(this.k * (max - min)));
        }
    }

    @Override
    public double evaluate(double z) {
        if ((z -= this.center) >= 0.0) {
            return this.a1 * (1.0 - Math.exp(-this.k * z));
        }
        return -this.a2 * (1.0 - Math.exp(this.k * z));
    }
}

